/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.lite;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;
import org.experlog.base.ESStore;
import org.experlog.base.OpenClient;
import org.experlog.lite.MultipartRequest;
import org.experlog.util.AppConfiguration;
import org.experlog.util.ESCategory;
import org.experlog.util.ESHttpUtils;

public class ESUploaderServlet
extends HttpServlet {
    private static final long serialVersionUID = 7154444616162553785L;
    private static String urlES = null;
    private static final String fParNbfiles_ = "nbfiles";
    private int mValNbfiles_ = 1;
    private static final String fParMaxsize = "maxsize";
    private static final String fParOverwrite = "overwrite";
    private static final String fParUploaddirectory = "uploaddirectory";
    private static final String fParUploadfile = "uploadfile";
    private static final String fParVerify = "verify";
    private String mValUploaddirectory = "";
    private String mValOverwrite = "off";
    private boolean mOverwrite = false;
    private String[] mValUploadfiles = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    private String mValVerify = "off";
    private boolean mVerify = false;
    private int mValMaxsize = 1024000;
    private OpenClient session_;
    private Category logger;

    private void setNoStore(HttpServletResponse res) {
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "no-store");
        res.setDateHeader("Expires", 0L);
    }

    public void init(ServletConfig cfg) throws ServletException {
        try {
            super.init(cfg);
            ESStore.getInstance();
        }
        catch (Exception e) {
            this.logger = ESCategory.getCategory("openeas.uploadservlet");
            this.logger.error((Object)("ESUploaderServlet:init Exception " + e));
            throw new ServletException(e.getMessage());
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String ct = req.getContentType();
            if (ct == null || ct.indexOf("multipart") == -1) {
                System.err.println("ESUploaderServlet:service UploadServlet request not multipart.");
            } else {
                MultipartRequest mreq = new MultipartRequest(req);
                this.setNoStore(res);
                String sessionid = ESHttpUtils.getSessionId(req);
                this.session_ = ESStore.getInstance().getClient(sessionid, req);
                PrintWriter out = res.getWriter();
                if (!this.session_.noComment()) {
                    out.println("<!-- Generated by openeas http://www.experlog.com -->");
                }
                this.loadServletParams(mreq, res);
                this.doUpload(mreq, res);
            }
        }
        catch (Exception e) {
            if (this.session_ != null) {
                Category logger = ESCategory.getCategory(ESStore.getInstance().getShopName(), "openeas.lite");
                logger.error((Object)("ERROR IN UploaderServlet " + e));
            }
            e.printStackTrace(System.err);
            throw new ServletException(e.getMessage());
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    public String getServletInfo() {
        return "ESUploader servlet";
    }

    protected void loadServletParams(MultipartRequest mreq, HttpServletResponse res) throws ServletException {
        System.err.println("ESUploaderServlet:loadServletParams Starting UploadServlet ... ");
        String max = this.getParameter(mreq, fParMaxsize, "" + this.mValMaxsize);
        urlES = this.getParameter(mreq, "urles", "urles");
        try {
            this.mValMaxsize = Integer.parseInt(max);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        String ctype = mreq.getContentType();
        if (ctype == null || ctype.indexOf("multipart/form-data") == -1) {
            this.throwServletException(mreq, "Error while accessing content type parameter.\nError description: parameter missing or malformed.");
        }
        String nbf = this.getParameter(mreq, fParNbfiles_, "1");
        try {
            this.mValNbfiles_ = Integer.parseInt(nbf);
        }
        catch (NumberFormatException nfe) {
            this.mValNbfiles_ = 1;
        }
        for (int i = 1; i <= this.mValNbfiles_; ++i) {
            String paramName = fParUploadfile + (i > 1 ? Integer.toString(i) : "");
            String sourceFile = mreq.getFileName(paramName);
            if (sourceFile == null) {
                throw new ServletException("Missing parameter: " + paramName);
            }
            if (!AppConfiguration.isSecurePath(sourceFile)) {
                throw new ServletException("Access forbidden for security reasons (tried to access parent directory)");
            }
            this.mValUploadfiles[i - 1] = mreq.getShortFileName(paramName);
        }
        this.mValUploaddirectory = this.getParameter(mreq, fParUploaddirectory, "");
        if (!AppConfiguration.isSecurePath(this.mValUploaddirectory)) {
            throw new ServletException("Access forbidden for security reasons (tried to access parent directory)");
        }
        this.mOverwrite = this.getParameter(mreq, fParOverwrite, this.mValOverwrite).toLowerCase().equals("on");
        this.mVerify = this.getParameter(mreq, fParVerify, this.mValVerify).toLowerCase().equals("on");
        res.setContentType("text/html");
        System.err.println("ESUploaderServlet:loadServletParams UploadServlet done. ");
    }

    protected void doUpload(MultipartRequest mreq, HttpServletResponse res) throws ServletException {
        String upld = this.session_.getAppConfiguration().getUploadDir();
        if (upld == null) {
            throw new ServletException("The app.UploadDir property is not present in the configuration file (session=" + this.session_ + ")");
        }
        String fullDir = this.buildFileName(upld, this.mValUploaddirectory);
        System.err.println("ESUploaderServlet:doUpload UploadServlet doUpload ... dir=" + fullDir);
        File fileDir = new File(fullDir);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        String parameters = "uploaddir=" + this.mValUploaddirectory;
        int nbfilez = 0;
        for (int i = 1; i <= this.mValNbfiles_; ++i) {
            if (this.mValUploadfiles[i - 1].trim().length() < 1) continue;
            ++nbfilez;
            String fullFileName = this.buildFileName(fullDir, this.mValUploadfiles[i - 1]);
            File fileUpload = new File(fullFileName);
            if (fileUpload.exists() && !this.mOverwrite) {
                this.throwServletException(mreq, "File exists already.");
            }
            FileOutputStream outUpload = null;
            try {
                outUpload = new FileOutputStream(fullFileName);
            }
            catch (FileNotFoundException e) {
                this.throwServletException(mreq, "Error while opening file: " + e);
            }
            String paramName = fParUploadfile + (i > 1 ? Integer.toString(i) : "");
            byte[] data = mreq.getFileValue(paramName);
            if (data == null) {
                data = ("Error: file " + fullFileName + " does not exist.").getBytes();
            }
            try {
                outUpload.write(data, 0, data.length);
                outUpload.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                this.throwServletException(mreq, "Error while uploading file." + ex);
            }
            parameters = parameters + "&uploadfile" + i + "=" + mreq.getShortFileName(paramName);
            if (!this.mVerify) continue;
            try {
                RandomAccessFile raf = new RandomAccessFile(fullFileName, "r");
                long length = raf.length();
                if (length == (long)data.length) continue;
                throw new Exception("Verification failed. Incorrect length: " + raf.length());
            }
            catch (FileNotFoundException fnf) {
                this.throwServletException(mreq, "\nException: " + fnf);
                continue;
            }
            catch (Exception ex) {
                this.throwServletException(mreq, "\nException: " + ex);
            }
        }
        parameters = parameters + "&nbfiles=" + nbfilez;
        try {
            System.err.println("parameters=" + parameters);
            urlES = urlES.indexOf(63) == -1 ? urlES + "?" + parameters : urlES + "&" + parameters;
            System.err.println("URL=" + urlES);
            res.sendRedirect(urlES);
        }
        catch (IOException e) {
            this.throwServletException(mreq, "\nException: " + e);
        }
        System.err.println("ESUploaderServlet:doUpload UploadServlet done. ");
    }

    private String getParameter(MultipartRequest mreq, String name, String defaultValue) {
        String value = mreq.getParameter(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private void throwServletException(MultipartRequest mreq, String message) throws ServletException {
        String resultHtml = "<HTML><HEAD><TITLE>UploadResult</TITLE></HEAD><BODY BGCOLOR=\"#ffffff\"><P><FONT color=\"red\"><B>" + message + "<p>" + "</B></BODY></HTML>";
        throw new ServletException(resultHtml);
    }

    private String buildFileName(String directory, String filename) {
        if (directory == null) {
            directory = "";
        }
        if (filename == null) {
            filename = "";
        }
        directory = directory.trim();
        filename = filename.trim();
        if (!directory.endsWith("\\") && !directory.endsWith("/")) {
            directory = directory + File.separator;
        }
        if (filename.startsWith("\\") || filename.startsWith("/")) {
            filename = filename.length() > 1 ? filename.substring(1, filename.length()) : "";
        }
        return directory + filename;
    }
}

