/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.gencode;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.experlog.openeas.api.DataObject;

public class ESHttpHeadersAccess
implements DataObject {
    HttpServletRequest req_;

    public ESHttpHeadersAccess(HttpServletRequest req) {
        this.req_ = req;
    }

    public String get(String name) throws SQLException {
        String h = this.req_.getHeader(name);
        if (h != null) {
            return h;
        }
        String nm = name.toLowerCase();
        if (nm.equals("request-method")) {
            return this.req_.getMethod();
        }
        if (nm.equals("request-uri")) {
            return this.req_.getRequestURI();
        }
        if (nm.equals("request-protocol")) {
            return this.req_.getProtocol();
        }
        if (nm.equals("servlet-path")) {
            return this.req_.getServletPath();
        }
        if (nm.equals("path-info")) {
            return this.req_.getPathInfo();
        }
        if (nm.equals("path-translated")) {
            return this.req_.getPathTranslated();
        }
        if (nm.equals("query-string")) {
            return this.req_.getQueryString();
        }
        if (nm.equals("content-length")) {
            return Integer.toString(this.req_.getContentLength());
        }
        if (nm.equals("content-type")) {
            return this.req_.getContentType();
        }
        if (nm.equals("server-name")) {
            return this.req_.getServerName();
        }
        if (nm.equals("server-port")) {
            return Integer.toString(this.req_.getServerPort());
        }
        if (nm.equals("remote-user")) {
            return this.req_.getRemoteUser();
        }
        if (nm.equals("remote-address")) {
            return this.req_.getRemoteAddr();
        }
        if (nm.equals("remote-host")) {
            return this.req_.getRemoteHost();
        }
        if (nm.equals("authorization-scheme")) {
            return this.req_.getAuthType();
        }
        return this.req_.getHeader(name);
    }
}

