/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.gencode;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Category;
import org.experlog.base.ESAction;
import org.experlog.base.ESServletRequest;
import org.experlog.base.OpenClient;
import org.experlog.db.DatasourceProperty;
import org.experlog.db.ESCallable;
import org.experlog.db.ESDBDataSet;
import org.experlog.gencode.CmdTokenizer;
import org.experlog.gencode.CustomStatement;
import org.experlog.gencode.DynHtml;
import org.experlog.gencode.ESDateAccess;
import org.experlog.gencode.ESHttpHeadersAccess;
import org.experlog.gencode.ESLoopExitException;
import org.experlog.gencode.ExitException;
import org.experlog.gencode.ExpEval;
import org.experlog.gencode.ExpOperand;
import org.experlog.gencode.ExpParser;
import org.experlog.gencode.ResourceBundleAccess;
import org.experlog.gencode.UserObject;
import org.experlog.openeas.api.DataObject;
import org.experlog.openeas.api.DataSet;
import org.experlog.util.AppConfiguration;
import org.experlog.util.BufferedRandomAccessFile;
import org.experlog.util.Client;
import org.experlog.util.ESCategory;
import org.experlog.util.ESEnumDataSet;
import org.experlog.util.ESFileDataSet;
import org.experlog.util.ESMaterializeDataSet;
import org.experlog.util.StringUtils;

public class ESDynHtml
implements DynHtml {
    File input_ = null;
    int lnb_ = 0;
    boolean inner_ = false;
    OpenClient session_ = null;
    ESServletRequest req_ = null;
    boolean hasResults_ = false;
    boolean errorSet_ = false;
    boolean displayUnresolved_ = false;
    int looplevel_ = 0;
    int iflevel_ = 0;
    Hashtable requests_ = new Hashtable();
    Hashtable params_ = null;
    Hashtable loopstart_ = new Hashtable();
    Hashtable datasets_ = new Hashtable();
    Hashtable dataobjects_ = new Hashtable();
    Hashtable customStatements_ = null;
    Hashtable procedures_ = new Hashtable();
    Locale formatLocale_ = Locale.getDefault();
    ESDateAccess dateaccess_;
    Category logger_ = null;
    Hashtable uObjects_ = null;
    String encodingValue = null;

    public ESDynHtml() {
    }

    public ESDynHtml(Client session, File file) {
        this(session, file, true);
    }

    public ESDynHtml(Client session, File file, boolean enforceSecurity) {
        try {
            this.session_ = (OpenClient)session;
            this.setInputFile(file, enforceSecurity);
            if (session != null) {
                this.logger_ = ESCategory.getCategory(session.getAppName(), "openeas.gencode");
                String unr = session.getAppConfiguration().get("displayUnresolvedNames");
                if (unr != null && unr.trim().toLowerCase().equals("true")) {
                    this.displayUnresolved_ = true;
                }
                this.formatLocale_ = session.getAppConfiguration().getFormatLocale();
            }
            this.dateaccess_ = new ESDateAccess();
            this.addDataObject("CurrentDate", this.dateaccess_);
            this.addDataObject("ResourceBundle", new ResourceBundleAccess(this));
            this.encodingValue = session.getAppConfiguration().getEncodingValue();
            if (this.logger_ == null) {
                this.logger_ = ESCategory.getCategory("openeas.gencode");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.logError("Internal error: " + e);
        }
    }

    public boolean isInner() {
        return this.inner_;
    }

    public void setInner(boolean inner) {
        this.inner_ = inner;
    }

    public OpenClient getSession() {
        return this.session_;
    }

    void logError(String info) {
        if (this.logger_ == null) {
            this.logger_ = ESCategory.getCategory("openeas.gencode");
        }
        String msg = "[" + new Date(System.currentTimeMillis()) + "] ERROR IN TEMPLATE " + this.input_.getName() + " line " + this.lnb_ + ": " + info;
        this.logger_.error((Object)msg);
        System.err.println(msg);
    }

    String getPositionInfo(boolean timestamp) {
        return (timestamp ? "[" + new Date(System.currentTimeMillis()) + "] " : "") + "[ TEMPLATE " + this.input_.getName() + " line " + this.lnb_ + " ] ";
    }

    public void displayUnresolved(boolean yes) {
        this.displayUnresolved_ = yes;
    }

    public void setInputFile(File file) throws IOException {
        this.setInputFile(file, true);
    }

    public void setInputFile(File file, boolean enforceSecurity) throws IOException {
        if (file != null && enforceSecurity && !AppConfiguration.isSecurePath(file.getPath())) {
            throw new IOException("ExpandFile: Access denied to " + file.getPath());
        }
        this.input_ = file;
    }

    public void addDataSet(String name, DataSet ds) {
        DataSet d = (DataSet)this.datasets_.remove(name);
        if (d != null) {
            try {
                d.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.datasets_.put(name, ds);
    }

    public void addDataObject(String name, DataObject t) {
        this.dataobjects_.put(name, t);
    }

    public void setParameter(String name, String val, boolean addtoreq) {
        if (this.params_ == null) {
            this.params_ = new Hashtable();
        }
        this.params_.put(name, val);
        if (addtoreq && this.req_ != null) {
            this.req_.addParameter(name, val);
        }
    }

    public void setParameters(Hashtable h, boolean addtoreq) {
        if (this.params_ == null) {
            this.params_ = h;
        } else {
            Enumeration en = h.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                Object val = h.get(key);
                this.params_.put(key, val);
                if (!addtoreq || this.req_ == null) continue;
                this.req_.addParameter(key.toString(), val.toString());
            }
        }
    }

    public void setServletRequest(ESServletRequest req) {
        this.req_ = req;
        this.setParameters(req.getAllParams(), false);
        this.addDataObject("HttpHeaders", new ESHttpHeadersAccess(req.getServletRequest()));
    }

    private void closeDataSets() {
        Enumeration nm = this.datasets_.keys();
        while (nm.hasMoreElements()) {
            DataSet ds = (DataSet)this.datasets_.get(nm.nextElement());
            try {
                ds.close();
            }
            catch (Exception exception) {}
        }
    }

    private void closeProcedures() {
        Enumeration nm = this.procedures_.keys();
        while (nm.hasMoreElements()) {
            ESCallable ds = (ESCallable)this.procedures_.get(nm.nextElement());
            try {
                ds.close();
            }
            catch (Exception e) {
                this.logger_.error((Object)"Problem to close procedure");
            }
        }
    }

    private void closeUserObjects() {
        if (this.uObjects_ != null) {
            Enumeration nm = this.uObjects_.keys();
            while (nm.hasMoreElements()) {
                UserObject uo = (UserObject)this.uObjects_.get(nm.nextElement());
                uo.close();
                Object var2_2 = null;
            }
        }
    }

    public void expand(PrintWriter out) throws ExitException {
        this.expand(out, true);
        this.setPriority(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(PrintWriter out, boolean closeds) throws ExitException {
        BufferedRandomAccessFile in = null;
        try {
            String line;
            in = new BufferedRandomAccessFile(this.input_);
            while ((line = in.readLine()) != null) {
                ++this.lnb_;
                this.expandLine(line, in, out);
            }
            this.flush(out);
            in.close();
        }
        catch (ExitException e) {
            this.flush(out);
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (e.exitAll() && this.inner_) {
                throw e;
            }
        }
        catch (Exception e) {
            this.logError(e.toString());
            e.printStackTrace(System.err);
            out.println("<p><b>[" + new Date(System.currentTimeMillis()) + "] INTERNAL ERROR IN " + this.input_.getName() + " line " + this.lnb_ + ": " + e + "</b></p>");
            this.flush(out);
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        finally {
            if (closeds) {
                this.closeDataSets();
                this.closeProcedures();
                this.closeUserObjects();
            }
        }
    }

    void expandLine(String line, BufferedRandomAccessFile in, PrintWriter out) throws Exception {
        if (this.startsWW(line, "$EXITALL")) {
            throw new ExitException(true);
        }
        if (this.startsWW(line, "$EXIT")) {
            throw new ExitException(false);
        }
        if (this.isComment(line)) {
            return;
        }
        CustomStatement stmt = null;
        if (this.isAdmOnly(line)) {
            this.checkAdmLogin();
        } else if (this.isDebug(line)) {
            this.traceLine(line);
        } else if (this.isAction(line)) {
            this.runAction(line.trim());
        } else if (this.isDefineSql(line)) {
            this.defineSql(line.trim());
        } else if (this.isAppendSql(line)) {
            this.appendSql(line.trim());
        } else if (this.isExecSql(line)) {
            this.execSql(line.trim());
        } else if (this.isExpandSql(line)) {
            this.expandSql(line.trim());
        } else if (this.isLoopBegin(line)) {
            this.expandLoop(line.trim(), in, out);
        } else if (this.isExpandFile(line)) {
            this.expandFile(line.trim(), out, false);
        } else if (this.isInclude(line)) {
            this.expandFile(line.trim(), out, true);
        } else if (this.isCookie(line)) {
            this.handleCookie(out);
        } else if (this.isAssign(line) || this.isDefVar(line)) {
            this.assignParam(line.trim());
        } else if (this.isSetCookie(line)) {
            this.setCookie(line.trim());
        } else if (this.isAppend(line)) {
            this.appendParam(line.trim());
        } else if (this.isCalc(line)) {
            this.doCalc(line.trim());
        } else if (this.isCheckNumber(line)) {
            this.checkNumber(line.trim());
        } else if (this.isClearError(line)) {
            this.errorSet_ = false;
        } else if (this.isIf(line)) {
            this.expandIf(line, in, out, true);
        } else if (this.isMaterialize(line)) {
            this.expandMaterialize(line.trim());
        } else if (this.isSystem(line)) {
            this.expandSystem(line.trim(), out);
        } else if (this.isSwitch(line)) {
            this.expandSwitch(line, in, out, true);
        } else if (this.isDefineSqlProc(line)) {
            this.expandDefineSqlProc(line.trim());
        } else if (this.isRegisterOutParameter(line)) {
            this.expandRegisterOutParameter(line.trim());
        } else if (this.isExecSqlProc(line)) {
            this.expandExecSqlProc(line.trim());
        } else if (this.isNewObject(line)) {
            this.expandNewObject(line.trim());
        } else if (this.isInvoke(line)) {
            this.expandInvoke(line.trim());
        } else if (this.isCloseObject(line)) {
            this.expandCloseObject(line.trim());
        } else if (this.isForward(line)) {
            this.expandForward(line);
        } else {
            stmt = this.getStatement(line);
            if (stmt != null) {
                stmt.execute(line.trim(), in, out, this);
            } else {
                this.println(out, this.expandString(line, this.params_));
            }
        }
    }

    public void addStatement(String name, CustomStatement stmt) {
        if (this.customStatements_ == null) {
            this.customStatements_ = new Hashtable();
        }
        this.customStatements_.put(name.toLowerCase(), stmt);
    }

    public CustomStatement getStatement(String line) {
        if (this.customStatements_ == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(line);
        if (!st.hasMoreTokens()) {
            return null;
        }
        return (CustomStatement)this.customStatements_.get(st.nextToken().toLowerCase());
    }

    void expandIf(String line, BufferedRandomAccessFile in, PrintWriter out, boolean visible) throws Exception {
        if (this.isErrorCase(line)) {
            this.handleErrorCase(in, out, visible);
        } else if (this.isNoResultCase(line)) {
            this.handleNoResultCase(line.trim(), in, out, visible);
        } else if (this.isPresenceCheck(line)) {
            this.handlePresenceCheck(line.trim(), in, out, visible);
        } else if (this.isFilePresenceCheck(line)) {
            this.handleFilePresenceCheck(line.trim(), in, out, visible);
        } else if (this.isEqual(line)) {
            this.checkEqual(line.trim(), in, out, visible);
        } else if (this.isCompareNumbers(line)) {
            this.compareNumbers(line.trim(), in, out, visible);
        } else if (this.isEval(line)) {
            this.expandEval(line, in, out, this.params_, visible);
        }
    }

    boolean startsWW(String base, String test) {
        int i;
        int l = base.length();
        for (i = 0; i < l && Character.isWhitespace(base.charAt(i)); ++i) {
        }
        int t = test.length();
        if (!base.regionMatches(true, i, test, 0, t)) {
            return false;
        }
        if ((i += t) >= l) {
            return true;
        }
        char c = base.charAt(i);
        return c == ' ' || c == '\t' || c == '\n';
    }

    boolean isComment(String s) {
        return s.trim().startsWith("$#");
    }

    boolean isAdmOnly(String s) {
        return this.startsWW(s, "$ADMINISTRATORONLY");
    }

    boolean isDebug(String s) {
        return this.startsWW(s, "$DEBUG");
    }

    boolean isAction(String s) {
        return this.startsWW(s, "$ACTION");
    }

    boolean isAssign(String s) {
        return this.startsWW(s, "$ASSIGN");
    }

    boolean isDefVar(String s) {
        return this.startsWW(s, "$DEFVAR");
    }

    boolean isSetCookie(String s) {
        return this.startsWW(s, "$SETCOOKIE");
    }

    boolean isCalc(String s) {
        return this.startsWW(s, "$ADD") || this.startsWW(s, "$SUB") || this.startsWW(s, "$MUL") || this.startsWW(s, "$DIV");
    }

    boolean isCheckNumber(String s) {
        return this.startsWW(s, "$CHECKNUMBER");
    }

    boolean isDefineSql(String s) {
        return this.startsWW(s, "$DEFINESQL");
    }

    boolean isMaterialize(String s) {
        return this.startsWW(s, "$MATERIALIZE");
    }

    boolean isSystem(String s) {
        return this.startsWW(s, "$SYSTEM");
    }

    boolean isAppendSql(String s) {
        return this.startsWW(s, "$APPENDSQL") || this.startsWW(s, "$APPENDSQL2");
    }

    boolean isAppend(String s) {
        return this.startsWW(s, "$APPEND");
    }

    boolean isExecSql(String s) {
        return this.startsWW(s, "$EXECSQL");
    }

    boolean isExpandSql(String s) {
        return this.startsWW(s, "$EXPANDSQL");
    }

    boolean isLoopBegin(String s) {
        return this.startsWW(s, "$LOOPONRESULTS") || this.startsWW(s, "$LOOPONENUM") || this.startsWW(s, "$LOOPONFILES");
    }

    boolean isLoopExit(String s) {
        return this.startsWW(s, "$EXITLOOP");
    }

    boolean isEndLoop(String s) {
        return this.startsWW(s, "$ENDLOOP");
    }

    boolean isErrorCase(String s) {
        return this.startsWW(s, "$IFERROR");
    }

    boolean isClearError(String s) {
        return this.startsWW(s, "$CLEARERROR");
    }

    boolean isNoResultCase(String s) {
        return this.startsWW(s, "$IFNORESULT");
    }

    boolean isCookie(String s) {
        return this.startsWW(s, "$COOKIE");
    }

    boolean isPresenceCheck(String s) {
        return this.startsWW(s, "$IFPRESENT");
    }

    boolean isFilePresenceCheck(String s) {
        return this.startsWW(s, "$IFFILEPRESENT");
    }

    boolean isEqual(String s) {
        return this.startsWW(s, "$IFEQUAL");
    }

    boolean isSwitch(String s) {
        return this.startsWW(s, "$SWITCH");
    }

    boolean isCompareNumbers(String s) {
        return this.startsWW(s, "$IFEE") || this.startsWW(s, "$IFLE") || this.startsWW(s, "$IFLT") || this.startsWW(s, "$IFGE") || this.startsWW(s, "$IFGT");
    }

    boolean isIf(String s) {
        return this.isErrorCase(s) || this.isNoResultCase(s) || this.isPresenceCheck(s) || this.isFilePresenceCheck(s) || this.isEqual(s) || this.isCompareNumbers(s) || this.isEval(s);
    }

    boolean isElse(String s) {
        return this.startsWW(s, "$ELSE");
    }

    boolean isEndIf(String s) {
        return this.startsWW(s, "$ENDIF");
    }

    boolean isExpandFile(String s) {
        return this.startsWW(s, "$EXPANDFILE");
    }

    boolean isInclude(String s) {
        return this.startsWW(s, "$INCLUDE");
    }

    boolean isCase(String s) {
        return this.startsWW(s, "$CASE");
    }

    boolean isDefaultCase(String s) {
        return this.startsWW(s, "$DEFAULT");
    }

    boolean isEndSwitch(String s) {
        return this.startsWW(s, "$ENDSWITCH");
    }

    boolean isEndCase(String s) {
        return this.startsWW(s, "$ENDCASE");
    }

    boolean isEval(String s) {
        return this.startsWW(s, "$IF");
    }

    boolean isForward(String s) {
        return this.startsWW(s, "$FORWARD");
    }

    boolean isDefineSqlProc(String s) {
        return this.startsWW(s, "$DEFINESQLPROC");
    }

    boolean isRegisterOutParameter(String s) {
        return this.startsWW(s, "$REGISTEROUTPARAMETER");
    }

    boolean isExecSqlProc(String s) {
        return this.startsWW(s, "$EXECSQLPROC");
    }

    boolean isNewObject(String s) {
        return this.startsWW(s, "$NEWOBJECT");
    }

    boolean isInvoke(String s) {
        return this.startsWW(s, "$INVOKE");
    }

    boolean isCloseObject(String s) {
        return this.startsWW(s, "$CLOSEOBJECT");
    }

    void traceLine(String line) throws Exception {
        if (line.length() < 8) {
            return;
        }
        String traces = line.trim().substring(7).trim();
        this.logger_.fatal((Object)("$Debug: " + traces));
        this.logger_.fatal((Object)("$Debug with expand: " + this.expandString(traces)));
    }

    void checkAdmLogin() throws IOException {
        if (!this.session_.isAdministrator()) {
            throw new IOException("ACCESS DENIED: Accessing this page requires ADMINISTRATOR rights");
        }
    }

    void assignParam(String line) throws IOException, SQLException {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String name = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        int pos = 8 + line.substring(8).indexOf(name) + name.length() + 1;
        String value = line.substring(pos).trim();
        boolean expd = false;
        if (value.equals("\"\"")) {
            value = "";
            expd = true;
        } else if (value.equals("\" \"")) {
            value = " ";
            expd = true;
        } else if (value.startsWith("(") && value.endsWith(")")) {
            value = this.expandString(value);
            expd = true;
            ExpParser parser = new ExpParser(value, false);
            ExpOperand operand = parser.parse();
            String w = parser.getWarning();
            if (w != null) {
                this.logger_.debug((Object)(this.getPositionInfo(true) + w));
            }
            if (operand != null && !operand.isStringValue()) {
                ExpEval eval = new ExpEval();
                value = Double.toString(eval.eval(operand));
            }
        }
        if (name.startsWith("$") && name.endsWith("$")) {
            name = this.expandString(name);
        }
        this.setParameter(name, expd ? value : this.expandString(value), this.isAssign(line));
    }

    void appendParam(String line) throws IOException, SQLException {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String name = st.nextToken();
        String prevval = (String)this.params_.get(name);
        if (prevval == null) {
            throw new IOException("$Append: undefined variable " + name);
        }
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        int pos = 8 + line.substring(8).indexOf(name) + name.length() + 1;
        String value = line.substring(pos).trim();
        if (value.equals("\"\"")) {
            value = "";
        } else if (value.equals("\" \"")) {
            value = " ";
        }
        boolean isparm = this.req_ != null && this.req_.getParameter(name) != null;
        this.setParameter(name, prevval + this.expandString(value), isparm);
    }

    void expandForward(String line) throws IOException {
        if (this.req_.getServletResponse() == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        HttpServletRequest r = this.req_.getServletRequest();
        try {
            r.getRequestDispatcher(st.nextToken()).forward((ServletRequest)r, (ServletResponse)this.req_.getServletResponse());
        }
        catch (ServletException e) {
            throw new IOException(e.getMessage());
        }
    }

    void setCookie(String line) throws IOException, SQLException {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String name = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        int pos = 11 + line.substring(11).indexOf(name) + name.length() + 1;
        String value = line.substring(pos).trim();
        if (value.equals("\"\"")) {
            value = "";
        } else if (value.equals("\" \"")) {
            value = " ";
        }
        this.session_.getCookie().set(name, this.expandString(value));
    }

    void runAction(String line) throws Exception {
        ESAction act;
        int pos;
        this.logger_.debug((Object)("ESDynHtml:runAction " + line));
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String clazz = st.nextToken();
        if (clazz.startsWith("$") && clazz.endsWith("$")) {
            clazz = this.getVarValue(clazz.substring(1, clazz.length() - 1), this.params_, false);
        }
        String info = null;
        if (st.hasMoreTokens() && (info = line.substring(pos = 8 + line.substring(8).indexOf(clazz) + clazz.length() + 1).trim()).startsWith("$") && info.endsWith("$")) {
            info = this.getVarValue(info.substring(1, info.length() - 1), this.params_, false);
        }
        this.errorSet_ = !(act = (ESAction)Class.forName(clazz).newInstance()).processRequest(this.session_, this.req_, this, info);
        this.setServletRequest(this.req_);
    }

    void defineSql(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String name = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        StringBuffer req = new StringBuffer(st.nextToken());
        while (st.hasMoreTokens()) {
            req.append(" " + st.nextToken());
        }
        this.requests_.put(name, req.toString());
    }

    void appendSql(String line) throws Exception {
        boolean expand = false;
        StringTokenizer st = new StringTokenizer(line);
        String stmt = st.nextToken();
        if (stmt.endsWith("2")) {
            expand = true;
        }
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String reqname = st.nextToken();
        String req = (String)this.requests_.get(reqname);
        if (req == null) {
            throw new IOException("$AppendSql: Undefined request: " + reqname + " line " + this.lnb_);
        }
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String clausestart = st.nextToken().toUpperCase();
        StringBuffer reqbuf = new StringBuffer(req.trim());
        String clause = line.substring((expand ? 12 : 11) + reqname.length()).trim();
        if (req.toUpperCase().endsWith("WHERE")) {
            if (clausestart.equals("AND")) {
                reqbuf.append(" " + clause.substring(4));
            } else if (clausestart.equals("OR")) {
                reqbuf.append(" " + clause.substring(3));
            } else {
                reqbuf.append(" " + clause);
            }
        } else {
            reqbuf.append(" " + clause);
        }
        if (expand) {
            this.requests_.put(reqname, this.expandString(reqbuf.toString(), this.params_, true));
        } else {
            this.requests_.put(reqname, reqbuf.toString());
        }
    }

    void execSql(String line) throws Exception {
        block18: {
            String d;
            this.errorSet_ = false;
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new IOException(this.syntaxError(line));
            }
            String reqname = st.nextToken();
            String req = (String)this.requests_.get(reqname);
            if (req == null) {
                throw new Exception("(execSql 2) Undefined request: " + req + " line " + this.lnb_);
            }
            String sql = this.expandString(req, this.params_);
            String datasource = null;
            if (st.hasMoreTokens() && (datasource = this.expandString(d = st.nextToken(), this.params_)).compareTo("") == 0) {
                datasource = null;
            }
            DataSet ds = null;
            Connection c = null;
            try {
                char cc;
                int i;
                int l = sql.length();
                for (i = 0; i < l && ((cc = sql.charAt(i)) == ' ' || cc == '\t' || cc == '('); ++i) {
                }
                if (sql.regionMatches(true, i, "SELECT", 0, 6)) {
                    this.logger_.debug((Object)("ESDynHtml:sql=" + sql + " with datasource=<" + datasource + "> with session=<" + this.session_.toString() + "> started"));
                    this.session_.logRequest(datasource, sql);
                    c = this.session_.getConnection(datasource);
                    Statement stat = null;
                    try {
                        stat = c.createStatement(1005, 1007);
                        if (stat == null) {
                            stat = c.createStatement();
                        }
                    }
                    catch (Exception e) {
                        if (stat != null) {
                            try {
                                stat.close();
                            }
                            catch (Exception ee) {
                                // empty catch block
                            }
                        }
                        stat = c.createStatement();
                    }
                    ds = new ESDBDataSet(stat.executeQuery(sql), this.session_, c, datasource, stat);
                    this.logger_.debug((Object)("ESDynHtml:sql=" + sql + " with datasource=<" + datasource + "> with session=<" + this.session_.toString() + "> ended"));
                    this.addDataSet(reqname, ds);
                    break block18;
                }
                this.logger_.debug((Object)("ESDynHtml:sql=" + sql));
                this.session_.updateDB(datasource, sql);
            }
            catch (Exception e) {
                this.logError("sql=[" + sql + "] " + e);
                e.printStackTrace(System.err);
                try {
                    if (ds != null) {
                        this.datasets_.remove(reqname);
                        ds.close();
                    } else if (c != null) {
                        this.session_.closeConnection(c, datasource);
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                this.errorSet_ = true;
            }
        }
    }

    void expandSql(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String reqname = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String varname = st.nextToken();
        String req = (String)this.requests_.get(reqname);
        if (req == null) {
            throw new Exception("(expandSql) Undefined request: " + req + " line " + this.lnb_);
        }
        this.setParameter(varname, this.expandString(req, this.params_), false);
    }

    boolean expandCase(String ln, BufferedRandomAccessFile in, PrintWriter out, String sw, boolean defaultcase) throws Exception {
        boolean aboolean = false;
        StringTokenizer st = new StringTokenizer(ln);
        st.nextToken().toUpperCase();
        if (!st.hasMoreTokens() && !defaultcase) {
            throw new IOException(this.syntaxError(ln));
        }
        String cas = null;
        if (!defaultcase) {
            cas = st.nextToken();
        }
        boolean endCase = false;
        String var = this.getVarValue(sw, this.params_, false);
        if (cas != null && cas.startsWith("$") && cas.endsWith("$")) {
            cas = this.getVarValue(cas.substring(1, cas.length() - 1), this.params_, false);
        }
        if (defaultcase || var.compareTo(cas) == 0) {
            String line;
            aboolean = true;
            while (!endCase && (line = in.readLine()) != null) {
                ++this.lnb_;
                if (this.isSwitch(line)) {
                    this.expandSwitch(line, in, out, true);
                    continue;
                }
                if (this.isEndCase(line)) {
                    endCase = true;
                    continue;
                }
                this.expandLine(line, in, out);
            }
        } else {
            String line;
            while (!endCase && (line = in.readLine()) != null) {
                ++this.lnb_;
                if (this.isSwitch(line)) {
                    this.expandSwitch(line, in, out, false);
                    continue;
                }
                if (!this.isEndCase(line)) continue;
                endCase = true;
            }
        }
        return aboolean;
    }

    void expandSwitch(String ln, BufferedRandomAccessFile in, PrintWriter out, boolean visible) throws Exception {
        String line;
        StringTokenizer st = new StringTokenizer(ln);
        st.nextToken().toUpperCase();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(ln));
        }
        String swit = st.nextToken();
        boolean endSwitch = false;
        boolean found = false;
        while (!endSwitch && (line = in.readLine()) != null) {
            ++this.lnb_;
            if (visible && this.isCase(line) && !found) {
                found = this.expandCase(line, in, out, swit, false);
                continue;
            }
            if (this.isEndSwitch(line)) {
                endSwitch = true;
                continue;
            }
            if (!visible || !this.isDefaultCase(line) || found) continue;
            this.expandCase(line, in, out, swit, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expandLoop(String ln, BufferedRandomAccessFile in, PrintWriter out) throws Exception {
        StringTokenizer st = new StringTokenizer(ln);
        String loopop = st.nextToken().toUpperCase();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(ln));
        }
        String dsname = st.nextToken();
        String elemname = st.hasMoreTokens() ? st.nextToken() : new String("tuple");
        int ind1 = -1;
        int ind2 = -1;
        try {
            if (st.hasMoreTokens()) {
                ind1 = Integer.parseInt(this.expandString(st.nextToken()));
            }
            if (st.hasMoreTokens()) {
                ind2 = Integer.parseInt(this.expandString(st.nextToken()));
            }
        }
        catch (NumberFormatException ne) {
            throw new Exception("ESDynHtml:expandLoop loop boundaries should be integers - line=" + this.lnb_);
        }
        if (ind1 >= 0 && ind2 >= 0 && ind2 < ind1) {
            throw new Exception("ESDynHtml:expandLoop check syntax (i>=1, j>=i) line=" + this.lnb_);
        }
        String line = null;
        int prevlevel = this.looplevel_;
        DataSet ds = null;
        try {
            if (loopop.equals("$LOOPONENUM")) {
                this.addDataSet(dsname, new ESEnumDataSet(this.getVarValue(dsname, this.params_, false), ","));
            } else if (loopop.equals("$LOOPONFILES")) {
                String fnm = dsname;
                if (fnm.startsWith("$") && fnm.endsWith("$")) {
                    dsname = fnm = this.getVarValue(fnm.substring(1, fnm.length() - 1), this.params_, false);
                }
                this.addDataSet(dsname, new ESFileDataSet(this.input_, fnm));
            }
            ds = (DataSet)this.datasets_.get(dsname);
            if (ds != null) {
                ds.open();
                if (ind1 >= 0) {
                    ds.setBoundaries(ind1, ind2);
                }
            }
            if (ds == null || !ds.next()) {
                if (this.looplevel_ == 0) {
                    this.setPriority(1);
                }
                ++this.looplevel_;
                while (this.looplevel_ > prevlevel && (line = in.readLine()) != null) {
                    ++this.lnb_;
                    if (this.isLoopBegin(line)) {
                        if (this.looplevel_ == 0) {
                            this.setPriority(1);
                        }
                        ++this.looplevel_;
                        continue;
                    }
                    if (!this.isEndLoop(line)) continue;
                    --this.looplevel_;
                    if (this.looplevel_ != 0) continue;
                    this.setPriority(5);
                }
                if (ds != null) {
                    if (ds.isTransient()) {
                        this.datasets_.remove(dsname);
                    }
                    ds.close();
                }
                return;
            }
        }
        catch (Exception e) {
            if (ds != null) {
                if (ds.isTransient()) {
                    this.datasets_.remove(dsname);
                }
                ds.close();
            }
            throw e;
        }
        this.loopstart_.put(dsname, new Long(in.getFilePointer()));
        int start_lnb = this.lnb_;
        int nbtrace = 0;
        try {
            do {
                this.logger_.debug((Object)("LOOP ON DATA SET : " + ++nbtrace));
                Long fp = (Long)this.loopstart_.get(dsname);
                in.seek(fp);
                this.lnb_ = start_lnb;
                if (this.looplevel_ == 0) {
                    this.setPriority(1);
                }
                ++this.looplevel_;
                this.logger_.debug((Object)"ESDynHtml:expandLoop avant appel getTuple");
                this.dataobjects_.put(elemname, ds.getTuple());
                this.logger_.debug((Object)"ESDynHtml:expandLoop apres appel getTuple");
                try {
                    this.logger_.debug((Object)"ESDynHtml:expandLoop dans le try");
                    while (this.looplevel_ > prevlevel && (line = in.readLine()) != null) {
                        this.logger_.debug((Object)"ESDynHtml:expandLoop dans le loop");
                        ++this.lnb_;
                        if (this.isLoopBegin(line)) {
                            this.expandLoop(line, in, out);
                            continue;
                        }
                        if (this.isEndLoop(line)) {
                            --this.looplevel_;
                            if (this.looplevel_ != 0) continue;
                            this.setPriority(5);
                            continue;
                        }
                        if (this.isExpandFile(line)) {
                            this.expandFile(line, out, false);
                            continue;
                        }
                        if (this.isInclude(line)) {
                            this.expandFile(line, out, true);
                            continue;
                        }
                        if (this.isLoopExit(line)) {
                            throw new ESLoopExitException();
                        }
                        this.logger_.debug((Object)"ESDynHtml:expandLoop avant le expand");
                        this.expandLine(line, in, out);
                        this.logger_.debug((Object)"ESDynHtml:expandLoop apres le expand");
                    }
                }
                catch (ESLoopExitException ee) {
                    this.logger_.debug((Object)"ESDynHtml:expandLoop dans le catch ESLoopExitException");
                    while (this.looplevel_ > prevlevel && (line = in.readLine()) != null) {
                        ++this.lnb_;
                        if (this.isLoopBegin(line)) {
                            ++this.looplevel_;
                            continue;
                        }
                        if (!this.isEndLoop(line)) continue;
                        --this.looplevel_;
                    }
                    if (this.looplevel_ <= 0) {
                        this.setPriority(5);
                    }
                    throw new ESLoopExitException();
                }
                if (line != null) continue;
                throw new Exception("(expandLoop 2) Unexpected EOF line " + this.lnb_);
            } while (ds.next());
        }
        catch (ESLoopExitException e) {
        }
        finally {
            this.dataobjects_.remove(elemname);
            this.loopstart_.remove(dsname);
            if (ds != null) {
                this.logger_.debug((Object)"ESDynHtml:expandLoop avant appel du close");
                ds.close();
                if (ds.isTransient()) {
                    this.datasets_.remove(dsname);
                }
                this.logger_.debug((Object)"ESDynHtml:expandLoop apres appel du close");
            }
        }
    }

    void handleNoResultCase(String ln, BufferedRandomAccessFile in, PrintWriter out, boolean visible) throws Exception {
        String line;
        boolean displayline;
        StringTokenizer st = new StringTokenizer(ln);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(ln));
        }
        int prevlevel = this.iflevel_++;
        String dsname = st.nextToken();
        DataSet ds = (DataSet)this.datasets_.get(dsname);
        this.logger_.debug((Object)"ESDynHtml:handleNoResultCase");
        boolean bl = displayline = ds == null || !ds.dataAvailable();
        if (ds != null && displayline) {
            this.datasets_.remove(dsname);
            ds.close();
        }
        while (this.iflevel_ > prevlevel && (line = in.readLine()) != null) {
            ++this.lnb_;
            if (this.isIf(line)) {
                this.expandIf(line, in, out, visible && displayline);
                continue;
            }
            if (this.isEndIf(line)) {
                --this.iflevel_;
                continue;
            }
            if (this.isElse(line)) {
                displayline = !displayline;
                continue;
            }
            if (this.isLoopExit(line) && visible && displayline) {
                throw new ESLoopExitException("Unexpected $ExitLoop line " + this.lnb_);
            }
            if (!visible || !displayline) continue;
            this.expandLine(line, in, out);
        }
    }

    void handleErrorCase(BufferedRandomAccessFile in, PrintWriter out, boolean visible) throws Exception {
        String line;
        boolean displayline = this.errorSet_;
        int prevlevel = this.iflevel_++;
        while (this.iflevel_ > prevlevel && (line = in.readLine()) != null) {
            ++this.lnb_;
            if (this.isIf(line)) {
                this.expandIf(line, in, out, visible && displayline);
                continue;
            }
            if (this.isEndIf(line)) {
                --this.iflevel_;
                continue;
            }
            if (this.isElse(line)) {
                displayline = !displayline;
                continue;
            }
            if (this.isLoopExit(line) && visible && displayline) {
                throw new ESLoopExitException("Unexpected $ExitLoop line " + this.lnb_);
            }
            if (!visible || !displayline) continue;
            this.expandLine(line, in, out);
        }
    }

    void handleCookie(PrintWriter out) throws UnsupportedEncodingException {
        this.println(out, "<input type=\"hidden\" name=\"S_\" value=\"" + URLEncoder.encode(this.session_.getClientId(), this.encodingValue) + "\" />");
    }

    void handlePresenceCheck(String cmd, BufferedRandomAccessFile in, PrintWriter out, boolean visible) throws Exception {
        String line;
        StringTokenizer st = new StringTokenizer(cmd);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(cmd));
        }
        int prevlevel = this.iflevel_++;
        boolean present = visible;
        if (visible) {
            while (st.hasMoreTokens()) {
                String field = st.nextToken();
                if (this.evalVariable(field, this.params_) != null) continue;
                present = false;
            }
        }
        boolean displayline = present;
        while (this.iflevel_ > prevlevel && (line = in.readLine()) != null) {
            ++this.lnb_;
            if (this.isIf(line)) {
                this.expandIf(line, in, out, visible && displayline);
                continue;
            }
            if (this.isEndIf(line)) {
                --this.iflevel_;
                continue;
            }
            if (this.isElse(line)) {
                displayline = !displayline;
                continue;
            }
            if (this.isLoopExit(line) && visible && displayline) {
                throw new ESLoopExitException("Unexpected $ExitLoop line " + this.lnb_);
            }
            if (!visible || !displayline) continue;
            this.expandLine(line, in, out);
        }
    }

    void handleFilePresenceCheck(String cmd, BufferedRandomAccessFile in, PrintWriter out, boolean visible) throws Exception {
        String line;
        StringTokenizer st = new StringTokenizer(cmd);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(cmd));
        }
        int prevlevel = this.iflevel_++;
        boolean present = visible;
        if (visible) {
            while (st.hasMoreTokens()) {
                String p;
                File tmp;
                File f;
                String fnm = st.nextToken();
                if (fnm.startsWith("$") && fnm.endsWith("$")) {
                    fnm = this.getVarValue(fnm.substring(1, fnm.length() - 1), this.params_, false);
                }
                if ((f = (tmp = new File(fnm)).isAbsolute() ? tmp : ((p = this.input_.getParent()) == null ? tmp : (p.endsWith(File.separator) ? new File(p + tmp) : new File(p + File.separatorChar + tmp)))).exists()) continue;
                present = false;
            }
        }
        boolean displayline = present;
        while (this.iflevel_ > prevlevel && (line = in.readLine()) != null) {
            ++this.lnb_;
            if (this.isIf(line)) {
                this.expandIf(line, in, out, visible && displayline);
                continue;
            }
            if (this.isEndIf(line)) {
                --this.iflevel_;
                continue;
            }
            if (this.isElse(line)) {
                displayline = !displayline;
                continue;
            }
            if (this.isLoopExit(line) && visible && displayline) {
                throw new ESLoopExitException("Unexpected $ExitLoop line " + this.lnb_);
            }
            if (!visible || !displayline) continue;
            this.expandLine(line, in, out);
        }
    }

    void checkNumber(String cmd) throws Exception {
        StringTokenizer st = new StringTokenizer(cmd);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(cmd));
        }
        String val = st.nextToken();
        if (val.startsWith("$") && val.endsWith("$")) {
            val = this.getVarValue(val.substring(1, val.length() - 1), this.params_, false);
        }
        try {
            Double.valueOf(val).doubleValue();
        }
        catch (NumberFormatException e) {
            this.errorSet_ = true;
        }
    }

    void doCalc(String cmd) throws Exception {
        double d2;
        double d1;
        StringTokenizer st = new StringTokenizer(cmd);
        String op = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(cmd));
        }
        String varname = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(cmd));
        }
        String val = st.nextToken();
        if (val.startsWith("$") && val.endsWith("$")) {
            val = this.getVarValue(val.substring(1, val.length() - 1), this.params_, false);
        }
        String varval = this.getVarValue(varname, this.params_, false);
        try {
            d1 = Double.valueOf(varval);
            d2 = Double.valueOf(val);
        }
        catch (NumberFormatException nf) {
            this.logError(cmd + ": " + nf);
            throw nf;
        }
        if (op.equalsIgnoreCase("$Add")) {
            d1 += d2;
        } else if (op.equalsIgnoreCase("$Sub")) {
            d1 -= d2;
        } else if (op.equalsIgnoreCase("$Mul")) {
            d1 *= d2;
        } else if (op.equalsIgnoreCase("$Div")) {
            d1 /= d2;
        } else {
            throw new IOException(this.syntaxError(cmd));
        }
        this.setParameter(varname, Double.toString(d1), true);
    }

    void expandEval(String ln, BufferedRandomAccessFile in, PrintWriter out, Hashtable params, boolean visible) throws Exception {
        String line = ln.trim().substring(3);
        String expline = this.expandString(line, params);
        boolean displayline = false;
        if (visible) {
            ExpEval eval = new ExpEval();
            ExpParser parser = new ExpParser(expline);
            displayline = eval.eval(parser.parse()) != 0.0;
            String w = parser.getWarning();
            if (w != null) {
                this.logger_.debug((Object)(this.getPositionInfo(true) + w));
            }
        }
        int prevlevel = this.iflevel_++;
        while (this.iflevel_ > prevlevel && (line = in.readLine()) != null) {
            ++this.lnb_;
            if (this.isIf(line)) {
                this.expandIf(line, in, out, visible && displayline);
                continue;
            }
            if (this.isEndIf(line)) {
                --this.iflevel_;
                continue;
            }
            if (this.isElse(line)) {
                displayline = !displayline;
                continue;
            }
            if (this.isLoopExit(line) && visible && displayline) {
                throw new ESLoopExitException("Unexpected $ExitLoop line " + this.lnb_);
            }
            if (!visible || !displayline) continue;
            this.expandLine(line, in, out);
        }
    }

    void compareNumbers(String cmd, BufferedRandomAccessFile in, PrintWriter out, boolean visible) throws Exception {
        String line;
        StringTokenizer st = new StringTokenizer(cmd);
        String op = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(cmd));
        }
        boolean displayline = false;
        if (visible) {
            double d2;
            double d1;
            String varname = st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new IOException(this.syntaxError(cmd));
            }
            String val = st.nextToken();
            if (val.startsWith("$") && val.endsWith("$")) {
                val = this.getVarValue(val.substring(1, val.length() - 1), this.params_, false);
            }
            String varval = this.getVarValue(varname, this.params_, false);
            try {
                varval = varval.replace(',', '.');
                val = val.replace(',', '.');
                d1 = Double.valueOf(varval);
                d2 = Double.valueOf(val);
            }
            catch (NumberFormatException nf) {
                this.logError(cmd + ": " + nf);
                throw nf;
            }
            if (op.equalsIgnoreCase("$IfEe")) {
                displayline = d1 == d2;
            } else if (op.equalsIgnoreCase("$IfLe")) {
                displayline = d1 <= d2;
            } else if (op.equalsIgnoreCase("$IfLt")) {
                displayline = d1 < d2;
            } else if (op.equalsIgnoreCase("$IfGe")) {
                displayline = d1 >= d2;
            } else if (op.equalsIgnoreCase("$IfGt")) {
                displayline = d1 > d2;
            } else {
                throw new IOException(this.syntaxError(cmd));
            }
        }
        int prevlevel = this.iflevel_++;
        while (this.iflevel_ > prevlevel && (line = in.readLine()) != null) {
            ++this.lnb_;
            if (this.isIf(line)) {
                this.expandIf(line, in, out, visible && displayline);
                continue;
            }
            if (this.isEndIf(line)) {
                --this.iflevel_;
                continue;
            }
            if (this.isElse(line)) {
                displayline = !displayline;
                continue;
            }
            if (this.isLoopExit(line) && visible && displayline) {
                throw new ESLoopExitException("Unexpected $ExitLoop line " + this.lnb_);
            }
            if (!visible || !displayline) continue;
            this.expandLine(line, in, out);
        }
    }

    void checkEqual(String cmd, BufferedRandomAccessFile in, PrintWriter out, boolean visible) throws Exception {
        String line;
        StringTokenizer st = new StringTokenizer(cmd);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(cmd));
        }
        String varname = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(cmd));
        }
        boolean displayline = visible;
        if (visible) {
            String val = cmd.substring(9 + varname.length()).trim();
            if (val.equals("\"\"") || val.length() < 1) {
                val = "";
            } else if (val.startsWith("$") && val.endsWith("$")) {
                val = this.getVarValue(val.substring(1, val.length() - 1), this.params_, false);
            }
            String val1 = this.getVarValue(varname, this.params_, false);
            this.logger_.debug((Object)("IfEqual: compare [" + val1 + "] [" + val + "]"));
            displayline = val1.equals(val);
        }
        int prevlevel = this.iflevel_++;
        while (this.iflevel_ > prevlevel && (line = in.readLine()) != null) {
            ++this.lnb_;
            if (this.isIf(line)) {
                this.expandIf(line, in, out, visible && displayline);
                continue;
            }
            if (this.isEndIf(line)) {
                --this.iflevel_;
                continue;
            }
            if (this.isElse(line)) {
                displayline = !displayline;
                continue;
            }
            if (this.isLoopExit(line) && visible && displayline) {
                throw new ESLoopExitException("Unexpected $ExitLoop line " + this.lnb_);
            }
            if (!visible || !displayline) continue;
            this.expandLine(line, in, out);
        }
    }

    void expandMaterialize(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String dsn = st.nextToken();
        if (dsn.startsWith("$") && dsn.endsWith("$")) {
            dsn = this.getVarValue(dsn.substring(1, dsn.length() - 1), this.params_, false);
        }
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String dss = st.nextToken();
        if (dss.startsWith("$") && dss.endsWith("$")) {
            dss = this.getVarValue(dss.substring(1, dss.length() - 1), this.params_, false);
        }
        String col = null;
        boolean asc = true;
        if (st.hasMoreTokens()) {
            col = st.nextToken();
            if (col.startsWith("-")) {
                asc = false;
                col = col.substring(1);
            }
            if (col.startsWith("$") && col.endsWith("$")) {
                col = this.getVarValue(col.substring(1, col.length() - 1), this.params_, false);
            }
        }
        try {
            ESMaterializeDataSet ds = new ESMaterializeDataSet((DataSet)this.datasets_.get(dsn));
            if (col != null) {
                ds.orderBy(col, asc);
            }
            this.addDataSet(dss, ds);
        }
        catch (Exception e) {
            throw new IOException("line " + this.lnb_ + ": Unknown Dataset or wrong Dataset state for " + dsn + ": " + e);
        }
    }

    void expandSystem(String line, PrintWriter out) throws Exception {
        int n;
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String s = st.nextToken();
        if (s.startsWith("$") && s.endsWith("$")) {
            s = this.getVarValue(s.substring(1, s.length() - 1), this.params_, false);
        }
        StringBuffer b = new StringBuffer(s);
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s.startsWith("$") && s.endsWith("$")) {
                s = this.getVarValue(s.substring(1, s.length() - 1), this.params_, false);
            }
            b.append(" " + s);
        }
        Process p = Runtime.getRuntime().exec(CmdTokenizer.tokenize(b.toString()));
        InputStream inp = p.getInputStream();
        byte[] buf = new byte[512];
        while ((n = inp.read(buf)) >= 0) {
            if (n <= 0) continue;
            this.writeString(out, new String(buf, 0, n));
        }
    }

    void expandDefineSqlProc(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        String start = st.nextToken();
        String sql = this.expandString(line.substring(line.indexOf(start) + start.length(), line.length()), this.params_);
        if (!(st = new StringTokenizer(sql)).hasMoreTokens()) {
            throw new IOException(this.syntaxError(sql));
        }
        String procName = st.nextToken();
        int endbrak = sql.lastIndexOf("}");
        this.logger_.debug((Object)("line='" + line + "' procedure name='" + procName + "', sql='" + sql + "'"));
        String procedure = sql.substring(sql.indexOf(procName) + procName.length(), endbrak + 1).trim();
        String adatasource = null;
        this.logger_.debug((Object)("procedure name='" + procName + "', procedure='" + procedure + "' line='" + line + "' endbrak='" + endbrak + "' sql.length='" + sql.length() + "'"));
        if (endbrak + 1 < sql.length()) {
            adatasource = sql.substring(endbrak + 1, sql.length()).trim();
        }
        this.logger_.debug((Object)("procedure name='" + procName + "', procedure='" + procedure + "', datasource='" + adatasource + "'"));
        CallableStatement callable = null;
        ESCallable escall = null;
        Connection con = this.session_.getConnection(adatasource);
        this.session_.logRequest(adatasource, procedure);
        callable = con.prepareCall(procedure);
        escall = new ESCallable(callable, adatasource, con, this.session_);
        this.logger_.debug((Object)("create a procedure='" + procName + "'"));
        this.procedures_.put(procName, escall);
    }

    void expandRegisterOutParameter(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String procName = st.nextToken();
        if (procName.startsWith("$") && procName.endsWith("$")) {
            procName = this.getVarValue(procName.substring(1, procName.length() - 1), this.params_, false);
        }
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String number = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String varType = st.nextToken();
        ESCallable callable = (ESCallable)this.procedures_.get(procName);
        if (callable == null) {
            throw new Exception("Try to define out parameter without defining the procedure itself");
        }
        int typeNumber = this.string2Type(varType, callable.getDatasource() == null ? null : this.session_.getAppConfiguration().getName() + "__" + callable.getDatasource());
        this.logger_.debug((Object)("procedure name='" + procName + "', number='" + number + "', var type='" + varType + "' typeNumber='" + typeNumber + "'"));
        if (typeNumber == 999) {
            throw new Exception("The type '" + varType + "' is unknow, please see java.sql.Types");
        }
        callable.registerOutParameter(Integer.parseInt(number), typeNumber);
    }

    void expandExecSqlProc(String line) throws Exception {
        ESCallable callable;
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String procName = st.nextToken();
        if (procName.startsWith("$") && procName.endsWith("$")) {
            procName = this.getVarValue(procName.substring(1, procName.length() - 1), this.params_, false);
        }
        if ((callable = (ESCallable)this.procedures_.get(procName)) == null) {
            throw new Exception("Try to execute without defining the procedure itself");
        }
        this.logger_.debug((Object)("procedure name='" + procName + "' toString='" + callable.toString() + "'"));
        try {
            callable.getCallable().execute();
            Hashtable params = callable.getParams();
            Enumeration enu = params.keys();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                params.remove(key);
                String str = callable.getCallable().getString(Integer.parseInt(key));
                Object resultSet = callable.getCallable().getObject(Integer.parseInt(key));
                this.logger_.debug((Object)("key='" + key + "' str='" + str + "'"));
                if (str != null) {
                    params.put(key, str);
                    continue;
                }
                if (resultSet == null) {
                    params.put(key, "");
                    continue;
                }
                ESDBDataSet ds = new ESDBDataSet((ResultSet)resultSet, this.session_, callable.getConnection(), callable.getDatasource(), null);
                this.logger_.debug((Object)("build a ESDBDataSet object with procname='" + procName + key + "'"));
                this.addDataSet(procName + key, ds);
            }
            this.addDataObject(procName, callable);
        }
        catch (Exception e) {
            this.errorSet_ = true;
        }
    }

    void expandNewObject(String line) throws Exception {
        if (this.uObjects_ == null) {
            this.uObjects_ = new Hashtable();
        }
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        this.logger_.debug((Object)("expandNewObject line=<" + line + ">"));
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String persist = st.nextToken();
        String rObj = null;
        boolean isPersist = false;
        if (persist.equalsIgnoreCase("isPersist")) {
            isPersist = true;
            rObj = st.nextToken();
        } else {
            rObj = persist;
        }
        this.logger_.debug((Object)("expandNewObject rObj=<" + rObj + ">"));
        String c = line.substring(line.indexOf(rObj) + rObj.length(), line.length()).trim();
        this.logger_.debug((Object)("expandNewObject c=<" + c + ">"));
        c = c.substring(1, c.length() - 1);
        this.logger_.debug((Object)("expandNewObject c=<" + c + ">"));
        String paramsList = c.substring(c.indexOf(40) + 1, c.length() - 1);
        this.logger_.debug((Object)("expandNewObject paramsList=<" + paramsList + ">"));
        if (paramsList.length() != 0) {
            line = line.substring(0, line.indexOf(paramsList)) + this.expandString(paramsList) + ")$";
        }
        this.logger_.debug((Object)("expandNewObject line=<" + line + ">"));
        UserObject uObj = null;
        try {
            uObj = new UserObject(line, this.lnb_, this.uObjects_, this.session_.getUserObjects(), this.logger_);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.errorSet_ = true;
            this.logger_.error((Object)"error ... exception");
        }
        if (uObj != null) {
            if (uObj.getName() == null) {
                this.errorSet_ = true;
            } else if (isPersist) {
                this.session_.addUserObject(uObj.getName(), uObj);
            } else {
                this.uObjects_.put(uObj.getName(), uObj);
            }
        }
    }

    void expandInvoke(String line) throws Exception {
        if (this.uObjects_ == null) {
            this.uObjects_ = new Hashtable();
        }
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String persist = st.nextToken();
        boolean isPersist = false;
        String objName = null;
        if (persist.equalsIgnoreCase("isPersist")) {
            isPersist = true;
        } else {
            objName = persist;
        }
        String c = line.substring(line.indexOf(objName) + objName.length(), line.length()).trim();
        String saveC = c = c.substring(1, c.length() - 1);
        c = this.expandString(c);
        int opar = c.indexOf(40);
        int dotp = c.substring(0, opar).lastIndexOf(46);
        String initObj = c.substring(0, dotp);
        UserObject uObj = null;
        if (this.uObjects_ != null) {
            uObj = (UserObject)this.uObjects_.get(initObj);
        }
        if (uObj == null) {
            uObj = this.session_.getUserObject(initObj);
        }
        if (uObj == null) {
            uObj = new UserObject(null, initObj, this.logger_);
        }
        Object retObj = null;
        try {
            this.logger_.debug((Object)("expandInvoke c=<" + c + ">"));
            this.logger_.debug((Object)("expandInvoke saveC=<" + saveC + ">"));
            retObj = uObj.invoke(line.substring(0, line.indexOf(saveC)) + c + "$", this.lnb_, this.uObjects_, this.session_.getUserObjects());
            this.logger_.debug((Object)"Create now a new UserObject");
            UserObject uoTemp = new UserObject(retObj, objName, this.logger_);
            this.logger_.debug((Object)"new UserObject has been created");
            if (uoTemp == null) {
                this.logger_.debug((Object)"... and new UserObject is null");
            }
            if (retObj == null) {
                this.logger_.debug((Object)"... retObj is null");
            }
            if (isPersist) {
                this.session_.addUserObject(objName, uoTemp);
            } else {
                this.uObjects_.put(objName, uoTemp);
            }
            this.logger_.debug((Object)"added object (uoTemp) into hashtable");
        }
        catch (Exception e) {
            this.errorSet_ = true;
            e.printStackTrace();
            this.logger_.error((Object)("INVOKE exception during method call, please verify syntax: " + e));
        }
        if (retObj == null) {
            this.setParameter(objName, "null", this.isAssign(line));
        }
        if (retObj instanceof DataSet) {
            this.addDataSet(objName, (DataSet)retObj);
        } else {
            this.setParameter(objName, retObj != null ? retObj.toString() : "null", this.isAssign(line));
        }
        this.logger_.debug((Object)"End of INVOKE method");
    }

    void expandCloseObject(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String objName = st.nextToken();
        if (this.session_.getUserObject(objName) == null) {
            this.errorSet_ = true;
            this.logger_.error((Object)("object (" + objName + ") does not exist"));
        } else {
            this.session_.closeUserObject(objName);
        }
    }

    int string2Type(String in, String adatasource) {
        if ("BIT".compareTo(in) == 0) {
            return -7;
        }
        if ("TINYINT".compareTo(in) == 0) {
            return -6;
        }
        if ("SMALLINT".compareTo(in) == 0) {
            return 5;
        }
        if ("INTEGER".compareTo(in) == 0) {
            return 4;
        }
        if ("BIGINT".compareTo(in) == 0) {
            return -5;
        }
        if ("FLOAT".compareTo(in) == 0) {
            return 6;
        }
        if ("REAL".compareTo(in) == 0) {
            return 7;
        }
        if ("DOUBLE".compareTo(in) == 0) {
            return 8;
        }
        if ("NUMERIC".compareTo(in) == 0) {
            return 2;
        }
        if ("DECIMAL".compareTo(in) == 0) {
            return 3;
        }
        if ("CHAR".compareTo(in) == 0) {
            return 1;
        }
        if ("VARCHAR".compareTo(in) == 0) {
            return 12;
        }
        if ("LONGVARCHAR".compareTo(in) == 0) {
            return -1;
        }
        if ("DATE".compareTo(in) == 0) {
            return 91;
        }
        if ("TIME".compareTo(in) == 0) {
            return 92;
        }
        if ("TIMESTAMP".compareTo(in) == 0) {
            return 93;
        }
        if ("BINARY".compareTo(in) == 0) {
            return -2;
        }
        if ("VARBINARY".compareTo(in) == 0) {
            return -3;
        }
        if ("LONGVARBINARY".compareTo(in) == 0) {
            return -4;
        }
        if ("NULL".compareTo(in) == 0) {
            return 0;
        }
        if ("OTHER".compareTo(in) == 0) {
            return 1111;
        }
        if ("JAVA_OBJECT".compareTo(in) == 0) {
            return 2000;
        }
        if ("DISTINCT".compareTo(in) == 0) {
            return 2001;
        }
        if ("STRUCT".compareTo(in) == 0) {
            return 2002;
        }
        if ("ARRAY".compareTo(in) == 0) {
            return 2003;
        }
        if ("BLOB".compareTo(in) == 0) {
            return 2004;
        }
        if ("CLOB".compareTo(in) == 0) {
            return 2005;
        }
        if ("REF".compareTo(in) == 0) {
            return 2006;
        }
        if ("DATALINK".compareTo(in) == 0) {
            return 70;
        }
        if ("BOOLEAN".compareTo(in) == 0) {
            return 16;
        }
        Class<?> types = null;
        try {
            if (adatasource != null) {
                Hashtable ds = this.session_.getAppConfiguration().getDatasources();
                this.logger_.debug((Object)("datasource='" + adatasource + "'"));
                DatasourceProperty dsprop = (DatasourceProperty)ds.get(adatasource);
                types = Class.forName(dsprop.getResultSet());
            } else {
                types = Class.forName(this.session_.getAppConfiguration().getResultSet());
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.logger_.debug((Object)("the class does not exist ! '" + this.session_.getAppConfiguration().getResultSet() + "'"));
        }
        try {
            Field field = types.getField(in);
            return field.getInt(null);
        }
        catch (NoSuchFieldException nsfe) {
            this.logger_.debug((Object)"the field does not exist !");
        }
        catch (IllegalAccessException iae) {
            this.logger_.debug((Object)"Illegal access to int type !");
        }
        return 999;
    }

    void expandFile(String line, PrintWriter out, boolean include) throws Exception {
        String p;
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line));
        }
        String fnm = st.nextToken();
        if (fnm.startsWith("$") && fnm.endsWith("$")) {
            fnm = this.getVarValue(fnm.substring(1, fnm.length() - 1), this.params_, false);
        }
        File tmp = new File(fnm);
        File f = null;
        f = tmp.isAbsolute() ? tmp : ((p = this.input_.getParent()) == null ? tmp : (p.endsWith(File.separator) ? new File(p + tmp) : new File(p + File.separatorChar + tmp)));
        Class[] parameterTypes = new Class[]{Client.class, File.class, Boolean.TYPE};
        Constructor<?> esd = this.getClass().getConstructor(parameterTypes);
        Object[] parm = new Object[]{this.session_, f, new Boolean(false)};
        ESDynHtml d = (ESDynHtml)esd.newInstance(parm);
        d.setInner(true);
        d.requests_ = this.requests_;
        d.req_ = this.req_;
        d.params_ = this.params_;
        d.datasets_ = this.datasets_;
        d.dataobjects_ = this.dataobjects_;
        d.procedures_ = this.procedures_;
        d.expand(out, false);
        if (include) {
            this.requests_ = d.requests_;
            this.req_ = d.req_;
            this.params_ = d.params_;
            this.datasets_ = d.datasets_;
            this.dataobjects_ = d.dataobjects_;
            this.procedures_ = d.procedures_;
        }
    }

    public String expandString(String line) throws SQLException {
        return this.expandString(line, this.params_, this.displayUnresolved_);
    }

    public String expandString(String line, Hashtable params) throws SQLException {
        return this.expandString(line, params, this.displayUnresolved_);
    }

    public String expandString(String line, Hashtable params, boolean displayUnresolved) throws SQLException {
        String tmp;
        int endvar;
        int pos = line.indexOf(36);
        if (pos < 0) {
            return line;
        }
        StringBuffer b = new StringBuffer(line.substring(0, pos));
        if ((endvar = (tmp = line.substring(++pos)).indexOf(36)) < 0) {
            return line;
        }
        String varname = tmp.substring(0, endvar);
        pos += varname.length() + 1;
        boolean cookie = varname.toUpperCase().equals("COOKIE");
        if (cookie) {
            try {
                b.append("S_=" + URLEncoder.encode(this.session_.getClientId(), this.encodingValue));
            }
            catch (Exception e) {
                b.append("S_=" + this.session_.getClientId());
            }
        } else {
            b.append(this.getVarValue(varname, params, displayUnresolved));
        }
        b.append(this.expandString(line.substring(pos), params, displayUnresolved));
        return b.toString();
    }

    public String getVarValue(String varname) throws SQLException {
        if (varname.startsWith("$") && varname.endsWith("$")) {
            return this.getVarValue(varname.substring(1, varname.length() - 1), this.params_, false);
        }
        return varname;
    }

    String getVarValue(String varname, Hashtable params, boolean displayUnresolved) throws SQLException {
        String val;
        int cpar;
        if (varname.equals("\\")) {
            return "$";
        }
        String unresolved = varname;
        boolean urlencode = varname.toUpperCase().startsWith("(URLENCODE)");
        boolean sqlencode = varname.toUpperCase().startsWith("(SQLENCODE");
        boolean htmlencode = varname.toUpperCase().startsWith("(HTMLENCODE)");
        boolean xmlencode = varname.toUpperCase().startsWith("(XMLENCODE)");
        boolean jsencode = varname.toUpperCase().startsWith("(JSENCODE)");
        String datasourcename = null;
        if (sqlencode && varname.charAt(10) == '.') {
            datasourcename = varname.substring(11, varname.indexOf(")"));
        }
        if (urlencode || sqlencode || htmlencode || jsencode || xmlencode) {
            varname = varname.substring(varname.indexOf(")") + 1);
        }
        String fmt = null;
        if (varname.startsWith("(") && (cpar = varname.indexOf(41)) >= 0) {
            fmt = varname.substring(1, cpar);
            varname = varname.substring(cpar + 1);
        }
        if ((val = this.evalVariable(varname, params)) == null) {
            val = displayUnresolved ? new String("$" + unresolved + "$") : new String("");
        } else if (fmt != null) {
            String fval;
            if (fmt.equalsIgnoreCase("Eval")) {
                if (val.indexOf(36) < 0) {
                    fval = this.evalVariable(val, params);
                    if (fval == null) {
                        fval = "";
                    }
                } else {
                    fval = this.expandString(val, params);
                }
            } else {
                fval = this.formatValue(fmt, val);
            }
            val = fval;
        }
        if (urlencode) {
            try {
                return URLEncoder.encode(val, this.encodingValue);
            }
            catch (Exception e) {
                return val;
            }
        }
        if (sqlencode) {
            return this.sqlEncode(val, datasourcename);
        }
        if (htmlencode) {
            return this.htmlEncode(val);
        }
        if (xmlencode) {
            return this.xmlEncode(val);
        }
        if (jsencode) {
            return this.jsEncode(val);
        }
        return val;
    }

    String evalVariable(String name, Hashtable params) throws SQLException {
        if (name.startsWith("%")) {
            return name.substring(1);
        }
        String val = null;
        String objname = null;
        String varname = null;
        int pos = name.indexOf(58);
        if (pos > 0) {
            objname = name.substring(0, pos);
            varname = name.substring(pos + 1);
        } else {
            varname = name;
        }
        if (objname != null) {
            DataObject t = (DataObject)this.dataobjects_.get(objname);
            if (t != null) {
                val = t.get(varname);
            }
        } else {
            DataObject t;
            if (params != null) {
                val = (String)params.get(varname);
            }
            if (val == null && (t = (DataObject)this.dataobjects_.get(varname)) != null) {
                val = t.toString();
            }
        }
        if (val != null) {
            return val.trim();
        }
        return null;
    }

    String formatValue(String fmt, String val) {
        String fval;
        block62: {
            fval = val;
            if (fmt.equalsIgnoreCase("Lower")) {
                return val.toLowerCase();
            }
            if (fmt.equalsIgnoreCase("Upper")) {
                return val.toUpperCase();
            }
            if (fmt.equalsIgnoreCase("UcFirst")) {
                return val.length() < 2 ? val.toUpperCase() : Character.toUpperCase(val.charAt(0)) + val.substring(1);
            }
            if (fmt.equalsIgnoreCase("RemoveHtmlTags")) {
                return StringUtils.removeHtmlTags(val);
            }
            if (fmt.equalsIgnoreCase("QuoteMessage")) {
                return StringUtils.quoteMessage(val);
            }
            if (fmt.equalsIgnoreCase("NormalizeUrl")) {
                return StringUtils.normalizeUrl(val);
            }
            if (fmt.startsWith("DateFormat.")) {
                try {
                    String customFmt = null;
                    int df = 2;
                    if (fmt.equals("DateFormat.DEFAULT")) {
                        df = 2;
                    } else if (fmt.equals("DateFormat.SHORT")) {
                        df = 3;
                    } else if (fmt.equals("DateFormat.MEDIUM")) {
                        df = 2;
                    } else if (fmt.equals("DateFormat.LONG")) {
                        df = 1;
                    } else if (fmt.equals("DateFormat.FULL")) {
                        df = 0;
                    } else {
                        customFmt = fmt.substring(11);
                    }
                    DecimalFormat frm = new DecimalFormat("0", new DecimalFormatSymbols(this.formatLocale_));
                    fval = frm.format(Double.valueOf(val));
                    if (customFmt == null) {
                        DateFormat formatter = DateFormat.getDateInstance(df, this.formatLocale_);
                        fval = formatter.format(new Date(Long.parseLong(fval)));
                        break block62;
                    }
                    if (customFmt.startsWith("$") && customFmt.endsWith("$")) {
                        customFmt = this.getVarValue(customFmt, this.params_, false);
                    }
                    SimpleDateFormat formatter = new SimpleDateFormat(customFmt, this.formatLocale_);
                    fval = formatter.format(new Date(Long.parseLong(fval)));
                }
                catch (Exception e) {
                    fval = val;
                }
            } else {
                if (fmt.startsWith("DateVal")) {
                    if (fmt.length() > 8) {
                        return this.dateaccess_.get(fmt.substring(8), this.fToDate(val + ":00", "yyyy:MM:dd:hh"));
                    }
                    return Long.toString(this.fToDate(val + ":00", "yyyy:MM:dd:hh"));
                }
                if (fmt.startsWith("String")) {
                    if (fmt.length() < 8) {
                        return val;
                    }
                    String strf = fmt.substring(7);
                    if (strf.equals("length")) {
                        return Integer.toString(val.length());
                    }
                    if (strf.startsWith("indexof:")) {
                        try {
                            String subf = strf.substring(8);
                            subf = subf.startsWith("%") ? subf.substring(1) : this.expandString("$" + subf + "$");
                            return subf.length() > 0 ? Integer.toString(val.indexOf(subf)) : "-1";
                        }
                        catch (SQLException se) {
                            return "-2";
                        }
                    }
                    if (strf.startsWith("sub")) {
                        String subf = strf.substring(3);
                        StringTokenizer st = new StringTokenizer(subf, ",");
                        int lo = -1;
                        int hi = -1;
                        if (!st.hasMoreTokens()) {
                            return val;
                        }
                        try {
                            lo = Integer.parseInt(st.nextToken());
                        }
                        catch (Exception e) {
                            return val;
                        }
                        if (val.length() < lo) {
                            return "";
                        }
                        if (!st.hasMoreTokens()) {
                            return val.substring(lo);
                        }
                        try {
                            hi = Integer.parseInt(st.nextToken());
                        }
                        catch (Exception e) {
                            return val.substring(lo);
                        }
                        if (val.length() < hi) {
                            return val.substring(lo);
                        }
                        return val.substring(lo, hi);
                    }
                    if (strf.startsWith("padl")) {
                        String subf = strf.substring(4);
                        int len = 0;
                        try {
                            len = Integer.parseInt(subf);
                        }
                        catch (Exception e) {
                            return val;
                        }
                        if (val.length() >= len) {
                            return val.substring(0, len);
                        }
                        StringBuffer b = new StringBuffer();
                        for (int i = val.length(); i < len; ++i) {
                            b.append(" ");
                        }
                        b.append(val);
                        return b.toString();
                    }
                    if (strf.startsWith("padr")) {
                        String subf = strf.substring(4);
                        int len = 0;
                        try {
                            len = Integer.parseInt(subf);
                        }
                        catch (Exception e) {
                            return "padr" + subf;
                        }
                        if (val.length() >= len) {
                            return val.substring(0, len);
                        }
                        StringBuffer b = new StringBuffer(val);
                        for (int i = val.length(); i < len; ++i) {
                            b.append(" ");
                        }
                        return b.toString();
                    }
                    if (strf.startsWith("padc")) {
                        int i;
                        String subf = strf.substring(4);
                        int len = 0;
                        try {
                            len = Integer.parseInt(subf);
                        }
                        catch (Exception e) {
                            return val;
                        }
                        if (val.length() >= len) {
                            return val.substring(0, len);
                        }
                        int mid = (len - val.length()) / 2;
                        StringBuffer b = new StringBuffer();
                        for (i = 0; i < mid; ++i) {
                            b.append(" ");
                        }
                        b.append(val);
                        for (i = 0; i < mid; ++i) {
                            b.append(" ");
                        }
                        if ((len - val.length()) % 2 != 0) {
                            b.append(" ");
                        }
                        return b.toString();
                    }
                    if (strf.startsWith("replace") && strf.length() >= 11) {
                        String rules = strf.substring(8);
                        return StringUtils.encodeWithRules(val, rules, strf.substring(7, 8));
                    }
                    return val;
                }
                try {
                    if (fmt.equals("Ceil")) {
                        return Double.toString(Math.ceil(Double.valueOf(val)));
                    }
                    if (fmt.equals("Floor")) {
                        return Double.toString(Math.floor(Double.valueOf(val)));
                    }
                    if (fmt.equals("Round")) {
                        return Double.toString(Math.round(Double.valueOf(val)));
                    }
                    DecimalFormat formatter = new DecimalFormat(fmt, new DecimalFormatSymbols(this.formatLocale_));
                    fval = formatter.format(Double.valueOf(val));
                }
                catch (Exception e) {
                    fval = val;
                }
            }
        }
        return fval;
    }

    long fToDate(String date, String fmt) {
        SimpleDateFormat formatter = new SimpleDateFormat(fmt);
        ParsePosition pos = new ParsePosition(0);
        Date dt = formatter.parse(date, pos);
        return dt.getTime();
    }

    public String sqlEncode(String s, String datasourcename) throws SQLException {
        String rules;
        String sep = this.session_.getAppConfiguration().get("sqlencode.Separator");
        if (sep == null) {
            sep = ";";
        }
        if ((rules = this.session_.getAppConfiguration().getSqlEncodeSubst(datasourcename)) == null) {
            rules = "'='';\r=\" \";\n=\" \";";
        }
        return StringUtils.encodeWithRules(s, rules, sep);
    }

    String htmlEncode(String s) {
        return StringUtils.encodeWithRules(s, "\"=&quot;|&=&amp;|<=&lt;|>=&gt;|\u00e9=&eacute;|\u00e8=&egrave;|\u00e0=&agrave;|\u00f9=&ugrave;|\u00e2=&acirc;|\u00ea=&ecirc;|\u00ee=&icirc;|\u00f4=&ocirc;|\u00fb=&ucirc;|\u00e7=&ccedil;|", "|");
    }

    String xmlEncode(String s) {
        return StringUtils.encodeWithRules(s, "&=&amp;|<=&lt;|>=&gt;|%=&#37;|^=&#94;|\"=&quot;|'=&apos;|\n=&#10;|", "|");
    }

    String jsEncode(String s) {
        return StringUtils.encodeWithRules(s, "'=\\'|\"=\\\"|\n=\\n|\r=\\r|\\=\\\\|\t=\\t", "|");
    }

    private void setPriority(int pri) {
        try {
            Thread.currentThread().setPriority(pri);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void flush(PrintWriter out) {
        if (out != null) {
            out.flush();
        }
    }

    private void println(PrintWriter out, String text) {
        if (out != null) {
            out.println(text);
        }
    }

    private void writeString(PrintWriter out, String text) {
        if (out != null) {
            out.write(text);
        }
    }

    private String syntaxError(String msg) {
        return "Syntax error line " + this.lnb_ + ": " + msg;
    }

    public static void main(String[] args) {
        try {
            ESDynHtml exp = new ESDynHtml(null, new File("DynHtml.tmpl"));
            exp.setParameter("firstname", "Pierre-Yves", false);
            exp.setParameter("lastname", "Gibello", false);
            PrintWriter out = new PrintWriter(System.out);
            exp.expand(out);
            out.flush();
        }
        catch (Exception e) {
            System.err.println("ESDynHtml Exception " + e);
        }
    }
}

