/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.util;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.enhydra.jdbc.util.Logger;

public class RequestCacheObject {
    private String request_ = null;
    private long time_ = 0L;
    private Object result_ = null;
    private Pattern pattern_ = null;
    private long timeToLive_ = 0L;
    private static Logger logger;

    public RequestCacheObject(int ttl) {
        logger = new Logger((Log)new Log4JLogger("org.enhydra.jdbc.util"));
        this.timeToLive_ = ttl;
    }

    public RequestCacheObject(String req, Pattern pattern, int ttl) {
        logger = new Logger((Log)new Log4JLogger("org.enhydra.jdbc.util"));
        logger.debug("RequestCacheObject:RequestCacheObject req=<" + req + "> ttl=<" + ttl + ">");
        this.request_ = req;
        this.pattern_ = pattern;
        this.timeToLive_ = ttl;
    }

    public void setResult(Object rset) {
        logger.debug("RequestCacheObject:setResult for=<" + this.request_ + ">");
        this.result_ = rset;
        this.time_ = System.currentTimeMillis();
    }

    public boolean isAlive() {
        long now = System.currentTimeMillis();
        if (now - this.time_ > this.timeToLive_) {
            logger.debug("RequestCacheObject:isAlive out of live");
            return false;
        }
        if (this.result_ == null) {
            logger.debug("RequestCacheObject:isAlive Object is null ");
            return false;
        }
        logger.debug("RequestCacheObject:isAlive Object is not null");
        return true;
    }

    public Object getResult() {
        if (this.result_ == null) {
            logger.debug("RequestCacheObject:getResult result_ is null");
        }
        return this.result_;
    }

    public Pattern getPattern() {
        return this.pattern_;
    }

    public String getRequest() {
        return this.request_;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("request=<" + this.request_ + "> time=<" + this.time_ + "> time to live=<" + this.timeToLive_ + "> pattern=<" + this.pattern_.pattern() + ">");
        return sbuf.toString();
    }

    public void close() {
        this.request_ = null;
        this.result_ = null;
        this.pattern_ = null;
    }
}

