/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.jmx;

import com.sun.management.jmx.NamedObject;
import com.sun.management.jmx.Repository;
import com.sun.management.jmx.Trace;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.RuntimeOperationsException;

class RepositorySupport
implements Repository {
    private Hashtable domainTb = new Hashtable();
    private int nbElements = 0;
    private String domain = "DefaultDomain";
    private String dbgTag = "Repository";

    public void addMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException {
        Hashtable hashtable;
        if (this.isTraceOn()) {
            this.trace("addMBean", "name=" + objectName);
        }
        if (objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: " + objectName.toString()));
        }
        String string = objectName.getDomain();
        try {
            if (!this.query(new ObjectName("JMImplementation:*"), null).isEmpty() && string.equals("JMImplementation")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Repository: domain name cannot be JMImplementation"));
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {}
        if (string.equals("")) {
            string = this.domain;
        }
        if ((hashtable = (Hashtable)this.domainTb.get(string)) == null) {
            this.addNewDomMoi(object, string, objectName);
            return;
        }
        Object v = hashtable.get(objectName);
        if (v != null) {
            throw new InstanceAlreadyExistsException(objectName.toString());
        }
        ++this.nbElements;
        hashtable.put(objectName, object);
    }

    private void addNewDomMoi(Object object, String string, ObjectName objectName) {
        Hashtable<ObjectName, Object> hashtable = new Hashtable<ObjectName, Object>();
        this.domainTb.put(string, hashtable);
        hashtable.put(objectName, object);
        ++this.nbElements;
    }

    public boolean contains(ObjectName objectName) {
        Object object;
        if (this.isTraceOn()) {
            this.trace("contains", "name=" + objectName);
        }
        return (object = this.retrieve(objectName)) != null;
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private Vector findDomainToQuery(ObjectName objectName) {
        Vector<String> vector = new Vector<String>();
        String string = objectName.getDomain();
        if (string.indexOf("*") != 0 || string.indexOf("?") != 0) {
            Enumeration enumeration = this.domainTb.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!this.wildmatch(string2, string)) continue;
                vector.addElement(string2);
            }
        } else {
            vector.addElement(string);
        }
        return vector;
    }

    public Integer getCount() {
        return new Integer(this.nbElements);
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    public boolean isFiltering() {
        return false;
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    public Set query(ObjectName objectName, QueryExp queryExp) {
        HashSet<NamedObject> hashSet = new HashSet<NamedObject>();
        if (objectName == null) {
            try {
                objectName = new ObjectName("*:*");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {}
        }
        ObjectName objectName2 = null;
        try {
            objectName2 = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {}
        if (!objectName.isPattern()) {
            try {
                Object object = this.retrieve(objectName);
                if (object != null) {
                    hashSet.add(new NamedObject(objectName, object));
                }
            }
            catch (RuntimeOperationsException runtimeOperationsException) {}
        } else if (objectName.equals(objectName2)) {
            Enumeration enumeration = this.domainTb.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)enumeration.nextElement();
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    ObjectName objectName3 = (ObjectName)enumeration2.nextElement();
                    hashSet.add(new NamedObject(objectName3, hashtable.get(objectName3)));
                }
            }
        } else if (objectName.getDomain().equals("") && objectName.getKeyPropertyListString().equals("")) {
            Enumeration enumeration = this.domainTb.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)enumeration.nextElement();
                Enumeration enumeration3 = hashtable.keys();
                while (enumeration3.hasMoreElements()) {
                    ObjectName objectName4 = (ObjectName)enumeration3.nextElement();
                    if (!objectName4.getDomain().equals(this.domain)) continue;
                    hashSet.add(new NamedObject(objectName4, hashtable.get(objectName4)));
                }
            }
        } else {
            Vector vector = this.findDomainToQuery(objectName);
            String string = null;
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                string = (String)iterator.next();
                if (objectName.getKeyPropertyListString().equals("")) {
                    object3 = (Hashtable)this.domainTb.get(string);
                    if (object3 == null) {
                        return hashSet;
                    }
                    object2 = ((Hashtable)object3).keys();
                    while (object2.hasMoreElements()) {
                        object = (ObjectName)object2.nextElement();
                        hashSet.add(new NamedObject((ObjectName)object, ((Hashtable)object3).get(object)));
                    }
                    continue;
                }
                object3 = this.domainTb.elements();
                while (object3.hasMoreElements()) {
                    object2 = (Hashtable)object3.nextElement();
                    object = ((Hashtable)object2).keys();
                    while (object.hasMoreElements()) {
                        String string2;
                        Enumeration<String> enumeration;
                        ObjectName objectName5 = (ObjectName)object.nextElement();
                        if (!objectName5.getDomain().equals(string)) continue;
                        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
                        Hashtable<String, String> hashtable2 = objectName5.getKeyPropertyList();
                        boolean bl = false;
                        if (objectName.isPropertyPattern()) {
                            bl = true;
                            enumeration = hashtable.keys();
                            while (enumeration.hasMoreElements()) {
                                string2 = enumeration.nextElement();
                                if (hashtable.get(string2).equals(hashtable2.get(string2))) continue;
                                bl = false;
                                break;
                            }
                        } else if (hashtable2.size() == hashtable.size()) {
                            bl = true;
                            enumeration = hashtable.keys();
                            while (enumeration.hasMoreElements()) {
                                string2 = enumeration.nextElement();
                                if (hashtable.get(string2).equals(hashtable2.get(string2))) continue;
                                bl = false;
                                break;
                            }
                        }
                        if (!bl) continue;
                        hashSet.add(new NamedObject(objectName5, ((Hashtable)object2).get(objectName5)));
                    }
                }
            }
        }
        return hashSet;
    }

    public void remove(ObjectName objectName) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("remove", "name=" + objectName);
        }
        if (!this.contains(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        String string = objectName.getDomain();
        Hashtable hashtable = (Hashtable)this.domainTb.get(string);
        if (hashtable == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Object v = hashtable.get(objectName);
        if (v == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        hashtable.remove(objectName);
        --this.nbElements;
    }

    public Object retrieve(ObjectName objectName) {
        Hashtable hashtable;
        if (this.isTraceOn()) {
            this.trace("retrieve", "name=" + objectName);
        }
        if (objectName.isPattern()) {
            return null;
        }
        String string = objectName.getDomain();
        if (string.equals("")) {
            string = this.domain;
        }
        if ((hashtable = (Hashtable)this.domainTb.get(string)) == null) {
            return null;
        }
        Object v = hashtable.get(objectName);
        return v;
    }

    public void setConfigParameters(ArrayList arrayList) {
    }

    public void setDefaultDomain(String string) {
        this.domain = string;
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private boolean wildmatch(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        while (n2 < n4) {
            char c;
            if ((c = string2.charAt(n2++)) == '?') {
                if (++n <= n3) continue;
                return false;
            }
            if (c == '*') {
                if (n2 >= n4) {
                    return true;
                }
                do {
                    if (!this.wildmatch(string.substring(n), string2.substring(n2))) continue;
                    return true;
                } while (++n < n3);
                return false;
            }
            if (n < n3 && c == string.charAt(n++)) continue;
            return false;
        }
        return n == n3;
    }
}

