/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.enhydra.instantdb.db.SqlFunction;

public class datemaxroll
implements SqlFunction {
    static GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"), Locale.getDefault());
    private static Date fixTime;
    private int lastDayOfWeek;
    private String error = "datemaxroll (date,field). Field = {DAY_OF_YEAR|DAY_OF_MONTH|DAY_OF_WEEK|HOUR_OF_DAY|MINUTE|-1}";

    public datemaxroll() {
        calendar.setLenient(true);
        this.setLastDayOfWeek((calendar.getFirstDayOfWeek() + 6) % 7 + 7);
        this.setFixTime(calendar.getTime());
    }

    public int checkParameters(int[] nArray) throws SQLException {
        if (nArray.length != 2 && nArray[0] != 5) {
            throw new SQLException(this.error);
        }
        int n = 1;
        while (n < 2) {
            if (nArray[n] != 2) {
                throw new SQLException(this.error);
            }
            ++n;
        }
        return 5;
    }

    public Object evaluate(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Date date = new Date((Long)objectArray[0]);
        int n = (Integer)objectArray[1];
        if (n == -1) {
            calendar.setTime(this.getFixTime());
        } else {
            calendar.setTime(date);
            switch (n) {
                case 5: 
                case 6: 
                case 7: {
                    if (n == 7) {
                        calendar.set(7, this.getLastDayOfWeek());
                    }
                }
                case 11: {
                    calendar.set(11, 23);
                }
                case 12: {
                    calendar.set(12, 59);
                }
                case 13: {
                    calendar.set(13, 59);
                    calendar.set(14, 999);
                    break;
                }
            }
        }
        return new Timestamp(calendar.getTime().getTime());
    }

    private Date getFixTime() {
        return fixTime;
    }

    private int getLastDayOfWeek() {
        return this.lastDayOfWeek;
    }

    public Object getSpecialValue(int n) {
        return null;
    }

    private void setFixTime(Date date) {
        fixTime = date;
    }

    private void setLastDayOfWeek(int n) {
        this.lastDayOfWeek = n;
    }

    public void setSpecialValue(int n, Object object) {
    }
}

