/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.enhydra.instantdb.db.BlobColumn;
import org.enhydra.instantdb.db.Database;
import org.enhydra.instantdb.db.Journal;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Trace;

public class Transaction
implements Serializable {
    int isolation;
    boolean used;
    long ID;
    Vector blobCols;
    Vector blobOffsets;
    Database dbase;
    Transaction waitTrans;
    Thread waitThread;
    boolean timeoutExpired;
    Vector lockList;
    String dateFormat;
    char currencySymbol;
    int currencyDecimal;
    boolean inTriggers;
    boolean inToString;
    String sql;
    Journal journal;
    Connection con;
    int sqlID;
    long expiryTime;
    Xid xid;
    long prepareRecordPosition;
    public static int READ = 1;
    public static int WRITE = 2;

    Transaction(Database database) throws SQLException {
        this.dbase = database;
        this.journal = this.dbase.journal;
        this.lockList = new Vector(10, 10);
        this.isolation = 8;
        this.ID = this.journal.getNextTransactionID();
        if (this.ID < 1000L) {
            throw new SQLException("Internal error - illegal transaction ID: " + this.ID);
        }
        this.blobCols = new Vector(10, 10);
        this.blobOffsets = new Vector(10, 10);
        this.used = false;
        this.journal.addToTransactionList(this);
        this.dateFormat = database.defDateFormat;
        this.currencySymbol = database.defCurrencySymbol;
        this.currencyDecimal = database.defCurrencyDecimal;
    }

    void addLock(Table table) {
        this.lockList.addElement(table);
    }

    public int allocateSqlID() {
        return ++this.sqlID;
    }

    boolean checkDeadLock(Transaction transaction) {
        if (this.waitTrans == null) {
            return false;
        }
        if (this.waitTrans == transaction) {
            return true;
        }
        return this.waitTrans.checkDeadLock(transaction);
    }

    boolean checkExpired() {
        long l = System.currentTimeMillis();
        boolean bl = false;
        if (l > this.expiryTime) {
            this.dbase.removeFromTimerQueue(this);
            if (this.waitTrans != null) {
                this.waitTrans = null;
                this.waitThread.interrupt();
            } else {
                this.timeoutExpired = true;
            }
        }
        return bl;
    }

    public synchronized void commit(int n) throws SQLException {
        if (Trace.traceIt(16)) {
            Trace.traceOut("Committing trans ID " + this.ID + ", callersID=" + n + ", cur ID=" + this.sqlID);
        }
        if (n != this.sqlID) {
            return;
        }
        this.deleteBlobs(true);
        this.freeAllLocks(false);
        if (!this.used) {
            return;
        }
        this.complete(1);
    }

    void complete(int n) throws SQLException {
        try {
            this.journal.writeTransactionRecord(this, 1164275295, n, null, null, null);
        }
        catch (Exception exception) {
            if (this.prepareRecordPosition != 0L) {
                try {
                    this.journal.Log.seek(this.prepareRecordPosition);
                }
                catch (IOException iOException) {
                    throw new SQLException("IO error upgrading prepare: " + this.ID + "\n" + exception.toString());
                }
                this.journal.writeTransactionRecord(this, 1164275295, n, null, null, null);
            }
            throw new SQLException("Problem closing transaction: " + this.ID + "\n" + exception.toString());
        }
        this.journal.getNextTransactionID();
        this.used = false;
        this.journal.updateTransactionCount(-1);
        this.prepareRecordPosition = 0L;
        this.xid = null;
    }

    void deleteBlobs(boolean bl) throws SQLException {
        if (bl) {
            int n = 0;
            while (n < this.blobCols.size()) {
                BlobColumn blobColumn = (BlobColumn)this.blobCols.elementAt(n);
                long l = (Long)this.blobOffsets.elementAt(n);
                blobColumn.deleteBlob(l);
                ++n;
            }
        }
        this.blobCols.removeAllElements();
        this.blobOffsets.removeAllElements();
    }

    protected void finalize() {
        try {
            if (this.used) {
                this.journal.updateTransactionCount(-1);
            }
        }
        catch (Exception exception) {}
    }

    void freeAllLocks(boolean bl) throws SQLException {
        int n = this.getLockCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            Table table = (Table)this.lockList.elementAt(n2);
            this.inTriggers = true;
            if (bl) {
                table.rollbackTriggers(this.ID);
            } else {
                table.commitTriggers(this.ID);
            }
            this.inTriggers = false;
            table.lock.freeWriteLock(this);
            --n2;
        }
        this.lockList.removeAllElements();
        this.waitTrans = null;
        this.xid = null;
    }

    Connection getConnection() {
        return this.con;
    }

    int getLockCount() {
        return this.lockList.size();
    }

    public int getSqlID() {
        return this.sqlID;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    boolean obeysLocks() {
        return this.isolation == 8;
    }

    public int prepare() throws XAException {
        if (Trace.traceIt(16)) {
            Trace.traceOut("Trans ID " + this.ID + " preparing to commit");
        }
        try {
            if (!this.used) {
                this.commit(this.sqlID);
                return 3;
            }
            this.prepareRecordPosition = this.journal.Log.getFilePointer();
            this.journal.writeTransactionRecord(this, 1347568976, 0, null, null, null);
        }
        catch (Exception exception) {
            Trace.traceOut("Trans ID " + this.ID + " prepare failed: " + exception.toString());
            throw new XAException(exception.getMessage());
        }
        return 0;
    }

    public void rollback() throws SQLException {
        this.journal.rollback(this);
    }

    public void setConnection(Connection connection) {
        this.con = connection;
    }

    void setSQL(String string) {
        this.sql = string;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (this.used) {
            throw new SQLException("Cannot set isolation level in mid transaction");
        }
        if (n != 8 && n != 1) {
            throw new SQLException("Unrecognised isolation level: " + n);
        }
        this.isolation = n;
    }

    void setWaitTransaction(Transaction transaction) {
        this.waitTrans = transaction;
    }

    public void startGlobalTransaction(Xid xid) throws XAException {
        if (Trace.traceIt(16)) {
            Trace.traceOut("Trans ID " + this.ID + " joining global transaction: " + xid);
        }
        if (this.xid == null) {
            if (this.used) {
                throw new XAException(-6);
            }
        } else if (!this.xid.equals(xid)) {
            throw new XAException("Already part of transaction: " + this.xid);
        }
        this.xid = xid;
    }

    public String toString() {
        if (this.inToString) {
            return "End of deadlock chain";
        }
        this.inToString = true;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Trans :");
        stringBuffer.append(this.ID);
        if (this.sql != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.sql);
        }
        stringBuffer.append('\n');
        stringBuffer.append("    Locked tables: ");
        int n = 0;
        while (n < this.lockList.size()) {
            Table table = (Table)this.lockList.elementAt(n);
            stringBuffer.append(table.getTableName());
            stringBuffer.append(' ');
            ++n;
        }
        if (this.lockList.size() == 0) {
            stringBuffer.append("none");
        }
        if (this.waitTrans != null) {
            stringBuffer.append("\n    Waiting on transaction...\n");
            stringBuffer.append(this.waitTrans.toString());
        }
        this.inToString = false;
        return stringBuffer.toString();
    }
}

