/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import org.enhydra.instantdb.db.BTreeObject;
import org.enhydra.instantdb.db.BlobColumn;
import org.enhydra.instantdb.db.ByteColumn;
import org.enhydra.instantdb.db.Char1Column;
import org.enhydra.instantdb.db.Column;
import org.enhydra.instantdb.db.CurrencyColumn;
import org.enhydra.instantdb.db.Database;
import org.enhydra.instantdb.db.DateColumn;
import org.enhydra.instantdb.db.DoubleColumn;
import org.enhydra.instantdb.db.FloatColumn;
import org.enhydra.instantdb.db.GrowArray;
import org.enhydra.instantdb.db.IdbVector;
import org.enhydra.instantdb.db.IndexColumn;
import org.enhydra.instantdb.db.IntegerColumn;
import org.enhydra.instantdb.db.Journal;
import org.enhydra.instantdb.db.LongColumn;
import org.enhydra.instantdb.db.ReadAheadBuffer;
import org.enhydra.instantdb.db.RowRangeCache;
import org.enhydra.instantdb.db.SQLProg;
import org.enhydra.instantdb.db.StringColumn;
import org.enhydra.instantdb.db.TableEncrypt;
import org.enhydra.instantdb.db.TableLock;
import org.enhydra.instantdb.db.Trace;
import org.enhydra.instantdb.db.Transaction;
import org.enhydra.instantdb.db.idbDataOutputStream;
import org.enhydra.instantdb.db.idbTrigger;
import org.enhydra.instantdb.db.indexTable;

public class Table
extends Observable
implements BTreeObject {
    String tableName;
    int recLength;
    Vector columnList;
    int rowCount;
    int deletedRowCount;
    Vector indexTables;
    String path;
    File fileDesc;
    ReadAheadBuffer rndFile;
    DataInputStream dataIn;
    FileDescriptor fd;
    ByteColumn controlCol;
    long rowCountPosn;
    long firstRowPosn;
    byte[] bytesOut;
    idbDataOutputStream dataOut;
    Database dbase;
    Journal journal;
    int firstDeletedRow;
    Integer tblID;
    int tableType;
    boolean recovered;
    static int accessCount;
    TableLock lock;
    int minRowDeleted;
    int maxRowDeleted;
    int[] orderedFields;
    int numOrdered;
    boolean noAutoInc;
    Vector triggers;
    boolean updating;
    boolean modified;
    boolean isClosed;
    boolean transModified;
    boolean fastUpdate;
    int[] order;
    int majVersion;
    int minVersion;
    TableEncrypt encryptor;
    int[] colOffsets;
    boolean addToTableList;
    boolean autoIncOff;
    Runtime runTime;
    GrowArray fromTable;
    Table underlyingTable;
    int partitionNumber;
    boolean doingRollback;
    int readersWaiting;
    private boolean hasFKreference;
    boolean hasFK;
    int cardinality;
    public static final int VANILLA_TABLE = 1;
    public static final int INDEX_TABLE = 2;
    public static final int TEMP_TABLE = 3;
    static final int ROW_DELETED = 1;
    static final int EOF_MARKER = -1;
    static final Integer rowdel;
    static final Integer rowvalid;

    static {
        rowdel = new Integer(1);
        rowvalid = new Integer(0);
    }

    public Table(String string, Database database, Transaction transaction, int n) throws SQLException {
        this.tableType = 1;
        try {
            this.construct(string, database, n);
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: " + iOException.toString() + iOException.getMessage());
        }
        this.lockTable(transaction, Transaction.WRITE);
    }

    Table(String string, Database database, boolean bl, boolean bl2) throws SQLException {
        this.tableType = bl ? 3 : 1;
        if (bl2) {
            this.addToTableList = true;
        }
        try {
            this.construct(string, database, -1);
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: " + iOException.toString() + iOException.getMessage());
        }
    }

    Table(IdbVector idbVector, Table table, Object object, Hashtable hashtable) throws SQLException {
        Object object2;
        this.runTime = Runtime.getRuntime();
        this.dbase = table.dbase;
        this.journal = this.dbase.journal;
        this.fastUpdate = this.dbase.fastUpdate;
        this.columnList = new Vector(10, 10);
        this.indexTables = new Vector(10, 10);
        if (idbVector == null) {
            this.tableName = (String)object;
            this.tblID = new Integer(1002);
            this.path = this.dbase.tablePath;
            this.tableType = 1;
        } else {
            this.tblID = idbVector.getIntegerAt(1);
            this.tableName = idbVector.getStringAt(2);
            object2 = idbVector.getStringAt(3);
            this.partitionNumber = ((String)object2).length() > 0 ? Integer.parseInt((String)object2) : -1;
            if (this.tblID.equals(new Integer(1000))) {
                return;
            }
            if (this.tblID.equals(new Integer(1002))) {
                return;
            }
            this.tableType = idbVector.getIntAt(5);
            this.setTablePath();
        }
        object2 = (Vector)hashtable.get(this.tblID);
        IdbVector idbVector2 = new IdbVector(table);
        int n = 0;
        while (n < ((Vector)object2).size()) {
            int[] nArray = (int[])((Vector)object2).elementAt(n);
            table.getRow(nArray[0], idbVector2);
            int n2 = idbVector2.getIntAt(1);
            String string = idbVector2.getStringAt(3);
            String string2 = idbVector2.getStringAt(4);
            int n3 = idbVector2.getIntAt(5);
            int n4 = idbVector2.getIntAt(6);
            int n5 = idbVector2.getIntAt(7);
            int n6 = idbVector2.getIntAt(8);
            int n7 = idbVector2.getIntAt(9);
            String string3 = idbVector2.getStringAt(10);
            int n8 = 0;
            int n9 = 0;
            if (!this.dbase.noFKs) {
                n8 = idbVector2.getIntAt(11);
                n9 = idbVector2.getIntAt(12);
            }
            Column column = null;
            switch (n3) {
                case 3: {
                    column = new StringColumn(this, string, (n5 - 4) / 2);
                    break;
                }
                case 11: {
                    column = new Char1Column(this, string, n5 - 4);
                    break;
                }
                case 2: {
                    column = new IntegerColumn(this, string);
                    break;
                }
                case 4: {
                    column = new LongColumn(this, string);
                    break;
                }
                case 5: {
                    column = new DateColumn(this, string, "dd-mmm-yyyy");
                    break;
                }
                case 6: {
                    column = new CurrencyColumn(this, string, '$', 2);
                    break;
                }
                case 7: {
                    column = new FloatColumn(this, string);
                    break;
                }
                case 8: {
                    column = new DoubleColumn(this, string);
                    break;
                }
                case 9: {
                    column = new IndexColumn(this, string, 0);
                    break;
                }
                case 10: {
                    column = new BlobColumn(this, string, 0);
                    break;
                }
                case 1: {
                    column = new ByteColumn(this, string);
                    if (!string.equals("$$control")) break;
                    this.controlCol = (ByteColumn)column;
                    break;
                }
                default: {
                    throw new SQLException("Corrupt columns table");
                }
            }
            column.setCacheCondition(n6, n7, true);
            column.recOffset = n4;
            column.colID = new Integer(n2);
            if (string2.indexOf(".PK") >= 0) {
                column.setBooleanProperty(1, true);
            }
            if (string2.indexOf(".UNIQ") >= 0) {
                column.setBooleanProperty(2, true);
            }
            if (string2.indexOf(".~NULL") >= 0) {
                column.setBooleanProperty(3, true);
            }
            if (!StringColumn.testNull(string3)) {
                column.setProperty(4, string3);
            }
            if (n8 != 0) {
                column.fkID = n8;
                column.fk_flags = n9;
                this.hasFKreference = true;
            }
            ++n;
        }
        try {
            if (!this.open(this.tableName)) {
                throw new SQLException("Could not open table " + this.tableName + " in path " + this.path);
            }
            this.lock = new TableLock(this);
            this.dbase.traceMemory();
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: " + iOException.toString() + iOException.getMessage());
        }
    }

    void addColumn(Column column) {
        column.setOffset(this.recLength);
        this.recLength += column.getLength();
        this.columnList.addElement(column);
        column.cardinality = ++this.cardinality;
    }

    void addOrderedField(String string, String string2, boolean bl) throws SQLException {
        if (this.orderedFields == null) {
            this.orderedFields = new int[this.columnList.size()];
            this.numOrdered = 0;
        }
        Column column = null;
        int n = 0;
        String string3 = null;
        if (string != null) {
            string3 = String.valueOf(string) + "." + string2;
        }
        int n2 = 0;
        while (n2 < this.columnList.size()) {
            Column column2 = (Column)this.columnList.elementAt(n2);
            if (string2.equalsIgnoreCase(column2.getName())) {
                column = column2;
                n = n2;
                break;
            }
            if (string != null) {
                if (string3.equalsIgnoreCase(column2.getName())) {
                    column = column2;
                    n = n2;
                    break;
                }
            } else {
                String string4 = column2.getName();
                int n3 = string4.indexOf(46);
                if (n3 >= 0 && string2.equalsIgnoreCase(string4 = string4.substring(n3 + 1))) {
                    if (column != null) {
                        throw new SQLException("Ambiguous column name: " + string2);
                    }
                    column = column2;
                    n = n2;
                }
            }
            ++n2;
        }
        if (column == null) {
            try {
                n = Integer.parseInt(string2);
                column = (Column)this.columnList.elementAt(n);
            }
            catch (Exception exception) {
                throw new SQLException("ORDER BY column, " + string2 + ", must be in the column selection");
            }
        }
        this.orderedFields[this.numOrdered++] = n;
        column.order = 1;
        if (bl) {
            column.order = 2;
        }
    }

    public int addRow(Object object, Transaction transaction) throws SQLException {
        int n = 0;
        n = this.rowCount + 1;
        if (this.deletedRowCount > 0) {
            if (this.firstDeletedRow < this.minRowDeleted) {
                n = this.firstDeletedRow;
            } else if (this.dbase.searchDeletes && this.maxRowDeleted != Integer.MAX_VALUE) {
                int n2 = this.maxRowDeleted + 1;
                while (n2 < this.rowCount) {
                    if (this.rowDeleted(n2)) {
                        n = n2;
                    }
                    ++n2;
                }
            }
        }
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            Vector vector = new Vector(this.columnList.size());
            int n3 = 0;
            while (n3 < this.columnList.size()) {
                Column column = (Column)this.columnList.elementAt(n3);
                String string = column.getName();
                Object object2 = hashtable.get(string);
                if (object2 == null || object2 == "NULL") {
                    object2 = column.getDefault();
                }
                vector.addElement(object2);
                ++n3;
            }
            this.addRowAtRow(vector, n, transaction);
        } else {
            this.addRowAtRow((Vector)object, n, transaction);
        }
        return n;
    }

    int addRow(Object object, Transaction transaction, int n) throws SQLException {
        int n2 = this.addRow(object, transaction);
        if (this.fromTable != null) {
            this.fromTable.add(n);
        }
        return n2;
    }

    void addRowAtRow(Vector vector, int n, Transaction transaction) throws SQLException {
        int n2;
        Object object;
        int n3;
        boolean bl = false;
        if (n <= this.rowCount && this.rowDeleted(n)) {
            bl = true;
        }
        try {
            this.dataOut.reset();
            n3 = 0;
            while (n3 < this.columnList.size()) {
                Column column = (Column)this.columnList.elementAt(n3);
                object = vector.elementAt(n3);
                column.setRow(this.dataOut, n, object, transaction);
                ++n3;
            }
        }
        catch (Exception exception) {
            if (bl) {
                Column column = (Column)this.columnList.elementAt(0);
                Integer n4 = ByteColumn.getInteger(1);
                column.rowCache.add(n4, n);
            }
            throw new SQLException(exception.toString());
        }
        if (this.dbase.readOnly) {
            if (this.tableType != 3) {
                throw new SQLException("Error writing to table, " + this.tableName + " - database is readonly.");
            }
            ++this.rowCount;
            return;
        }
        if (this.tableType == 3 && !this.dbase.resultsOnDisk) {
            if (bl) {
                --this.deletedRowCount;
                if (n == this.firstDeletedRow) {
                    this.findFirstDeletedRow(n + 1);
                }
            } else if (n > this.rowCount) {
                ++this.rowCount;
            }
            return;
        }
        if (this.encryptor != null) {
            n3 = this.bytesOut[0];
            this.encryptor.Encrypt(this.tableName, this.bytesOut, n, this.colOffsets);
            this.bytesOut[0] = n3;
            this.rndFile.invalidateDecryptedRow(n);
            this.dataOut.cache = null;
            this.saveRowCounts();
        }
        try {
            if (!this.modified) {
                this.markDirty();
            }
            this.transModified = true;
            if (transaction != null && this.tableType != 3) {
                this.journal.writeTransactionRecord(transaction, 1231975028, n, this, null, this.bytesOut);
            }
            if (bl) {
                --this.deletedRowCount;
                if (n == this.firstDeletedRow) {
                    this.findFirstDeletedRow(n + 1);
                }
            } else if (n > this.rowCount) {
                ++this.rowCount;
            }
            if (this.rndFile.writeBuffer != null) {
                this.rndFile.addRowToWriteBuffer(this.bytesOut, n);
            } else {
                long l = this.firstRowPosn + (long)((n - 1) * this.recLength);
                this.rndFile.seek(l);
                this.rndFile.write(this.bytesOut, 0, this.recLength);
                if (n == this.rowCount) {
                    this.writeEOF();
                }
            }
            this.rndFile.replaceRow(this.bytesOut, n);
            if (this.rowDeleted(n)) {
                ++this.deletedRowCount;
            }
            n2 = 0;
            while (n2 < this.indexTables.size()) {
                indexTable indexTable2 = (indexTable)this.indexTables.elementAt(n2);
                indexTable2.addRowToIndex(n);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Disk write problem: " + iOException.toString());
        }
        if (this.triggers != null && transaction != null) {
            Vector vector2 = new Vector(this.columnList.size());
            this.getRow(n, vector2);
            vector2.removeElementAt(0);
            n2 = 0;
            while (n2 < this.triggers.size()) {
                object = (idbTrigger)this.triggers.elementAt(n2);
                if (this.updating) {
                    if ((((idbTrigger)object).getEvents() & 1) > 0) {
                        ((idbTrigger)object).onUpdate((Vector)vector2.clone(), transaction.ID);
                    }
                } else if ((((idbTrigger)object).getEvents() & 4) > 0) {
                    ((idbTrigger)object).onAdd((Vector)vector2.clone(), transaction.ID);
                }
                ++n2;
            }
        }
    }

    void addTrigger(idbTrigger idbTrigger2) throws SQLException {
        if (this == this.dbase.tblTable || this == this.dbase.colTable || this == this.dbase.idxTable) {
            throw new SQLException("Triggers not allowed on system tables");
        }
        if (this.triggers == null) {
            this.triggers = new Vector(10, 10);
        }
        this.triggers.addElement(idbTrigger2);
    }

    void allColumnsAdded(Transaction transaction, boolean bl) throws IOException, SQLException {
        Object object;
        this.bytesOut = new byte[this.recLength];
        this.dataOut = new idbDataOutputStream(this.bytesOut, 2 * this.columnList.size());
        if (this.rndFile != null) {
            this.rndFile.setRecordLength(this.recLength);
        }
        if (this.addToTableList) {
            this.dbase.addTable(this);
        }
        if (this.dbase.readOnly) {
            return;
        }
        if (this.rndFile == null) {
            return;
        }
        if (this.tableType != 3) {
            this.dbase.addTable(this);
        }
        Vector<String> vector = new Vector<String>(this.columnList.size());
        Enumeration enumeration = this.columnList.elements();
        while (enumeration.hasMoreElements()) {
            object = (Column)enumeration.nextElement();
            ((Column)object).write(this.rndFile);
            if (!((Column)object).inPrimaryKey() || !bl) continue;
            vector.addElement(((Column)object).getName());
        }
        this.rndFile.writeInt(this.recLength);
        this.firstRowPosn = this.rndFile.getFilePointer();
        object = new byte[this.recLength];
        int n = 0;
        while (n < this.recLength) {
            object[n] = -1;
            ++n;
        }
        this.rndFile.write((byte[])object, 0, this.recLength);
        if (this.fd != null) {
            this.fd.sync();
        }
        this.registerTable(transaction);
        if (!vector.isEmpty()) {
            new indexTable(this, vector, String.valueOf(this.tableName) + "$pKey", false, transaction, this.partitionNumber);
        }
        if (this.tableType == 2) {
            try {
                int n2;
                if (this.tblID != null && (n2 = this.tblID.intValue()) > 1005) {
                    this.rndFile.close();
                    this.rndFile = null;
                    this.fd = null;
                }
            }
            catch (IOException iOException) {
                throw new SQLException("IO problem closing index file: " + iOException);
            }
        }
    }

    public boolean checkColName(String string) {
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    synchronized void close(boolean bl) throws IOException, SQLException {
        if (this.isClosed) {
            return;
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("Closing table " + this.tableName + " Rows " + this.rowCount + " Deleted rows " + this.deletedRowCount);
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("  Rec len " + this.recLength + " Cols " + this.columnList.size() + " Indexes " + this.indexTables.size());
        }
        if (!this.modified || this.dbase.readOnly) {
            if (Trace.traceIt(8)) {
                Trace.traceOut("  No change");
            }
        } else if (this.tableType != 3 && !bl) {
            this.saveRowCounts();
        }
        if (this.rndFile != null) {
            this.rndFile.close();
        }
        this.isClosed = true;
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            column.onClose();
            column = null;
            ++n;
        }
        this.columnList = null;
        this.indexTables = null;
    }

    void commitTriggers(long l) {
        if (this.triggers != null) {
            int n = 0;
            while (n < this.triggers.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.triggers.elementAt(n);
                if ((idbTrigger2.getEvents() & 0x10) > 0) {
                    idbTrigger2.onCommit(l);
                }
                ++n;
            }
        }
    }

    void construct(String string, Database database, int n) throws IOException, SQLException {
        Object object;
        this.runTime = Runtime.getRuntime();
        if (string == null) {
            if (Trace.traceIt(8)) {
                Trace.traceOut("Creating table null");
            }
        } else if (Trace.traceIt(8)) {
            Trace.traceOut("Creating table " + string);
        }
        this.dbase = database;
        this.partitionNumber = n;
        this.journal = this.dbase.journal;
        this.fastUpdate = this.dbase.fastUpdate;
        if (this.tableType != 3 && (object = database.getTable(string)) != null) {
            throw new SQLException("Table alreacy exists: " + string);
        }
        this.columnList = new Vector(10, 10);
        this.indexTables = new Vector(10, 10);
        this.setTablePath();
        if (string != null) {
            this.tableName = new String(string);
            if (this.tableType != 3 || this.dbase.resultsOnDisk) {
                this.fileDesc = new File(this.path, String.valueOf(string) + ".tbl");
                object = "rw";
                if (this.dbase.readOnly) {
                    object = "r";
                }
                this.rndFile = new ReadAheadBuffer(this.fileDesc, (String)object, this, 0);
                if (this.tableType != 3) {
                    this.fd = this.rndFile.getFD();
                }
                this.rndFile.writeInt(3);
                this.rndFile.writeInt(21);
                this.rowCountPosn = this.rndFile.getFilePointer();
                this.markDirty();
            }
        }
        this.controlCol = new ByteColumn(this, "$$control");
        this.controlCol.setBooleanProperty(3, true);
        this.controlCol.setProperty(4, "0");
        if (this.rndFile != null) {
            this.controlCol.setCacheCondition(1, this.dbase.controlColCacheSize);
            this.dbase.traceMemory();
        }
        this.lock = new TableLock(this);
    }

    public void deleteRow(int n, Transaction transaction, Vector vector) throws SQLException {
        Object object;
        if (n > this.rowCount && transaction == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.columnList.size()) {
            object = (Column)this.columnList.elementAt(n2);
            ((Column)object).onDelete(this.rndFile, n, transaction, vector);
            ++n2;
        }
        this.rndFile.invalidateDecryptedRow(n);
        if (this.maxRowDeleted == 0) {
            this.minRowDeleted = this.maxRowDeleted = n;
        } else if (n > this.maxRowDeleted) {
            this.maxRowDeleted = n;
        } else if (n < this.minRowDeleted) {
            this.minRowDeleted = n;
        }
        if (transaction != null) {
            this.journal.writeTransactionRecord(transaction, 1147497588, n, this, null, null);
        }
        int n3 = 0;
        while (n3 < this.indexTables.size()) {
            object = (indexTable)this.indexTables.elementAt(n3);
            ((indexTable)object).delRowFromIndex(n);
            ++n3;
        }
        ++this.deletedRowCount;
        if (n < this.firstDeletedRow || this.deletedRowCount == 1) {
            this.firstDeletedRow = n;
        }
        this.dataOut.reset();
        this.controlCol.setRow(this.dataOut, n, rowdel, transaction);
        try {
            if (!this.modified) {
                this.markDirty();
            }
            this.transModified = true;
            if (this.rndFile != null) {
                this.rndFile.seek(this.firstRowPosn + (long)((n - 1) * this.recLength) + (long)this.controlCol.getOffset());
                this.rndFile.write(this.bytesOut, 0, this.controlCol.getLength());
            }
            if (this.encryptor != null) {
                this.saveRowCounts();
            }
        }
        catch (Exception exception) {
            throw new SQLException("IO problem while deleting row: " + n + " " + exception.toString());
        }
        this.rndFile.invalidateCache(n);
        if (this.triggers != null && transaction != null) {
            Vector vector2 = new Vector(this.columnList.size());
            this.getRow(n, vector2);
            vector2.removeElementAt(0);
            int n4 = 0;
            while (n4 < this.triggers.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.triggers.elementAt(n4);
                if ((idbTrigger2.getEvents() & 2) > 0 && !this.updating) {
                    idbTrigger2.onDelete((Vector)vector2.clone(), transaction.ID);
                }
                if ((idbTrigger2.getEvents() & 1) > 0 && this.updating) {
                    idbTrigger2.preUpdate((Vector)vector2.clone(), transaction.ID);
                }
                ++n4;
            }
        }
    }

    void dropColumn(String string, Column column) throws SQLException, IOException {
        int n;
        int n2 = 0;
        while (n2 < this.indexTables.size()) {
            indexTable indexTable2 = (indexTable)this.indexTables.elementAt(n2);
            Vector vector = indexTable2.indexedCols;
            n = 0;
            while (n < vector.size()) {
                Column column2 = (Column)vector.elementAt(n);
                if (column == column2) {
                    throw new SQLException("Col " + column2.getName() + " is part of index " + indexTable2.getTableName());
                }
                ++n;
            }
            ++n2;
        }
        int n3 = column.getLength();
        int n4 = column.getOffset();
        n = n4 + n3;
        int n5 = this.recLength - n3;
        int n6 = this.recLength - n4 - n3;
        long l = 0L;
        String string2 = "DELETE FROM " + this.dbase.colsTableName + " WHERE ColId = " + column.getColID();
        this.dbase.execSQL(string2, null);
        string2 = "UPDATE " + this.dbase.colsTableName + " SET offset = offset - " + n3 + " WHERE TableID = " + this.tblID + " AND offset > " + n4;
        this.dbase.execSQL(string2, null);
        int n7 = 0;
        int n8 = 0;
        while (n8 < this.columnList.size()) {
            Column column3 = (Column)this.columnList.elementAt(n8);
            if (column == column3) {
                n7 = n8;
            } else if (column3.getOffset() > n4) {
                column3.setOffset(column3.getOffset() - n3);
                if (l == 0L) {
                    l = column3.headerPosn - column.headerPosn;
                }
                column3.headerPosn -= l;
            }
            column3.close(this.rndFile);
            ++n8;
        }
        if (l == 0L) {
            l = this.rndFile.getFilePointer() - column.headerPosn;
        }
        this.columnList.removeElementAt(n7);
        this.rndFile.dropColumnFromTable(n4, n, n5, n6, l);
        this.rndFile.write(-1);
        this.recLength = n5;
        this.firstRowPosn -= l;
        this.rndFile.seek(this.firstRowPosn - 4L);
        this.rndFile.writeInt(n5);
        if (this.encryptor != null) {
            this.setTableEncryption(this.encryptor);
        }
    }

    public synchronized void dropTable(Transaction transaction) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("Dropping table " + this.tableName);
        }
        try {
            Object object;
            int n = 0;
            while (n < this.columnList.size()) {
                object = (Column)this.columnList.elementAt(n);
                ((Column)object).onDrop();
                ++n;
            }
            this.dbase.removeTable(this);
            while (!this.indexTables.isEmpty()) {
                object = (indexTable)this.indexTables.elementAt(0);
                ((indexTable)object).dropTable(transaction);
            }
            this.close(false);
        }
        catch (IOException iOException) {}
        if (this.tableType != 3) {
            Object object;
            Table table = this.dbase.colTable;
            int n = 1;
            while (n <= table.rowCount) {
                object = (Integer)table.getColByRow("TableID", n);
                if (this.tblID.equals(object)) {
                    table.deleteRow(n, transaction, null);
                }
                ++n;
            }
            object = this.dbase.tblTable;
            int n2 = 1;
            while (n2 <= ((Table)object).rowCount) {
                Integer n3 = (Integer)((Table)object).getColByRow("TableID", n2);
                if (this.tblID.equals(n3)) {
                    ((Table)object).deleteRow(n2, transaction, null);
                    break;
                }
                ++n2;
            }
        }
        try {
            if (this.tableType != 3) {
                this.dbase.colTable.fd.sync();
                this.dbase.tblTable.fd.sync();
                this.dbase.idxTable.fd.sync();
            }
            if (this.fileDesc != null) {
                this.fileDesc.delete();
            }
        }
        catch (Exception exception) {}
    }

    public void dump() {
        int n = 0;
        while (n <= this.rowCount) {
            this.dump(n);
            ++n;
        }
    }

    void dump(int n) {
        System.out.println(this.rowToString(n, true));
    }

    public void exportText(String string) throws SQLException {
        Trace trace = Trace.getTrace();
        if (trace.export == null) {
            return;
        }
        if ((trace.getTraceLevel() & 0x800) == 0) {
            return;
        }
        PrintWriter printWriter = trace.export;
        synchronized (printWriter) {
            int n;
            PrintWriter printWriter2 = trace.export;
            if (string != null) {
                printWriter2.println(string);
            }
            if (trace.printSummaryHeader && this.tableType != 3) {
                printWriter2.println("Table " + this.tableName + " has " + this.rowCount + " rows. " + this.deletedRowCount + " are deleted.");
            }
            StringBuffer stringBuffer = new StringBuffer(1024);
            int n2 = this.columnList.size();
            Column[] columnArray = new Column[n2];
            int[] nArray = new int[n2];
            if (trace.colHeaders && trace.printRowNumbers) {
                stringBuffer.append("Row  ");
            }
            int n3 = 0;
            while (n3 < n2) {
                if (n3 != 0 || trace.printControlCol) {
                    Object object;
                    columnArray[n3] = (Column)this.columnList.elementAt(n3);
                    int n4 = 0;
                    switch (columnArray[n3].type) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            n4 = 9;
                            break;
                        }
                        case 8: {
                            n4 = 15;
                            break;
                        }
                        case 3: {
                            object = (StringColumn)columnArray[n3];
                            n4 = ((StringColumn)object).maxSize + 1;
                            break;
                        }
                        default: {
                            n4 = 5;
                        }
                    }
                    if (trace.colHeaders) {
                        object = String.valueOf(columnArray[n3].getName()) + ' ';
                        nArray[n3] = ((String)object).length();
                        stringBuffer.append((String)object);
                        if (nArray[n3] < n4) {
                            n = nArray[n3];
                            while (n < n4) {
                                stringBuffer.append(' ');
                                ++n;
                            }
                            nArray[n3] = n4;
                        }
                    } else {
                        nArray[n3] = n4;
                    }
                }
                ++n3;
            }
            if (trace.colHeaders) {
                printWriter2.println(stringBuffer);
            }
            Vector vector = new Vector(n2);
            int n5 = 1;
            while (n5 <= this.rowCount) {
                stringBuffer.setLength(0);
                if (!this.rowDeleted(n5) || trace.printDelRows) {
                    if (trace.printRowNumbers) {
                        stringBuffer.append(n5);
                        if (!trace.csvDelimited) {
                            if (n5 < 10) {
                                stringBuffer.append(' ');
                            }
                            if (n5 < 100) {
                                stringBuffer.append(' ');
                            }
                            if (n5 < 1000) {
                                stringBuffer.append(' ');
                            }
                            if (n5 < 10000) {
                                stringBuffer.append(' ');
                            }
                        } else {
                            stringBuffer.append(trace.delimiter);
                        }
                    }
                    this.getRow(n5, vector);
                    n = 0;
                    while (n < n2) {
                        if (n != 0 || trace.printControlCol) {
                            Object e = vector.elementAt(n);
                            String string2 = columnArray[n].toString(e);
                            trace.appendQuote(stringBuffer);
                            stringBuffer.append(string2);
                            trace.appendQuote(stringBuffer);
                            if (trace.csvDelimited) {
                                if (n != n2 - 1) {
                                    stringBuffer.append(trace.delimiter);
                                }
                            } else if (string2.length() < nArray[n]) {
                                int n6 = string2.length();
                                while (n6 < nArray[n]) {
                                    stringBuffer.append(' ');
                                    ++n6;
                                }
                            } else {
                                stringBuffer.append(' ');
                                nArray[n] = string2.length() + 1;
                            }
                        }
                        ++n;
                    }
                    printWriter2.println(stringBuffer);
                }
                ++n5;
            }
            trace.export.flush();
        }
    }

    protected void finalize() throws Throwable {
        if (this.tableType == 3 && this.indexTables != null) {
            this.dropTable(null);
        }
        if (this.addToTableList) {
            this.dbase.removeTable(this);
        }
    }

    int findFirstDeletedRow(int n) throws SQLException {
        if (this.deletedRowCount == 0) {
            this.firstDeletedRow = 0;
            return this.firstDeletedRow;
        }
        int n2 = n;
        while (n2 <= this.rowCount) {
            if (this.rowDeleted(n2)) {
                this.firstDeletedRow = n2;
                return this.firstDeletedRow;
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 < n) {
            if (this.rowDeleted(n3)) {
                if (n3 == this.firstDeletedRow) break;
                this.firstDeletedRow = n3;
                return this.firstDeletedRow;
            }
            ++n3;
        }
        this.firstDeletedRow = 0;
        this.deletedRowCount = 0;
        if (!this.modified) {
            this.markDirty();
        }
        return this.firstDeletedRow;
    }

    void gc() {
        long l;
        long l2;
        boolean bl = false;
        if (++accessCount % 100 == 0 && (l2 = (l = this.runTime.totalMemory()) - this.runTime.freeMemory()) > 3L * l / 4L && !this.dbase.microsoftVM) {
            bl = true;
        }
        if (accessCount > 1000) {
            bl = true;
        }
        if (bl) {
            accessCount = 0;
            if (Trace.traceIt(128)) {
                Trace.traceOut("Requesting gc");
            }
            this.dbase.traceMemory();
            this.dbase.traceMemory();
        }
    }

    Vector getAllIndexes(Column column) {
        Vector<Column> vector = new Vector<Column>(1);
        vector.addElement(column);
        Vector<indexTable> vector2 = new Vector<indexTable>(5);
        int n = 0;
        while (n < this.indexTables.size()) {
            indexTable indexTable2 = (indexTable)this.indexTables.elementAt(n);
            if (indexTable2.indexes(vector)) {
                vector2.addElement(indexTable2);
            }
            ++n;
        }
        return vector2;
    }

    public Column getColByID(int n) {
        int n2 = 0;
        while (n2 < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n2);
            if (column.colID == n) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    public Column getColByID(Integer n) {
        return this.getColByID((int)n);
    }

    public Column getColByName(String string) {
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return column;
            }
            ++n;
        }
        return null;
    }

    public Column getColByName(String string, boolean bl) {
        boolean bl2 = false;
        int n = string.indexOf(46);
        if (n != -1) {
            bl2 = true;
        }
        int n2 = 0;
        while (n2 < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n2);
            String string2 = column.getName();
            if (bl2) {
                Table table = column.getUnderlyingTable();
                if (table != null) {
                    String string3 = table.getTableName();
                    string2 = String.valueOf(string3) + "." + string2;
                } else {
                    string2 = String.valueOf(this.tableName) + "." + string2;
                }
            }
            if (string2.equalsIgnoreCase(string)) {
                return column;
            }
            if (bl && (n = string2.indexOf(46)) != -1) {
                string2 = string2.substring(n + 1);
            }
            if (string2.equalsIgnoreCase(string)) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    public Object getColByRow(String string, int n) throws SQLException {
        Column column = this.getColByName(string);
        if (column == null) {
            return null;
        }
        return column.getByRow(n);
    }

    public int getColCount() {
        return this.columnList.size();
    }

    public int getColIndex(String string) {
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Vector getColList() {
        return this.columnList;
    }

    public int getCount() {
        this.rowCount -= this.deletedRowCount;
        return this.rowCount;
    }

    indexTable getIndex(Vector vector) {
        int n = 0;
        while (n < this.indexTables.size()) {
            indexTable indexTable2 = (indexTable)this.indexTables.elementAt(n);
            if (indexTable2.indexes(vector)) {
                return indexTable2;
            }
            ++n;
        }
        return null;
    }

    indexTable getIndex(Column column) {
        Vector<Column> vector = new Vector<Column>(1);
        vector.addElement(column);
        return this.getIndex(vector);
    }

    int getIntValByRow(String string, int n) throws SQLException {
        return (Integer)this.getColByRow(string, n);
    }

    Column getPrimaryKey() throws SQLException {
        Column column = null;
        int n = 0;
        while (n < this.columnList.size()) {
            Column column2 = (Column)this.columnList.elementAt(n);
            if (column2.inPrimaryKey()) {
                if (column != null) {
                    throw new SQLException("Table, " + this.tableName + ", has more than one column in its primary key.");
                }
                column = column2;
            }
            ++n;
        }
        return column;
    }

    public int getRelColPosn(String string) {
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void getRow(int n, Vector vector) throws SQLException {
        int n2 = this.columnList.size();
        vector.removeAllElements();
        if (this.order != null) {
            n = this.order[n - 1] + 1;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Column column = (Column)this.columnList.elementAt(n3);
            Object object = column.getByRow(n);
            vector.addElement(object);
            if (n3 == 0 && (n4 = ((Integer)object).intValue()) == -1) break;
            ++n3;
        }
    }

    public void getRowByValue(String string, Object object, Vector vector) throws SQLException {
        Column column = this.getColByName(string);
        int n = column.getRowByValue(object, 0);
        if (n == 0) {
            return;
        }
        this.getRow(n, vector);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getTableID() {
        if (this.tblID == null) {
            return 0;
        }
        return this.tblID;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getTableType() {
        return this.tableType;
    }

    public int getUnderlyingRow(int n) {
        if (this.order != null) {
            n = this.order[n - 1] + 1;
        }
        int n2 = this.fromTable.array[n - 1];
        return n2;
    }

    public Table getUnderlyingTable() {
        return this.underlyingTable;
    }

    public int getValidRowCount() {
        return this.rowCount - this.deletedRowCount;
    }

    public Object getValueByValue(String string, Object object, Column column) throws SQLException {
        Vector vector = new Vector(this.getColCount());
        this.getRowByValue(string, object, vector);
        if (vector == null) {
            return null;
        }
        int n = 0;
        while (n < this.columnList.size()) {
            if (this.columnList.elementAt(n) == column) {
                return vector.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    void lockTable(Transaction transaction, int n) throws SQLException {
        if (transaction == null) {
            return;
        }
        if (!transaction.obeysLocks()) {
            return;
        }
        if (n == Transaction.WRITE) {
            this.lock.getWriteLock(transaction);
        } else {
            this.lock.getReadLock(transaction);
        }
    }

    public boolean lt(int n, int n2) {
        try {
            int n3 = 0;
            while (n3 < this.numOrdered) {
                int n4 = this.orderedFields[n3];
                Column column = (Column)this.columnList.elementAt(n4);
                Object object = column.getByRow(n2 + 1);
                int n5 = 7;
                if (column.order == 2) {
                    n5 = 5;
                }
                if (column.compare(n + 1, object, n5, true)) {
                    return true;
                }
                if (!column.compare(n + 1, object, 1, true)) {
                    return false;
                }
                ++n3;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("Error comparing rows during ordering: \n" + exception.getMessage());
            return false;
        }
    }

    void markDirty() throws SQLException {
        try {
            if (Trace.traceIt(8)) {
                Trace.traceOut(String.valueOf(this.tableName) + " marked dirty");
            }
            boolean bl = false;
            if (this.rndFile == null) {
                this.rndFile = new ReadAheadBuffer(this.fileDesc, "rw", this, 0);
                this.fd = this.rndFile.getFD();
                bl = true;
            }
            this.rndFile.seek(this.rowCountPosn);
            this.rndFile.writeInt(-1);
            this.rndFile.writeInt(0);
            if (this.fd != null) {
                this.fd.sync();
            }
            this.modified = true;
            if (bl) {
                this.rndFile.close();
                this.rndFile = null;
                this.fd = null;
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error saving row counts " + exception.toString());
        }
    }

    void newColAdded() throws SQLException, IOException {
        Object object;
        Column column = (Column)this.columnList.lastElement();
        this.recLength -= column.getLength();
        Table table = new Table(this.dbase.getTmpFile(), this.dbase, null, this.partitionNumber);
        table.tableName = this.tableName;
        Integer[] integerArray = new Integer[this.columnList.size()];
        int n = 1;
        while (n < this.columnList.size()) {
            object = (Column)this.columnList.elementAt(n);
            table.addColumn((Column)object);
            ((Column)object).cTable = table;
            integerArray[n] = ((Column)object).colID;
            ++n;
        }
        object = "DELETE FROM " + this.dbase.colsTableName + " WHERE TableId = " + this.tblID;
        String string = "DELETE FROM " + this.dbase.tblsTableName + " WHERE TableId = " + this.tblID;
        this.dbase.execSQL((String)object, null);
        this.dbase.execSQL(string, null);
        this.dbase.removeTable(this);
        table.allColumnsAdded(null, false);
        String string2 = "UPDATE " + this.dbase.indxTableName + " SET ColID = ? WHERE ColID = ?";
        SQLProg sQLProg = new SQLProg(this.dbase, string2, true, null);
        int n2 = 1;
        while (n2 < this.columnList.size() - 1) {
            Column column2 = (Column)this.columnList.elementAt(n2);
            sQLProg.setParam(1, column2.colID);
            sQLProg.setParam(2, integerArray[n2]);
            sQLProg.execute();
            ++n2;
        }
        table.rndFile.seek(table.firstRowPosn);
        int n3 = 1;
        while (n3 <= this.rowCount) {
            int n4 = this.rndFile.readRow(n3, 0);
            System.arraycopy(this.rndFile.rowInputBuffer, n4, table.bytesOut, 0, this.recLength);
            table.dataOut.reset();
            table.dataOut.count = this.recLength;
            table.dataOut.curCol = this.columnList.size() - 1;
            column.setRow(table.dataOut, n3, column.getDefault(), null);
            table.rndFile.write(table.bytesOut);
            this.rndFile.freeReadAhead();
            ++n3;
        }
        table.rndFile.write(-1);
        table.rowCount = this.rowCount;
        table.deletedRowCount = this.deletedRowCount;
        table.findFirstDeletedRow(1);
        table.indexTables = this.indexTables;
        table.triggers = this.triggers;
        this.rndFile.close();
        if (!this.fileDesc.delete()) {
            throw new SQLException("Error deleting file: " + this.fileDesc);
        }
        table.rndFile.close();
        if (!table.fileDesc.renameTo(this.fileDesc)) {
            throw new SQLException("Error renaming file: " + table.fileDesc + " to " + this.fileDesc);
        }
        table.fileDesc = this.fileDesc;
        table.rndFile = new ReadAheadBuffer(table.fileDesc, "rw", table, 0);
        table.rndFile.setRecordLength(this.recLength);
        table.fd = table.rndFile.getFD();
        table.markDirty();
        if (this.encryptor != null) {
            this.setTableEncryption(this.encryptor);
        }
    }

    synchronized boolean open(String string) throws IOException, SQLException {
        Object object;
        Object object2;
        if (Trace.traceIt(8)) {
            Trace.traceOut("Opening table " + string);
        }
        this.tableName = string;
        this.fileDesc = new File(this.path, String.valueOf(string) + ".tbl");
        if (!this.fileDesc.exists()) {
            return false;
        }
        int n = 0;
        if (this.tblID == null) {
            n = this.dbase.systemRows;
        } else if (this.tblID <= 1005) {
            n = this.dbase.systemRows;
        }
        if (this.dbase.readOnly) {
            this.rndFile = new ReadAheadBuffer(this.fileDesc, "r", this, n);
        } else {
            this.rndFile = new ReadAheadBuffer(this.fileDesc, "rw", this, n);
            this.fd = this.rndFile.getFD();
        }
        if (this.rndFile.length() < 16L) {
            throw new SQLException("Invalid table file: " + this.path + File.separatorChar + string);
        }
        this.majVersion = this.rndFile.readInt();
        if (this.majVersion > 3) {
            throw new SQLException("Table, " + this.fileDesc.toString() + ", created with a later version.");
        }
        this.minVersion = this.rndFile.readInt();
        int n2 = this.majVersion * 100 + this.minVersion;
        if (this.tblID == null) {
            if (n2 >= 320) {
                this.dbase.addFkColumns();
            } else {
                this.dbase.noFKs = true;
            }
        }
        if (this.tableType != 2) {
            this.rndFile.setRecordLength(this.recLength);
        }
        this.rowCountPosn = this.rndFile.getFilePointer();
        this.rowCount = this.rndFile.readInt();
        this.deletedRowCount = this.rndFile.readInt();
        if (this.rowCount == -1) {
            object2 = "Database not shut down cleanly or in use by another program.\nSet recoveryPolicy=1 for automatic recovery.";
            switch (this.dbase.recoveryPolicy) {
                case 1: {
                    this.dbase.doRecovery = true;
                    break;
                }
                case 2: {
                    if (this.dbase.doRecovery) break;
                    System.out.println((String)object2);
                    System.out.println("Note that it is dangerous to proceed if another\nprogram is currently accessing this database.");
                    System.out.println("Should InstantDB attempt recovery now? (y/n)");
                    object = new BufferedReader(new InputStreamReader(System.in));
                    String string2 = "";
                    while (string2.length() == 0) {
                        string2 = ((BufferedReader)object).readLine();
                    }
                    char c = string2.charAt(0);
                    if (c != 'y' && c != 'Y') break;
                    this.dbase.doRecovery = true;
                    break;
                }
            }
            if (this.dbase.doRecovery) {
                this.recovered = true;
            } else {
                this.dbase.close();
                throw new SQLException((String)object2);
            }
        }
        object2 = this.columnList.elements();
        while (object2.hasMoreElements()) {
            object = (Column)object2.nextElement();
            ((Column)object).read(this.rndFile);
        }
        int n3 = this.rndFile.readInt();
        if (this.recLength != n3) {
            throw new SQLException("Internal error header recLength=" + n3 + "\nComputed record length should be " + this.recLength + "\nTable: " + this.tableName);
        }
        this.bytesOut = new byte[this.recLength];
        this.dataOut = new idbDataOutputStream(this.bytesOut, 2 * this.columnList.size());
        this.firstRowPosn = this.rndFile.getFilePointer();
        if (Trace.traceIt(8)) {
            Trace.traceOut("    Rows " + this.rowCount + " Deleted rows " + this.deletedRowCount);
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("    Rec len " + this.recLength + " Cols " + this.columnList.size() + " Indexes " + this.indexTables.size());
        }
        if (this.recovered) {
            try {
                this.recover();
            }
            catch (Exception exception) {
                System.out.println("WARNING, table " + this.tableName + " could not be recovered. Error: " + exception.toString());
            }
            if (Trace.traceIt(8)) {
                Trace.traceOut("    Rows " + this.rowCount + " Deleted rows " + this.deletedRowCount);
            }
            if (Trace.traceIt(8)) {
                Trace.traceOut("    Rec len " + this.recLength + " Cols " + this.columnList.size() + " Indexes " + this.indexTables.size());
            }
        }
        if (this.tableType != 2) {
            this.findFirstDeletedRow(1);
        }
        this.dbase.addTable(this);
        return true;
    }

    void recover() throws SQLException {
        long l;
        Object object;
        Column[] columnArray;
        block18: {
            if (Trace.traceIt(8)) {
                Trace.traceOut("Recovering table: " + this.tableName);
            }
            this.deletedRowCount = 0;
            this.rowCount = 0;
            columnArray = new Column[this.columnList.size()];
            int n = 0;
            while (n < this.columnList.size()) {
                object = (Column)this.columnList.elementAt(n);
                if (((Column)object).requiresRecovery) {
                    columnArray[n] = object;
                }
                ++n;
            }
            object = new Vector(this.getColCount());
            l = 0L;
            try {
                l = this.rndFile.length();
            }
            catch (Exception exception) {
                if (!Trace.traceIt(8)) break block18;
                Trace.traceOut("IO problem getting file length" + exception.toString());
            }
        }
        int n = 0;
        while (true) {
            block20: {
                block19: {
                    try {
                        if (this.rndFile.length() > l) {
                            if (Trace.traceIt(4)) {
                                Trace.traceOut("Had to add new EOF marker " + this.tableName + " may contain invalid data.");
                            }
                            this.rndFile.seek(this.rndFile.length());
                            byte[] byArray = new byte[this.recLength];
                            this.writeEOF();
                        }
                    }
                    catch (Exception exception) {
                        if (!Trace.traceIt(4)) break block19;
                        Trace.traceOut("IO problem adding EOF marker" + exception.toString());
                    }
                }
                ++this.rowCount;
                boolean bl = false;
                try {
                    this.getRow(this.rowCount, (Vector)object);
                }
                catch (Exception exception) {
                    ++n;
                    bl = true;
                }
                int n2 = (Integer)((Vector)object).elementAt(0);
                if (n2 == -1) break;
                if ((n2 & 1) > 0) {
                    ++this.deletedRowCount;
                }
                try {
                    int n3 = 0;
                    while (n3 < columnArray.length) {
                        if (columnArray[n3] != null) {
                            columnArray[n3].recover(((Vector)object).elementAt(n3));
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    if (bl) break block20;
                    ++n;
                }
            }
            if (this.rowCount % 100 != 0 || !Trace.traceIt(32)) continue;
            Trace.traceOut(String.valueOf(this.rowCount) + " rows recovered");
        }
        --this.rowCount;
        this.saveRowCounts();
        if (n > 0) {
            System.out.println("WARNING, table \"" + this.tableName + "\", " + n + " rows could not be recovered.");
        }
    }

    void registerTable(Transaction transaction) throws SQLException {
        if (this.dbase.colTable == null) {
            return;
        }
        if (this.tableType == 3) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(20);
        hashtable.put("TableName", this.tableName);
        hashtable.put("Path", Integer.toString(this.partitionNumber));
        hashtable.put("RecLen", new Integer(this.recLength));
        hashtable.put("Type", new Integer(this.tableType));
        int n = this.dbase.tblTable.addRow(hashtable, transaction);
        this.tblID = (Integer)this.dbase.tblTable.getColByRow("TableID", n);
        Column column = this.dbase.colTable.getColByName("ColID");
        int n2 = ((IntegerColumn)column).nextIncrement;
        int n3 = 0;
        while (n3 < this.columnList.size()) {
            Column column2 = (Column)this.columnList.elementAt(n3);
            column2.colID = new Integer(n2 + n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.columnList.size()) {
            int n5;
            Object object;
            hashtable.clear();
            Column column3 = (Column)this.columnList.elementAt(n4);
            hashtable.put("TableId", this.tblID);
            hashtable.put("ColName", column3.colName);
            hashtable.put("Type", new Integer(column3.type));
            hashtable.put("Offset", new Integer(column3.recOffset));
            hashtable.put("Length", new Integer(column3.colLength));
            RowRangeCache rowRangeCache = (RowRangeCache)column3.rowCache;
            hashtable.put("CacheCond", new Integer(rowRangeCache.cacheCondition));
            hashtable.put("CacheAmnt", new Integer(rowRangeCache.cacheAmount));
            if (column3.defaultValue != null) {
                hashtable.put("ColDefault", column3.defaultValue.toString());
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (column3.isPrimaryKey) {
                stringBuffer.append(".PK");
            }
            if (column3.unique) {
                stringBuffer.append(".UNIQ");
            }
            if (column3.notNull) {
                stringBuffer.append(".~NULL");
            }
            hashtable.put("Flags", stringBuffer.toString());
            if (!this.dbase.noFKs) {
                if (column3.fk != null) {
                    hashtable.put("FK", column3.fk.colID);
                    hashtable.put("FK_FLAGS", new Integer(column3.fk_flags));
                } else {
                    object = new Integer(0);
                    hashtable.put("FK", object);
                    hashtable.put("FK_FLAGS", object);
                }
            }
            if ((n5 = ((Integer)(object = this.dbase.colTable.getColByRow("ColID", n = this.dbase.colTable.addRow(hashtable, transaction)))).intValue()) != column3.colID) {
                throw new SQLException("Internal error. " + column3.toString() + " has wrong column ID");
            }
            ++n4;
        }
        try {
            this.dbase.colTable.fd.sync();
            this.dbase.tblTable.fd.sync();
            this.fd.sync();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    void removeTrigger(idbTrigger idbTrigger2) {
        this.triggers.removeElement(idbTrigger2);
        if (this.triggers.size() == 0) {
            this.triggers = null;
        }
    }

    void rollbackTriggers(long l) {
        if (this.triggers != null) {
            int n = 0;
            while (n < this.triggers.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.triggers.elementAt(n);
                if ((idbTrigger2.getEvents() & 8) > 0) {
                    idbTrigger2.onRollback(l);
                }
                ++n;
            }
        }
    }

    boolean rowDeleted(int n) throws SQLException {
        if (this.deletedRowCount == 0) {
            return false;
        }
        if (this.order != null) {
            n = this.order[n - 1] + 1;
        }
        return this.controlCol.deleteBitSet(n);
    }

    boolean rowEquals(int n, Vector vector) throws SQLException {
        int n2 = 1;
        while (n2 < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n2);
            if (!column.compare(n, vector.elementAt(n2), 1, true)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    String rowToString(int n, boolean bl) {
        int n2 = this.columnList.size();
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Row " + n);
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0 || bl) {
                Column column = (Column)this.columnList.elementAt(n3);
                try {
                    Object object = column.getByRow(n);
                    stringBuffer.append(' ');
                    if (object instanceof String) {
                        stringBuffer.append(object.toString());
                    } else {
                        stringBuffer.append(column.toString(object));
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    void saveRowCounts() throws SQLException {
        try {
            this.markDirty();
            int n = 0;
            while (n < this.columnList.size()) {
                Column column = (Column)this.columnList.elementAt(n);
                column.write(this.rndFile);
                ++n;
            }
            this.rndFile.seek(this.rowCountPosn);
            this.rndFile.writeInt(this.rowCount);
            this.rndFile.writeInt(this.deletedRowCount);
            if (this.fd != null) {
                this.fd.sync();
            }
            if (Trace.traceIt(8)) {
                Trace.traceOut(String.valueOf(this.tableName) + " marked OK");
            }
            this.modified = false;
        }
        catch (Exception exception) {
            throw new SQLException("Error saving row counts " + exception.toString());
        }
    }

    public void setOrder(int[] nArray) {
        this.order = nArray;
    }

    void setTableEncryption(TableEncrypt tableEncrypt) throws SQLException {
        this.encryptor = tableEncrypt;
        this.rndFile.createEncryptionBuffer();
        this.colOffsets = new int[this.columnList.size()];
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            this.colOffsets[n] = column.getOffset();
            ++n;
        }
    }

    void setTablePath() {
        this.path = this.dbase.tablePath;
        if (this instanceof indexTable && this.dbase.indexPath != null) {
            this.path = this.dbase.indexPath;
        }
        if (this.partitionNumber > 0) {
            this.path = this.dbase.partitions.getStringAt(this.partitionNumber - 1);
        }
        if (this.tableType == 3 && this.dbase.tmpPath != null) {
            this.path = this.dbase.tmpPath;
        }
    }

    public void setUpdateFlags(boolean bl) {
        this.noAutoInc = bl;
        this.updating = bl;
    }

    void setupFKs(indexTable indexTable2) throws SQLException {
        if (!this.hasFKreference) {
            return;
        }
        Table table = indexTable2.parentTable;
        Vector vector = new Vector(table.columnList.size());
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            int n2 = column.fkID;
            if (n2 != 0) {
                Column column2;
                int n3 = indexTable2.lookupKey(n2, true);
                int n4 = indexTable2.getRowByRow(n3);
                table.getRow(n4, vector);
                Integer n5 = (Integer)vector.elementAt(2);
                Table table2 = this.dbase.getTable(n5);
                column.fk = column2 = table2.getColByID(n2);
                column2.addFk(column);
            }
            ++n;
        }
    }

    public void swap(int n, int n2) {
        try {
            Vector vector = new Vector(this.columnList.size());
            this.getRow(n + 1, vector);
            Vector vector2 = new Vector(this.columnList.size());
            this.getRow(n2 + 1, vector2);
            this.addRowAtRow(vector2, n + 1, null);
            this.addRowAtRow(vector, n2 + 1, null);
            if (this.dbase.readOnly) {
                this.rowCount -= 2;
            }
        }
        catch (Exception exception) {
            System.out.println("Error swapping rows during ordering: \n" + exception.getMessage());
        }
    }

    void writeEOF() throws IOException {
        byte by = this.bytesOut[0];
        this.bytesOut[0] = -1;
        this.rndFile.write(this.bytesOut, 0, this.recLength);
        this.bytesOut[0] = by;
    }
}

