/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.enhydra.instantdb.TestObject;
import org.enhydra.instantdb.db.Trace;
import org.enhydra.instantdb.jdbc.idbConnection;

class SampleThread
implements Runnable {
    Connection con;
    BufferedReader in;
    Statement stmt;
    PreparedStatement pstmt;
    ResultSet rs;
    DatabaseMetaData dma;
    Vector childThreads;
    String url;
    static PreparedStatement globPrepStmnt;
    static Connection globCon;
    String sqlName;
    char command;
    String sql;
    StringBuffer curStatement;
    boolean norsClose;
    TestObject test1;
    boolean batchMode;
    boolean rsmd;

    public SampleThread(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            this.in = new BufferedReader(fileReader);
            this.childThreads = new Vector(10, 10);
            this.sqlName = string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void closers() throws SQLException {
        if (this.norsClose) {
            return;
        }
        if (this.rs == null) {
            return;
        }
        if (this.rsmd) {
            ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            StringBuffer stringBuffer = new StringBuffer(64);
            Trace.traceOut("Result Set Meta Data");
            int n2 = 1;
            while (n2 <= n) {
                String string = resultSetMetaData.getColumnName(n2);
                String string2 = resultSetMetaData.getTableName(n2);
                stringBuffer.setLength(0);
                stringBuffer.append("Table='" + string2 + "' ");
                stringBuffer.append(String.valueOf(string) + ": ");
                if (resultSetMetaData.isAutoIncrement(n2)) {
                    stringBuffer.append("[AUTO INC] ");
                }
                if (resultSetMetaData.isCaseSensitive(n2)) {
                    stringBuffer.append("[CASE SENSITIVE] ");
                }
                if (resultSetMetaData.isCurrency(n2)) {
                    stringBuffer.append("[CURRENCY] ");
                }
                if (resultSetMetaData.isNullable(n2) == 1) {
                    stringBuffer.append("[NULLABLE] ");
                }
                if (resultSetMetaData.isReadOnly(n2)) {
                    stringBuffer.append("[READONLY] ");
                }
                Trace.traceOut(stringBuffer.toString());
                ++n2;
            }
        }
        try {
            this.rs.close();
        }
        catch (Exception exception) {}
    }

    static void dispResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            if (n2 > 1) {
                System.out.print(",");
            }
            System.out.print(resultSetMetaData.getColumnLabel(n2));
            ++n2;
        }
        System.out.println("");
        while (resultSet.next()) {
            System.out.println(SampleThread.dispRow(resultSet));
        }
    }

    static String dispRow(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer(128);
        int n2 = 1;
        while (n2 <= n) {
            if (n2 > 1) {
                stringBuffer.append(',');
            }
            stringBuffer.append(resultSet.getString(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    void exportAll() throws SQLException {
        String string;
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = this.dma.getTables(null, null, "%", stringArray);
        while (resultSet.next()) {
            string = resultSet.getString(3);
            String string2 = "SET EXPORT \"ex$" + string + ".txt\" CSVDELIMITED NO SQL TRACE 0";
            this.stmt.execute(string2);
            string2 = "SELECT * FROM " + string;
            this.stmt.execute(string2);
        }
        string = "SET EXPORT \"NULL\"";
        this.stmt.execute(string);
    }

    void getSQL(String string) throws IOException {
        if (string == null) {
            this.curStatement.setLength(0);
            boolean bl = false;
            while (!bl) {
                if (!this.in.ready()) break;
                String string2 = this.in.readLine();
                if (string2 == null || string2.length() == 0 || string2.charAt(0) == ';' || string2.charAt(0) == '!' || string2.charAt(0) == '-' || string2.charAt(0) == '#') continue;
                this.curStatement.append(string2);
                if (this.curStatement.charAt(this.curStatement.length() - 1) != ';') continue;
                bl = true;
                this.curStatement.setLength(this.curStatement.length() - 1);
            }
            this.sql = this.curStatement.toString();
        } else {
            this.sql = string;
        }
        this.sql = this.sql.trim();
        if (this.sql.length() > 0) {
            this.command = this.sql.charAt(0);
            if (this.sql.length() > 1 && this.sql.charAt(1) != ' ') {
                this.command = (char)101;
                this.sql = "  " + this.sql;
            }
        }
    }

    void importAll() throws SQLException {
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = this.dma.getTables(null, null, "%", stringArray);
        while (resultSet.next()) {
            String string = resultSet.getString(3);
            String string2 = "DELETE FROM " + string;
            this.stmt.execute(string2);
            string2 = "IMPORT " + string + " FROM \"ex$" + string + ".txt\" BUFFER 1024";
            this.stmt.execute(string2);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        var1_1 = Thread.currentThread();
        var1_1.setName(this.sqlName);
        var2_2 = 0L;
        var4_3 = 0L;
        var6_4 = false;
        var7_5 = 0;
        var8_6 = new String[100];
        var9_7 = 0;
        this.curStatement = new StringBuffer(512);
        try {
            try {
                while (this.in.ready()) {
                    if (var7_5 > 0) {
                        if (var6_4) {
                            this.getSQL(null);
                            var8_6[var9_7++] = this.sql;
                            if (this.command != '}') continue;
                            var6_4 = false;
                            var9_7 = 0;
                            continue;
                        }
                        this.getSQL(var8_6[var9_7++]);
                        if (this.command == '}') {
                            var9_7 = 0;
                            --var7_5;
                            continue;
                        }
                    } else {
                        this.getSQL(null);
                        if (this.sql.length() == 0) break;
                    }
                    try {
                        this.sql = this.sql.substring(2);
                        this.sql = this.sql.trim();
                    }
                    catch (Exception v0) {
                        this.sql = "";
                    }
                    try {
                        var12_8 = new StringTokenizer(this.sql);
                        var13_12 = null;
                        var2_2 = System.currentTimeMillis();
                        block6 : switch (this.command) {
                            case 'c': {
                                if (this.sql.equalsIgnoreCase("autocommit on")) {
                                    this.con.setAutoCommit(true);
                                    System.out.println("Auto-commit is " + this.con.getAutoCommit());
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("autocommit off")) {
                                    this.con.setAutoCommit(false);
                                    System.out.println("Auto-commit is " + this.con.getAutoCommit());
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("break")) {
                                    System.out.println("Breakpoint reached");
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("batch mode")) {
                                    this.batchMode = true;
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("use global prepared statement")) {
                                    this.pstmt = SampleThread.globPrepStmnt;
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("cancel row updates")) {
                                    this.rs.cancelRowUpdates();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("create test object")) {
                                    this.test1 = new TestObject(1, "first test", null);
                                    this.test1 = new TestObject(2, "second test", this.test1);
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("delete row")) {
                                    this.rs.deleteRow();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("execute batch")) {
                                    if (this.stmt != null) {
                                        this.stmt.executeBatch();
                                    }
                                    if (this.pstmt != null) {
                                        this.pstmt.executeBatch();
                                    }
                                    this.batchMode = false;
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("export all")) {
                                    this.exportAll();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("import all")) {
                                    this.importAll();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("insert row")) {
                                    this.rs.insertRow();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("time")) {
                                    System.out.println("Last command took: " + var4_3);
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("set global prepared statement")) {
                                    SampleThread.globPrepStmnt = this.pstmt;
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("use global connection")) {
                                    this.con = SampleThread.globCon;
                                    this.stmt = this.con.createStatement();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("set global connection")) {
                                    SampleThread.globCon = this.con;
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("set isolation READ_UNCOMMITTED")) {
                                    this.con.setTransactionIsolation(1);
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("set isolation SERIALIZABLE")) {
                                    this.con.setTransactionIsolation(8);
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("update row")) {
                                    this.rs.updateRow();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("close")) {
                                    if (this.stmt != null) {
                                        this.stmt.close();
                                    }
                                    this.stmt = null;
                                    this.con.close();
                                    this.con = null;
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("rollback")) {
                                    this.con.rollback();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("commit")) {
                                    this.con.commit();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("show meta-data")) {
                                    this.rs = this.dma.getTypeInfo();
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    this.rs = this.dma.getTables("", "", "%", null);
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("system tables")) {
                                    var14_13 = new String[]{"SYSTEM TABLE"};
                                    this.rs = this.dma.getTables("", "", "%", (String[])var14_13);
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("ordinary tables")) {
                                    var14_13 = new String[]{"TABLE"};
                                    this.rs = this.dma.getTables("", "", "%", (String[])var14_13);
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("all tables")) {
                                    var14_13 = new String[]{"SYSTEM TABLE", "TABLE"};
                                    this.rs = this.dma.getTables("", "", "%", (String[])var14_13);
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("table types")) {
                                    this.rs = this.dma.getTableTypes();
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("toggle result set close")) {
                                    this.norsClose ^= true;
                                    if (this.norsClose) break;
                                    this.closers();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("toggle RSMD")) {
                                    this.rsmd ^= true;
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("wait for children")) {
                                    this.waitForChildren();
                                    break;
                                }
                                if (this.sql.equalsIgnoreCase("exit")) {
                                    System.exit(0);
                                    break;
                                }
                                var14_13 = var12_8.nextToken();
                                if (var14_13.equalsIgnoreCase("set")) {
                                    var15_14 = var12_8.nextToken();
                                    if (var15_14.equalsIgnoreCase("timeout")) {
                                        var16_15 = Integer.parseInt(var12_8.nextToken());
                                        this.stmt.setQueryTimeout(var16_15);
                                        break;
                                    }
                                    if (var15_14.equalsIgnoreCase("maxRows")) {
                                        var16_16 = Integer.parseInt(var12_8.nextToken());
                                        this.stmt.setMaxRows(var16_16);
                                        break;
                                    }
                                    System.out.println("Unknown set command: " + var15_14);
                                    break;
                                }
                                if (var14_13.equalsIgnoreCase("get")) {
                                    var15_14 = var12_8.nextToken();
                                    if (var15_14.equalsIgnoreCase("columns")) {
                                        var16_17 = var12_8.nextToken();
                                        var17_22 = var12_8.nextToken();
                                        this.rs = this.dma.getColumns("", "", var16_17, var17_22);
                                        SampleThread.dispResultSet(this.rs);
                                        this.rs.close();
                                        break;
                                    }
                                    if (var15_14.equalsIgnoreCase("imported_keys")) {
                                        var16_18 = var12_8.nextToken();
                                        this.rs = this.dma.getImportedKeys(null, null, var16_18);
                                        SampleThread.dispResultSet(this.rs);
                                        this.rs.close();
                                        break;
                                    }
                                    if (var15_14.equalsIgnoreCase("exported_keys")) {
                                        var16_19 = var12_8.nextToken();
                                        this.rs = this.dma.getExportedKeys(null, null, var16_19);
                                        SampleThread.dispResultSet(this.rs);
                                        this.rs.close();
                                        break;
                                    }
                                    if (var15_14.equalsIgnoreCase("crossReference")) {
                                        var16_20 = var12_8.nextToken();
                                        var17_22 = var12_8.nextToken();
                                        this.rs = this.dma.getCrossReference(null, null, var16_20, null, null, var17_22);
                                        SampleThread.dispResultSet(this.rs);
                                        this.rs.close();
                                        break;
                                    }
                                    System.out.println("Unknown get command: " + var15_14);
                                    break;
                                }
                                System.out.println("Unknown command: " + (String)var14_13);
                                break;
                            }
                            case 'd': {
                                Class.forName(this.sql).newInstance();
                                break;
                            }
                            case 'e': {
                                if (this.batchMode) {
                                    this.stmt.addBatch(this.sql);
                                    break;
                                }
                                this.stmt.executeUpdate(this.sql);
                                this.rs = this.stmt.getResultSet();
                                this.closers();
                                break;
                            }
                            case 'i': {
                                this.rs = this.dma.getIndexInfo(null, null, this.sql, false, false);
                                SampleThread.dispResultSet(this.rs);
                                this.rs = this.dma.getPrimaryKeys(null, null, this.sql);
                                SampleThread.dispResultSet(this.rs);
                                this.rs.close();
                                break;
                            }
                            case 'l': {
                                var14_13 = var12_8.nextToken();
                                var15_14 = var12_8.nextToken();
                                var16_21 = (idbConnection)this.con;
                                Trace.traceOut("Table: " + (String)var14_13 + ", column: " + var15_14 + ", value inserted=" + var16_21.getLastValueInserted((String)var14_13, var15_14));
                                break;
                            }
                            case 'm': {
                                var17_23 = var12_8.nextToken().charAt(0);
                                var18_24 = 0;
                                try {
                                    var13_12 = var12_8.nextToken();
                                    var18_24 = Integer.parseInt(var13_12);
                                }
                                catch (Exception v1) {}
                                var19_25 = false;
                                switch (var17_23) {
                                    case 'a': {
                                        var19_25 = this.rs.absolute(var18_24);
                                        break;
                                    }
                                    case 'r': {
                                        var19_25 = this.rs.relative(var18_24);
                                        break;
                                    }
                                    case 'n': {
                                        var19_25 = this.rs.next();
                                        break;
                                    }
                                    case 'p': {
                                        var19_25 = this.rs.previous();
                                        break;
                                    }
                                    case 'f': {
                                        var19_25 = this.rs.first();
                                        break;
                                    }
                                    case 'l': {
                                        var19_25 = this.rs.last();
                                        break;
                                    }
                                    case 'b': {
                                        this.rs.beforeFirst();
                                        break;
                                    }
                                    case 't': {
                                        this.rs.afterLast();
                                        break;
                                    }
                                    case 'i': {
                                        this.rs.moveToInsertRow();
                                        break;
                                    }
                                    case 'c': {
                                        this.rs.moveToCurrentRow();
                                        break;
                                    }
                                }
                                Trace.traceOut("result=" + var19_25 + " row=" + this.rs.getRow() + " beforeFirst=" + this.rs.isBeforeFirst() + " afterLast=" + this.rs.isAfterLast() + " first=" + this.rs.isFirst() + " last=" + this.rs.isLast());
                                Trace.traceOut(SampleThread.dispRow(this.rs));
                                break;
                            }
                            case 'o': {
                                var20_26 = var12_8.nextToken();
                                var21_27 = new Properties();
                                var22_28 = null;
                                var23_29 = null;
                                if (var12_8.hasMoreTokens()) {
                                    var22_28 = var12_8.nextToken();
                                }
                                if (var12_8.hasMoreTokens()) {
                                    var23_29 = var12_8.nextToken();
                                }
                                if (var22_28 == null) ** GOTO lbl298
                                if (var23_29 != null) {
                                    this.con = DriverManager.getConnection(var20_26, var22_28, var23_29);
                                } else {
                                    var24_30 = new FileInputStream(var22_28);
                                    var21_27.load((InputStream)var24_30);
                                    var24_30.close();
                                    this.con = DriverManager.getConnection(var20_26, var21_27);
                                }
                                ** GOTO lbl299
lbl298:
                                // 1 sources

                                this.con = DriverManager.getConnection(var20_26);
lbl299:
                                // 3 sources

                                this.dma = this.con.getMetaData();
                                System.out.println("\nConnected to " + this.dma.getURL());
                                System.out.println("Driver   " + this.dma.getDriverName());
                                System.out.println("Version  " + this.dma.getDriverVersion());
                                System.out.println("");
                                this.stmt = this.con.createStatement();
                                this.stmt.setQueryTimeout(300);
                                this.pstmt = null;
                                break;
                            }
                            case 'p': {
                                this.pstmt = this.con.prepareStatement(this.sql);
                                this.rs = this.pstmt.getResultSet();
                                this.closers();
                                break;
                            }
                            case 'q': {
                                this.rs = this.stmt.executeQuery(this.sql);
                                SampleThread.dispResultSet(this.rs);
                                this.closers();
                                break;
                            }
                            case 'r': {
                                var24_30 = var12_8.nextToken();
                                var7_5 = Integer.parseInt((String)var24_30);
                                var6_4 = true;
                                break;
                            }
                            case 's': {
                                var25_31 = new StringTokenizer(this.sql, ",;%", true);
                                var26_32 = 1;
                                while (true) {
                                    if (!var25_31.hasMoreTokens()) {
                                        if (!this.batchMode) break;
                                        this.pstmt.addBatch();
                                        break block6;
                                    }
                                    var13_12 = var25_31.nextToken();
                                    if (var13_12.equals(" ") || var13_12.equals(";") || var13_12.equals(",")) continue;
                                    if (var13_12.equals("%")) {
                                        var27_33 = var25_31.nextToken();
                                        var28_34 = var25_31.nextToken();
                                        var13_12 = var25_31.nextToken();
                                        if (var27_33.equalsIgnoreCase("binaryStream")) {
                                            var29_35 = new File(var13_12);
                                            var30_36 = (int)var29_35.length();
                                            var31_37 = new FileInputStream((File)var29_35);
                                            this.pstmt.setBinaryStream(var26_32++, (InputStream)var31_37, var30_36);
                                            continue;
                                        }
                                        if (var27_33.equalsIgnoreCase("asciiStream")) {
                                            var29_35 = new File(var13_12);
                                            var30_36 = (int)var29_35.length();
                                            var31_37 = new FileInputStream((File)var29_35);
                                            this.pstmt.setAsciiStream(var26_32++, (InputStream)var31_37, var30_36);
                                            continue;
                                        }
                                        if (var27_33.equalsIgnoreCase("timestamp")) {
                                            var29_35 = Timestamp.valueOf(var13_12);
                                            this.pstmt.setTimestamp(var26_32++, (Timestamp)var29_35);
                                            continue;
                                        }
                                        System.out.println("Unknown type specifier: " + (String)var27_33);
                                        continue;
                                    }
                                    var13_12 = var13_12.trim();
                                    this.pstmt.setString(var26_32++, var13_12);
                                }
                                this.pstmt.executeUpdate();
                                break;
                            }
                            case 't': {
                                var27_33 = new Thread(new SampleThread(this.sql));
                                var27_33.start();
                                this.childThreads.addElement(var27_33);
                                break;
                            }
                            case 'u': {
                                var28_34 = var12_8.nextToken();
                                var29_35 = var12_8.nextToken();
                                if (this.test1 != null) {
                                    this.rs.updateObject(var28_34, (Object)this.test1);
                                    this.test1 = null;
                                    break;
                                }
                                this.rs.updateString(var28_34, (String)var29_35);
                                break;
                            }
                            default: {
                                throw new Exception("Unknown command: " + this.command);
                            }
                        }
                        var4_3 = System.currentTimeMillis() - var2_2;
                    }
                    catch (Exception var12_9) {
                        var12_9.printStackTrace();
                    }
                }
                this.waitForChildren();
            }
            catch (Exception var12_10) {
                var12_10.printStackTrace();
            }
            var11_38 = null;
        }
        catch (Throwable var10_40) {
            var11_39 = null;
            try {
                this.in.close();
                throw var10_40;
            }
            catch (Exception var12_11) {
                var12_11.printStackTrace();
            }
            throw var10_40;
        }
        try {}
        catch (Exception var12_8) {
            var12_8.printStackTrace();
            return;
        }
        this.in.close();
    }

    void waitForChildren() throws InterruptedException {
        int n = 0;
        while (n < this.childThreads.size()) {
            Thread thread = (Thread)this.childThreads.elementAt(n);
            thread.join();
            ++n;
        }
    }
}

