/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb;

import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.enhydra.instantdb.RowEncrypt;
import org.enhydra.instantdb.jdbc.idbConnection;

class EncryptTest {
    static String[] createSQL = new String[]{"DROP TABLE clear", "DROP TABLE encrypted", "CREATE TABLE clear     (int1 INT PRIMARY KEY, char1 CHAR (10), text1 TEXT)", "CREATE TABLE encrypted (int1 INT PRIMARY KEY, char1 CHAR (10), text1 TEXT)"};
    static String[] querySQL = new String[]{"SELECT * FROM encrypted", "SELECT * FROM clear", "SELECT * FROM encrypted WHERE int1 > 6", "SELECT * FROM clear WHERE int1 > 6"};
    static idbConnection con;
    static Statement stmt;

    EncryptTest() {
    }

    private static void dispResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            if (n2 > 1) {
                System.out.print(",");
            }
            System.out.print(resultSetMetaData.getColumnLabel(n2));
            ++n2;
        }
        System.out.println("");
        while (resultSet.next()) {
            int n3 = 1;
            while (n3 <= n) {
                if (n3 > 1) {
                    System.out.print(",");
                }
                System.out.print(resultSet.getString(n3));
                ++n3;
            }
            System.out.println("");
        }
    }

    static void execSQLs(String[] stringArray) throws SQLException {
        int n = 0;
        while (n < stringArray.length) {
            stmt.execute(stringArray[n]);
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet != null) {
                EncryptTest.dispResultSet(resultSet);
                resultSet.close();
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            Class.forName("org.enhydra.instantdb.jdbc.idbDriver").newInstance();
            EncryptTest.openDatabase();
            EncryptTest.execSQLs(createSQL);
            RowEncrypt rowEncrypt = new RowEncrypt("myPassword");
            con.setTableEncryption("encrypted", rowEncrypt);
            EncryptTest.populateTable("clear", 10);
            EncryptTest.populateTable("encrypted", 10);
            stmt.execute("IMPORT encrypted FROM 'encrypted.txt' USING 'schema.ini'");
            stmt.execute("IMPORT clear FROM 'encrypted.txt'");
            EncryptTest.execSQLs(querySQL);
            EncryptTest.openDatabase();
            rowEncrypt = new RowEncrypt("wrongPassword");
            con.setTableEncryption("encrypted", rowEncrypt);
            try {
                EncryptTest.execSQLs(querySQL);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            EncryptTest.openDatabase();
            rowEncrypt = new RowEncrypt("myPassword");
            con.setTableEncryption("encrypted", rowEncrypt);
            EncryptTest.execSQLs(querySQL);
            stmt.close();
            con.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void openDatabase() throws SQLException {
        if (con != null) {
            stmt.close();
            con.close();
        }
        con = (idbConnection)DriverManager.getConnection("jdbc:idb:sample.prp");
        stmt = con.createStatement();
    }

    static void populateTable(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = con.prepareStatement("INSERT INTO ? VALUES (?, ?, ?)");
        preparedStatement.setString(1, string);
        int n2 = 0;
        while (n2 < n) {
            preparedStatement.setInt(2, n2);
            preparedStatement.setString(3, String.valueOf(n2));
            preparedStatement.setString(4, String.valueOf(n2));
            preparedStatement.execute();
            ++n2;
        }
        preparedStatement.close();
    }
}

