package org.opensi.webmanager.utils;

/**
 * 
 * <B>ImageStruct</B><br/> nom:String<br/> contenu:String (Binary64)<br/>
 * taille:int<br/>
 * 
 * 
 */
public class ImageStruct {
	// Constantes
	private final int NOM = 0;
	private final int CONTENU = 1;
	private final int TAILLE = 2;
	private final int NB_CHAMPS = 3;

	// Image
	Object[] image;

	/**
	 * 
	 * @param nom
	 */
	public ImageStruct(String nom) {
		image = new Object[NB_CHAMPS];
		image[NOM] = new String(nom);
	}

	/**
	 * 
	 * @param imageBrute
	 */
	public ImageStruct(Object[] imageBrute) {
		image = imageBrute;
	}

	/**
	 * 
	 * @param contenuB64
	 */
	public void setContenu(String contenuB64) {
		image[CONTENU] = new String(contenuB64);
	}

	/**
	 * 
	 * @param laTaille
	 */
	public void setTaille(int laTaille) {
		image[TAILLE] = new Integer(laTaille);
	}

	/* *********************************** */
	/* ************ GET ****************** */
	/* *********************************** */

	/**
	 * 
	 * @return
	 */
	public String getNom() {
		return "" + image[NOM];

	}

	/**
	 * 
	 * @return
	 */
	public String getContenu() {
		return "" + image[CONTENU];

	}

	/**
	 * 
	 * @return
	 */
	public int getTaille() {
		return Integer.parseInt("" + image[TAILLE]);

	}

	/**
	 * Retourne l'article sous forme de tableau d'Object pour tre transmis via
	 * SOAP
	 */
	public Object[] getImageStruct() {
		return image;
	}

}
