/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  mise  jour des prix 
 */

package org.opensi.webmanager.modifications;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.webmanager.utils.RedactionRapport;
import org.opensi.webmanager.utils.ToolsMAJ;

public class ListeRapports extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String site_id = r.getParameter("site_id");
		String dossierRoot = s.getAppConfiguration().get("opensi.absdir");
		String dossierId = r.getParameter("dossierId");
		String type_string = r.getParameter("type");

		int type_int = 0;
		if (type_string.equals("PRIX"))
			type_int = ToolsMAJ.TYPE_MAJ_PRIX;
		if (type_string.equals("STOCK"))
			type_int = ToolsMAJ.TYPE_MAJ_STOCKS;
		if (type_string.equals("INFO"))
			type_int = ToolsMAJ.TYPE_MAJ_INFO;
		if (type_string.equals("COM"))
			type_int = ToolsMAJ.TYPE_UPLOAD_COMMANDES;
		if (type_string.equals("CLI"))
			type_int = ToolsMAJ.TYPE_UPLOAD_CLIENTS;
		if (type_string.equals("ART"))
			type_int = ToolsMAJ.TYPE_MAJ_ARTICLES;
		if (type_string.equals("UPLOAD_ART"))
			type_int = ToolsMAJ.TYPE_UPLOAD_ART;

		String[] liste_string = RedactionRapport.listeLesRapports(type_int, dossierRoot, dossierId, site_id);

		String liste_reponse = "";

		if (liste_string != null) {
			for (int i = 0; i < liste_string.length; i++) {
				liste_reponse += "," + liste_string[i];
			}

		}

		r.addParameter("liste", liste_reponse);

		return true;

	}
}
