/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.webmanager.init_vente;

import java.io.File;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

/**
 * Rennomage des images quand changement de ref
 */
public class RenommerImage extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		String dossierRoot = s.getAppConfiguration().get("opensi.absdir");
		String dossierId = r.getParameter("dossierId");

		String old_ref = r.getParameter("old_ref");
		String new_ref = r.getParameter("new_ref");

		try {

			File imagePetiteOrigine = new File(dossierRoot + "/photos_articles/" + dossierId + "/" + old_ref + "_small.jpg");
			File imagePetiteNouvelle = new File(dossierRoot + "/photos_articles/" + dossierId + "/" + new_ref + "_small.jpg");

			if (imagePetiteOrigine.exists()) {
				imagePetiteOrigine.renameTo(imagePetiteNouvelle);
			}

			File imageGrandeOrigine = new File(dossierRoot + "/photos_articles/" + dossierId + "/" + old_ref + "_big.jpg");
			File imageGrandeNouvelle = new File(dossierRoot + "/photos_articles/" + dossierId + "/" + new_ref + "_big.jpg");

			if (imageGrandeOrigine.exists()) {
				imageGrandeOrigine.renameTo(imageGrandeNouvelle);
			}
		}
		catch (Exception e) {
			System.out.println("" + e);
		}

		return true;

	}

}
