/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Mise a jour des informations des articles  l'exception du prix, du stock et du on-line/off-line
 */

package org.opensi.webmanager.fonctions_periodiques;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;

import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.ArticleClientStruct;
import org.opensi.webmanager.utils.ClientStruct;
import org.opensi.webmanager.utils.ListeArticleClientStruct;
import org.opensi.webmanager.utils.MultiRapports;
import org.opensi.webmanager.utils.PersonneStruct;
import org.opensi.webmanager.utils.RedactionRapport;
import org.opensi.webmanager.utils.ToolsMAJ;

/**
 * Procdure de mise  jour des informations des articles (description...)
 */
public class MAJClients {

	private boolean appelServiceReussi;
	private boolean appelToutServiceReussi;
	private boolean noErreurRapport;
	Object[] rapport;
	String dateDebut;
	String dateFin;
	Vector<String> listeId;
	MultiRapports lesRapports;
	private int nbArticlesParEnvoi = 100;
	private int timeout;
	private int nbEchecs;
	private int nbArticles;
	int nbRapports;
	private File aEcrire;
	private String type;
	
	/**
	 * Prepare le lancement de la mise  jour.
	 * 
	 * @param nbArticles
	 *          nombre d'articles maximum par envoi
	 * @param timeoutService
	 *          temps de rponse maximum du web service
	 * @param lenbRapports
	 *          Nombre de rapports a conserver.
	 */
	public MAJClients(int nbArticles, int timeoutService, int lenbRapports,String fichier, String nomtype) {
		this(nbArticles,timeoutService,lenbRapports);
		aEcrire = new File(fichier);// le fichier de log
		this.type=nomtype;

	}
	public MAJClients(int nbArticles, int timeoutService, int lenbRapports) {
		aEcrire = new File("Lancer_Maintenant.log");// le fichier de log
		this.type="";
		appelServiceReussi = true;
		appelToutServiceReussi = true;
		noErreurRapport = true;
		lesRapports = new MultiRapports();
		nbRapports = (lenbRapports > 0)?lenbRapports:10;
		nbArticlesParEnvoi = (nbArticles > 0)?nbArticles:100;
		timeout = (timeoutService >= 0)?timeoutService:20000;
		nbEchecs = 0;
		AppelServices.setTimeout(Integer.valueOf(timeout));
	}
	/**
	 * Lance la mise  jour.
	 * 
	 * La mise  jour est faite en plusieurs tapes: On regarde si il y a des
	 * articles  mettre  jour, puis on cre la liste d'article a envoyer au
	 * serveur, si tout s'est bien pass, on enregistre dans OpenSi que les
	 * informations de ces articles sont maintenant  jour.
	 * 
	 * La connexion  la base de donne n'est ni ouverte ni ferme.
	 * 
	 * @param serveur
	 *          adresse du web service
	 * @param dossierRoot
	 *          chemin absolu vers le seveur de OpenSi (opensi-serveur)
	 * @param dossierId
	 *          identifiant du dossier
	 * @param con
	 *          Connexion  la base de donne
	 * @param base
	 *          Nom de la base de donne FACT_qquechose
	 * @param site_id
	 *          identifiant du site
	 * @return vrai si la mise  jour s'est bien passe, faux sinon.
	 */
	public boolean lancerMAJ(String serveur, String dossierRoot, String dossierId, Connection con, String base, String site_id) {
		java.util.Date date = new java.util.Date();
		Timestamp stamp = new Timestamp(date.getTime());
		dateDebut = "" + stamp;

		appelService(serveur, con, base, site_id);

		date = new java.util.Date();
		stamp = new Timestamp(date.getTime());
		dateFin = "" + stamp;

		try {

			String requete = "UPDATE " + base + ".MAJ_AUTO SET Derniere_Maj=" + date.getTime() + " WHERE Site_Id=" + site_id
					+ " AND Type_Maj='MAJCLI'";
			Statement state = con.createStatement();
			state.executeUpdate(requete);
		}
		catch (Exception e) {
			e.printStackTrace();
		}

		ecrireRapport(dossierRoot, dossierId, site_id);

		return appelToutServiceReussi;

	}

	/**
	 * Envoie les informations au web service
	 */
	private void appelService(String serveur, Connection con, String base, String site_id) {
		try {
			// On rcupre toutes les infos  du client a uploader
			String reqInfo = "";
			reqInfo += "SELECT cw.*, p.Nom_FR, coalesce(fc.Client_Id,'') as Client_Id,coalesce(Remise_Web,0) as Remise_Web, coalesce(fc.Code_Tarif,5) as Code_Tarif";
			reqInfo += " FROM PAYS p, " + base + ".CLIENT_WEB cw left join " + base + ".FICHE_CLIENT fc on cw.Client_Id=fc.Client_Id where UploadStatus=0 and Site_Id="+site_id;
			reqInfo += " and p.Code_Pays=cw.Code_Pays";

			Statement state = con.createStatement();
			System.out.println(reqInfo);
			ResultSet resInfo = state.executeQuery(reqInfo);
			System.out.println(reqInfo);

			Vector<Object> liste = new Vector<Object>();
			listeId = new Vector<String>();

			
			int compteur = 0;
			while (resInfo.next()) {
				ClientStruct clientTemp = new ClientStruct();
				PersonneStruct personneTemp = new PersonneStruct();
				clientTemp.setString(clientTemp.ID,resInfo.getString("Client_Site_Id"));
				clientTemp.setString(clientTemp.EMAIL,resInfo.getString("Email"));
				clientTemp.setString(clientTemp.TEL,resInfo.getString("Tel"));
				clientTemp.setString(clientTemp.FAX,resInfo.getString("Fax"));
				clientTemp.setString(clientTemp.PASS,resInfo.getString("Password"));
				clientTemp.setString(clientTemp.CLIENTID,resInfo.getString("Client_Id"));
				clientTemp.setString(clientTemp.REMISE_WEB,resInfo.getString("Remise_Web"));
				clientTemp.setString(clientTemp.ACTIF ,resInfo.getString("Actif"));
				personneTemp.setString(personneTemp.CIV, resInfo.getString("Civ"));
				personneTemp.setString(personneTemp.NOM, resInfo.getString("Nom"));
				personneTemp.setString(personneTemp.PRENOM, resInfo.getString("Prenom"));
				personneTemp.setString(personneTemp.ENTREPRISE, resInfo.getString("Entreprise"));
				personneTemp.setString(personneTemp.ADRESSE, resInfo.getString("Adresse_1"));
				personneTemp.setString(personneTemp.COMPADRESSE, resInfo.getString("Adresse_2"));
				personneTemp.setString(personneTemp.ADRESSE3, resInfo.getString("Adresse_3"));
				personneTemp.setString(personneTemp.CP, resInfo.getString("Code_Postal"));
				personneTemp.setString(personneTemp.VILLE, resInfo.getString("Ville"));
				personneTemp.setString(personneTemp.PAYS, resInfo.getString("Nom_FR"));
				
				clientTemp.setString(clientTemp.CLIENTID,resInfo.getString("Client_Id"));
				clientTemp.setString(clientTemp.TARIF,resInfo.getString("Code_Tarif"));
				
				clientTemp.setStruct(clientTemp.PERSONNE,personneTemp.getStruct());

				ListeArticleClientStruct listeArticleClient=new ListeArticleClientStruct();

				String listeaf = "SELECT * from " + base + ".CLIENT_ARTICLE where Client_Id='"+resInfo.getString("Client_Id")+"'";
				
				PreparedStatement psListeaf = con.prepareStatement(listeaf);
				ResultSet resultListeaf = psListeaf.executeQuery();
				while (resultListeaf.next()) {
					ArticleClientStruct article=new ArticleClientStruct();
					article.setString(article.REFERENCE,resultListeaf.getString("Article_Id"));
					article.setString(article.CLIENT,resultListeaf.getString("Client_Id"));
					article.setString(article.TARIF,resultListeaf.getString("Prix"));

					listeArticleClient.addClientArticle(article);
				}
				
				clientTemp.setStruct(clientTemp.LISTE_ARTICLE_CLIENT,listeArticleClient.getListeStruct());				

				liste.add(clientTemp.getStruct());
				listeId.add(resInfo.getString("Client_Web_Id"));

				// On envoi tout les nbArticlesParEnvoi articles
				if ((compteur % nbArticlesParEnvoi) == 0 && compteur > 0) {
					ToolsMAJ.ecrireLog(aEcrire,type,"[MAJClients(appelService)] Appel du service pour " + nbArticlesParEnvoi + " articles.");
					envoyerMaj(serveur, liste.toArray());

					appelToutServiceReussi &= appelServiceReussi;

					if (appelServiceReussi) {
						ToolsMAJ.ecrireLog(aEcrire,type,"[MAJClients(appelService)] Je valide ");
						validerDansOpenSi(con, base, site_id);
					}
					else {
						nbEchecs += nbArticlesParEnvoi;
					}

					liste = new Vector<Object>();
					listeId = new Vector<String>();// pour valider
				}
				compteur++;

			}

			nbArticles = compteur;

			// la fin de la liste
			if (nbArticles > 0) {
				ToolsMAJ.ecrireLog(aEcrire,type,"[MAJClients(appelService)] Appel du service pour " + nbArticlesParEnvoi + " articles.");
				envoyerMaj(serveur, liste.toArray());

				if (appelServiceReussi) {
					ToolsMAJ.ecrireLog(aEcrire,type,"[MAJClients(appelService)] Je valide ");
					validerDansOpenSi(con, base, site_id);
				}
				else {
					nbEchecs += nbArticlesParEnvoi;
				}
			}

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJClients(appelService)] ERREUR " + e);
		}

	}

	private void envoyerMaj(String serveur, Object[] liste) {

		appelServiceReussi = true;

		try {
			Object resultat = AppelServices.MAJClients(serveur, liste);
			Object[] rep = (Object[]) resultat;
			Object[] rapport = (Object[]) rep[0];
			lesRapports.addRapport(rapport);
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJClients(envoyerMaj)] ERREUR:" + e);
			appelServiceReussi = false;
		}

	}

	/*
	 * Ecris un rapport dans dossierRoot/rapport/dossierId
	 */

	private void ecrireRapport(String dossierRoot, String dossierId, String site_id) {

		try {
			RedactionRapport ecriveur = new RedactionRapport(ToolsMAJ.TYPE_MAJ_INFO, nbRapports, dossierRoot, dossierId, site_id);

			ecriveur.ajouterLigne(dateDebut + ":La mise a jour des dtails a t lance", true);
			if (nbArticles > 0) {
				if (!appelToutServiceReussi) {
					ecriveur.ajouterLigne("\nUne erreur s'est produite.", false);
				}

				String lesDetails = "";

				int cptErreur = 0;
				int cptOk = 0;

				while (lesRapports.next()) {
					if (lesRapports.aReussi()) {
						lesDetails += "\n<br>" + lesRapports.getMessageUtilisateur();
						cptOk++;
					}
					else {
						lesDetails += "\n<br><span class=\"echec\">" + lesRapports.getMessageUtilisateur() + "</span>";
						cptErreur++;
					}

					noErreurRapport = noErreurRapport && (lesRapports.aReussi());
				}

				if (noErreurRapport && nbEchecs == 0) {
					ecriveur.ajouterLigne(dateFin + ":Tous les dtails ont t mis a jour", true);
				}
				else {
					ecriveur.ajouterLigne(dateFin + ":" + nbEchecs + " articles n'ont pas t mis a jour sur " + nbArticles + ".", false);
					ecriveur.ajouterLigne(dateFin + ":Fin de la transmission.", true);
				}

				if (!lesDetails.equals("")) {
					ecriveur.ajouterLigne(" ****************** DETAILS **************", true);
					ecriveur.ajouterLigne(lesDetails, true);
				}
			}
			else {
				ecriveur.ajouterLigne("Pas d'articles a mettre  jour", true);
			}

			ecriveur.fermerFichier();

		}
		catch (java.io.IOException e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJClients(ecrireRapport)] ERREUR:" + e);
		}

	}

	/*
	 * Valide la mise  jour dans OpenSi: change la date de rfrence info par
	 * celle de l'article utilise prcedemment
	 */
	private void validerDansOpenSi(Connection con, String base, String site_id) {
		try {

			String listeId_str = "";

			if (listeId.size() > 0) {
				listeId_str += "'" + ToolsMAJ.sqlEncode(listeId.elementAt(0)) + "'";
			}

			for (int i = 1; i < listeId.size(); i++) {
				listeId_str += ",'" + ToolsMAJ.sqlEncode(listeId.elementAt(i)) + "'";
			}

			String req = "UPDATE " + base + ".CLIENT_WEB w SET UploadStatus=1 ";
			req += " WHERE Client_Web_Id IN(" + listeId_str + ") AND Site_Id=" + site_id;

			ToolsMAJ.ecrireLog(aEcrire,type,"La requete:" + req);

			Statement state = con.createStatement();
			state.executeUpdate(req);

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJClients(validerDansOpenSi)] ERREUR " + e);
			e.printStackTrace();
		}
	}
}
