/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Mise a jour des articles
 */

package org.opensi.webmanager.fonctions_periodiques;

import java.io.File;
import java.io.FileWriter;

import javax.imageio.stream.FileImageInputStream;

import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.MultiRapports;
import org.opensi.webmanager.utils.RedactionRapport;

/**
 * Procdure de mise  jour
 */
public class MAJ {

	protected boolean appelServiceReussi;
	protected boolean appelToutServiceReussi;
	protected boolean noErreurRapport;
	protected Object[] rapport;
	protected String dateDebut;
	protected String dateFin;
	protected int nbArticlesParEnvoi = 100;
	protected int timeout;
	protected int nbEchecs;
	protected int nbArticles;
	protected MultiRapports lesRapports;
	protected File aEcrire;
	protected FileWriter fichier;
	protected String type;

	protected int nbRapports;

	/**
	 * Procdure de mise  jour
	 * 
	 * Timeout:Le temps maximum d'attente d'une rponse de la part du webservice.
	 * Si il y a plus de nbRapport pour cette mise  jour, alors les plus vieux
	 * rapports sont effacs.
	 * 
	 * @param nbArticles
	 *          nombre objets maximum par envoi
	 * @param timeoutService
	 *          timeout en milisecondes
	 * @param lenbRapports
	 *          nombre de rapport  conserver
	 */
	protected MAJ(int nbArticles, int timeoutService, int lenbRapports,String fichier, String nomtype) {
		this(nbArticles,timeoutService,lenbRapports);
		aEcrire = new File(fichier);// le fichier de log
		this.type=nomtype;
	}
	protected MAJ(int nbArticles, int timeoutService, int lenbRapports) {
		aEcrire = new File("Lancer_Maintenant.log");// le fichier de log
		this.type="";
		appelServiceReussi = true;
		appelToutServiceReussi = true;
		noErreurRapport = true;
		lesRapports = new MultiRapports();

		nbRapports = (lenbRapports > 0)?lenbRapports:10;
		nbArticlesParEnvoi = (nbArticles > 0)?nbArticles:100;
		timeout = (timeoutService >= 0)?timeoutService:20000;
		nbEchecs = 0;
		AppelServices.setTimeout(Integer.valueOf(timeout));
	}


	protected void ecrireRapport(String dossierRoot, String dossierId, String site_id,String type,int typemaj) {
		try {
			RedactionRapport ecriveur = new RedactionRapport(typemaj, nbRapports, dossierRoot, dossierId, site_id);

			ecriveur.ajouterLigne(dateDebut + ":La mise a jour des "+type+" a t lance", true);
			if (nbArticles > 0) {
				if (!appelToutServiceReussi) {
					ecriveur.ajouterLigne("\nUne erreur s'est produite.", false);
				}

				String lesDetails = "";

				int cptErreur = 0;
				int cptOk = 0;

        while (lesRapports.next()) {
					if (lesRapports.aReussi()) {
						lesDetails += "\n<br>" + lesRapports.getMessageUtilisateur();
						cptOk++;
					}
					else {
						lesDetails += "\n<br><span class=\"echec\">" + lesRapports.getMessageUtilisateur() + "</span>";
						cptErreur++;
					}

					noErreurRapport = noErreurRapport && (lesRapports.aReussi());
				}

				if (noErreurRapport && nbEchecs == 0) {
					ecriveur.ajouterLigne(dateFin + ":Tous les "+type+" ont t mis a jour", true);
				}
				else {
					ecriveur.ajouterLigne(dateFin + ":" + nbEchecs + " "+type+" n'ont pas t mis a jour sur " + nbArticles + ".", false);
					ecriveur.ajouterLigne(dateFin + ":Fin de la transmission.", true);
				}

				if (!lesDetails.equals("")) {
					ecriveur.ajouterLigne(" ****************** DETAILS **************", true);
					ecriveur.ajouterLigne(lesDetails, true);
				}
			}
			else {
				ecriveur.ajouterLigne("Pas d'"+type+" a mettre  jour", true);
			}

			ecriveur.fermerFichier();

		}
		catch (java.io.IOException e) {
			e.printStackTrace();
		}

	}

	// **********************************
	// * IMAGE ARTICLE *
	// **********************************

	protected void publicationImage(String url_serveur, String dossierRoot, String nomDossier, String IdArticleOpenSi, String idArticle) {

		try {

			String adresseGrande = dossierRoot + "/photos_articles/" + nomDossier + "/" + IdArticleOpenSi + "_big.jpg";
			File fichierGrande = new File(adresseGrande);

			String adressePetite = dossierRoot + "/photos_articles/" + nomDossier + "/" + IdArticleOpenSi + "_small.jpg";
			File fichierPetite = new File(adressePetite);

			if (fichierGrande.exists() && fichierPetite.exists()) {
				// Lecture de la grande image
				FileImageInputStream grandeImageStream = new FileImageInputStream(fichierGrande);
				int taille_grande = (int) grandeImageStream.length();
				byte contenu_grandeImage[] = new byte[taille_grande];
				grandeImageStream.read(contenu_grandeImage, 0, taille_grande);

				// Lecture de la petite image
				FileImageInputStream petiteImageStream = new FileImageInputStream(fichierPetite);
				int taille_petite = (int) petiteImageStream.length();
				byte contenu_petiteImage[] = new byte[taille_petite];
				petiteImageStream.read(contenu_petiteImage, 0, taille_petite);

				String nom_petiteImage = IdArticleOpenSi + "_small.jpg";
				String nom_grandeImage = IdArticleOpenSi + "_big.jpg";

				AppelServices.envoyerImage(url_serveur, idArticle, taille_petite, contenu_petiteImage, nom_petiteImage,
						taille_grande, contenu_grandeImage, nom_grandeImage);
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}


	// *************************************
	// * IMAGE SOUS-FAMILLE *
	// *************************************
/*
	private void publicationImageSousFamille(String url_serveur, String dossierRoot, String nomDossier, String famille, String sousfamille,
			String nomImage) {

		try {

			String adresse = dossierRoot + "/photos_familles/" + nomDossier + "/" + famille + "/" + nomImage;

			File fichier = new File(adresse);

			if (fichier.exists()) {
				// Lecture de la grande image
				FileImageInputStream imageStream = new FileImageInputStream(fichier);
				int taille = (int) imageStream.length();
				byte contenu[] = new byte[taille];
				imageStream.read(contenu, 0, taille);

				Object result = AppelServices.envoyerImageSousFamille(url_serveur, famille, sousfamille, taille, contenu, nomImage);

				Object[] rep = (Object[]) result;

				Object[] rapport = (Object[]) rep[0];

				for (int i = 0; i < rapport.length; i++) {
					Object[] contenuRap = (Object[]) rapport[i];
					if (Integer.parseInt("" + contenuRap[0]) > 100) {
						// imagesSousFamilleReussie=false;
					}
				}

			}

		}

		catch (FileNotFoundException fnfe) {
			imagesSousFamilleReussie=false;
			fnfe.printStackTrace();
		}
		catch (IOException ioe) {
			imagesSousFamilleReussie=false;
			ioe.printStackTrace();
		}
		catch (Exception e) {
			imagesSousFamilleReussie=false;
			e.printStackTrace();
		}

	}

	// **********************************
	// * IMAGE MARQUE *
	// **********************************

	private void publicationImageMarque(String url_serveur, String dossierRoot, String nomDossier, String marque, String nomImage) {

		try {

			String adresse = dossierRoot + "/photos_marques/" + nomDossier + "/" + nomImage;
			File fichier = new File(adresse);

			if (fichier.exists()) {
				// Lecture de la grande image
				FileImageInputStream imageStream = new FileImageInputStream(fichier);
				int taille = (int) imageStream.length();
				byte contenu[] = new byte[taille];
				imageStream.read(contenu, 0, taille);

				Object result = AppelServices.envoyerImageMarque(url_serveur, marque, taille, contenu, nomImage);

				Object[] rep = (Object[]) result;

				Object[] rapport = (Object[]) rep[0];

				for (int i = 0; i < rapport.length; i++) {
					Object[] contenuRap = (Object[]) rapport[i];
					if (Integer.parseInt("" + contenuRap[0]) > 100) {
						// imagesMarqueReussie=false;
					}
				}

			}
		}
		catch (FileNotFoundException fnfe) {
			imagesMarqueReussie=false;
			fnfe.printStackTrace();

		}
		catch (IOException ioe) {
			imagesMarqueReussie=false;
			ioe.printStackTrace();
		}
		catch (Exception e) {
			imagesMarqueReussie=false;
			e.printStackTrace();
		}

	}

	// **********************************
	// * IMAGE FAMILLE *
	// **********************************

	private void publicationImageFamille(String url_serveur, String dossierRoot, String nomDossier, String famille, String nomImage) {

		try {

			String adresse = dossierRoot + "/photos_familles/" + nomDossier + "/" + nomImage;

			File fichier = new File(adresse);

			if (fichier.exists()) {
				// Lecture de la grande image
				FileImageInputStream imageStream = new FileImageInputStream(fichier);
				int taille = (int) imageStream.length();
				byte contenu[] = new byte[taille];
				imageStream.read(contenu, 0, taille);

				Object result = AppelServices.envoyerImageFamille(url_serveur, famille, taille, contenu, nomImage);

				Object[] rep = (Object[]) result;

				Object[] rapport = (Object[]) rep[0];

				for (int i = 0; i < rapport.length; i++) {
					Object[] contenuRap = (Object[]) rapport[i];
					if (Integer.parseInt("" + contenuRap[0]) > 100) {
						// imagesFamilleReussie=false;
					}
				}
			}

		}
		catch (Exception e) {
			imagesFamilleReussie=false;
			e.printStackTrace();
		}

	}
*/
}
