/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.openoffice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
* Permet de generer un tableau openoffice  partir de lignes de tableau
*
* Pour utiliser un style particulier pour une ou des cellules, il faut ajouter le style dans le crateurOpenOffice et le donner dans le constructeur de la cellule concerne.
* Il faut que tous les styles aient un nom diffrent pour qu'ils soient identifiables.Si vous ne savez pas quoi mettre, par convention Ooo mettez "ce2", "ce3", "ce4"....
*
* ATTENTION ne pas utiliser "ce1" car il est utilis pour le style par dfaut. 
*
* Un tableau Openoffice.org (ou Ooo) est constitu d'une liste de OooLignes ordonnes dans l'ordre ou elles sont ajoutes.
* Chaque OooLigne est constitu de OooCellules ordonnes dans l'ordre ou elles sont ajoute dans la OooLigne
*
**/

public class CreateurOpenOffice {

	private File contentXml;
	private File fichierOoo;
	
	private String chemin;
	
	private static final int BUFFER = 2048;
	private byte[] donnee = new byte[BUFFER];
	
	private Vector<OooLigne> listeLignes;
	private Vector<OooColonne> listeColonnes;
	
	private Vector<OooStyleColonne> stylesColonne;
	private Vector<OooStyleLigne> stylesLigne;
	private Vector<OooStyleCellule> stylesCellule;
	private Vector<OooStyleFeuille> stylesFeuille;

	/**
	 * Constructeur
	 * l'adresse est l'adresse des fichiers style.xml, meta.xml, mimetype et settings.xml et du futur content.xml et machin.sxc
	 * @param adresse adresse  laquelle se trouvent les fichiers necessires  la cration du document openoffice.
	 */
	public CreateurOpenOffice(String adresse)	{
		
		listeLignes = new Vector<OooLigne>();
		listeColonnes = new Vector<OooColonne>();
		
		chemin = adresse+"/";
		
		//Styles par dfaut
		stylesColonne = new Vector<OooStyleColonne>();
		stylesLigne = new Vector<OooStyleLigne>();
		stylesCellule = new Vector<OooStyleCellule>();
		stylesFeuille = new Vector<OooStyleFeuille>();
		
		stylesColonne.addElement(new OooStyleColonne("co1"));
		stylesLigne.addElement(new OooStyleLigne("ro1"));
		stylesCellule.addElement(new OooStyleCellule("ce1"));
		stylesFeuille.addElement(new OooStyleFeuille("ta1"));
	}
	

	public OooStyleCellule getStyleCelluleParDefaut()	{
		return stylesCellule.elementAt(0);
	}
	
	public OooStyleColonne getStyleColonneParDefaut()	{
		return stylesColonne.elementAt(0);
	}
	
	public OooStyleFeuille getStyleFeuilleParDefaut()	{
		return stylesFeuille.elementAt(0);
	}
	
	public OooStyleLigne getStyleLigneParDefaut()	{
		return stylesLigne.elementAt(0);
	}
	
	
	public OooStyleCellule creerNewStyleCellule()	{
		int increment = stylesCellule.size()+1;
		String nomStyle = "ce"+ increment;
		
		OooStyleCellule truc = new OooStyleCellule(nomStyle);
		
		stylesCellule.addElement(truc);
		
		return truc;
	}
	
	
	public OooStyleColonne creerNewStyleColonne()	{
	
		int increment = stylesColonne.size()+1;
		String nomStyle = "co"+ increment;
		
		OooStyleColonne truc = new OooStyleColonne(nomStyle);
		
		stylesColonne.addElement(truc);
		
		return truc;
	}
	

	
	
	
	/* GESTION DU TABLEAU */
	/**
	 * Ajoute une ligne au tableau. Les lignes doivent etre ajoutes dans l'ordre du haut vers le bas.
	 * @param ligne la ligne a ajouter
	 */
	public void ajouterLigne(OooLigne ligne) {

	//vrif sur les colonnes
	
		if (ligne.getNbCellules()>listeColonnes.size()) {
			
			for (int u=listeColonnes.size(); u<ligne.getNbCellules();u++)	{
				listeColonnes.addElement(new OooColonne(getStyleColonneParDefaut()));
			}
		}
		listeLignes.addElement(ligne);
	}
	
	
	
	public void changerLargeurColonne(int index, float taille) {
		
		if (index<listeColonnes.size()) {
			OooStyleColonne styleColonne=creerNewStyleColonne();
			styleColonne.setLargeur(taille);
			
			OooColonne col = new OooColonne(styleColonne);
			
			listeColonnes.removeElementAt(index);
			listeColonnes.insertElementAt(col,index);
		}
	}

	/*GENERATION DU DOCUMENT */
	
	/**
	 * Genre le document calc de nom celui donn en paramtre.
	 * L'objet File retourn peut etre utilis pour faire fichier.deleteOnExit() par exemple.
	 * @param nom nom du fichier openoffice, sans extension
	 * @return La rfrence sur l'objet File du ficher
	 */
	public File genererDocument(String nom)	{
		try {
			
			contentXml=new File(chemin+ File.separatorChar+"content.xml");//FileNotFound
			//contentXml.deleteOnExit();
			FileOutputStream content=new FileOutputStream(contentXml);//FileNotFound
			DataOutputStream donnee=new DataOutputStream(content);
			EcrireEnteteContent(donnee);
			EcrireCorpsContent(donnee);
			EcrireFinContent(donnee);
			donnee.close();
			content.close();
			
			zipperTout(nom +".sxc");
			
		}
		catch (Exception e)	{
			System.out.println("erreur dans [creerContent] -2- \n");
			System.out.println("[creerContent] ERREUR qquepart...\n");
			System.out.println("StackTrace:"+e.toString()+"\n");
		}
		
		return contentXml;		
	}
	
	
	private void EcrireEnteteContent(DataOutputStream flux)	{
		try	{
			
			flux.writeBytes("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");//IO
			flux.writeBytes("<!DOCTYPE office:document-content PUBLIC \"-//OpenOffice.org//DTD OfficeDocument 1.0//EN\" \"office.dtd\">");
			flux.writeBytes("<office:document-content xmlns:office=\"http://openoffice.org/2000/office\"");

			flux.writeBytes(" xmlns:style=\"http://openoffice.org/2000/style\"");
			flux.writeBytes(" xmlns:text=\"http://openoffice.org/2000/text\"");
			flux.writeBytes(" xmlns:table=\"http://openoffice.org/2000/table\"");
			flux.writeBytes(" xmlns:draw=\"http://openoffice.org/2000/drawing\"");
			flux.writeBytes(" xmlns:fo=\"http://www.w3.org/1999/XSL/Format\"");
			flux.writeBytes(" xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
			flux.writeBytes(" xmlns:number=\"http://openoffice.org/2000/datastyle\"");
			flux.writeBytes(" xmlns:svg=\"http://www.w3.org/2000/svg\"");
			flux.writeBytes(" xmlns:chart=\"http://openoffice.org/2000/chart\"");
			flux.writeBytes(" xmlns:dr3d=\"http://openoffice.org/2000/dr3d\"");
			flux.writeBytes(" xmlns:math=\"http://www.w3.org/1998/Math/MathML\"");
			flux.writeBytes(" xmlns:form=\"http://openoffice.org/2000/form\"");
			flux.writeBytes(" xmlns:script=\"http://openoffice.org/2000/script\"");
			flux.writeBytes(" office:class=\"spreadsheet\" office:version=\"1.0\">"); 
	
			flux.writeBytes("<office:script/>"); 
			flux.writeBytes("<office:font-decls>"); 
			flux.writeBytes("<style:font-decl style:name=\"Bitstream Vera Sans1\" fo:font-family=\"&apos;Bitstream Vera Sans&apos;\" style:font-pitch=\"variable\"/> ");
			flux.writeBytes("<style:font-decl style:name=\"Tahoma\" fo:font-family=\"Tahoma, Lucidasans, &apos;Lucida Sans&apos;, &apos;Arial Unicode MS&apos;\" style:font-pitch=\"variable\"/>"); 
			flux.writeBytes("<style:font-decl style:name=\"Bitstream Vera Sans\" fo:font-family=\"&apos;Bitstream Vera Sans&apos;\" style:font-family-generic=\"swiss\" style:font-pitch=\"variable\"/>"); 
			flux.writeBytes("</office:font-decls> ");
			
			flux.writeBytes("<office:automatic-styles>"); 
	
			for(int a=0; a<stylesColonne.size();a++) {
				flux.writeBytes(stylesColonne.elementAt(a).toStringOoo());
			}
			
			for(int a=0; a<stylesLigne.size();a++) {
				flux.writeBytes(stylesLigne.elementAt(a).toStringOoo());
			}
			
			for(int a=0; a<stylesFeuille.size();a++) {
				flux.writeBytes(stylesFeuille.elementAt(a).toStringOoo());
			}
			
			
			//Pour le format des nombre
				flux.writeBytes("<number:number-style style:name=\"N3\" style:family=\"data-style\">");
				flux.writeBytes("<number:number number:decimal-places=\"0\" number:min-integer-digits=\"1\" number:grouping=\"true\"/>");
				flux.writeBytes("</number:number-style>");
				
				flux.writeBytes("<number:number-style style:name=\"N5\" style:family=\"data-style\">");
				flux.writeBytes("<number:number number:decimal-places=\"2\" number:min-integer-digits=\"1\" number:grouping=\"true\"/>");
				flux.writeBytes("</number:number-style>");
			
			for(int a=0; a<stylesCellule.size();a++) {
				flux.writeBytes(stylesCellule.elementAt(a).toStringOoo());
			}
			
			flux.writeBytes("</office:automatic-styles>");			
			flux.writeBytes("<office:body>");
			
			
		}
		catch(IOException e) {
			System.out.println("erreur dans [EcrireEnteteContent] -2- \n");
			System.out.println("[EcrireEnteteContent] ERREUR lors de l'criture de l'entete du content \n");
			System.out.println("StackTrace:"+e.toString()+"\n");
		}
		
	
	}
	
	private void EcrireCorpsContent(DataOutputStream flux) {
		try	{
			
			flux.writeBytes("<table:table table:name=\"Feuille1\" table:style-name=\"ta1\">");
			
			for (int p=0; p<listeColonnes.size();p++)	{
				flux.writeBytes(listeColonnes.elementAt(p).toStringOoo());
			}
			
			for (int p=0; p<listeLignes.size();p++)	{
				//une ligne par boucle
				flux.writeBytes(listeLignes.elementAt(p).toStringOoo());
			}			
			flux.writeBytes("</table:table>");
			
			flux.writeBytes("<table:table table:name=\"Feuille2\" table:style-name=\"ta1\">"); 
			flux.writeBytes("<table:table-column table:style-name=\"co1\" table:default-cell-style-name=\"Default\"/>"); 
			flux.writeBytes("<table:table-row table:style-name=\"ro1\">");
			flux.writeBytes("<table:table-cell/>");
			flux.writeBytes("</table:table-row>");
			flux.writeBytes("</table:table>");
			flux.writeBytes("<table:table table:name=\"Feuille3\" table:style-name=\"ta1\">"); 
			flux.writeBytes("<table:table-column table:style-name=\"co1\" table:default-cell-style-name=\"Default\"/>"); 
			flux.writeBytes("<table:table-row table:style-name=\"ro1\">");
			flux.writeBytes("<table:table-cell/>");
			flux.writeBytes("</table:table-row>");
			flux.writeBytes("</table:table>");
		}
		catch(Exception e) {
			System.out.println("erreur dans [EcrireCorpsContent] \n");
			System.out.println("[EcrireCorpsContent] ERREUR dans l'ecriture du corps de content \n");
			System.out.println("StackTrace:"+e.toString()+"\n");
		}
	}
	
	private void EcrireFinContent(DataOutputStream flux) {
		try	{
			flux.writeBytes("</office:body>");
			flux.writeBytes("</office:document-content>");
		}
		catch(Exception e) {
			System.out.println("erreur dans [EcrireCorpsContent] \n");
			System.out.println("[EcrireCorpsContent] ERREUR dans l'ecriture de la fin de content \n");
			System.out.println("StackTrace:"+e.toString()+"\n");			
		}
	}
	
	/**
	* Zippe tous les fichier pour crer le fichier .sxc 
	**/
	private void zipperTout(String nomFichier) {
		try	{
			
			fichierOoo=new File(chemin+nomFichier);
			FileOutputStream fichierSortie =new FileOutputStream(fichierOoo);//FileNotFound
			BufferedOutputStream bufferSortie=new BufferedOutputStream(fichierSortie);
			ZipOutputStream zipSortie=new ZipOutputStream(bufferSortie);
			zipSortie.setMethod(ZipOutputStream.DEFLATED);
			zipSortie.setLevel(9);
			
			zipperFichier(chemin,"settings.xml",zipSortie);
			zipperFichier(chemin,"styles.xml",zipSortie);
			zipperFichier(chemin,"meta.xml",zipSortie);
			zipperFichier(chemin,"content.xml",zipSortie);
			zipperFichier(chemin,"mimetype",zipSortie);			
			zipSortie.close();//IO			
		}		
		catch (FileNotFoundException e)	{
			System.out.println("erreur dans [zipperTout] \n");
			System.out.println("[zipperTout] ERREUR fichier non trouv \n");
			System.out.println("StackTrace:"+e.toString()+"\n");
		}
		catch (IOException e) {
			System.out.println("erreur dans [zipperTout] \n");
			System.out.println("[zipperTout] ERREUR d'entre sortie \n");
			System.out.println("StackTrace:"+e.toString()+"\n");
		}	
	}
	
	private void zipperFichier(String cheminFichier, String nomFichier, ZipOutputStream sortieZip) {		
		try	{
			
			String path=cheminFichier+nomFichier;
			FileInputStream fichierAZipper=new FileInputStream(path);//FileNotFound
			BufferedInputStream bufferEntree=new BufferedInputStream(fichierAZipper,BUFFER);
			ZipEntry entreeZip=new ZipEntry(nomFichier);
			sortieZip.putNextEntry(entreeZip);
			int count;
			while((count=bufferEntree.read(donnee, 0, BUFFER))!=-1)	{
				sortieZip.write(donnee, 0, count);
			}
			sortieZip.closeEntry();
			bufferEntree.close();			
		}
		catch (FileNotFoundException e)	{
			System.out.println("erreur dans [zipperFichier] \n");
			System.out.println("[zipperFichier] ERREUR fichier non trouv \n");
			System.out.println("StackTrace:"+e.toString()+"\n");
		}
		catch (IOException e)	{
			System.out.println("erreur dans [zipperFichier] \n");
			System.out.println("[zipperFichier] ERREUR d'entre sortie \n");
			System.out.println("StackTrace:"+e.toString()+"\n");
		}
	}
}
