/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une facture standard
 */

package org.opensi.util.calcul;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.sql.SQLException;


import org.experlog.openeas.api.Session;
import org.opensi.api.SessionOSI;

public class Calcul {

	private CalculDocument cd;
	private String base;
	private String req;
	private String reqArticles;
	private String typeDocument;
	private Session s;
	private int documentId;
	private Connection con;
	private Iterator<Integer> la;
	private LigneDocument cv;
	private PreparedStatement psUpLignesFacture;
	private PreparedStatement psUpLignesAvoir;
	private PreparedStatement psUpLignesCommande;
	private PreparedStatement psUpLignesDevis;
	private PreparedStatement psUpLignesFactureFournisseur;
	private PreparedStatement psUpLignesAvoirFournisseur;
	private PreparedStatement psUpLignesCommandeFournisseur;
	private PreparedStatement psUpLignesProforma;
	private PreparedStatement psUpLignesBonLivraison;
	private PreparedStatement psUpLignesBonReception;
	private PreparedStatement psUpLignesBonRetour;



	public Calcul(String s_, int id,String type) {
		try {
			this.typeDocument= type;
			this.documentId= id;
			this.s = Session.findClient(s_);
			con = s.getConnection(null);
			base = s.getCookie().get("BaseDossier");
			init();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public Calcul(Session s, int id,String type) {
		try {
			base = s.getCookie().get("BaseDossier");
			this.typeDocument= type;
			this.documentId= id;
			this.s= s;
			con = s.getConnection(null);
			init();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}


	public Calcul(Connection con, int id,String type, String dossierId) {
		this.base= "FACT_"+dossierId;
		this.typeDocument= type;
		this.documentId= id;
		this.con= con;
		init();
	}


	public Calcul(SessionOSI sosi) {
		try {

			this.base = sosi.getBaseDossier();
			this.con = sosi.getConnection();

		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public Calcul(SessionOSI sosi, int id, String type) {
		try {
			this.typeDocument = type;
			this.documentId = id;
			this.base = sosi.getBaseDossier();
			this.con = sosi.getConnection();
			init();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public Calcul(Connection con, String base) {
		try {

			this.base = base;
			this.con = con;

		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	
	public void setDocument(int id, String type) {

		this.typeDocument= type;
		this.documentId= id;
		init();
	}


	public void init() {
		try {

			Statement stt = con.createStatement();
			Statement stt2 = con.createStatement();

			ResultSet rset;
			ResultSet rsetArticles;

			if (typeDocument.equals("Facture")) {
				req = "select f.*, (select coalesce(sum(iafc.Montant),0) as Acompte from "+ base +".IMPUTATION_ACOMPTE_FACTURE_CLIENT iafc join "+ base +".ACOMPTE_CLIENT ac on ac.Acompte_Id=iafc.Acompte_Id where Statut='V' and iafc.Facture_Id="+documentId+" group by iafc.Facture_Id) as Acompte from "+ base +".FACTURE f where f.Facture_Id="+ documentId;
				reqArticles = "select * from "+ base +".LIGNE_FACTURE where Facture_Id="+ documentId;
				psUpLignesFacture = con.prepareStatement("update "+ base +".LIGNE_FACTURE set Montant_Ligne=?, Marge_Ligne=? where Facture_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Avoir")) {
				req = "select *,0 as Acompte  from "+ base +".AVOIR where Avoir_Id="+ documentId;
				reqArticles = "select * from "+ base +".LIGNE_AVOIR where Avoir_Id="+ documentId;
				psUpLignesAvoir = con.prepareStatement("update "+ base +".LIGNE_AVOIR set Montant_Ligne=?, Marge_Ligne=? where Avoir_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Commande")) {
				req = "select cc.*, coalesce(sum(ac.Total_TTC),0) as Acompte from "+ base +".COMMANDE_CLIENT cc left join "+ base +".ACOMPTE_CLIENT ac on cc.Commande_Id=ac.Commande_Id and ac.Statut='V' where cc.Commande_Id="+ documentId+" group by cc.Commande_Id";
				reqArticles = "select *, Prix_Unitaire as Prix from "+ base +".LIGNE_COMMANDE_CLIENT where Statut='V' and Commande_Id="+ documentId;
				psUpLignesCommande = con.prepareStatement("update "+ base +".LIGNE_COMMANDE_CLIENT set Montant_Ligne=?, Marge_Ligne=? where Commande_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Devis")) {
				req = "select *,0 as Acompte from "+ base +".DEVIS where Devis_Id="+ documentId;
				reqArticles = "select *,0 as Prix_Achat from "+ base +".LIGNE_DEVIS where Devis_Id="+ documentId;
				psUpLignesDevis = con.prepareStatement("update "+ base +".LIGNE_DEVIS set Montant_Ligne=? where Devis_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Bon_Livraison")) {
				req = "select c.Vers_Calc, Escompte,Remise,Montant_Remise, 0 as Frais_Port,0 as Taux_Tva_Port, Code_TVA_Port,Edition_TTC, MRemise_FP, PRemise_FP,0 as Acompte from "+ base +".BON_LIVRAISON bl join "+ base +".COMMANDE_CLIENT c on c.Commande_Id=bl.Commande_Id where Bon_Id="+ documentId;
				reqArticles = "select lbl.Ligne_Id, lcc.Commission, lbl.Quantite,lcc.Prix_Unitaire as Prix, lcc.Ristourne, lcc.Code_TVA, lcc.Taux_TVA,0 as Prix_Achat from "+ base +".LIGNE_BON_LIVRAISON lbl join "+ base +".LIGNE_COMMANDE_CLIENT lcc on lbl.Ref_Ligne=lcc.Ligne_Id and lcc.Statut='V' and lbl.Statut='V' where Bon_Id="+ documentId;
				psUpLignesBonLivraison = con.prepareStatement("update "+ base +".LIGNE_BON_LIVRAISON set Montant_Ligne=? where Bon_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Bon_Retour")) {
				req = "select c.Vers_Calc, Escompte,Remise,Montant_Remise, 0 as Frais_Port,0 as Taux_Tva_Port, Code_TVA_Port,Edition_TTC, MRemise_FP, PRemise_FP,0 as Acompte from "+ base +".BON_RETOUR_CLIENT br join "+ base +".BON_LIVRAISON bl on br.BL_Id=bl.Bon_Id join "+ base +".COMMANDE_CLIENT c on c.Commande_Id=bl.Commande_Id where br.Bon_Id="+ documentId;
				reqArticles = "select lbr.Ligne_Id, lcc.Commission, lbr.Quantite,lcc.Prix_Unitaire as Prix, lcc.Ristourne, lcc.Code_TVA, lcc.Taux_TVA,0 as Prix_Achat from "+ base +".LIGNE_BON_RETOUR_CLIENT lbr join "+ base +".LIGNE_BON_LIVRAISON lbl on lbr.Ligne_BL=lbl.Ligne_Id and lbl.Statut='V' join "+ base +".LIGNE_COMMANDE_CLIENT lcc on lbl.Ref_Ligne=lcc.Ligne_Id and lcc.Statut='V' where lbr.Bon_Id="+ documentId;
				psUpLignesBonRetour = con.prepareStatement("update "+ base +".LIGNE_BON_RETOUR_CLIENT set Montant_Ligne=? where Bon_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Proforma")) {
				req = "select Vers_Calc,0 as Acompte,Escompte,Remise,0 as Montant_Remise, Frais_Port,Taux_Tva_Port, Code_TVA_Port,Edition_TTC, 0 as MRemise_FP, PRemise_FP,0 as Acompte from "+ base +".PROFORMA where Proforma_Id="+ documentId;
				reqArticles = "select *,0 as Prix_Achat from "+ base +".LIGNE_PROFORMA where Proforma_Id="+ documentId;
				psUpLignesProforma = con.prepareStatement("update "+ base +".LIGNE_PROFORMA set Montant_Ligne=? where Proforma_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Commande_Fournisseur")) {
				req = "select *, 0 as Edition_TTC,0 as Montant_Remise, 0 as MRemise_FP,0 as PRemise_FP,0 as Taux_TVA_Port, 0 as Code_TVA_Port,0 as Acompte from "+ base +".COMMANDE_FOURNISSEUR where Commande_Id="+ documentId;
				reqArticles = "select *, 0 as Commission,0 as Prix_Achat from "+ base +".LIGNE_COMMANDE_FOURNISSEUR where Commande_Id="+ documentId;
				psUpLignesCommandeFournisseur = con.prepareStatement("update "+ base +".LIGNE_COMMANDE_FOURNISSEUR set Montant_Ligne=? where Commande_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Bon_Reception")) {
				req = "select c.*, 0 as Edition_TTC,0 as Montant_Remise, 0 as MRemise_FP,0 as PRemise_FP,0 as Taux_TVA_Port, 0 as Code_TVA_Port,0 as Acompte from "+ base +".BON_RECEPTION br join "+ base +".COMMANDE_FOURNISSEUR c on c.Commande_Id=br.Commande_Id where BR_Id="+ documentId;
				reqArticles = "select lbr.Ligne_Id, 0 as Commission, lbr.Quantite,lcc.Prix, lcc.Ristourne, lcc.Code_TVA, lcc.Taux_TVA,0 as Prix_Achat from "+ base +".LIGNE_BON_RECEPTION lbr join "+ base +".LIGNE_COMMANDE_FOURNISSEUR lcc on lbr.Ref_Ligne=lcc.Ligne_Id where BR_Id="+ documentId;
				psUpLignesBonReception = con.prepareStatement("update "+ base +".LIGNE_BON_RECEPTION set Montant_Ligne=? where BR_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Facture_Fournisseur")) {
				req = "select *, 0 as Edition_TTC,0 as Montant_Remise,0 as MRemise_FP,0 as PRemise_FP,0 as Acompte from "+ base +".FACTURE_FOURNISSEUR where Facture_Id="+ documentId;
				reqArticles = "select *, 0 as Commission,0 as Prix_Achat from "+ base +".LIGNE_FACTURE_FOURNISSEUR where Facture_Id="+ documentId;
				psUpLignesFactureFournisseur = con.prepareStatement("update "+ base +".LIGNE_FACTURE_FOURNISSEUR set Montant_Ligne=? where Facture_Id=? and Ligne_Id=?");
			}
			else if (typeDocument.equals("Avoir_Fournisseur")) {
				req = "select *, 0 as Edition_TTC,0 as Montant_Remise,0 as MRemise_FP,0 as PRemise_FP,0 as Acompte from "+ base +".AVOIR_FOURNISSEUR where Avoir_Id="+ documentId;
				reqArticles = "select *, 0 as Commission,0 as Prix_Achat from "+ base +".LIGNE_AVOIR_FOURNISSEUR where Avoir_Id="+ documentId;
				psUpLignesAvoirFournisseur = con.prepareStatement("update "+ base +".LIGNE_AVOIR_FOURNISSEUR set Montant_Ligne=? where Avoir_Id=? and Ligne_Id=?");
			}

			rset = stt.executeQuery(req);
			rsetArticles = stt2.executeQuery(reqArticles);

			if (rset.next()) {
				if (rset.getInt("Vers_Calc")==1) {
					cd = new CalculDocumentV1(rset.getDouble("Acompte"),rset.getDouble("Escompte"), rset.getDouble("Remise"), rset.getDouble("Frais_Port"), rset.getDouble("Taux_Tva_Port"), rset.getInt("Code_Tva_Port"),rset.getDouble("Montant_Remise"),rset.getInt("Edition_TTC")==1,rset.getDouble("PRemise_FP"),rset.getDouble("MRemise_FP"));
				}
				else { // V2 par dfaut
					cd = new CalculDocumentV2(rset.getDouble("Acompte"),rset.getDouble("Escompte"), rset.getDouble("Remise"), rset.getDouble("Frais_Port"), rset.getDouble("Taux_Tva_Port"), rset.getInt("Code_Tva_Port"),rset.getDouble("Montant_Remise"),rset.getInt("Edition_TTC")==1,rset.getDouble("PRemise_FP"),rset.getDouble("MRemise_FP"));
				}

				while (rsetArticles.next()) {
					cd.addLigne(rsetArticles.getInt("Ligne_Id"),rsetArticles.getDouble("Quantite"), rsetArticles.getDouble("Prix"), rsetArticles.getDouble("Ristourne"),rsetArticles.getInt("Code_TVA"), rsetArticles.getDouble("Taux_TVA"),rsetArticles.getDouble("Commission"),rsetArticles.getDouble("Prix_Achat"));
				}
				cd.calculTotaux();
			}
			stt.close();
			stt2.close();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public void majTotaux() {
		try {
			Statement stt = con.createStatement();

			double totalHT = getTotalHTTable();
			double totalTVA = getTotalTVA();
			double totalTTC = getTotalTTCTable();

			if (typeDocument.equals("Facture")) {
				req = "update "+ base +".FACTURE set Total_HT="+ totalHT +", Total_TVA="+totalTVA+", Total_TTC = "+ totalTTC +", Marge_HT=" + getMMargeHT()+ " where Facture_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesFacture.setDouble(1,cv.mQuantifieLigne);
					psUpLignesFacture.setDouble(2,cv.getMontantMarge());
					psUpLignesFacture.setInt(3,documentId);
					psUpLignesFacture.setInt(4,ligneId);
					psUpLignesFacture.executeUpdate();
				}
				psUpLignesFacture.close();
			}
			else if (typeDocument.equals("Avoir")) {
				req = "update "+ base +".AVOIR set Total_HT="+ totalHT +", Total_TVA="+totalTVA+", Total_TTC = "+ totalTTC +", Marge_HT=" + getMMargeHT()+ " where Avoir_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesAvoir.setDouble(1,cv.mQuantifieLigne);
					psUpLignesAvoir.setDouble(2,cv.getMontantMarge());
					psUpLignesAvoir.setInt(3,documentId);
					psUpLignesAvoir.setInt(4,ligneId);
					psUpLignesAvoir.executeUpdate();
				}
				psUpLignesAvoir.close();
			}
			else if (typeDocument.equals("Commande")) {
				req = "update "+ base +".COMMANDE_CLIENT set Total_HT="+ totalHT +", Total_TTC = "+ totalTTC +", Marge_HT=" + getMMargeHT()+ " where Commande_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesCommande.setDouble(1,cv.mQuantifieLigne);
					psUpLignesCommande.setDouble(2,cv.getMontantMarge());
					psUpLignesCommande.setInt(3,documentId);
					psUpLignesCommande.setInt(4,ligneId);
					psUpLignesCommande.executeUpdate();
				}
				psUpLignesCommande.close();
			}
			else if (typeDocument.equals("Devis")) {
				req = "update "+ base +".DEVIS set Total_HT="+ totalHT +", Total_TTC = "+ totalTTC +" where Devis_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesDevis.setDouble(1,cv.mQuantifieLigne);
					psUpLignesDevis.setInt(2,documentId);
					psUpLignesDevis.setInt(3,ligneId);
					psUpLignesDevis.executeUpdate();
				}
				psUpLignesDevis.close();
			}
			else if (typeDocument.equals("Bon_Livraison")) {
				req = "update "+ base +".BON_LIVRAISON set Total_HT="+ totalHT +", Total_TTC = "+ totalTTC +" where Bon_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesBonLivraison.setDouble(1,cv.mQuantifieLigne);
					psUpLignesBonLivraison.setInt(2,documentId);
					psUpLignesBonLivraison.setInt(3,ligneId);
					psUpLignesBonLivraison.executeUpdate();
				}
				psUpLignesBonLivraison.close();
			}
			else if (typeDocument.equals("Bon_Retour")) {
				req = "update "+ base +".BON_RETOUR_CLIENT set Total_HT="+ totalHT +", Total_TTC = "+ totalTTC +" where Bon_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesBonRetour.setDouble(1,cv.mQuantifieLigne);
					psUpLignesBonRetour.setInt(2,documentId);
					psUpLignesBonRetour.setInt(3,ligneId);
					psUpLignesBonRetour.executeUpdate();
				}
				psUpLignesBonRetour.close();
			}
			else if (typeDocument.equals("Proforma")) {
				req = "update "+ base +".PROFORMA set Total_HT="+ totalHT +", Total_TTC = "+ totalTTC +" where Proforma_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesProforma.setDouble(1,cv.mQuantifieLigne);
					psUpLignesProforma.setInt(2,documentId);
					psUpLignesProforma.setInt(3,ligneId);
					psUpLignesProforma.executeUpdate();
				}
				psUpLignesProforma.close();
			}
			else if (typeDocument.equals("Commande_Fournisseur")) {
				req = "update "+ base +".COMMANDE_FOURNISSEUR set Total_HT="+ totalHT +", Total_TTC = "+ totalTTC +" where Commande_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesCommandeFournisseur.setDouble(1,cv.mQuantifieLigne);
					psUpLignesCommandeFournisseur.setInt(2,documentId);
					psUpLignesCommandeFournisseur.setInt(3,ligneId);
					psUpLignesCommandeFournisseur.executeUpdate();
				}
				psUpLignesCommandeFournisseur.close();
			}
			else if (typeDocument.equals("Bon_Reception")) {
				req = "update "+ base +".BON_RECEPTION set Total_HT="+ totalHT +", Total_TTC = "+ totalTTC +" where BR_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesBonReception.setDouble(1,cv.mQuantifieLigne);
					psUpLignesBonReception.setInt(2,documentId);
					psUpLignesBonReception.setInt(3,ligneId);
					psUpLignesBonReception.executeUpdate();
				}
				psUpLignesBonReception.close();
			}
			else if (typeDocument.equals("Facture_Fournisseur")) {
				req = "update "+ base +".FACTURE_FOURNISSEUR set Total_HT="+ totalHT +", Total_TTC = "+ totalTTC +" where Facture_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesFactureFournisseur.setDouble(1,cv.mQuantifieLigne);
					psUpLignesFactureFournisseur.setInt(2,documentId);
					psUpLignesFactureFournisseur.setInt(3,ligneId);
					psUpLignesFactureFournisseur.executeUpdate();
				}
				psUpLignesFactureFournisseur.close();
			}
			else if (typeDocument.equals("Avoir_Fournisseur")) {
				req = "update "+ base +".AVOIR_FOURNISSEUR set Total_HT="+ totalHT +", Total_TTC = "+ totalTTC +" where Avoir_Id="+ documentId;

				la = getLignes().keySet().iterator();
				while (la.hasNext()) {
					int ligneId= la.next();
					cv = getLignes().get(ligneId);
					psUpLignesAvoirFournisseur.setDouble(1,cv.mQuantifieLigne);
					psUpLignesAvoirFournisseur.setInt(2,documentId);
					psUpLignesAvoirFournisseur.setInt(3,ligneId);
					psUpLignesAvoirFournisseur.executeUpdate();
				}
				psUpLignesAvoirFournisseur.close();
			}

			stt.executeUpdate(req);

			stt.close();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}


 	public double getTotalHTTable() { return cd.getTotalHTTable(); }
 	public double getTotalTTCTable() { return cd.getTotalTTCTable(); }

	public double getMontantHT() { return cd.getMontantHT(); }
 	public double getTotalHT() { return cd.getTotalHT(); }
 	public double getTotalHTCommissionne() { return cd.getTotalHTCommissionne(); }
 	public double getTotalTVA() { return cd.getTotalTVA(); }
 	public double getMontantTTC() { return cd.getMontantTTC(); }
 	public double getTotalTTC() { return cd.getTotalTTC(); }
 	public double getRemiseM() { return cd.getMRemise(); }
 	public double getRemiseP() { return cd.getPRemise(); }
 	public double getMHTRemise() { return cd.getMHTRemise(); }
	public double getMTTCRemise() { return cd.getMTTCRemise(); }
 	public double getMTVARemise() { return cd.getMTVARemise(); }
 	public double getTTVARemise() { return cd.getTTVARemise(); }
	public double getPRemise_FP() { return cd.getPRemise_FP(); }
 	public double getMRemise_FP() { return cd.getMRemise_FP(); }
 	public double getMHTRemise_FP() { return cd.getMHTRemise_FP(); }
 	public double getMTTCRemise_FP() { return cd.getMTTCRemise_FP(); }
 	public double getMTVARemise_FP() { return cd.getMTVARemise_FP(); }
 	public double getTTVARemise_FP() { return cd.getTTVARemise_FP(); }
	public double getPCommission() { return cd.getPCommission(); }
 	public double getMCommission() { return cd.getMCommission(); }
 	public double getMHTCommission() { return cd.getMHTCommission(); }
 	public double getMTTCCommission() { return cd.getMTTCCommission(); }
 	public double getMTVACommission() { return cd.getMTVACommission(); }
 	public double getTTVACommission() { return cd.getTTVACommission(); }
 	public double getEscompteM() { return cd.getMEscompte(); }
 	public double getEscompteP() { return cd.getPEscompte(); }
 	public double getMFraisPort() { return cd.getMFraisPort(); }
 	public double getFraisPortHT() { return cd.getMHTFraisPort(); }
 	public double getFraisPortTVA() { return cd.getMTVAFraisPort(); }
 	public double getFraisPortTauxTVA() { return cd.getTTVAFraisPort(); }
	public double getFraisPortTTC() { return cd.getMTTCFraisPort(); }
 	public double getFraisPortHTHR() { return cd.getMHTFraisPortHR(); }
 	public double getFraisPortTVAHR() { return cd.getMTVAFraisPortHR(); }
	public double getFraisPortTTCHR() { return cd.getMTTCFraisPortHR(); }
	public double getAcompte() { return cd.getAcompte(); }
 	public double getMontantNet() { return cd.getMontantNet(); }
 	public boolean getEditionTTC() {return cd.getEditionTTC();}
	public double getRemisePCalcul() {return cd.getRemisePCalcul();}
	public double getPRemise_FPCalcul() {return cd.getPRemise_FPCalcul();}
	public double getMMargeHT() {return cd.getMMargeHT();}
	public double getPMargeHT() {return cd.getPMargeHT();}

 	public HashMap<Integer, LigneDocument> getLignes() { return cd.getLignes(); }
 	public HashMap<Integer, CalculVentilTVA> getLignesTVA() { return cd.getLignesTVA(); }
 	public HashMap<Integer, CalculVentilTVARemise> getLignesTVARemise() { return cd.getLignesTVARemise(); }
 	public HashMap<Integer, CalculVentilTVACommission> getLignesTVACommission() { return cd.getLignesTVACommission(); }

	protected void finalize() {
		try {
			if (s!=null) {
				s.closeConnection(con, null);
			}
		}
		catch(SQLException e) {
			e.printStackTrace();
		}
	}

} // fin Calcul
