/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Traitement des fichiers des photos de produits
 */

package org.opensi.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class PhotosManager {

	private static final int LARGEUR = 100;

	private String chemin;

	private String dossier;

	public PhotosManager(String cheminServeur, String dossierId) {
		chemin = cheminServeur;
		dossier = dossierId;

	}

	public void creerPhotos(String fichierImage, String article) {

		try {

			File tempFile = new File(chemin + "/iobuffer/" + fichierImage);

			if (tempFile.exists()) {

				BufferedImage imageOrigine = ImageIO.read(tempFile);

				if (imageOrigine == null) {

					// r.addParameter("Action_Error","Fichier image non lisible
					// !");
				}
				else {

					int w = imageOrigine.getWidth();
					int h = imageOrigine.getHeight();

					if (w > LARGEUR || h > LARGEUR) {
						if (w > h) {
							h = (h * LARGEUR) / w;
							w = LARGEUR;
						}
						else {
							w = (w * LARGEUR) / h;
							h = LARGEUR;
						}
					}

					BufferedImage imageVignette = makeBufferedImage(imageOrigine.getScaledInstance(w, h, Image.SCALE_FAST));

					File grande_photo = new File(chemin + "/photos_articles/" + dossier + "/" + article + "_big.jpg");
					grande_photo.createNewFile();

					File petite_photo = new File(chemin + "/photos_articles/" + dossier + "/" + article + "_small.jpg");
					petite_photo.createNewFile();

					ImageIO.write(imageOrigine, "JPG", grande_photo);
					ImageIO.write(imageVignette, "JPG", petite_photo);
				}

				try {
					tempFile.delete();
				}
				catch (SecurityException se) {
					// s.trace("Impossible d'effacer le fichier image temporaire
					// !");
					System.out.println("" + se);
				}
			}

		}
		catch (IOException ioe) { // r.addParameter("Action_Error","Erreur
			// d'criture sur le serveur !"); }
			System.out.println("" + ioe);
		}

	}

	private BufferedImage makeBufferedImage(Image image) {
		/** On test si l'image n'est pas dja une instance de BufferedImage */
		// if (image instanceof BufferedImage) {
		/** cool, rien  faire */
		// return((BufferedImage) image);
		// } else {
		/** On s'assure que l'image est compltement charge */
		// image = new ImageIcon(image).getImage();
		/** On cre la nouvelle image */
		BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), BufferedImage.TYPE_INT_RGB);
		Graphics g = bufferedImage.createGraphics();
		g.drawImage(image, 0, 0, null);
		g.dispose();

		return (bufferedImage);
		// }
	}

} // fin ManagePhotos

