/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.reglements.fournisseurs;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;


public class CalculEcheanceFournisseur {

	private String Fournisseur_Id;
	private String Fournisseur;
	private int Mode_Reg;
	private double Montant;
	private double Montant_initial;
	private double Montant_regle;
	private String Base;
	private int nb;
	private int i;
	private Hashtable<String, String> tab=new Hashtable<String, String>();
	private ResultSet rset;
	private ArrayList<String[]> liste=new ArrayList<String[]>();
	private Statement st;
	private Arrondi arrondi=new Arrondi(2);
	private ArrayList<String> liste_fini=new ArrayList<String>();

	private Hashtable<String, String> hashtablesomme=new Hashtable<String, String>();
	private ArrayList<String[]> listesomme=new ArrayList<String[]>();
	private Session s;


  public CalculEcheanceFournisseur (String Sess,String Base,String Fournisseur_Id,String Fournisseur,int Mode_Reg,double Montant,double Montant_Regle) {
    try {
			this.Base=Base;
			this.Fournisseur_Id=Fournisseur_Id;
			this.Fournisseur=Fournisseur;
			this.Mode_Reg=Mode_Reg;
			this.Montant=Montant;
			this.Montant_initial=Montant;
			this.Montant_regle=Montant_Regle;
			this.nb=0;
			this.s = Session.findClient(Sess);
    	Connection c = s.getConnection(null);
    	st = c.createStatement();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

	public boolean liste () {

		try {
			
			String sqlCountEch = "select count(ef.Echeance_Id) as nb from " + Base + ".ECHEANCE_FOURNISSEUR ef";
			sqlCountEch += " where ef.Fournisseur_Id = '"+ Fournisseur_Id+"' and ef.Etat != 'R'";
			if (Fournisseur_Id.equals("")) {
				sqlCountEch+=" and Denomination = '"+s.sqlEncode(Fournisseur)+"'";
			}
			rset = st.executeQuery(sqlCountEch);
			if (rset.next()) {
				nb=rset.getInt("nb");
			}

			String sqlListeEch = "select ef.*, mr.Libelle as LblModeReglement from " + Base + ".ECHEANCE_FOURNISSEUR ef join "+ Base +".MODE_REGLEMENT mr on ef.Mode_Reg_Id=mr.Mode_Reg_Id";
			sqlListeEch += " where ef.Fournisseur_Id = '"+ Fournisseur_Id+"' and ef.Etat != 'R'";
			if (Fournisseur_Id.equals("")) {
				sqlListeEch+=" and Denomination = '"+s.sqlEncode(Fournisseur)+"'";
			}
			sqlListeEch+=" order by Type, Date_Echeance";
			rset = st.executeQuery(sqlListeEch);

			while (rset.next()) {
				String tree[]=new String [15];
				tree[0]=rset.getString("Echeance_Id");
				tree[1]=rset.getString("Type");
				tree[2]=rset.getString("Provenance");
				tree[3]=rset.getString("Numero");
				tree[4]=rset.getString("Date_Echeance");
				tree[5]=rset.getString("Echeance_Initiale");
				tree[6]=rset.getString("Fournisseur_Id");
				tree[7]=rset.getString("Denomination");
				tree[8]=rset.getString("Montant_Du");
				tree[9]=rset.getString("Montant_Regle");
				tree[10]=rset.getString("Montant_Restant");
				tree[11]=rset.getString("Regulariser");
				tree[12]=rset.getString("Etat");
				tree[13]=rset.getString("Mode_Reg_Id");
				tree[14]=rset.getString("LblModeReglement");
				liste.add(tree);
				
				int modeR = Integer.parseInt(tree[13]);

				int nbsomme=listesomme.size();
				if (nb<15) {
					for (i=0;i<nbsomme;i++)
					{
						double val=Double.parseDouble(listesomme.get(i)[2]);
						double somme=rset.getDouble("Montant_Restant")+val;
						somme=arrondi.round(somme);
						if (somme<=Montant) {
							int Mode = Integer.parseInt(listesomme.get(i)[1]);
							String cle=listesomme.get(i)[0];
							Mode=(Mode==modeR)?Mode:0;

							String som[]={cle+";"+tree[0],""+Mode,""+somme};
							listesomme.add(som);
						}
					}
				}
				if (rset.getDouble("Montant_Restant")<Montant) {
					String nouv []={tree[0],tree[13],tree[10]};
					listesomme.add(nouv);
				}
			}

    } catch (Exception e) {
      e.printStackTrace();
    }
    return true;
	}

	public boolean calcul () {
		try {

			boolean suite=false;
			impute_egal(true);
			if (Montant!=0){
				if (Montant==Montant_initial) {
					suite=somme_egal(true,Montant_regle);
					if (Montant!=0 && Montant==Montant_initial){
						if (suite) {somme_egal(true,Montant);}
					}
				}
				if (Montant!=0){
					trouve_diff(true);
					if (Montant!=0){
						if (Montant==Montant_initial) {
							impute_egal(false);
							if (Montant!=0){
								if (Montant==Montant_initial) {
									suite=somme_egal(false,Montant_regle);
									if (Montant!=0 && Montant==Montant_initial){
										if (suite) {somme_egal(false,Montant);}
									}
								}
							}
						}
						if (Montant!=0){
							trouve_diff(false);
						}
					}
				}
			}
    } catch (Exception e) {
      e.printStackTrace();
    }
    return true;
	}


	public boolean impute_egal(boolean meme_mode) {
		try {

			String [] ech=trouve_egal(meme_mode,Montant_regle);
			String [] ech_avo=trouve_egal(meme_mode,Montant);

			if (!ech[1].equals("") && !ech_avo[1].equals("")) {
				if ((new Long (ech[1]).longValue())<=(new Long (ech_avo[1]).longValue())) {
					tab.put(ech[0],(new Double(Montant_regle)).toString());
  				Montant-=Montant_regle;
					Montant=arrondi.round(Montant);
					Montant_regle=0;
					liste_fini.add(ech[0]);
				}
				else {
					tab.put(ech_avo[0],(new Double(Montant)).toString());
					Montant=0;
					Montant_regle=0;
					liste_fini.add(ech_avo[0]);
				}
			}
			else if (!ech[1].equals("") || !ech_avo[1].equals("")) {
				if (ech_avo[1].equals("")) {
					tab.put(ech[0],(new Double(Montant_regle)).toString());
  				Montant-=Montant_regle;
					Montant=arrondi.round(Montant);
					Montant_regle=0;
					liste_fini.add(ech[0]);
				}
				else {
					tab.put(ech_avo[0],(new Double(Montant)).toString());
					Montant=0;
					Montant_regle=0;
					liste_fini.add(ech_avo[0]);
				}
			}
    } catch (Exception e) {
      e.printStackTrace();
    }
    return true;
	}


	public String [] trouve_egal(boolean meme_mode,double mont) {
		String [] ech=new String [2];
		ech[0]="";
		ech[1]="";
		boolean trouve=false;
		int i=0;
		try {
			while (i<liste.size() && !trouve)
			{
				boolean egal;
				double Restant=new Double(liste.get(i)[10]).doubleValue();
				int Mode=Integer.parseInt(liste.get(i)[13]);
				String Id=liste.get(i)[0];
				String date=liste.get(i)[4];
				if (meme_mode)
					egal=(Mode_Reg==Mode);
				else
					egal=(Mode_Reg!=Mode);
				if (egal)
				{
					if (Restant==mont && mont!=0)
					{
						trouve=true;
						ech[0]=Id;
						ech[1]=date;
					}
				}
				i++;
			}
    } catch (Exception e) {
      e.printStackTrace();
    }
    return ech;
	}


	public boolean somme_egal(boolean meme_mode,double mont) {
		boolean suite=true;
		try {
			if (meme_mode){

				for (int i=0;i<listesomme.size();i++)
				{
					double val=new Double(listesomme.get(i)[2]).doubleValue();
					int Mode=Integer.parseInt(listesomme.get(i)[1]);
					String Id=listesomme.get(i)[0];
					if (Mode_Reg==Mode)
					{
						if (val==mont && mont!=0 && Montant!=0)
						{
							suite=false;
							int nombre=1;
							for (int j=0;j<Id.length();j++)
							{
								if ((Id.charAt(j))==';')
									nombre++;

							}
							String Ech []=Id.split(";");
							for (int k=0;k<nombre;k++)
							{
								double Restant=(new Double(hashtablesomme.get(Ech[k]).toString())).doubleValue();
								tab.put(Ech[k],hashtablesomme.get(Ech[k]));
								liste_fini.add(Ech[k]);
								Montant-=Restant;
								Montant=arrondi.round(Montant);
								if (Restant<=Montant_regle) {
									Montant_regle-=Restant;
									Montant_regle=arrondi.round(Montant_regle);
								}
								else {
									Montant_regle=0;
								}
							}
						}
					}
				}
			}
			else
			{
				for (int i=0;i<listesomme.size();i++)
				{
					double val=new Double(listesomme.get(i)[2]).doubleValue();
					int Mode=Integer.parseInt(listesomme.get(i)[1]);
					String Id=listesomme.get(i)[0];
					if (Mode_Reg!=Mode)
					{
						if (val==mont && mont!=0 && Montant!=0)
						{
							suite=false;
							int nombre=1;
							for (int j=0;j<Id.length();j++)
							{
								if ((Id.charAt(j))==';')
									nombre++;

							}
							String Ech []=Id.split(";");
							for (int k=0;k<nombre;k++)
							{
								double Restant=(new Double(hashtablesomme.get(Ech[k]).toString())).doubleValue();
								tab.put(Ech[k],hashtablesomme.get(Ech[k]));
								liste_fini.add(Ech[k]);
								Montant-=Restant;
								Montant=arrondi.round(Montant);
								if (Restant<=Montant_regle) {
									Montant_regle-=Restant;
									Montant_regle=arrondi.round(Montant_regle);
								}
								else {
									Montant_regle=0;
								}

							}
						}
					}
				}
			}
    } catch (Exception e) {
      e.printStackTrace();
    }
    return suite;
	}

	public boolean trouve_diff(boolean meme_mode) {
		try {
			for (i=0;i<liste.size();i++)
			{	boolean egal;
				double Restant=new Double(liste.get(i)[10]).doubleValue();
				String Type=liste.get(i)[1];
				int Mode=Integer.parseInt(liste.get(i)[13]);
				String Id=liste.get(i)[0];
				if (meme_mode)
					egal=(Mode_Reg==Mode);
				else
					egal=(Mode_Reg!=Mode);
				if (egal && !liste_fini.contains(Id))
				{
					if (Restant<=Montant)
					{
						tab.put(Id,(new Double(Restant)).toString());
						liste_fini.add(Id);
						Montant-=Restant;
						Montant=arrondi.round(Montant);
						if (Restant<=Montant_regle) {
							Montant_regle-=Restant;
							Montant_regle=arrondi.round(Montant_regle);
						}
						else {
							Montant_regle=0;
						}
					}
					else if (Montant!=0)
					{
						if (Type.equals("Echeance") || !meme_mode) {
							tab.put(Id,(new Double(Montant)).toString());
							Montant_regle=0;
							Montant=0;
						}
					}
				}
			}
    } catch (Exception e) {
      e.printStackTrace();
    }
    return true;
	}

	public int nombre () {
		return nb;
	}

	public String getValeur(int i,int j) {
		return liste.get(i-1)[j];
	}

	public String getMontant_Impute(String ech_Id) {
		return tab.get(ech_Id);
	}


}
