/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un bordereau de remise d'espces
 */

package org.opensi.facturation.reglements.clients;


import org.opensi.api.SessionOSI;
import org.opensi.util.pdf.GlobalDocument;


public class GenPdfRemiseEspeces {
	

	public GenPdfRemiseEspeces(SessionOSI sosi, String nomFichier, int remiseId) throws Exception {
		
		
		DataRemiseEspeces dre = new DataRemiseEspeces(sosi, remiseId);
		
		String repPdf = sosi.getPdfDirectory();
		String repTemp = repPdf;
	
		PdfRemiseEspeces pdfRemiseEspeces = new PdfRemiseEspeces(repTemp, dre);
		GlobalDocument gd = new GlobalDocument(repPdf, nomFichier);
		gd.addInternal(pdfRemiseEspeces);
		gd.close(GlobalDocument.ON_EXIT);
	}


} // fin GenPdfRemiseEspeces
