/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Import des numros de colis
 */

package org.opensi.facturation.expedition;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;


public class ImporterColis extends Action {


	public boolean serverSide() { return true; }

  	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

  		String fichier = s.getAppConfiguration().get("opensi.absdir") +"/iobuffer/" + r.getParameter("Fichier");
  		String format = r.getParameter("Format");
  		
  		IImportation importation;
  		
  		if (format.equals("LAPOSTE")) {
			// format par dfaut, sous licence GPL
  			importation = new CsvImportLaposte();
		}
		else {
			// autres formats
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			String base = s.getCookie().get("BaseDossier");
			ResultSet rsClass = stt.executeQuery("select Class from "+ base +".IMPORT_COLIS where Import_Id='"+ format +"'");
			rsClass.next();
			importation = (IImportation)Class.forName(rsClass.getString("Class")).newInstance();
			rsClass.close();
			stt.close();
		}
  		
  		String bons = importation.makeImportation(s, fichier);
  		
  		r.addParameter("Bons",bons);

		return true;


	} // fin service



} // fin ImporterColis
