/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;


public class TransfertRemboursementsFournisseur extends TransfertCompta {

	private String compteFournisseursDivers;
	private double montantImpute;
	private int reglementId;
	private int avoirId;
	private String codeJournal;

	private PreparedStatement psCpteFournisseur;
	private PreparedStatement psCpteJournal;


	public TransfertRemboursementsFournisseur(SessionOSI sosi, String codeJournal, int reglementId, double montantImpute, int avoirId) throws Exception {

		super(sosi);
		this.codeJournal = codeJournal;
		this.reglementId = reglementId;
		this.avoirId = avoirId;
		this.montantImpute = montantImpute;
	}


	public void transfert() throws Exception {

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Numero_Compte_Fournisseurs from "+ baseDossier +".PARAM_DOSSIER");
		rset.next();

		compteFournisseursDivers = rset.getString("Numero_Compte_Fournisseurs");


		String reqCpteFournisseur = "select c.Numero_Compte from "+ baseDossier +".FICHE_FOURNISSEUR e,"+ baseDossier +".COMPTE c where e.Fournisseur_Id=? and e.Numero_Compte=c.Numero_Compte";

		String reqCpteJournal = "select Contrepartie from "+ baseDossier +".JOURNAL where Code_Journal=?";

		psCpteFournisseur = con.prepareStatement(reqCpteFournisseur);
		psCpteJournal = con.prepareStatement(reqCpteJournal);

		if (reglementId!=0) {

			rset = stt.executeQuery("select * from " + baseDossier + ".REGLEMENT_FOURNISSEUR where Reglement_Id="+ reglementId);

			while (rset.next()) {

				long dateReglement = rset.getLong("Date_Reg");
				String fournisseurId = rset.getString("Fournisseur_Id");
				String numPiece = rset.getString("Num_Piece");
				double montant = montantImpute;
				int modeRegId = rset.getInt("Mode_Reg_Id");

				Ecriture ecriture = new Ecriture();
				ecriture.setCodeJournal(codeJournal);
				ecriture.setDateEcriture(dateReglement);

				if (montant>0) {
					String compteFournisseur = getCompteFournisseur(fournisseurId);

					Operation op = new Operation();
					op.setDateOp(dateReglement);
					op.setNumPiece(numPiece);
					op.setModeRegId(modeRegId);

					op.setNumeroCompte(compteFournisseur);
					op.setLibelle(getIntitule(compteFournisseur));
					op.setMontantC(montant);

					ecriture.addOperation(op);
				
					String compteJournal = getContrePartieJournal(codeJournal);

					op = new Operation();
					op.setDateOp(dateReglement);
					op.setNumPiece(numPiece);
					op.setNumeroCompte(compteJournal);
					op.setLibelle(getIntitule(compteJournal));
					op.setMontantD(montant);

					ecriture.addOperation(op);
				}

				validerEcriture(ecriture, reglementId, dateReglement);
			}
		}
		else {

			rset = stt.executeQuery("select * from " + baseDossier + ".AVOIR_FOURNISSEUR where Avoir_Id="+ avoirId);

			while (rset.next()) {

				long dateAvoir = rset.getLong("Date_Avoir");
				String fournisseurId = rset.getString("Fournisseur_Id");
				String numPiece = rset.getString("Numero");
				double montant = rset.getDouble("Rembourser");

				Ecriture ecriture = new Ecriture();
				ecriture.setCodeJournal(codeJournal);
				ecriture.setDateEcriture(dateAvoir);

				if (montant>0) {
					String compteFournisseur = getCompteFournisseur(fournisseurId);

					Operation op = new Operation();
					op.setDateOp(dateAvoir);
					op.setNumPiece(numPiece);

					op.setNumeroCompte(compteFournisseur);
					op.setLibelle(getIntitule(compteFournisseur));
					op.setMontantC(montant);

					ecriture.addOperation(op);
				
					String compteJournal = getContrePartieJournal(codeJournal);

					op = new Operation();
					op.setDateOp(dateAvoir);
					op.setNumPiece(numPiece);
					op.setNumeroCompte(compteJournal);
					op.setLibelle(getIntitule(compteJournal));
					op.setMontantD(montant);

					ecriture.addOperation(op);
				}

				validerEcriture(ecriture, avoirId, dateAvoir);
			}
		}
	}


	protected void marquerDocument(int voidId) throws SQLException {

	}


	private String getCompteFournisseur(String fournisseurId) throws SQLException {

		if (fournisseurId.equals("")) {
			return compteFournisseursDivers;
		}
		else {
			psCpteFournisseur.setString(1, fournisseurId);
			ResultSet rset = psCpteFournisseur.executeQuery();

			if (rset.next()) {
				return rset.getString("Numero_Compte");
			}
			else {
				return compteFournisseursDivers;
			}
		}
	}

	private String getContrePartieJournal(String codeJournal) throws SQLException {
		if (codeJournal.equals("")) {
			return "";
		}
		else {
			psCpteJournal.setString(1, codeJournal);
			ResultSet rset = psCpteJournal.executeQuery();
			if (rset.next()) {
				return rset.getString("Contrepartie");
			}
			else {
				return "";
			}
		}
	}


} // fin TransfertRemboursementsFournisseur
