/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;
import java.util.HashMap;
import java.util.Iterator;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;

import org.opensi.util.tools.Arrondi;
import org.opensi.util.sql.SqlUtils;

import org.opensi.util.calcul.*;


public class TransfertFacturesFournisseur extends TransfertAchats {

	private SessionOSI sosi;
	private String codeJournal;
	private String listeId;

	private PreparedStatement psMarqueFact;

	private Arrondi rd = new Arrondi(2);


	public TransfertFacturesFournisseur(SessionOSI sosi, String codeJournal, String listeId) throws Exception {

		super(sosi);

		this.sosi = sosi;
		this.codeJournal = codeJournal;
		this.listeId = (listeId.length()==0?"-1":SqlUtils.normalizeCSList(listeId));

		psMarqueFact = con.prepareStatement("update "+ baseDossier +".FACTURE_FOURNISSEUR set Transferee=1 where Facture_Id=?");
	}


	public synchronized void transfert() throws Exception {

		Statement stt = con.createStatement();

		Calcul cf = new Calcul(sosi);

		PreparedStatement psArtFact = con.prepareStatement("select * from "+ baseDossier +".LIGNE_FACTURE_FOURNISSEUR where Facture_Id=?");

		ResultSet rset = stt.executeQuery("select * from "+ baseDossier +".FACTURE_FOURNISSEUR where Statut='V' and Transferee=0 and Total_HT>0 and Facture_Id in ("+ listeId +") order by Numero");

		while (rset.next()) {

			long echeance = rset.getLong("Echeance");
			long dateFacture = rset.getLong("Date_Facture");

			int factureId = rset.getInt("Facture_Id");

			String fournisseurId = rset.getString("Fournisseur_Id");
			String numPiece = rset.getString("Numero");
			String typeAchat = rset.getString("Type_Achat");
			int modeRegId = rset.getInt("Mode_Reg_Id");

			double tRemise = rset.getDouble("Remise");

			cf.setDocument(factureId, "Facture_Fournisseur");

			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(codeJournal);
			ecriture.setDateEcriture(dateFacture);

			HashMap<String, Double> vtvas = new HashMap<String, Double>(2);
			HashMap<String, Double> vachats = new HashMap<String, Double>(2);


			// ventilation des comptes de TVA

			HashMap<Integer, CalculVentilTVA> ventilTVA = cf.getLignesTVA();
			Iterator<Integer> ltva = ventilTVA.keySet().iterator();

			while (ltva.hasNext()) {
				int codeTVA = ltva.next();
				double montantTVA = ventilTVA.get(codeTVA).getMontantTVA();

				String compteTVA = cptesTva.get(new Integer(codeTVA));

				if (vtvas.containsKey(compteTVA)) {
					montantTVA += vtvas.get(compteTVA).doubleValue();
				}

				vtvas.put(compteTVA , new Double(rd.round(montantTVA)));
			}


			// parcours des articles de la facture pour calculer la ventilation des comptes d'achat

			psArtFact.setInt(1, factureId);
			ResultSet rsAF = psArtFact.executeQuery();

			while (rsAF.next()) {

				String reference = rsAF.getString("Reference");
				String typeLigne = rsAF.getString("Type_Ligne");

				double montantLigne = rsAF.getDouble("Montant_Ligne");
				int codeTVA = rsAF.getInt("Code_TVA");

				String compteHT = (typeLigne.equalsIgnoreCase("S")?getCompteHT(reference, typeAchat, codeTVA):getCompteDefault(typeAchat, codeTVA));
				
				double montantHT = rd.round(montantLigne);

				if (montantHT>0) {

					if (vachats.containsKey(compteHT)) {
						montantHT += vachats.get(compteHT).doubleValue();
					}

					vachats.put(compteHT, new Double(rd.round(montantHT)));
				}
			}


			// application du pourcentage de remise globale aux comptes d'achat et calcul du total HT
			// la remise globale est applique maintenant pour viter au maximum les carts

			double fraisPortHT = cf.getFraisPortHT();

			double totalHT = fraisPortHT;

			Iterator<String> li = vachats.keySet().iterator();

			while (li.hasNext()) {

				String compteHT = li.next();

				double valeurCpte = vachats.get(compteHT).doubleValue();

				double valeurRem = rd.round(valeurCpte * (1-tRemise/100));

				totalHT += valeurRem;

				if (valeurRem>0)
					vachats.put(compteHT, new Double(valeurRem));
				else
					vachats.put(compteHT, new Double(0));
			}


			double htFacture = cf.getTotalHT();

			// rajustement de la ventilation HT  partir du dernier compte HT ventil

			if (htFacture>totalHT) {
				ajusterHT(rd.round(htFacture-totalHT), 'P', vachats);
			}
			else if (htFacture<totalHT) {
				ajusterHT(rd.round(totalHT-htFacture), 'M', vachats);
			}


			// calcul spcial de la tva intracom

			double tvaIntraCom = 0;

			if (typeAchat.equalsIgnoreCase("U")) {

				tvaIntraCom = totalHT * (tauxNormalFR/100);
			}

			// ajout des oprations  l'ecriture comptable

			// operations sur comptes d'achat

			String compteFournisseur = getCompteFournisseur(fournisseurId);
			String intituleFournisseur = getIntitule(compteFournisseur);

			li = vachats.keySet().iterator();
			
			while (li.hasNext()) {

				String compteHT = li.next();
				double montantHT = vachats.get(compteHT).doubleValue();

				if (montantHT>0) {
					Operation op = new Operation();
					op.setDateOp(dateFacture);
					op.setNumPiece(numPiece);
					op.setDateEcheance(echeance);
					
					op.setNumeroCompte(compteHT);
					op.setLibelle(intituleTiers?intituleFournisseur:getIntitule(compteHT));
					op.setMontantD(montantHT);

					ecriture.addOperation(op);
				}
			}

			// affectation des frais de port au compte de frais de livraison

			if (fraisPortHT>0) {

				Operation op = new Operation();
				op.setDateOp(dateFacture);
				op.setNumPiece(numPiece);
				op.setDateEcheance(echeance);

				op.setNumeroCompte(compteLivraison);
				op.setLibelle(intituleTiers?intituleFournisseur:getIntitule(compteLivraison));
				op.setMontantD(fraisPortHT);

				ecriture.addOperation(op);
			}

			// operations sur comptes de TVA

			li = vtvas.keySet().iterator();

			while (li.hasNext()) {

				String compteTVA = li.next();
				double montantTVA = vtvas.get(compteTVA).doubleValue();

				if (montantTVA>0) {
					Operation op = new Operation();
					op.setDateOp(dateFacture);
					op.setNumPiece(numPiece);
					op.setDateEcheance(echeance);
					
					op.setNumeroCompte(compteTVA);
					op.setLibelle(intituleTiers?intituleFournisseur:getIntitule(compteTVA));
					op.setMontantD(montantTVA);

					ecriture.addOperation(op);
				}
			}

			// opration spciales de tva intracom pour achats UE

			if (tvaIntraCom>0) {

				Operation op = new Operation();
				op.setDateOp(dateFacture);
				op.setNumPiece(numPiece);
				op.setDateEcheance(echeance);

				op.setNumeroCompte(compteTvaDueIC);
				op.setLibelle(intituleTiers?intituleFournisseur:getIntitule(compteTvaDueIC));
				op.setMontantD(tvaIntraCom);

				ecriture.addOperation(op);

				op = new Operation();
				op.setDateOp(dateFacture);
				op.setNumPiece(numPiece);
				op.setDateEcheance(echeance);

				op.setNumeroCompte(compteTvaDedIC);
				op.setLibelle(intituleTiers?intituleFournisseur:getIntitule(compteTvaDedIC));
				op.setMontantC(tvaIntraCom);

				ecriture.addOperation(op);
			}

			// operation d'escompte

			double montantEscompte = cf.getEscompteM();

			if (montantEscompte>0) {
				Operation op = new Operation();
				op.setDateOp(dateFacture);
				op.setNumPiece(numPiece);
				op.setDateEcheance(echeance);

				op.setNumeroCompte(compteEscompteAC);
				op.setLibelle(intituleTiers?intituleFournisseur:getIntitule(compteEscompteAC));
				op.setMontantC(montantEscompte);

				ecriture.addOperation(op);
			}


			// operation du compte fournisseur

			double montantNet = cf.getTotalTTC();

			if (montantNet>0) {

				Operation op = new Operation();
				op.setDateOp(dateFacture);
				op.setNumPiece(numPiece);
				op.setDateEcheance(echeance);
				op.setModeRegId(modeRegId);

				op.setNumeroCompte(compteFournisseur);
				op.setLibelle(intituleFournisseur);
				op.setMontantC(montantNet);

				ecriture.addOperation(op);
			}

			validerEcriture(ecriture, factureId, dateFacture);
		}
	}


	protected void marquerDocument(int factureId) throws SQLException {

		psMarqueFact.setInt(1, factureId);
		psMarqueFact.executeUpdate();
	}


} // fin TransfertFacturesFournisseur

