/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import java.util.HashMap;
import java.util.Iterator;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;

import org.opensi.util.tools.Arrondi;
import org.opensi.util.sql.SqlUtils;

import org.opensi.util.calcul.*;


public class TransfertFacturesClient extends TransfertVentes {


	private PreparedStatement psMarqueFact;
	private SessionOSI sosi;
	private String codeJournal;
	private String listeId;


	private Arrondi rd = new Arrondi(2);


  public TransfertFacturesClient(SessionOSI sosi, String codeJournal, String listeId) throws Exception {

		super(sosi);

		this.sosi = sosi;
		this.codeJournal = codeJournal;
		this.listeId = (listeId.length()==0?"-1":SqlUtils.normalizeCSList(listeId));

		psMarqueFact = con.prepareStatement("update "+ baseDossier +".FACTURE set Transferee=1 where Facture_Id=?");
	}


	public synchronized void transfert() throws Exception {

		Statement stt = con.createStatement();

		Calcul cf = new Calcul(sosi);

		PreparedStatement psArtFact = con.prepareStatement("select * from "+ baseDossier +".LIGNE_FACTURE where Facture_Id=?");
		PreparedStatement psEcheance = con.prepareStatement("select Date_Echeance, Mode_Reg_Id from "+ baseDossier +".ECHEANCE_FACTURE_CLIENT where Facture_Id=? order by Date_Echeance limit 1");
		PreparedStatement psAcomptes = con.prepareStatement("select sum(i.Montant - (i.Montant / (1 + a.Taux_TVA/100))) as Montant_TVA, a.Code_TVA from "+ baseDossier +".IMPUTATION_ACOMPTE_FACTURE_CLIENT i join "+ baseDossier +".ACOMPTE_CLIENT a on a.Acompte_Id=i.Acompte_Id where i.Facture_Id=? group by a.Code_TVA");


		String reqFactures = " select f.*, p.Zone_UE from "+ baseDossier +".FACTURE f join PAYS p on p.Code_Pays=f.Code_Pays_Liv"
											 + " where f.Numero>0 and f.Transferee=0 and f.Total_HT>0 and Facture_Id in ("+ listeId +") order by f.Num_Entier";

		ResultSet rset = stt.executeQuery(reqFactures);

		while (rset.next()) {

			long dateFacture = rset.getLong("Date_Facture");
			int factureId = rset.getInt("Facture_Id");
			long echeance = 0;
			int modeRegId = 0;

			psEcheance.setInt(1, factureId);
			ResultSet rsE = psEcheance.executeQuery();
			if (rsE.next()) {
				echeance = rsE.getLong("Date_Echeance");
				modeRegId = rsE.getInt("Mode_Reg_Id");
			}

			String clientId = rset.getString("Client_Id");
			String numPiece = rset.getString("Num_Entier");
			String libelle = rset.getString("Denomination");

			cf.setDocument(factureId, "Facture");

			double tRemise = rset.getDouble("Remise");
			String codePaysLiv = rset.getString("Code_Pays_Liv");
			boolean zoneUE = (rset.getInt("Zone_UE")==1 && !codePaysLiv.equalsIgnoreCase("FR"));

			boolean editionTTC = (rset.getInt("Edition_TTC")==1);

			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(codeJournal);
			ecriture.setDateEcriture(dateFacture);

			HashMap<String, Double> vtvas = new HashMap<String, Double>(2);
			HashMap<String, Double> vventes = new HashMap<String, Double>(2);


			// ventilation des comptes de TVA

			HashMap<Integer, CalculVentilTVA> ventilTVA = cf.getLignesTVA();
			Iterator<Integer> ltva = ventilTVA.keySet().iterator();

			while (ltva.hasNext()) {
				int codeTVA = ltva.next();
				double montantTVA = ventilTVA.get(codeTVA).getMontantTVA();

				String compteTVA = cptesTva.get(new Integer(codeTVA));

				if (vtvas.containsKey(compteTVA)) {
					montantTVA += vtvas.get(compteTVA).doubleValue();
				}

				vtvas.put(compteTVA , new Double(rd.round(montantTVA)));
			}


			// parcours des articles de la facture pour calculer la ventilation des comptes de vente

			psArtFact.setInt(1, factureId);
      ResultSet rsAF = psArtFact.executeQuery();

      while (rsAF.next()) {

				String reference = rsAF.getString("Reference");
				String typeLigne = rsAF.getString("Type_Ligne");

				double montantLigne = rsAF.getDouble("Montant_Ligne");
				double tauxTVA = rsAF.getDouble("Taux_TVA");
				int codeTVA = rsAF.getInt("Code_TVA");

				String compteHT = (typeLigne.equalsIgnoreCase("S")?getCompteHT(reference, codeTVA, tauxTVA, zoneUE, codePaysLiv):getCompteDefault(codeTVA, tauxTVA, zoneUE, codePaysLiv));

				double montantHT;

				if (editionTTC)
					montantHT = rd.round(montantLigne / (1 + tauxTVA/100));
				else
					montantHT = rd.round(montantLigne);

				if (montantHT>0) {

        	if (vventes.containsKey(compteHT)) {
						montantHT += vventes.get(compteHT).doubleValue();
					}

					vventes.put(compteHT, new Double(rd.round(montantHT)));
				}
			}


			// application du pourcentage de remise globale aux comptes de vente et calcul du total HT
			// la remise globale est applique maintenant pour viter au maximum les carts

			double fraisPortHT = cf.getFraisPortHT();

			double totalHT = fraisPortHT;

			Iterator<String> li = vventes.keySet().iterator();

			while (li.hasNext()) {

				String compteHT = li.next();

				double valeurCpte = vventes.get(compteHT).doubleValue();

				double valeurRem = rd.round(valeurCpte * (1-tRemise/100));

				totalHT += valeurRem;

				if (valeurRem>0)
					vventes.put(compteHT, new Double(valeurRem));
				else
					vventes.put(compteHT, new Double(0));
			}


			double htFacture = cf.getTotalHT();

			// rajustement de la ventilation HT  partir du dernier compte HT ventil

			if (htFacture>totalHT) {
				ajusterHT(rd.round(htFacture-totalHT), 'P', vventes);
			}
			else if (htFacture<totalHT) {
				ajusterHT(rd.round(totalHT-htFacture), 'M', vventes);
			}


			// ajout des oprations  l'ecriture comptable

			// operations sur comptes de vente

			String compteClient = getCompteClient(clientId);
			String intituleClient = getIntitule(compteClient);

			li = vventes.keySet().iterator();

			while (li.hasNext()) {

				String compteHT = li.next();
				double montantHT = vventes.get(compteHT).doubleValue();

				if (montantHT>0) {
					Operation op = new Operation();
					op.setDateOp(dateFacture);
					op.setNumPiece(numPiece);
					op.setDateEcheance(echeance);

					op.setNumeroCompte(compteHT);
					op.setLibelle(intituleTiers?intituleClient:getIntitule(compteHT));
					op.setMontantC(montantHT);

					ecriture.addOperation(op);
				}
			}

			// affectation des frais de port au compte de frais de livraison

			if (fraisPortHT>0) {

				Operation op = new Operation();
				op.setDateOp(dateFacture);
				op.setNumPiece(numPiece);
				op.setDateEcheance(echeance);

				op.setNumeroCompte(compteLivraison);
				op.setLibelle(intituleTiers?intituleClient:getIntitule(compteLivraison));
				op.setMontantC(fraisPortHT);

				ecriture.addOperation(op);
			}

			// operations sur comptes de TVA

			li = vtvas.keySet().iterator();

			while (li.hasNext()) {

				String compteTVA = li.next();
				double montantTVA = vtvas.get(compteTVA).doubleValue();

				if (montantTVA>0) {
					Operation op = new Operation();
					op.setDateOp(dateFacture);
					op.setNumPiece(numPiece);
					op.setDateEcheance(echeance);

					op.setNumeroCompte(compteTVA);
					op.setLibelle(intituleTiers?intituleClient:getIntitule(compteTVA));
					op.setMontantC(montantTVA);

					ecriture.addOperation(op);
				}
			}


			// operation d'escompte

			double montantEscompte = cf.getEscompteM();

			if (montantEscompte>0) {
				Operation op = new Operation();
				op.setDateOp(dateFacture);
				op.setNumPiece(numPiece);
				op.setDateEcheance(echeance);

				op.setNumeroCompte(compteEscompteVE);
				op.setLibelle(intituleTiers?intituleClient:getIntitule(compteEscompteVE));
				op.setMontantD(montantEscompte);

				ecriture.addOperation(op);
			}


			// operation du compte client

			double montantNet = cf.getMontantNet();

			if (montantNet>0) {
				Operation op = new Operation();
				op.setDateOp(dateFacture);
				op.setNumPiece(numPiece);
				op.setDateEcheance(echeance);
				op.setModeRegId(modeRegId);

				op.setNumeroCompte(compteClient);
				op.setLibelle(intituleClient);
				op.setMontantD(montantNet);

				ecriture.addOperation(op);
			}
			
			
			// operation du compte d'acompte + tva ventuelle
			
			double totalTvaAcompte = 0;
			
			psAcomptes.setInt(1, factureId);
			ResultSet rsA = psAcomptes.executeQuery();
			
			while (rsA.next()) {
				
				double mTvaAcompte = rd.round(rsA.getDouble("Montant_TVA"));
				totalTvaAcompte += mTvaAcompte;
				
				if (mTvaAcompte>0) {
				
					String compteTVA = cptesTva.get(rsA.getInt("Code_TVA"));
					
					Operation op = new Operation();
					op.setDateOp(dateFacture);
					op.setNumPiece(numPiece);
					op.setDateEcheance(echeance);

					op.setNumeroCompte(compteTVA);
					op.setLibelle(intituleTiers?intituleClient:getIntitule(compteTVA));
					op.setMontantD(mTvaAcompte);

					ecriture.addOperation(op);
				}
			}
			
			double montantAcompte = rd.round(cf.getAcompte() - totalTvaAcompte);

			if (montantAcompte>0) {
				Operation op = new Operation();
				op.setDateOp(dateFacture);
				op.setNumPiece(numPiece);
				op.setDateEcheance(echeance);

				op.setNumeroCompte(compteAcompteVE);
				op.setLibelle(intituleTiers?intituleClient:getIntitule(compteAcompteVE));
				op.setMontantD(montantAcompte);

				ecriture.addOperation(op);
			}

			validerEcriture(ecriture, factureId, dateFacture);

		} // fin boucle factures

		psArtFact.close();
		psEcheance.close();
		stt.close();
  }


	protected void marquerDocument(int factureId) throws SQLException {

		psMarqueFact.setInt(1, factureId);
		psMarqueFact.executeUpdate();
	}


} // fin TransfertFacturesClient

