/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition de la mise  jour des tarifs
 */

package org.opensi.facturation.actions.majtarifs;


import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.PdfWidths;
import org.opensi.util.pdf.TableBuilder;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;



public class PdfMajTarifs extends MultiPagesDocument {
	
	private static final Font fontLine = new Font(Font.HELVETICA, 8, Font.NORMAL);
	private static final Font fontColonne = new Font(Font.HELVETICA, 8, Font.BOLD);
	private static final Font fontTitre = new Font(Font.HELVETICA, 16, Font.BOLD, Color.WHITE);
	private static final Font fontLegale = new Font(Font.HELVETICA , 7, Font.NORMAL);

	private DataMajTarifs id;	   // les donnes dynamiques des tarifs

	private int element;
	private boolean repercution;
	private float[] widthsCols;
	private int nbCols;
	
	private DecimalFormat numFormat = new DecimalFormat("0.00");
	private DecimalFormat numFormatCap = new DecimalFormat("0.##");
	

	public PdfMajTarifs(String tempdir, DataMajTarifs id) throws Exception {
		
		super(tempdir);
		this.id = id;
		this.element = id.element;
		this.repercution = id.repercution;
		
		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("");
		numFormat.setNegativePrefix("-");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);
		
		numFormatCap.setDecimalFormatSymbols(dfs);
		numFormatCap.setGroupingUsed(true);
		numFormatCap.setGroupingSize(3);
		
		PdfWidths pw = new PdfWidths();
		
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		pw.addColonneVariableMin(1, 10);
		if (element==4) { // Element = PA HT
			pw.addColonneVariableMin(1, 10);
			pw.addColonneVariableMin(1, 10);
		}
		
		nbCols = pw.getNbCols();
		widthsCols = pw.getWidthsCols();

	}
	
	
	
	/* implmentation des fonctions de MultiPagesDocument */
	
	public PdfPTable firstHeader() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeEntete());
		tb.add(makeSpace(10));
		tb.add(makeTitre());
		tb.add(makeSpace(5));
		tb.add(makeEntetesColonnes());
		
		return tb.getTable();	
	}
	
	
	public PdfPTable middleHeader(int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(firstHeader());
		
		return tb.getTable();
	}
	
	
	public PdfPTable lastFooter() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeSpace(3));
		tb.add(makeInfosLegales());
		
		return tb.getTable();
	}
	
	
	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {
			
		TableBuilder tb = new TableBuilder();
		
		tb.add(lastFooter());

		return tb.getTable();		
	}
	
	
	public PdfPTable bodyLine(int numLine) throws DocumentException {
	
		LigneArticle la = id.lignesTarifs.get(numLine);
		
		return makeLine(la);
	}
	
	
	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {
		
		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.TOP);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));		
	
		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}
	
		return pptSpace;
	}
	
	
	public int nbLines() {
		
		return id.getNbLignes();
	}
	
	
	public int nbEx() {
	
		return 1;
	}
	
	
	public Image imageFond() {
	
		return null;
	}
	
	
	
	/* mthodes internes */

	private PdfPTable makeSpace(int space) {
		
		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	
	
	private PdfPTable makeEntete() throws DocumentException {
		
		PdfPTable bandeau = new PdfPTable(1);
	
		bandeau.setWidthPercentage(100);
	
		PdfPTable entete = new PdfPTable(3);
	
		PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());
	
		cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellEntete.setBorder(PdfPCell.NO_BORDER);
		cellEntete.setMinimumHeight(10);
	
		cellEntete.setPhrase(new Phrase("Dossier : "+ id.dossierId, fontLine));
		entete.addCell(cellEntete);
	
		cellEntete.setPhrase(new Phrase(id.raisonSociale, fontLine));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);
	
		cellEntete.setPhrase(new Phrase("Date : " + id.dateCourante, fontLine));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);
	
		cellEntete.setPhrase(new Phrase(id.adresse1, fontLine));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);
	
		cellEntete.setPhrase(new Phrase("", fontLine));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);
	
		cellEntete.setPhrase(new Phrase(id.adresse2, fontLine));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);
	
		cellEntete.setPhrase(new Phrase("Page : "+ currentPage +" / "+ totalPages, fontLine));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);
		
		if (!id.adresse3.equals("")) {
			cellEntete.setPhrase(new Phrase(id.adresse3, fontLine));
			cellEntete.setColspan(2);
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			entete.addCell(cellEntete);
			cellEntete.setColspan(1);
			
			cellEntete.setPhrase(new Phrase("", fontLine));
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			entete.addCell(cellEntete);
		}
	
		cellEntete.setPhrase(new Phrase(id.codePostal +" "+ id.ville, fontLine));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);

		PdfPCell cellBandeau = new PdfPCell(entete);
		cellBandeau.setPadding(10);
	
		bandeau.addCell(cellBandeau);
		
		return bandeau;		
	}
	
	
	private PdfPTable makeTitre() {
		
		PdfPTable pptTitre = new PdfPTable(1);
		pptTitre.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptTitre.getDefaultCell());		
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setBackgroundColor(new Color(175,175,175));
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setFixedHeight(30);
		cell.setPaddingBottom(5);
		cell.setPhrase(new Phrase("M I S E    A    J O U R    D E S    T A R I F S", fontTitre));
		
		pptTitre.addCell(cell);
		
		return pptTitre;	
	}
	
	
	
	private PdfPTable makeEntetesColonnes() throws DocumentException {

		PdfPTable pptCols = new PdfPTable(nbCols);
		pptCols.setWidthPercentage(100);
		pptCols.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptCols.getDefaultCell());
		cell.setMinimumHeight(30);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		
		cell.setPhrase(new Phrase("Code Article", fontColonne));
		pptCols.addCell(cell);
		
		switch (this.element) {
			case 0: // PV HT
				cell.setPhrase(new Phrase("Anc. PV HT 1 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV HT 1 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. PV HT 2 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV HT 2 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. PV HT 3 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV HT 3 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. PV HT 4 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV HT 4 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. PV HT 5 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV HT 5 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
			break;
			case 1: // PV TTC
				cell.setPhrase(new Phrase("Anc. PV TTC 1 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV TTC 1 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. PV TTC 2 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV TTC 2 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. PV TTC 3 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV TTC 3 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. PV TTC 4 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV TTC 4 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. PV TTC 5 (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. PV TTC 5 (\u20AC)", fontColonne));
				pptCols.addCell(cell);
			break;
			case 2: // Coeff
				cell.setPhrase(new Phrase("Anc. Coeff 1", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Coeff 1", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. Coeff 2", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Coeff 2", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. Coeff 3", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Coeff 3", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. Coeff 4", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Coeff 4", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. Coeff 5", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Coeff 5", fontColonne));
				pptCols.addCell(cell);
			break;
			case 3: // Marge HT
				cell.setPhrase(new Phrase("Anc. Marge 1 (%)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Marge 1 (%)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. Marge 2 (%)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Marge 2 (%)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. Marge 3 (%)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Marge 3 (%)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. Marge 4 (%)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Marge 4 (%)", fontColonne));
				pptCols.addCell(cell);
				cell.setPhrase(new Phrase("Anc. Marge 5 (%)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Marge 5 (%)", fontColonne));
				pptCols.addCell(cell);
			break;
			case 4: // PA HT
				cell.setPhrase(new Phrase("Anc. Prix Achat (\u20AC)", fontColonne));
				pptCols.addCell(cell);				
				cell.setPhrase(new Phrase("Nv. Prix Achat (\u20AC)", fontColonne));
				pptCols.addCell(cell);
				
				if (this.repercution) {
					// si la mise  jour des PA est rpercute sur les PV, on affiche les PV HT
					cell.setPhrase(new Phrase("Anc. PV HT 1 (\u20AC)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. PV HT 1 (\u20AC)", fontColonne));
					pptCols.addCell(cell);
					cell.setPhrase(new Phrase("Anc. PV HT 2 (\u20AC)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. PV HT 2 (\u20AC)", fontColonne));
					pptCols.addCell(cell);
					cell.setPhrase(new Phrase("Anc. PV HT 3 (\u20AC)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. PV HT 3 (\u20AC)", fontColonne));
					pptCols.addCell(cell);
					cell.setPhrase(new Phrase("Anc. PV HT 4 (\u20AC)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. PV HT 4 (\u20AC)", fontColonne));
					pptCols.addCell(cell);
					cell.setPhrase(new Phrase("Anc. PV HT 5 (\u20AC)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. PV HT 5 (\u20AC)", fontColonne));
					pptCols.addCell(cell);
				} else {
					// sinon on affiche les marges
					cell.setPhrase(new Phrase("Anc. Marge 1 (%)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. Marge 1 (%)", fontColonne));
					pptCols.addCell(cell);
					cell.setPhrase(new Phrase("Anc. Marge 2 (%)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. Marge 2 (%)", fontColonne));
					pptCols.addCell(cell);
					cell.setPhrase(new Phrase("Anc. Marge 3 (%)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. Marge 3 (%)", fontColonne));
					pptCols.addCell(cell);
					cell.setPhrase(new Phrase("Anc. Marge 4 (%)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. Marge 4 (%)", fontColonne));
					pptCols.addCell(cell);
					cell.setPhrase(new Phrase("Anc. Marge 5 (%)", fontColonne));
					pptCols.addCell(cell);				
					cell.setPhrase(new Phrase("Nv. Marge 5 (%)", fontColonne));
					pptCols.addCell(cell);
				}
			break;
		}

		return pptCols;
	}
	



	private PdfPTable makeLine(LigneArticle la) throws DocumentException {

		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		cell.setPhrase(new Phrase(la.refArticle, fontLine));
		pptLine.addCell(cell);
		
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		
		switch (this.element) {
			case 0: // PV HT
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT1), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT1), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT2), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT2), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT3), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT3), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT4), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT4), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT5), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT5), fontLine));
				pptLine.addCell(cell);
			break;
			case 1: // PV TTC
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifTTC1), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifTTC1), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifTTC2), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifTTC2), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifTTC3), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifTTC3), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifTTC4), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifTTC4), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancTarifTTC5), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvTarifTTC5), fontLine));
				pptLine.addCell(cell);
			break;
			case 2: // Coeff
				cell.setPhrase(new Phrase(numFormat.format(la.ancCoeff1), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvCoeff1), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancCoeff2), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvCoeff2), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancCoeff3), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvCoeff3), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancCoeff4), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvCoeff4), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancCoeff5), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvCoeff5), fontLine));
				pptLine.addCell(cell);
			break;
			case 3: // Marge HT
				cell.setPhrase(new Phrase(numFormat.format(la.ancMarge1), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvMarge1), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancMarge2), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvMarge2), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancMarge3), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvMarge3), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancMarge4), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvMarge4), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.ancMarge5), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvMarge5), fontLine));
				pptLine.addCell(cell);
			break;
			case 4: // PA HT
				cell.setPhrase(new Phrase(numFormat.format(la.ancPrixAchat), fontLine));
				pptLine.addCell(cell);
				cell.setPhrase(new Phrase(numFormat.format(la.nvPrixAchat), fontLine));
				pptLine.addCell(cell);
				
				if (this.repercution) {
					// si la mise  jour des PA est rpercute sur les PV, on affiche les PV HT
					cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT1), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT1), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT2), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT2), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT3), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT3), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT4), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT4), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.ancTarifHT5), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvTarifHT5), fontLine));
					pptLine.addCell(cell);
				} else {
					// sinon on affiche les marges
					cell.setPhrase(new Phrase(numFormat.format(la.ancMarge1), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvMarge1), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.ancMarge2), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvMarge2), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.ancMarge3), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvMarge3), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.ancMarge4), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvMarge4), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.ancMarge5), fontLine));
					pptLine.addCell(cell);
					cell.setPhrase(new Phrase(numFormat.format(la.nvMarge5), fontLine));
					pptLine.addCell(cell);
				}
			break;
		}

		return pptLine;
	}
	
	
	private PdfPTable makeInfosLegales() {
		
		PdfPTable pptLegales = new PdfPTable(1);
		pptLegales.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptLegales.getDefaultCell());		
		
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase(id.raisonSociale +" - "+ id.typeSociete + (id.capital>0?" au capital de "+ numFormatCap.format(id.capital) +" Euros":"") +" - immatricul\u00E9e au RCS "+ id.rcs +" "+ id.siren +" - N\u00B0 TVA : "+ id.tvaIntra, fontLegale));
		
		pptLegales.addCell(cell);
		
		return pptLegales;	
	}


} // fin PdfMajTarifs
