/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tableau des affaires
 */

package org.opensi.facturation.actions.listing;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;


public class ListeArticlesRecus extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		String fichier = r.getParameter("Fichier");
		String buffer = s.getAppConfiguration().get("opensi.absdir") +"/iobuffer/";

		String base = s.getCookie().get("BaseDossier");

		String date_debut = r.getParameter("Date_Debut");
		String date_fin = r.getParameter("Date_Fin");
		String code_fournisseur = r.getParameter("Code_Fournisseur");

		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("R\u00E9f\u00E9rence");
		lf.addToLine("D\u00E9signation");
		lf.addToLine("Date de r\u00E9ception");
		lf.addToLine("N\u00B0 Bon de r\u00E9ception");
		lf.addToLine("N\u00B0 Fournisseur");
		lf.addToLine("Quantit\u00E9");

		Connection con = s.getConnection(null);

		Statement stt = con.createStatement();

		String reqArtRecus = "select ac.Reference, ac.Designation,br.Num_Entier, Date_BR, c.Fournisseur_Id, sum(abr.Quantite) as Quantite";
		reqArtRecus += " from " + base + ".LIGNE_COMMANDE_FOURNISSEUR ac, " + base + ".BON_RECEPTION br," + base + ".LIGNE_BON_RECEPTION abr, " + base + ".COMMANDE_FOURNISSEUR c";
		reqArtRecus += " where abr.BR_Id = br.BR_Id and ac.Ligne_Id=abr.Ref_Ligne";
		reqArtRecus += " and ac.Commande_Id = c.Commande_Id";
		reqArtRecus += " and br.Etat='V' and ac.Type_Ligne='S'";
		if (!date_debut.equals("")) {
			reqArtRecus += " and br.Date_BR >="+ DateTime.parseDate(date_debut, "yyyy:MM:dd");
			if (!date_fin.equals("")) {
				reqArtRecus += " and br.Date_BR <="+ DateTime.parseDate(date_fin, "yyyy:MM:dd");
			}
		}
		
		if (!code_fournisseur.equals("0")) {
			reqArtRecus += " and c.Fournisseur_Id = '" + code_fournisseur + "'";
		}

		reqArtRecus += " group by ac.Reference,br.Num_Entier having Quantite>0 order by ac.Reference,Date_BR";

		ResultSet rset = stt.executeQuery(reqArtRecus);

		while (rset.next()) {
			lf.newLine();
			lf.addToLine(rset.getString("Reference"));
			lf.addToLine(rset.getString("Designation"));
			lf.addToLine(DateTime.formatTime(rset.getLong("Date_BR"), "dd/MM/yyyy"));
			lf.addToLine(rset.getString("Num_Entier"));
			lf.addToLine(rset.getString("Fournisseur_Id"));
			lf.addToLine(rset.getString("Quantite").replaceAll("\\.", ","));
		}

		lf.write(buffer, fichier, true);

		s.closeConnection(con, null);

		return true;

	} // fin service


} // fin ListeArticlesRecus
