/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tableau des affaires
 */

package org.opensi.facturation.actions.listing;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.DateTime;


public class ListeArticlesEnAttente extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		String fichier = r.getParameter("Fichier");
		String buffer = s.getAppConfiguration().get("opensi.absdir") +"/iobuffer/";
		
		String fournisseurId = r.getParameter("Fournisseur_Id");

		String base = s.getCookie().get("BaseDossier");
		
		Arrondi arrondi = new Arrondi(2);

		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("R\u00E9f\u00E9rence");
		lf.addToLine("D\u00E9signation");
		lf.addToLine("Date de commande");
		lf.addToLine("N\u00B0 Commande");
		lf.addToLine("N\u00B0 Fournisseur");
		lf.addToLine("Quantit\u00E9");
		lf.addToLine("Valeur");

		Connection con = s.getConnection(null);

		String getArtAtt = "select ac.Reference, ac.Designation, ac.Prix, c.Date_Commande, c.Num_Entier, c.Fournisseur_Id, sum(ac.Quantite)- BON.BR as Quantite";
		getArtAtt += " from (select ac.Reference, ac.Prix, c.Num_Entier,coalesce(sum(abr.Quantite),0) as BR";
		getArtAtt += " from " + base + ".COMMANDE_FOURNISSEUR c, " + base + ".LIGNE_COMMANDE_FOURNISSEUR ac   left join " + base + ".LIGNE_BON_RECEPTION abr on ac.ligne_Id=abr.Ref_Ligne left join " + base + ".BON_RECEPTION br on br.BR_Id=abr.BR_Id and br.Etat='V'";  
		getArtAtt += " where ac.Commande_Id=c.Commande_Id   and c.Etat='V'   and ac.Type_Ligne='S'";
		getArtAtt += " group by Reference, Prix, c.Num_Entier order by Reference) as BON," + base + ".COMMANDE_FOURNISSEUR c, " + base + ".LIGNE_COMMANDE_FOURNISSEUR ac";
		getArtAtt += " where ac.Commande_Id=c.Commande_Id   and c.Etat='V'   and ac.Type_Ligne='S'";
		getArtAtt += " and BON.Reference=ac.Reference and BON.Num_Entier=c.Num_Entier";
		
		if (!fournisseurId.equals("T")) {
			getArtAtt += " and c.Fournisseur_Id=?";
		}
		
		getArtAtt += " group by Reference, Prix, c.Num_Entier ";
		getArtAtt += " having Quantite>0 order by Reference";

		PreparedStatement psArtAtt = con.prepareStatement(getArtAtt);
		if (!fournisseurId.equals("T")) {
			psArtAtt.setString(1, fournisseurId);
		}
		ResultSet rset = psArtAtt.executeQuery();

		while (rset.next()) {
			double valeur = arrondi.round(rset.getDouble("Prix")*rset.getDouble("Quantite"));
			
			lf.newLine();
			lf.addToLine(rset.getString("Reference"));
			lf.addToLine(rset.getString("Designation"));
			lf.addToLine(DateTime.formatTime(rset.getLong("Date_Commande"), "dd/MM/yyyy"));
			lf.addToLine(rset.getString("Num_Entier"));
			lf.addToLine(rset.getString("Fournisseur_Id"));
			lf.addToLine(rset.getString("Quantite").replaceAll("\\.", ","));
			lf.addToLine((""+valeur).replaceAll("\\.", ","));
		}
		rset.close();
		psArtAtt.close();

		lf.write(buffer, fichier, true);

		s.closeConnection(con, null);

		return true;

	} // fin service


} // fin ListeArticlesEnAttente
