/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Ventilation des bases HT et TTC par taux de TVA
 */

package org.opensi.facturation.actions.editions;

import org.opensi.util.tools.Arrondi;


public class VentilTVA {

	protected double tauxTVA;
	protected double montantHT = 0;
	protected double montantTVA = 0;
	protected double montantTTC = 0;
	protected boolean npr = false;
	
	
	private Arrondi r = new Arrondi(2);
	


	public VentilTVA(double tauxTVA, double montantBase, boolean ttc) {

		this.tauxTVA = tauxTVA;

		this.add(montantBase, ttc, 0);    
	}
	
	public VentilTVA(double tauxTVA, double montantHT, double montantTVA, double montantTTC) {

		this.tauxTVA = tauxTVA;

		this.add(montantHT, montantTVA, montantTTC);    
	}
	
	
	public VentilTVA(double tauxTVA, double montantBase, boolean ttc, double tauxEscompte) {

		this.tauxTVA = tauxTVA;

		this.add(montantBase, ttc, tauxEscompte);    
	}


	public void add(double montantBase, boolean ttc) {
	
		this.add(montantBase, ttc, 0); 
	}


	public void add(double montantBase, boolean ttc, double tauxEscompte) {
	
		if (ttc) {
			this.montantTTC = r.round(this.montantTTC + montantBase * (1 - tauxEscompte/100));
			double tva = r.round(montantBase * (this.tauxTVA/100) / (1 + this.tauxTVA/100));
			this.montantTVA = r.round(this.montantTVA + tva);
			this.montantHT = r.round(this.montantHT + montantBase - tva);
		}
		else {
			this.montantHT = r.round(this.montantHT + montantBase);
			double tva = r.round(montantBase * (this.tauxTVA/100));
			this.montantTVA = r.round(this.montantTVA + tva);
			this.montantTTC = r.round(this.montantTTC + (montantBase + tva) * (1 - tauxEscompte/100));
		} 
	}

	public void add(double montantHT, double montantTVA, double montantTTC) {
		
			this.montantHT += montantHT;
			this.montantTVA += montantTVA;
			this.montantTTC += montantTTC;
			
			this.montantHT = r.round(this.montantHT);
			this.montantTVA = r.round(this.montantTVA);
			this.montantTTC = r.round(this.montantTTC);
			
	}

	public void setNPR(boolean npr) {
    this.npr = npr;
	}
	
} // fin VentilTVA
