/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste de clients en pdf
 */

package org.opensi.facturation.actions.editions;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.TableBuilder;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class PdfListeClients extends MultiPagesDocument {

	private static final Font font9N = new Font(Font.HELVETICA, 9, Font.NORMAL);
	private static final Font font9G = new Font(Font.HELVETICA, 9, Font.BOLD);
	
	private DataListeClients dlc;	   // les donnes dynamiques de la liste des clients

	private DecimalFormat numFormat = new DecimalFormat("0.00");

	private int[] widthsCols;
	private int nbCols;
	
	
	public PdfListeClients(String tempdir, DataListeClients dlc) throws Exception {

		super(tempdir);
		
		this.dlc = dlc;
		
		if (!dlc.familleClient.equals("")) {
			nbCols = 6;
			int widths6[] = {15,21,27,6,17,14};
			widthsCols = widths6;
		} else {
			nbCols = 7;
			int widths7[] = {11,12,19,23,6,15,14};
			widthsCols = widths7;
		}

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("");
		numFormat.setNegativePrefix("-");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);
	}
	
	
	/* implmentation des fonctions de MultiPagesDocument */
	
	public PdfPTable firstHeader() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeEntete());
		tb.add(makeSpace(10));
		tb.add(makeEntetesColonnes());
		tb.add(makeSpace(5));
		
		return tb.getTable();	
	}
	
	
	public PdfPTable middleHeader(int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(firstHeader());
		
		return tb.getTable();
	}
	
	
	public PdfPTable lastFooter() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		if (this.nbLines() > 0)
			tb.add(makeFinPage());
		
		return tb.getTable();
	}
	
	
	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {
			
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeFinPage());
		
		return tb.getTable();		
	}
	
	
	public PdfPTable bodyLine(int numLine) throws DocumentException {
	
		LigneListeClients llc = dlc.lignes.get(numLine);
		
		return makeLine(llc);
	}
	
	
	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {
		
		PdfPTable pptSpace = new PdfPTable(nbCols);	
		return pptSpace;
	}
	
	
	public int nbLines() {
		
		return dlc.getNbLignes();
	}
	
	
	public int nbEx() {
	
		return 1;
	}
	
	
	public Image imageFond() {
	
		return null;
	}
	
	
	/* mthodes internes */	

	private PdfPTable makeSpace(int space) {
	
		PdfPTable pptSpace = new PdfPTable(1);
		pptSpace.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	
	
	private PdfPTable makeEntete() throws DocumentException {
		PdfPTable bandeau = new PdfPTable(1);

		bandeau.setWidthPercentage(100);

		PdfPTable entete = new PdfPTable(3);

		PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

		cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellEntete.setBorder(PdfPCell.NO_BORDER);
		cellEntete.setMinimumHeight(10);

		cellEntete.setPhrase(new Phrase("Dossier : "+ dlc.dossierId, font9N));
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dlc.raisonSociale, font9N));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("Date : " + dlc.dateCourante, font9N));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dlc.adresse1, font9N));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("", font9N));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dlc.adresse2, font9N));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("Page : "+ currentPage +" / "+ totalPages, font9N));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);
		
		if (!dlc.adresse3.equals("")) {
			cellEntete.setPhrase(new Phrase(dlc.adresse3, font9N));
			cellEntete.setColspan(2);
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			entete.addCell(cellEntete);
			cellEntete.setColspan(1);
			
			cellEntete.setPhrase(new Phrase("", font9N));
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			entete.addCell(cellEntete);
		}

		cellEntete.setPhrase(new Phrase(dlc.codePostal +" "+ dlc.ville, font9N));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase("Liste des clients"+ dlc.clientsDe, new Font(Font.HELVETICA, 16, Font.BOLD)));
		cellEntete.setColspan(3);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(""));
		cellEntete.setFixedHeight(10);
		entete.addCell(cellEntete);

		if (dlc.criteres.length()>0) {
			cellEntete.setPhrase(new Phrase(dlc.criteres, font9N));
			cellEntete.setMinimumHeight(0);
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			entete.addCell(cellEntete);
		}

		PdfPCell cellBandeau = new PdfPCell(entete);
		cellBandeau.setPadding(10);

		bandeau.addCell(cellBandeau);
		
		return bandeau;
		
	}
	
	
	private PdfPTable makeEntetesColonnes() throws DocumentException {
		PdfPTable pptCols = new PdfPTable(nbCols);
		pptCols.setWidthPercentage(100);
		pptCols.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptCols.getDefaultCell());
		cell.setMinimumHeight(30);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		if (nbCols==7) {
			cell.setPhrase(new Phrase("Famille", font9G));
			pptCols.addCell(cell);
		}

		cell.setPhrase(new Phrase("Num\u00E9ro", font9G));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("Client", font9G));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("Adresse", font9G));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("CP", font9G));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("Ville", font9G));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("T\u00E9l.", font9G));
		pptCols.addCell(cell);

		return pptCols;
	}
	
	
	private PdfPTable makeFinPage() {
		
		PdfPTable pptFP = new PdfPTable(1);
		pptFP.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptFP.getDefaultCell());
		cell.setBorder(PdfPCell.TOP);
		cell.setPhrase(new Phrase(""));
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(1);
				
		pptFP.addCell(cell);
	
		return pptFP;
	}
	
	
	private PdfPTable makeLine(LigneListeClients llc) throws DocumentException {
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		if (nbCols==7) {
			cell.setPhrase(new Phrase(llc.famille, font9N));
			pptLine.addCell(cell);
		}

		cell.setPhrase(new Phrase(llc.numero, font9N));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(llc.client, font9N));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(llc.adresse, font9N));
		pptLine.addCell(cell);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase(llc.cp, font9N));
		pptLine.addCell(cell);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase(llc.ville, font9N));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(llc.tel, font9N));
		pptLine.addCell(cell);
		
		return pptLine;
	}



} // fin PdfListeClients
