/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tableau de chiffre d'affaires par code stats
 */

package org.opensi.facturation.actions.editions;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;

public class GenStatistiquesMA extends Action {

	public boolean serverSide() { return true; }
	
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		
		String fichierCsv = r.getParameter("FichierCsv") != null ? r.getParameter("FichierCsv") : "";
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		
		String periode =  r.getParameter("Periode");
		
		
		long debutPeriode = 0;
		long debutNmoins1=0;
		long finPeriode = 0;
		long finNmoins1=0;
		DataStatistiquesMA dsc = null;
		if (periode.equals("AP")) {
			debutPeriode = DateTime.parseDate(r.getParameter("DateDebut"), "yyyy:MM:dd");
			finPeriode = DateTime.parseDate(r.getParameter("DateFin"), "yyyy:MM:dd");
			DateTime dtDeb = new DateTime(debutPeriode);
			int anneeDeb = dtDeb.getYear();
			dtDeb.setYear(anneeDeb-1);
			debutNmoins1=dtDeb.getDateInMillis();
			
			DateTime dtFin = new DateTime(finPeriode);
			int anneeFin = dtFin.getYear();
			dtFin.setYear(anneeFin-1);
			finNmoins1=dtFin.getDateInMillis();
			System.out.println(" debutNmoins1 " + debutNmoins1 + " finNmoins1 "+ finNmoins1);
			dsc = new DataStatistiquesMA(s, debutPeriode, finPeriode,debutNmoins1, finNmoins1 );
		}
		else if (periode.equals("MP")) {
			debutPeriode = DateTime.parseDate(r.getParameter("Mois"), "yyyy:MM:dd");
			DateTime dtFin = new DateTime(debutPeriode);
			dtFin.setDay(dtFin.currentMaxDay());
			finPeriode=dtFin.getDateInMillis();
			
			DateTime dtDeb2= new DateTime(debutPeriode);
			dtDeb2.addMonth(-1);
			debutNmoins1=dtDeb2.getDateInMillis();
			dtDeb2.setDay(dtDeb2.currentMaxDay());
			finNmoins1=dtDeb2.getDateInMillis();
			
			System.out.println(" debutPeriode " + debutPeriode + "finPeriode" +finPeriode+ " debutNmoins1" + debutNmoins1 + " finNmoins1 " + finNmoins1);
			dsc = new DataStatistiquesMA(s, debutPeriode, finPeriode,debutNmoins1, finNmoins1 );
		}
		
		
		
		if (!fichierCsv.equals("")) {
			// Cration d'un CSV
			String buffer = absdir +"/iobuffer/";
			new CsvStatistiquesMA(buffer, fichierCsv, dsc);
		}
		
		return true;
	}

} // fin GenStatistiquesCA
