/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tat de stock (mouvements)
 */

package org.opensi.facturation.actions.editions;

import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class EtatMvtStock extends Action {


	class MyPageEvent implements PdfPageEvent {

		private String dossierId;
		private String raisonSociale;
		private String adresse1;
		private String adresse2;
		private String adresse3;
		private String codePostal;
		private String ville;
		private String monnaie;

		private String finPeriodeStr;
		private String debutPeriodeStr;
		private String dateCourante;

		private Phrase titreVal;


		public MyPageEvent(String dossierId, long debutPeriode, long finPeriode, Phrase titreVal) {

			this.titreVal = titreVal;
			this.dossierId = dossierId;

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ base +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";

			try {

				Statement stt = con.createStatement();
				ResultSet rset = stt.executeQuery(reqLeDossier);

				rset.next();

				this.raisonSociale = rset.getString("Denomination");
				this.adresse1 = rset.getString("Adresse_1");
				this.adresse2 = rset.getString("Adresse_2");
				this.adresse3 = rset.getString("Adresse_3");
				this.codePostal = rset.getString("Code_Postal");
				this.ville = rset.getString("Ville");
				this.monnaie = rset.getString("Devise");

				rset.close();				

				stt.close();
			}
			catch(SQLException sqle) {sqle.printStackTrace();	}
			catch(Exception e) { e.printStackTrace();	}

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			finPeriodeStr = formatDate.format(new Date(finPeriode));
			debutPeriodeStr = formatDate.format(new Date(debutPeriode));
		}


		public void onStartPage(PdfWriter writer, Document document) {

			try {

				// Entete Gnrale

				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorder(PdfPCell.NO_BORDER);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : "+ this.dossierId, font9N));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.raisonSociale, font9N));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, font9N));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse1, font9N));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("", font9N));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse2, font9N));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), font9N));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);
				
				if (!this.adresse3.equals("")) {
					cellEntete.setPhrase(new Phrase(this.adresse3, font9N));
					cellEntete.setColspan(2);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
					entete.addCell(cellEntete);
					cellEntete.setColspan(1);
					
					cellEntete.setPhrase(new Phrase("", font9N));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
					entete.addCell(cellEntete);
				}

				cellEntete.setPhrase(new Phrase(this.codePostal +" "+ this.ville, font9N));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Mouvements de stock en "+ this.monnaie, new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(5);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(titreVal);
				cellEntete.setMinimumHeight(0);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("P\u00E9riode du "+ this.debutPeriodeStr +" au "+ this.finPeriodeStr, font9N));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale


				// Titres de colonnes

				document.add(space(10));
				//document.add(ligneTitres());
				//document.add(space(5));

			}
			catch(DocumentException de) {	de.printStackTrace();}
		}

		public void onOpenDocument(PdfWriter writer, Document document) {}
		public void onEndPage(PdfWriter writer, Document document) {}
		public void onCloseDocument(PdfWriter writer, Document document) {}
		public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
		public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
		public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
		public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}
	}


	private static final Font font9N = new Font(Font.HELVETICA, 9, Font.NORMAL);
	private static final Font font9G = new Font(Font.HELVETICA, 9, Font.BOLD);
	private static final Font font7N = new Font(Font.HELVETICA, 7, Font.NORMAL);


	private DecimalFormat numFormat = new DecimalFormat("0.00");
	private DecimalFormat numFormatQte = new DecimalFormat("0.###");
	private SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");

	private int[] widths;
	private int nbCols;
	private Connection con;
	private String nomArticle;
	private String refArticle;
	private String base;


	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("");
		numFormat.setNegativePrefix("-");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);
		
		numFormatQte.setDecimalFormatSymbols(dfs);
		numFormatQte.setNegativeSuffix("");
		numFormatQte.setNegativePrefix("-");
		numFormatQte.setPositiveSuffix(" ");
		numFormatQte.setGroupingUsed(true);
		numFormatQte.setGroupingSize(3);

		base = s.getCookie().get("BaseDossier");

		// critres
		int famille1 = Integer.parseInt(r.getParameter("Famille_1"));
		int famille2 = Integer.parseInt(r.getParameter("Famille_2"));
		int famille3 = Integer.parseInt(r.getParameter("Famille_3"));
		int marque = Integer.parseInt(r.getParameter("Marque"));


		String formattedDate = "";

		Phrase titreVal = new Phrase();


		Chunk ch1 = new Chunk("FICHE DE STOCK EN COUT UNITAIRE MOYEN PONDERE en fin de p\u00E9riode", font9G);

		titreVal.add(ch1);


		Document document = new Document(PageSize.A4, 30, 20, 20, 20);
		String chemin = s.getAppConfiguration().get("opensi.absdir") +"/pdf/";
		String fichierPdf = chemin + r.getParameter("FichierPdf");

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(fichierPdf));

		int widths11[] = {10,10,7,11,9,7,11,9,7,10,9};
		widths = widths11;

		nbCols = widths.length;

		//periode totale

		String periode = r.getParameter("Periode");
		long  debutPeriode=0;
		long  finPeriode=0;
		DateTime dtDeb = new DateTime();
		DateTime dtFin = new DateTime();
		if (periode.equals("DD")) {
			dtDeb.setTimeInMillis(DateTime.parseDate(r.getParameter("DateDebut"), "yyyy:MM:dd"));
			dtFin.setTimeInMillis(DateTime.parseDate(r.getParameter("DateFin"), "yyyy:MM:dd"));
		}

		else {
			DateTime cd = new DateTime();
			int currentYear = cd.getYear();
			int currentMonth = cd.getMonth();

			if (periode.equals("AC")) {
				dtDeb = new DateTime(1, 1, currentYear);
				dtFin = new DateTime(31, 12, currentYear);
			}
			else if (periode.equals("AP")) {
				dtDeb = new DateTime(1, 1, currentYear-1);
				dtFin = new DateTime(31, 12, currentYear-1);
			}
			else if (periode.equals("MC")) {
				dtDeb = new DateTime(1, currentMonth, currentYear);
				dtFin = new DateTime(cd.currentMaxDay(), currentMonth, currentYear);
			}
			else if (periode.equals("MP")) {
				dtDeb = new DateTime(1, currentMonth-1, currentYear);
				dtFin = new DateTime(cd.previousMaxDay(), currentMonth-1, currentYear);
			}
		}
		debutPeriode=dtDeb.getDateInMillis();
		finPeriode=dtFin.getDateFullTime();

		String mvte=r.getParameter("mvte");
		MyPageEvent event = new MyPageEvent(s.getCookie().get("Dossier_Id"), debutPeriode, finPeriode, titreVal);
		writer.setPageEvent(event);
		if (!document.isOpen()) {
			document.open();
		}
		String reqArticles = "select Article_Id, Designation from "+ base +".FICHE_ARTICLE where 1 ";

		if (famille1 != 0) {
			reqArticles += " and Famille_1="+ famille1;
			if (famille2 != 0) {
				reqArticles += " and Famille_2="+ famille2;
				if (famille3 != 0) {
					reqArticles += " and Famille_3="+ famille3;
				}
			}
		}

		if (marque != 0) {
			reqArticles += " and Marque_Id="+ marque;
		}

		reqArticles += " order by Article_Id";
		Statement stt = con.createStatement();	
		ResultSet rsArt = stt.executeQuery(reqArticles);


		//priode de 1 mois pour chaque calcul de CUMP - reinitialisation de dtDEB et dtFin pour chaque article
		double montantTotE=0;
		double montantTotS=0;
		double montantS=0;
		
		PreparedStatement psVt = con.prepareStatement("select Periode, Valorisation, Quantite from "+ base +".STOCK_ANOUVEAU s join "+ base +".FICHE_ARTICLE fa on s.Article_Id=fa.Fiche_Article_Id where fa.Article_Id=? and Periode<=? order by Periode desc limit 1");
		PreparedStatement psMvt = con.prepareStatement("select Date_Mvt, Quantite, Prix_HT, Type_Mvt, Num_Piece, Libelle from "+ base +".MVT_STOCK where Article_Id=? and Date_Mvt<=? and Date_Mvt>=? order by Date_Mvt, Type_Mvt");
		PreparedStatement psCmvtP = con.prepareStatement("select count(Date_Mvt) from "+ base +".MVT_STOCK where Article_Id=? and Date_Mvt<=? and Date_Mvt>=? order by Date_Mvt, Type_Mvt");
		PreparedStatement pspuSMvt = con.prepareStatement("select sum(Prix_HT * Quantite), sum(Quantite) from "+ base +".MVT_STOCK where Article_Id=? and Date_Mvt<=? and Date_Mvt>=? and Type_Mvt='E'");
		

		while (rsArt.next()) {
			
			refArticle = rsArt.getString("Article_Id");
			nomArticle = rsArt.getString("Designation");
			long pini = 0;
			long pfin = 0;
			
			pspuSMvt.setString(1, refArticle);			
			psMvt.setString(1, refArticle);			
			psVt.setString(1, refArticle);
			psVt.setLong(2, debutPeriode);
			
			psCmvtP.setString(1, refArticle);
			psCmvtP.setLong(2, finPeriode);
			psCmvtP.setLong(3, debutPeriode);
			ResultSet rsCmvtP = psCmvtP.executeQuery();

			int countP = 0;
			if (rsCmvtP.next()) {	
				countP=rsCmvtP.getInt(1);
			}
			//si l'article est mouvement sur la priode totale	
			if (countP>0 || mvte.equals("1")) {
				document.add(ligneTitreArt());
				dtDeb.setTimeInMillis(debutPeriode);
				while (pfin<=finPeriode) {
					pini = dtDeb.getDateInMillis();									
					SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
					formattedDate = formatter.format(dtDeb.getTimeInMillis());
					pfin = dtDeb.addMonth(1)-1;
					
					if (pfin<=finPeriode) {
								
						psCmvtP.setLong(2, pfin);
						psCmvtP.setLong(3, pini);	
						ResultSet rsCmvt = psCmvtP.executeQuery();
						int count=0;
	
						while (rsCmvt.next()) {	
							count=rsCmvt.getInt(1);
						}
	
						//si l'article est mouvement sur le mois
						if (count>0){
	
							document.add(ligneTitres(formattedDate));
																
							pspuSMvt.setLong(2, pfin);
							pspuSMvt.setLong(3, pini); 
							ResultSet rsSum = pspuSMvt.executeQuery();
							double puSortie = 0;
							double cmontantE = 0;
							double cqteE = 0;
							if (rsSum.next()) {
								cmontantE=rsSum.getDouble(1);
								cqteE=rsSum.getDouble(2);
							}
	
							ResultSet rsVt = psVt.executeQuery();
							double qteVt=0;
							double puVt=0;
							if (rsVt.next()) {						
								qteVt=rsVt.getDouble("Quantite");					    
								puVt= rsVt.getDouble("Valorisation");
							}												
							rsVt.close();
							if (qteVt>0) {
								document.add(ligneAN(debutPeriode, qteVt, puVt));
							}
							else{
								qteVt=0;
								puVt=0;
							}
							double totqteE =0;
							double totPUE =0;
							double totqteS =0;
							double qte =0;
							double pu =0;
							puSortie=(cmontantE + (qteVt * puVt))/ (cqteE + qteVt);
								
							psMvt.setLong(2, pfin);
							psMvt.setLong(3, pini);
							ResultSet rset = psMvt.executeQuery();
							double qteStock=qteVt;
							double montantStock=qteVt*puVt;
							while (rset.next()) {
								long date = rset.getLong("Date_Mvt");				
								String piece = rset.getString("Num_Piece");
								String libelle = rset.getString("Libelle");
								String type = rset.getString("Type_Mvt");									
								double montantE;
	
								// si c'est une entre 
								if (type.equals("E")) {
									qte = rset.getDouble("Quantite");			
									pu = rset.getDouble("Prix_HT");
									totqteE = totqteE + qte;
									totPUE = totPUE + pu;
									montantE=pu*qte;
									montantTotE=montantTotE+montantE;
									qteStock=qteStock + qte;
									montantStock=montantStock +montantE;
									montantE=0;
								}
								// si c'est une sortie
								else {
									qte = rset.getDouble("Quantite");
									pu=puSortie;
									totqteS = totqteS + qte;
									montantS=pu*qte;
									montantTotS=montantTotS + montantS;
									qteStock=qteStock - qte;
									montantStock=montantStock - montantS;
									montantS=0;
								}
	
	
								document.add(ligneMvt(date, type, piece, libelle, qte, pu,puSortie, qteStock, montantStock));
								qte=0;
								pu=0;
								date=0;
								piece="";
								libelle="";
	
	
							}
							//on ajoute la ligne de stock initial
	
							montantTotE=montantTotE + (qteVt*puVt);
	
							totqteE=totqteE+qteVt;
							document.add(ligneTotalPeriode(totqteE, montantTotE, totqteS,puSortie, montantTotS));
							totqteE=0;
							montantTotE=0;
							totqteS=0;
							puSortie=0;
							montantTotS=0;
							rset.close();							
							qteStock=0;
							montantStock=0;
						}
					}
				}
				document.add(space(20));
			}
		}
		rsArt.close();
		stt.close();
		
		psVt.close();
		psMvt.close();
		psCmvtP.close(); 
		pspuSMvt.close();
		
		if (document.isOpen()) {
			document.close();
		}

		s.closeConnection(con, null);


		try {
			File filePdf = new File(fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}

		return true;


	} // fin service

	private PdfPTable ligneTitreArt() throws DocumentException {
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widths);


		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setMinimumHeight(20);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setColspan(4);
		cell.setPhrase(new Phrase("R\u00E9f\u00E9rence : " +  refArticle , font9G));
		pptLine.addCell(cell);

		cell.setColspan(7);
		cell.setPhrase(new Phrase("Article : " + nomArticle, font9G));
		pptLine.addCell(cell);

		return pptLine;
	}

	private PdfPTable ligneTitres(String formattedDate) throws DocumentException {

		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widths);


		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setMinimumHeight(20);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		/*cell.setColspan(11);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("FICHE DE STOCK EN COUT UNITAIRE MOYEN PONDERE en fin de p\u00E9riode", font9G));
		pptLine.addCell(cell);

		cell.setMinimumHeight(20);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);*/
		/*2eme ligne*/



		cell.setColspan(11);
		cell.setPhrase(new Phrase("P\u00E9riode : " +  formattedDate , font9G));
		pptLine.addCell(cell);

		/*cell.setColspan(2);
		cell.setPhrase(new Phrase("Fournisseur : ", font9G));
		pptLine.addCell(cell);
		cell.setColspan(4);
		cell.setPhrase(new Phrase(" ", font9G));
		pptLine.addCell(cell);

		/*3eme ligne
		cell.setColspan(1);
		cell.setPhrase(new Phrase("Mois : ", font9G));
		pptLine.addCell(cell);


		cell.setPhrase(new Phrase(" ", font9G));
		pptLine.addCell(cell);

		cell.setColspan(3);
		cell.setPhrase(new Phrase("Stock minimum ", font9G));
		pptLine.addCell(cell);

		cell.setColspan(1);
		cell.setPhrase(new Phrase(" ", font9G));
		pptLine.addCell(cell);

		cell.setColspan(3);
		cell.setPhrase(new Phrase("Stock maximum : ", font9G));
		pptLine.addCell(cell);
		cell.setColspan(1);
		cell.setPhrase(new Phrase(" ", font9G));
		pptLine.addCell(cell);

		cell.setColspan(2);
		cell.setPhrase(new Phrase(" ", font9G));
		pptLine.addCell(cell);*/

		/*4eme ligne et 5 eme ligne*/
		cell.setMinimumHeight(17);
		cell.setColspan(1);
		cell.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
		cell.setPhrase(new Phrase("Date", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("N\u00B0 Pi\u00E8ce  / Libell\u00E9 ", font9G));
		pptLine.addCell(cell);

		cell.setBorder(PdfPCell.BOX);
		cell.setColspan(3);
		cell.setPhrase(new Phrase("Entr\u00E9es", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("Sorties", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("Stocks", font9G));
		pptLine.addCell(cell);

		cell.setColspan(1);
		cell.setBorder(PdfPCell.BOX - PdfPCell.TOP);
		cell.setPhrase(new Phrase("", font9G));
		pptLine.addCell(cell);
		pptLine.addCell(cell);

		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("Qt\u00E9", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("PU HT", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("Montant", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("Qt\u00E9", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("PU HT", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("Montant", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("Qt\u00E9", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("PU HT", font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("Montant", font9G));
		pptLine.addCell(cell);

		return pptLine;
	}

	private PdfPTable ligneMvt(long date, String type, String numpiece, String libelle, double qte, double pu, double puSortie, double qteStock, double montantStock ) throws DocumentException {

		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widths);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setPadding(2);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase(formatDate.format(new Date(date)), font9N));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numpiece +" " + libelle  , font7N));
		pptLine.addCell(cell);

		double montant = 0;
		montant=pu * qte;

		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);

		if (type.equals("E")) {

			cell.setPhrase(new Phrase(numFormatQte.format(qte), font9N));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(pu), font9N));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(montant), font9N));
			pptLine.addCell(cell);

			cell.setPhrase(new Phrase("", font9N));
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormatQte.format(qteStock), font9N));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(puSortie), font9N));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(montantStock), font9N));
			pptLine.addCell(cell);

		}
		else {

			cell.setPhrase(new Phrase("", font9N));
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			pptLine.addCell(cell);

			cell.setPhrase(new Phrase(numFormatQte.format(qte), font9N));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(pu), font9N));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(montant), font9N));
			pptLine.addCell(cell);

			cell.setPhrase(new Phrase(numFormatQte.format(qteStock), font9N));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(puSortie), font9N));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(montantStock), font9N));
			pptLine.addCell(cell);

		}



		return pptLine;
	}


	private PdfPTable ligneTotalPeriode(double totqteE, double montantTotE, double totqteS, double puSortie, double montantS) throws DocumentException {

		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widths);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setPadding(2);

		cell.setColspan(2);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase("Totaux", font9G));
		pptLine.addCell(cell);

		cell.setColspan(1);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);

		cell.setPhrase(new Phrase(numFormatQte.format(totqteE), font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numFormat.format(montantTotE/totqteE), font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numFormat.format(montantTotE), font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numFormatQte.format(totqteS), font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numFormat.format(puSortie), font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numFormat.format(montantS), font9G));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numFormatQte.format(totqteE - totqteS ), font9G));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(puSortie ), font9G));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(montantTotE - montantS ), font9G));
		pptLine.addCell(cell);

		return pptLine;
	}


	private PdfPTable ligneAN(long date, double qteEval, double puEval) throws DocumentException {

		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widths);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setPadding(2);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase(formatDate.format(new Date(date)), font9N));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase("Stock initial", font9N));
		pptLine.addCell(cell);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPhrase(new Phrase(numFormatQte.format(qteEval), font9N));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numFormat.format(puEval), font9N));
		pptLine.addCell(cell);

		double montantEval = qteEval * puEval;

		cell.setPhrase(new Phrase(numFormat.format(montantEval), font9N));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(""));
		pptLine.addCell(cell);
		pptLine.addCell(cell);
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numFormatQte.format(qteEval), font9N));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(numFormat.format(puEval), font9N));
		pptLine.addCell(cell);


		cell.setPhrase(new Phrase(numFormat.format(montantEval), font9N));
		pptLine.addCell(cell);

		return pptLine;
	}



	private PdfPTable space(int space) throws DocumentException {

		PdfPTable sectionSpace = new PdfPTable(1);
		sectionSpace.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(sectionSpace.getDefaultCell());

		cell.setPhrase(new Phrase(""));
		cell.setFixedHeight(space);
		cell.setBorder(PdfPCell.NO_BORDER);
		sectionSpace.addCell(cell);

		return sectionSpace;
	}



} // fin EtatMvtStock
