/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un palmars client
 */

package org.opensi.facturation.actions.editions;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;


public class DataPalmaresClient {
	
	// les lignes du palmars client
	protected ArrayList<LignePalmaresClient> lignes = new ArrayList<LignePalmaresClient>(10);
	
	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String monnaie;

	String familleClient = "";
	String commercial;
	String typeDetail;
	String tarifsSpe;
	protected String finPeriodeStr;
	protected String debutPeriodeStr;
	protected String dateCourante;
	protected String criteres = "";
	protected boolean detail;
	protected String titreDetail;
	protected String titreDetailCsv;
		
	
	public DataPalmaresClient(Session s, long debutPeriode, long finPeriode, int familleId, String commercial, String typeDetail, String tarifsSpe) {
		
		try {
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();

			this.dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			
			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finPeriodeStr = formatDate.format(new Date(finPeriode));
			this.debutPeriodeStr = formatDate.format(new Date(debutPeriode));
			this.commercial = commercial;
			this.typeDetail = typeDetail;
			this.tarifsSpe = tarifsSpe;
			this.detail = !typeDetail.equals("N");
			
			ResultSet rset;
			
			if (familleId != 0) {
				String reqFamille = "select Libelle from "+ base +".FAMILLE_CLIENT where Famille_Id="+ familleId;
				rset = stt.executeQuery(reqFamille);
				rset.next();
				this.familleClient = rset.getString("Libelle");
				rset.close();
			}
			
			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ base +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";
			rset = stt.executeQuery(reqLeDossier);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");
			rset.close();
			
			
			String ajoutCritereFacture = "";
			String ajoutCritereAvoir = "";

			if (!commercial.equals("")) {
				ajoutCritereFacture = " and f.Util_R="+ Integer.parseInt(commercial);
				ajoutCritereAvoir = " and a.Util_R="+ Integer.parseInt(commercial);
				Statement sttCom = con.createStatement();
				ResultSet rsCom = sttCom.executeQuery("select Prenom, Nom from UTILISATEUR where Utilisateur_Id="+ Integer.parseInt(commercial));
				if (rsCom.next()) {
					criteres += "Commercial : "+ rsCom.getString("Prenom") +" "+ rsCom.getString("Nom");
				}
				sttCom.close();
			}


			String reqClientCA = "select Client_Id, Denomination, coalesce(sum(CA_HT),0) as CA_HT,coalesce(sum(CA_TTC),0) as CA_TTC"
				+" from (select c.Client_Id, c.Denomination, coalesce(sum(f.Total_HT),0) as CA_HT,coalesce(sum(f.Total_TTC),0) as CA_TTC"
				+" from "+ base +".FICHE_CLIENT c"
				+" left join "+ base +".FACTURE f on (c.Client_Id=f.Client_Id and f.Numero<>0 and f.Date_Facture<="+ finPeriode +" and f.Date_Facture>="+ debutPeriode + ajoutCritereFacture +")"
				+" where 1 ";

			if (familleId != 0) {
				reqClientCA += " and c.Famille_Id="+ familleId;
				if (criteres.length()>0) criteres += " - ";
				criteres += "Famille : "+ familleClient;
			}

			if (tarifsSpe.equals("1")) {
				reqClientCA += " and c.Client_Id in (select distinct Client_Id from "+ base +".CLIENT_ARTICLE)";
				criteres += (!criteres.equals("")?" - ":"") +"Clients ayant des tarifs sp\u00E9cifiques";
			}
			reqClientCA += " group by c.Client_Id, c.Denomination";

			reqClientCA += " union select c.Client_Id, c.Denomination, -coalesce(sum(a.Total_HT),0) as CA_HT,-coalesce(sum(a.Total_TTC),0) as CA_TTC"
			+" from "+ base +".FICHE_CLIENT c"
			+" left join "+ base +".AVOIR a on (a.Client_Id=c.Client_Id and a.Numero<>0 and a.Date_Avoir<="+ finPeriode +" and a.Date_Avoir>="+ debutPeriode + ajoutCritereAvoir +")"
			+" where 1 ";

			
			if (familleId != 0) {
				reqClientCA += " and c.Famille_Id="+ familleId;
			}

			if (tarifsSpe.equals("1")) {
				reqClientCA += " and c.Client_Id in (select distinct Client_Id from "+ base +".CLIENT_ARTICLE)";
			}			
			reqClientCA += " group by c.Client_Id, c.Denomination) as PC"
					+" group by Client_Id, Denomination having CA_HT!=0 order by CA_HT desc";

			String reqDetail;
			if (this.typeDetail.equals("D")) {
				titreDetail = " date";
				titreDetailCsv = titreDetail;
				reqDetail =  " select AF.Date_Doc, sum(AF.CA_HT) as CA_HT from"
					+" ((select Date_Facture as Date_Doc, sum(Total_HT) as CA_HT from "+ base +".FACTURE f where Client_Id=? and Date_Facture<="+ finPeriode +" and Date_Facture>="+ debutPeriode +" and Numero<>0 "+ ajoutCritereFacture +" group by Date_Doc)"
					+" union "
					+" (select Date_Avoir as Date_Doc, -sum(Total_HT) as CA_HT from "+ base +".AVOIR a where Client_Id=? and Date_Avoir<="+ finPeriode +" and Date_Avoir>="+ debutPeriode +" and Numero<>0 "+ ajoutCritereAvoir +" group by Date_Doc)) as AF"
					+" group by AF.Date_Doc order by AF.Date_Doc";
			}
			else {
				String selection;
				String condition;

				if (this.typeDetail.equals("F1")) {
					selection = "coalesce(fa1.Libelle,'') as LblFamille1";
					condition = "LblFamille1";
					titreDetail = " famille 1 d'article";
					titreDetailCsv = titreDetail;
				} else if (this.typeDetail.equals("F2")) {
					selection = "coalesce(fa1.Libelle,'') as LblFamille1, coalesce(fa2.Libelle,'') as LblFamille2";
					condition = "LblFamille1, LblFamille2";
					titreDetail = " familles 1 et 2 d'article";
					titreDetailCsv = titreDetail;
				} else if (this.typeDetail.equals("F3")) {
					selection = "coalesce(fa1.Libelle,'') as LblFamille1, coalesce(fa2.Libelle,'') as LblFamille2, coalesce(fa3.Libelle,'') as LblFamille3";
					condition = "LblFamille1, LblFamille2, LblFamille3";
					titreDetail = " familles 1, 2 et 3 d'article";
					titreDetailCsv = titreDetail;
				} else {
					selection = "coalesce(fa.Article_Id,'') as LblArticle";
					condition = "LblArticle";
					titreDetail = " article";
					titreDetailCsv = titreDetail;
				}

				reqDetail = " select "+ condition +", sum(TG.CA_HT) as CA_HT from"
				 +" ((select "+ selection +", coalesce(if(f.Edition_TTC=0, coalesce(sum(af.Montant_Ligne * (1-f.Remise/100)),0), coalesce(sum(af.Montant_Ligne * (1-f.Remise/100) / (1+af.Taux_TVA/100)),0)),0) as CA_HT"
				 +" from "+ base +".FACTURE f left join "+ base +".LIGNE_FACTURE af on f.Facture_Id=af.Facture_Id"
				 +" left join "+ base +".FICHE_ARTICLE fa on af.Reference=fa.Article_Id"
				 +" left join "+ base +".FAMILLE_ARTICLE fa1 on fa.Famille_1=fa1.Famille_Id"
				 +" left join "+ base +".FAMILLE_ARTICLE fa2 on fa.Famille_2=fa2.Famille_Id"
				 +" left join "+ base +".FAMILLE_ARTICLE fa3 on fa.Famille_3=fa3.Famille_Id"
				 +" where f.Numero<>0 and f.Client_Id=? and f.Date_Facture<="+ finPeriode +" and f.Date_Facture>="+ debutPeriode +" "+ ajoutCritereFacture +" group by "+ condition +" order by "+ condition +")"
				 +" union all "
				 +" (select "+ selection +", -coalesce(if(a.Edition_TTC=0, coalesce(sum(aa.Montant_Ligne * (1-a.Remise/100)),0), coalesce(sum(aa.Montant_Ligne * (1-a.Remise/100) / (1+aa.Taux_TVA/100)),0)),0) as CA_HT"
				 +" from "+ base +".AVOIR a left join "+ base +".LIGNE_AVOIR aa on a.Avoir_Id=aa.Avoir_Id"
				 +" left join "+ base +".FICHE_ARTICLE fa on aa.Reference=fa.Article_Id"
				 +" left join "+ base +".FAMILLE_ARTICLE fa1 on fa.Famille_1=fa1.Famille_Id"
				 +" left join "+ base +".FAMILLE_ARTICLE fa2 on fa.Famille_2=fa2.Famille_Id"
				 +" left join "+ base +".FAMILLE_ARTICLE fa3 on fa.Famille_3=fa3.Famille_Id"
				 +" where a.Numero<>0 and a.Client_Id=? and a.Date_Avoir<="+ finPeriode +" and a.Date_Avoir>="+ debutPeriode +" "+ ajoutCritereAvoir +" group by "+ condition +" order by "+ condition +")) as TG"
				 +" group by "+ condition +" order by "+ condition;
			}
			
			PreparedStatement psDetail = con.prepareStatement(reqDetail);
			rset = stt.executeQuery(reqClientCA);
			while (rset.next()) {
				if (detail) {
					psDetail.setString(1, rset.getString("Client_Id"));
					psDetail.setString(2, rset.getString("Client_Id"));
					ResultSet rset2 = psDetail.executeQuery();
					String gp;

					if (rset2.next()) {
						LignePalmaresClient lp = new LignePalmaresClient();

						lp.setNumero(rset.getString("Client_Id"));
						lp.setClient(rset.getString("Denomination"));
						lp.setCaHT(rset.getDouble("CA_HT"));
						lp.setCaTTC(rset.getDouble("CA_TTC"));
						lp.setDetailSeulement(false); // on affichera une ligne complte
						
						if (this.typeDetail.equals("D")) {
							gp = formatDate.format(new Date(rset2.getLong("Date_Doc")));
						}
						else {
							if (this.typeDetail.equals("F1")) {
								gp = rset2.getString("LblFamille1");
							} else if (this.typeDetail.equals("F2")) {
								gp = rset2.getString("LblFamille1");
								if (!gp.isEmpty() && !rset2.getString("LblFamille2").isEmpty()) {
									gp +=", "+ rset2.getString("LblFamille2");
								}
							} else if (this.typeDetail.equals("F3")) {
								gp = rset2.getString("LblFamille1");
								if (!gp.isEmpty() && !rset2.getString("LblFamille2").isEmpty()) {
									gp +=", "+ rset2.getString("LblFamille2");
									if (!gp.isEmpty() && !rset2.getString("LblFamille3").isEmpty()) {
										gp +=", "+ rset2.getString("LblFamille3");
									}
								}
							} else {
								gp = rset2.getString("LblArticle");
							}
						}
						lp.setGroupe(gp);
						lp.setHtGp(rset2.getDouble("CA_HT"));
						
						lignes.add(lp);
					}

					while (rset2.next()) {
						LignePalmaresClient lp = new LignePalmaresClient();

						lp.setNumero(rset.getString("Client_Id"));
						lp.setClient(rset.getString("Denomination"));
						lp.setCaHT(rset.getDouble("CA_HT"));
						lp.setCaTTC(rset.getDouble("CA_TTC"));
						lp.setDetailSeulement(true); // on n'affichera que les dtails
						
						if (this.typeDetail.equals("D")) {
							gp = formatDate.format(new Date(rset2.getLong("Date_Doc")));
						}
						else {
							if (this.typeDetail.equals("F1")) {
								gp = rset2.getString("LblFamille1");
							} else if (this.typeDetail.equals("F2")) {
								gp = rset2.getString("LblFamille1");
								if (!gp.isEmpty() && !rset2.getString("LblFamille2").isEmpty()) {
									gp +=", "+ rset2.getString("LblFamille2");
								}
							} else if (this.typeDetail.equals("F3")) {
								gp = rset2.getString("LblFamille1");
								if (!gp.isEmpty() && !rset2.getString("LblFamille2").isEmpty()) {
									gp +=", "+ rset2.getString("LblFamille2");
									if (!gp.isEmpty() && !rset2.getString("LblFamille3").isEmpty()) {
										gp +=", "+ rset2.getString("LblFamille3");
									}
								}
							} else {
								gp = rset2.getString("LblArticle");
							}
						}
						lp.setGroupe(gp);
						lp.setHtGp(rset2.getDouble("CA_HT"));
						
						lignes.add(lp);
					}
				}
				else {
					LignePalmaresClient lp = new LignePalmaresClient();

					lp.setNumero(rset.getString("Client_Id"));
					lp.setClient(rset.getString("Denomination"));
					lp.setCaHT(rset.getDouble("CA_HT"));
					lp.setCaTTC(rset.getDouble("CA_TTC"));
					lp.setDetailSeulement(false); // on affichera une ligne complte
					lp.setGroupe(""); // initialisation
					lp.setHtGp(0); // initialisation
					
					lignes.add(lp);
				}
			}		
			rset.close();
			stt.close();
			s.closeConnection(con, null);
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}
	public int getNbLignes() {
		return lignes.size();
	}
} // fin DataPalmaresClient
