/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une liste de fournisseurs
 */

package org.opensi.facturation.actions.editions;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;

public class DataListeFournisseurs {

	// les lignes de la liste des fournisseurs
	protected ArrayList<LigneListeFournisseurs> lignes = new ArrayList<LigneListeFournisseurs>(10);
	
	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String dateCourante;
	protected String familleFournisseur = "";
	protected String tri1;
	protected String tri2;
	protected String tri3;
	protected String criteres = "";
	
	public DataListeFournisseurs(Session s, int familleId, String tri1, String tri2, String tri3) {

		try {
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String base = s.getCookie().get("BaseDossier");
			this.dossierId = s.getCookie().get("Dossier_Id");
			
			this.tri1 = tri1;
			this.tri2 = tri2;
			this.tri3 = tri3;
			
			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			
			ResultSet rset;
			
			if (familleId != 0) {
				String reqFamille = "select Libelle from "+ base +".FAMILLE_FOURNISSEUR where Famille_Id="+ familleId;
				rset = stt.executeQuery(reqFamille);
				rset.next();
				this.familleFournisseur = rset.getString("Libelle");
				rset.close();
			}
			
			String reqLeDossier = "select * from "+ base +".SOCIETE";
			rset = stt.executeQuery(reqLeDossier);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");

			rset.close();
			
			String reqFournisseurs = "select coalesce(fa.Libelle,'') as Famille, ff.Fournisseur_Id, ff.Denomination, ff.Adresse_1, ff.Code_Postal, ff.Ville, ff.Tel_1";
			reqFournisseurs += " from "+ base +".FICHE_FOURNISSEUR ff left join "+ base +".FAMILLE_FOURNISSEUR fa on ff.Famille_Id=fa.Famille_Id where ff.Supprime=0";

			if (familleId != 0) {
				reqFournisseurs += " and ff.Famille_Id="+ familleId;
				criteres += "Famille : "+ familleFournisseur;
			}
			
			reqFournisseurs += " order by "+ tri1;

			if (tri2.length()>0) reqFournisseurs += ","+ tri2;
			if (tri3.length()>0) reqFournisseurs += ","+ tri3;
			
			rset = stt.executeQuery(reqFournisseurs);

			while (rset.next()) {
				LigneListeFournisseurs llf = new LigneListeFournisseurs();

				llf.setFamille(rset.getString("Famille"));
				llf.setNumero(rset.getString("Fournisseur_Id"));
				llf.setFournisseur(rset.getString("Denomination"));
				llf.setAdresse(rset.getString("Adresse_1"));
				llf.setCp(rset.getString("Code_Postal"));
				llf.setVille(rset.getString("Ville"));
				llf.setTel(rset.getString("Tel_1"));

				lignes.add(llf);
			}			
			
			rset.close();
			stt.close();
			s.closeConnection(con, null);
		}
		catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataListeFournisseurs
