/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un palmars client en csv
 */

package org.opensi.facturation.actions.editions;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;


public class CsvPalmaresClient {
		
	public CsvPalmaresClient(String buffer, String fichier, DataPalmaresClient dpc) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Num\u00E9ro");
		lf.addToLine("Client");
		lf.addToLine("CA TTC");
		lf.addToLine("CA HT");
		
		if (dpc.detail) {
			lf.addToLine("D\u00E9tail par"+ dpc.titreDetailCsv);
			lf.addToLine("Montant D\u00E9tail HT");
		}
		
		int nbLignes = dpc.getNbLignes();
		
		for (int i=0; i<nbLignes; i++) {
			LignePalmaresClient lp = dpc.lignes.get(i);
			
			lf.newLine();
			
			if (lp.detailSeulement) {
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
			} else {
				lf.addToLine(lp.numero);
				lf.addToLine(lp.client);
				lf.addToLine(("" + lp.caTTC).replaceAll("\\.", ","));
				lf.addToLine(("" + lp.caHT).replaceAll("\\.", ","));
			}
			
			if (dpc.detail) {
				lf.addToLine(lp.groupe);
				lf.addToLine(("" + lp.htGp).replaceAll("\\.", ","));
			}
		}
		
		lf.write(buffer, fichier, true);
	}



} // fin CsvPalmaresClient
