/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste pour les bl et br utilisant le numro de lot concern
 */

package org.opensi.facturation.actions.documents.modeles;


import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.PdfWidths;
import org.opensi.util.pdf.TableBuilder;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class SuiviLotStd extends MultiPagesDocument {


	private static final Font fontAdrSociete = new Font(Font.HELVETICA, 10, Font.NORMAL);
	private static final Font fontAdrSocieteGras = new Font(Font.HELVETICA, 11, Font.BOLD);
	private static final Font fontTitre = new Font(Font.HELVETICA , 16, Font.BOLD, Color.WHITE);
	private static final Font fontSousTitre = new Font(Font.HELVETICA, 14, Font.BOLD);
	private static final Font fontArticle = new Font(Font.HELVETICA, 12, Font.NORMAL);
	private static final Font fontEnteteColonne = new Font(Font.HELVETICA, 9, Font.BOLD);
	private static final Font fontWeb = new Font(Font.HELVETICA, 10, Font.ITALIC);
	private static final Font fontInfosFact = new Font(Font.HELVETICA , 10, Font.NORMAL);
	private static final Font fontLegale = new Font(Font.HELVETICA , 7, Font.NORMAL);
	private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);
	
	private DecimalFormat numFormatCap = new DecimalFormat("0.##");


	private DataSuiviLot id;	   // les donnes du lot
	
	private float[] widthsCols;
	private int nbCols;
	
	private boolean nbPieces;
	
	private boolean titreBL = false;
	private boolean titreBR = false;

	private Image logo;



	public SuiviLotStd(String tempdir, DataSuiviLot id) throws Exception {

		super(tempdir);

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormatCap.setDecimalFormatSymbols(dfs);
		numFormatCap.setGroupingUsed(true);
		numFormatCap.setGroupingSize(3);		

		this.id = id;

		try {
			logo = Image.getInstance(id.urlLogo);
			if (logo.getDpiX()!=0 && logo.getDpiY()!=0) {
				logo.scaleAbsolute(logo.getPlainWidth() * 72 / logo.getDpiX(), logo.getPlainHeight() * 72 / logo.getDpiY());
			}
		}
		catch (IOException e) {
			logo = null;
		}
		
		nbPieces = id.nbPieces;
		
		PdfWidths pw = new PdfWidths();
		
		pw.addColonneVariableMin(4,20);
		pw.addColonneVariableMin(4,25);
		pw.addColonneVariableMin(1, 4);
		pw.addColonneVariableMin(1, 15);
		pw.addColonneVariableMin(1, 4);
		if (nbPieces) pw.addColonneFixe(5);
		pw.addColonneVariableMin(1, 8);
		pw.addColonneVariableMin(1, 9);
		
		nbCols = pw.getNbCols();
		widthsCols = pw.getWidthsCols();

	}


	/* implmentation des fonctions de MultiPagesDocument */
		
	public PdfPTable firstHeader() throws DocumentException {

		TableBuilder tb = new TableBuilder();

		tb.add(makeEntete());
		tb.add(makeSpace(35));
		tb.add(makeTitre());
		tb.add(makeSpace(5));
		tb.add(firstLine());

		return tb.getTable();	
	}


	public PdfPTable middleHeader(int lastLine) throws DocumentException {

		TableBuilder tb = new TableBuilder();
		
		tb.add(firstHeader());

		return tb.getTable();
	}


	public PdfPTable lastFooter() throws DocumentException {

		TableBuilder tb = new TableBuilder();

		tb.add(lastLine());
		tb.add(makeSpace(3));
		tb.add(makeInfosLegales());

		return tb.getTable();
	}	


	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {	

		return lastFooter();		
	}


	public PdfPTable bodyLine(int numLine) throws DocumentException {

		LigneSuiviLot ls = id.lignes.get(numLine);
		
		TableBuilder tb = new TableBuilder();
		
		if ((ls.type.equals("BL") && !titreBL) || (ls.type.equals("BR") && !titreBR)) {
			tb.add(makeLineSousTitre(ls));
		}
		
		tb.add(makeLineSuiviLot(ls));

		return tb.getTable();
	}


	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {

		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));		

		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}

		return pptSpace;
	}


	public int nbLines() {
		return id.getNbLignes();
	}


	public int nbEx() {
		return 1;
	}


	public Image imageFond() {
		return null;
	}



	/* mthodes internes */
	
	public PdfPTable firstLine() throws DocumentException {

		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT+PdfPCell.TOP);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setPhrase(new Phrase(""));		

		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}

		return pptSpace;
	}
	
	
	public PdfPTable lastLine() throws DocumentException {

		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT+PdfPCell.BOTTOM);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setPhrase(new Phrase(""));		

		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}

		return pptSpace;
	}

	private PdfPTable makeSpace(int space) {

		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));

		pptSpace.addCell(cell);

		return pptSpace;
	}


	private PdfPTable makeEntete() throws DocumentException {

		PdfPTable pptEntete = new PdfPTable(2);
		pptEntete.setWidthPercentage(100);
		int[] widths = {50,50};
		pptEntete.setWidths(widths);

		PdfPCell cellSociete = new PdfPCell(makeInfosSociete());
		cellSociete.setBorder(PdfPCell.NO_BORDER);

		PdfPCell cellLot = new PdfPCell(makeInfosLot());
		cellLot.setBorder(PdfPCell.NO_BORDER);

		pptEntete.addCell(cellSociete);		
		pptEntete.addCell(cellLot);

		return pptEntete;		
	}


	private PdfPTable makeInfosSociete() {

		PdfPTable pptInfos = new PdfPTable(1);

		PdfPCell cell;

		if (logo != null) {
			cell = new PdfPCell(logo, false);

			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

			pptInfos.addCell(cell);

			cell.setImage(null);

			cell.setMinimumHeight(5);
			cell.setPhrase(new Phrase("", fontAdrSociete));
			pptInfos.addCell(cell);
			cell.setMinimumHeight(0);
		}
		else {
			cell = new PdfPCell(pptInfos.getDefaultCell());
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		}		

		if (!id.logoAdr) {
			cell.setPhrase(new Phrase(id.raisonSociale, fontAdrSocieteGras));		
			pptInfos.addCell(cell);
			cell.setPhrase(new Phrase(id.adresse1, fontAdrSociete));		
			pptInfos.addCell(cell);
			if (!id.adresse2.equals("")) {
				cell.setPhrase(new Phrase(id.adresse2, fontAdrSociete));
				pptInfos.addCell(cell);
			}
			if (!id.adresse3.equals("")) {
				cell.setPhrase(new Phrase(id.adresse3, fontAdrSociete));
				pptInfos.addCell(cell);
			}
			cell.setPhrase(new Phrase(id.codePostal+" "+id.ville, fontAdrSociete));		
			pptInfos.addCell(cell);

			String telfax = "";

			if (id.tel.length()>0) {
				telfax = "T\u00E9l: "+ id.tel;
				if (id.fax.length()>0) {
					telfax += " - Fax: "+ id.fax;
				}
			}
			else if (id.fax.length()>0) {
				telfax = "Fax: "+ id.fax;
			}		

			if (telfax.length()>0) {
				cell.setPhrase(new Phrase(telfax, fontAdrSociete));		
				pptInfos.addCell(cell);
			}

			if (!id.email.equals("")) {
				cell.setPhrase(new Phrase("e-mail: "+ id.email, fontAdrSociete));		
				pptInfos.addCell(cell);
			}
			if (!id.web.equals("")) {
				cell.setPhrase(new Phrase(id.web, fontWeb));		
				pptInfos.addCell(cell);
			}
		}

		cell.setPhrase(new Phrase(""));		
		pptInfos.addCell(cell);

		return pptInfos;	
	}


	private PdfPTable makeInfosLot() throws DocumentException {

		PdfPTable pptInfos = new PdfPTable(1);

		PdfPCell cell = new PdfPCell(pptInfos.getDefaultCell());

		cell.setVerticalAlignment(PdfPCell.ALIGN_TOP);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(4);
		cell.setPaddingBottom(4);		
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("Page "+ currentPage +" / "+ totalPages, fontInfosFact));
		
		pptInfos.addCell(cell);

		return pptInfos;		
	}


	private PdfPTable makeTitre() {

		PdfPTable pptTitre = new PdfPTable(1);
		pptTitre.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(pptTitre.getDefaultCell());		
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setBackgroundColor(new Color(175,175,175));
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setFixedHeight(30);
		cell.setPaddingBottom(5);
		cell.setPhrase(new Phrase("S   U   I   V   I         D   E         N   \u00B0         L   O   T", fontTitre));

		pptTitre.addCell(cell);

		return pptTitre;	
	}
	
	
	private PdfPTable makeEntetesColonnes() throws DocumentException {

		PdfPTable pptCols = new PdfPTable(nbCols);
		pptCols.setWidthPercentage(100);
		pptCols.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptCols.getDefaultCell());		

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setMinimumHeight(40);

		cell.setPhrase(new Phrase("Raison Sociale", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Adresse", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("CP", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Ville", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Code Pays", fontEnteteColonne));
		pptCols.addCell(cell);
		
		if (nbPieces) {
			cell.setPhrase(new Phrase("Nb Pc", fontEnteteColonne));
			pptCols.addCell(cell);
		}
		
		if (titreBR) {
			cell.setPhrase(new Phrase("Qt\u00E9 r\u00E9cep.", fontEnteteColonne));
			pptCols.addCell(cell);
			
			cell.setPhrase(new Phrase("Date de r\u00E9ception", fontEnteteColonne));
			pptCols.addCell(cell);
		} else {		
			cell.setPhrase(new Phrase("Qt\u00E9 livr\u00E9e", fontEnteteColonne));
			pptCols.addCell(cell);
			
			cell.setPhrase(new Phrase("Date de livraison", fontEnteteColonne));
			pptCols.addCell(cell);
		}
		

		return pptCols;
	}
	
	
	private PdfPTable makeLineSousTitre(LigneSuiviLot ls) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		PdfPTable pptLine = new PdfPTable(1);
		pptLine.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());		
		
		cell.setPaddingLeft(5);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setVerticalAlignment(PdfPCell.ALIGN_BOTTOM);
		cell.setBorder(PdfPCell.BOX-PdfPCell.BOTTOM);
		cell.setMinimumHeight(30);
		
		if (ls.type.equals("BL")) {
			cell.setPhrase(new Phrase("CLIENTS CONCERNES PAR LE LOT N\u00B0 "+ id.numLot, fontSousTitre));
			titreBL = true;
		} else if (ls.type.equals("BR")) {
			cell.setPhrase(new Phrase("FOURNISSEURS CONCERNES PAR LE LOT N\u00B0 "+ id.numLot, fontSousTitre));
			titreBR = true;
		}
		pptLine.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cell.setPhrase(new Phrase("R\u00E9f. Article : "+ id.refArticle, fontArticle));
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.BOX-PdfPCell.TOP);
		cell.setPhrase(new Phrase("D\u00E9signation : "+ id.designationArticle, fontArticle));
		pptLine.addCell(cell);
		tb.add(pptLine);
		
		tb.add(makeEntetesColonnes());
		
		return tb.getTable();
	}
	
	
	private PdfPTable makeLineSuiviLot(LigneSuiviLot ls) throws DocumentException {

		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());		
		
		cell.setPaddingLeft(5);
		cell.setMinimumHeight(10);
		cell.setBorder(PdfPCell.RIGHT+PdfPCell.LEFT);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			
		cell.setPhrase(new Phrase(ls.denomination, fontLine));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase(ls.adresse1 + " "+ ls.adresse2 + " "+ ls.adresse3, fontLine));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase(ls.codePostal, fontLine));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase(ls.ville, fontLine));
		pptLine.addCell(cell);		
		
		cell.setPaddingLeft(0);
		cell.setPaddingRight(0);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		
		cell.setPhrase(new Phrase(ls.codePays, fontLine));
		pptLine.addCell(cell);
		
		if (nbPieces) {
			if (ls.nbPieces != 0)
				cell.setPhrase(new Phrase(""+numFormatCap.format(ls.nbPieces), fontLine));
			else
				cell.setPhrase(new Phrase("", fontLine));			
			pptLine.addCell(cell);
		}
		
		cell.setPhrase(new Phrase(""+ numFormatCap.format(ls.qte), fontLine));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(ls.date, fontLine));
		pptLine.addCell(cell);	


		return pptLine;	
	}
	

	private PdfPTable makeInfosLegales() {

		PdfPTable pptLegales = new PdfPTable(1);
		pptLegales.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(pptLegales.getDefaultCell());		

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase(id.raisonSociale +" - "+ id.typeSociete + (id.capital>0?" au capital de "+ numFormatCap.format(id.capital) +" Euros":"") +" - immatricul\u00E9e au RCS "+ id.rcs +" "+ id.siren +" - N\u00B0 TVA : "+ id.tvaIntra, fontLegale));

		pptLegales.addCell(cell);

		return pptLegales;
	}


} // fin SuiviLotStd
