/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un bon de reliquats standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.tools.DateTime;
import org.opensi.util.tools.StringUtils;


public class DataBonReliquats {


	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");


	// les lignes de la commande
	protected ArrayList<LigneBonReliquats> lignes = new ArrayList<LigneBonReliquats>(10);
	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	
	// coordonnes du fournisseur
	
	protected String fournisseurId;
	protected String raisonSocialeFourn;
	protected String adresse1Fourn;
	protected String adresse2Fourn;
	protected String adresse3Fourn;
	protected String codePostalFourn;
	protected String villeFourn;
	protected String paysFourn;
	
	
	// infos commande
	
	protected long dateBonReliquats;
	
	protected double mRemise = 0;
	protected double montantBase = 0;
	protected double totalBase = 0;
	
	protected boolean rist = false;
	protected boolean coul = false;
	protected boolean unite = false;
	protected boolean logoAdr;
	protected String urlLogo = "";	
	
	
	
	public DataBonReliquats(Session s, String fournisseurId) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			
			this.fournisseurId = fournisseurId;
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
      
			ResultSet rset;
			
			dfs2.setDecimalSeparator('.');
			numFormatQte.setDecimalFormatSymbols(dfs2);
			
      
			// coordonnes de l'entreprise facturante
      
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);
			
			rset.next();
			
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");
			
			rset.close();
			
			
			// Elments du fournisseur
			
			String reqFournisseur = "select ff.Denomination, ff.Adresse_1, ff.Adresse_2, ff.Adresse_3, ff.Code_Postal, ff.Ville, p.Nom_FR as Pays";
			reqFournisseur += " from "+ base +".FICHE_FOURNISSEUR ff, PAYS p where ff.Code_Pays=p.Code_Pays and ff.Fournisseur_Id=?";
			PreparedStatement psFournisseur = con.prepareStatement(reqFournisseur);
			psFournisseur.setString(1, fournisseurId);
			rset = psFournisseur.executeQuery();
			rset.next();
			this.raisonSocialeFourn = rset.getString("Denomination");
			this.adresse1Fourn = rset.getString("Adresse_1");
			this.adresse2Fourn = rset.getString("Adresse_2");
			this.adresse3Fourn = rset.getString("Adresse_3");
			this.codePostalFourn = rset.getString("Code_Postal");
			this.villeFourn = rset.getString("Ville");
			this.paysFourn = rset.getString("Pays");
			rset.close();
			psFournisseur.close();
			
			
			// Paramtres dossier
      
			String reqCom = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			rset = stt.executeQuery(reqCom);
			rset.next();
			logoAdr = rset.getInt("Logo_Adr")==1;
			rset.close();
			this.dateBonReliquats = new DateTime().getTimeInMillis();
			
			
			// selection des articles ayant des reliquats
			
			String reqArticles = "select fa.Ref_Fournisseur, ac.Reference, ac.Designation, ac.Prix, ac.Unite, ac.Ristourne, c.Date_Commande, c.Num_Entier, (ac.Prix*ac.Quantite*c.Remise/100) as Remise, ac.Quantite as QuantiteCde, (ac.Quantite-BON.BR) as Reliquat";
			reqArticles += " from (select ac.Reference, ac.Prix, c.Num_Entier,coalesce(sum(abr.Quantite),0) as BR";
			reqArticles += " from " + base + ".COMMANDE_FOURNISSEUR c, " + base + ".LIGNE_COMMANDE_FOURNISSEUR ac left join " + base + ".LIGNE_BON_RECEPTION abr on ac.ligne_Id=abr.Ref_Ligne left join " + base + ".BON_RECEPTION br on br.BR_Id=abr.BR_Id and br.Etat='V'";  
			reqArticles += " where ac.Commande_Id=c.Commande_Id and c.Etat='V' and ac.Type_Ligne='S'";
			reqArticles += " group by Reference, Prix, c.Num_Entier order by ac.Reference) as BON," + base + ".COMMANDE_FOURNISSEUR c, " + base + ".LIGNE_COMMANDE_FOURNISSEUR ac, "+ base +".FOURNISSEUR_ARTICLE fa";
			reqArticles += " where ac.Commande_Id=c.Commande_Id and c.Etat='V' and ac.Type_Ligne='S'";
			reqArticles += " and BON.Reference=ac.Reference and BON.Num_Entier=c.Num_Entier";
			reqArticles += " and ac.Reference=fa.Article_Id and fa.Fournisseur_Id=c.Fournisseur_Id and c.Fournisseur_Id=?";
			reqArticles += " and (ac.Quantite-BON.BR)>0 order by Ref_Fournisseur, c.Num_Entier";
			PreparedStatement psArticles = con.prepareStatement(reqArticles);
			psArticles.setString(1, fournisseurId);
			rset = psArticles.executeQuery();
			
			
			String reqInfosSup = "select coalesce(ca.Libelle,'') as Couleur, fa.Descrip_1, fa.Descrip_2, fa.Imp_Nom_BCF, fa.Imp_Desc1_BCF, fa.Imp_Desc2_BCF";
			reqInfosSup += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id where fa.Article_Id=?";
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);
			
			
			String reqNomenclature = "select n.ArticleComp_Id, n.Quantite, f.Designation";
			reqNomenclature += " from "+ base +".FICHE_ARTICLE f,"+ base +".COMPOSANT_ARTICLE n where f.Article_Id=n.ArticleComp_Id and n.Article_Id=?";
			PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);
			
			
			while (rset.next()) {
				
				LigneBonReliquats lc = new LigneBonReliquats();		
				
				lc.setReference(rset.getString("Ref_Fournisseur"));
				lc.setDesignation(rset.getString("Designation"));
				lc.setDateCommande(rset.getLong("Date_Commande"));
				lc.setNumCommande(rset.getString("Num_Entier"));
				lc.setQuantiteCde(rset.getDouble("QuantiteCde"));
				lc.setReliquat(rset.getDouble("Reliquat"));
				lc.setUnite(rset.getString("Unite"));
				lc.setPrixUnitaire(rset.getDouble("Prix"));
				lc.setRistourne(rset.getDouble("Ristourne"));
				lc.setType('A');				
				
				if (lc.ristourne!=0) rist = true;
				if (!lc.unite.equals("U")) unite = true;
				
				lc.setMontant(lc.prixUnitaire * lc.quantiteCde * (1-lc.ristourne/100));
				
				montantBase += lc.montant;
				
				lc.setSousTotal(montantBase);
				
				lignes.add(lc);
				
				mRemise += rset.getDouble("Remise");
				
				
				// rcupration infos supplmentaires si existent
				psInfosSup.setString(1, rset.getString("Reference"));
				ResultSet rsIS = psInfosSup.executeQuery();

				if (rsIS.next()) {

					lc.setCouleur(rsIS.getString("Couleur"));

					if (rsIS.getString("Couleur").length()>0) {
						coul = true;
					}
					
					if (rsIS.getInt("Imp_Desc1_BCF")==1) {
						lc.setDetail_1(StringUtils.removeHtmlTags(rsIS.getString("Descrip_1")));
					}
					if (rsIS.getInt("Imp_Desc2_BCF")==1) {
						lc.setDetail_2(StringUtils.removeHtmlTags(rsIS.getString("Descrip_2")));
					}

					// gestion de la nomenclature
					if (rsIS.getInt("Imp_Nom_BCF")==1)	{

						psNomenclature.setString(1, rset.getString("Reference"));
						ResultSet rsN = psNomenclature.executeQuery();

						while (rsN.next()) {
							LigneBonReliquats ln = new LigneBonReliquats();

							ln.setReference(rsN.getString("ArticleComp_Id"));
							ln.setDesignation(rsN.getString("Designation"));
							ln.setQuantiteCde(rsN.getDouble("Quantite"));
							ln.setType('N');
							ln.setSousTotal(montantBase);			

							lignes.add(ln);
						}

						rsN.close();
					}
					
				}
				rsIS.close();
			}
			rset.close();
			
			totalBase = montantBase - mRemise;
			
			
			psArticles.close();
			psInfosSup.close();
			psNomenclature.close();
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	
	public double calcSousTotal(int derniereLigne) {
	
		if (derniereLigne<0) 
			return 0;
		else {
			return lignes.get(derniereLigne).sousTotal;
		}		
	}	
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	
} // fin DataBonReliquats
