/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un devis
 */

package org.opensi.facturation.actions.documents;


import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.documents.modeles.DataDevis;
import org.opensi.facturation.actions.documents.modeles.DevisPDF;
import org.opensi.facturation.actions.documents.modeles.DevisStd;
import org.opensi.util.pdf.GlobalDocument;


public class GenDevis extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
		String fichierPdf = r.getParameter("FichierPDF");
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		String base = s.getCookie().get("BaseDossier");
		
		String repPdf = absdir +"/pdf/";
		String repTemp = repPdf;
		
		String reqModeleDevis = "select md.Modele_Id, md.Class from "+ base +".MODELE_DEVIS md, "+ base +".PARAM_DOSSIER d";
		reqModeleDevis += " where md.Modele_Id=d.Modele_Pdf_DC";
		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(reqModeleDevis);
		rset.next();
		String modele = rset.getString("Modele_Id");
		String chemin = rset.getString("Class");
		rset.close();
		stt.close();
		s.closeConnection(con, null);
		
		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
		
		DevisPDF devis;
		DataDevis dd = new DataDevis(s, r.getParameter("Devis_Id"));
		if (modele.equals("STD01")) {
			devis = new DevisStd(repTemp, dd);
		}
		else {
			Object[] o = {repTemp, dd};
			Class<?> cl = Class.forName(chemin);
			Constructor<?> c = cl.getConstructors()[0];
			devis = (DevisPDF)c.newInstance(o);
		}
		
		devis.setAffTotaux(r.getParameter("SansTotaux")==null);
		if (r.getParameter("Marque")!=null)
			devis.setAffMarque(r.getParameter("Marque").equalsIgnoreCase("true"));

		gd.addInternal(devis);		
		
		gd.close(GlobalDocument.ON_EXIT);
	
		return true;
		
	} // fin service


} // fin GenDevis
