package org.opensi.dbm.dossier;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.opensi.data.dossier.SecteurActivite;

public class DBM_SecteurActivite {

	private Connection	con;

	private String		baseDossier;

	public DBM_SecteurActivite(Connection con, String baseDossier) {

		this.con = con;
		this.baseDossier = baseDossier;
	}

	public void insert(SecteurActivite secteur) throws SQLException {

		String sql="insert into " + baseDossier +".SECTEUR_ACTIVITE(Libelle,Code_Secteur)" +
				"VALUES(?,?)";
		
		PreparedStatement ps = con.prepareStatement(sql,
				Statement.RETURN_GENERATED_KEYS);
		
		ps.setString(1, secteur.getString("Libelle"));
		ps.setString(2, secteur.getString("Code_Secteur"));
		ps.executeUpdate();
		ResultSet rset = ps.getGeneratedKeys();
		rset.next();
		secteur.setInt("Secteur_Id", rset.getInt(1));
		ps.close();
	}
		
	public SecteurActivite load(int secteurId) throws SQLException
	{
		SecteurActivite secteur = new SecteurActivite();
		
		String sql="select * from " + baseDossier + ".SECTEUR_ACTIVITE " +
				"where Secteur_Id=?";
		
		PreparedStatement ps =con.prepareStatement(sql);
		
		ps.setInt(1,secteurId);
		
		ResultSet rset = ps.executeQuery();
		
		if(rset.next())
		{
			secteur.setInt("Secteur_Id", secteurId);
			secteur.setString("Libelle",rset.getString("Libelle"));
			secteur.setInt("Code_Secteur",rset.getInt("Secteur_Activite"));
			return secteur;
		}
		else
		{
			return null;
		}
			
	}
	
	public SecteurActivite loadViaCode_Secteur(String codeSecteur) throws SQLException
	{
SecteurActivite secteur = new SecteurActivite();
		
		String sql="select * from " + baseDossier + ".SECTEUR_ACTIVITE " +
				"where Code_Secteur=?";
		
		PreparedStatement ps =con.prepareStatement(sql);
		
		ps.setString(1,codeSecteur);
		
		ResultSet rset = ps.executeQuery();
		
		if(rset.next())
		{
			secteur.setInt("Secteur_Id", rset.getInt("Secteur_Id"));
			secteur.setString("Libelle",rset.getString("Libelle"));
			secteur.setString("Code_Secteur",rset.getString("Code_Secteur"));
			return secteur;
		}
		else
		{
			return null;
		}
	}
	
	
	public boolean exist(int codeSecteur) throws SQLException
	{
		String sql="select * from " + baseDossier + ".SECTEUR_ACTIVITE " +
		"where Code_Secteur=?";

		PreparedStatement ps = con.prepareStatement(sql);

		ps.setInt(1, codeSecteur);

		ResultSet rset = ps.executeQuery();

		return rset.next();
	
	
	}
	
}
