package org.opensi.compta.actions.transferts;


public class Log {

	protected static final int INFO = 0;	
	protected static final int WARN = 1;
	protected static final int ERROR = 2;

	private int type;
	private String msg;
	private int line;

	public Log(int type, String msg, int line) {

		if (type>ERROR || type<INFO) {
			this.type = ERROR;
		}
		else {			
			this.type = type;
		}

		this.msg = msg;
		this.line = line;
	}
	
	public int getType() { return type; }
	public String getMsg() { return msg; }
	public int getLine() { return line; }	
	
	public String getStrType() {
		
		switch(type) {
			case 0: return "info";
			case 1: return "warning";
			case 2: return "erreur";
			default: return "erreur";
		}
	}
	
}
	
