/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Import de donnes comptables CSV
 */

package org.opensi.compta.actions.transferts;


import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.opensi.util.tools.DateTime;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.data.dossier.Compte;

import org.opensi.api.SessionOSI;


public class ImportCsv extends ImportCompta {


	public ImportCsv(SessionOSI sosi, String base, String fichierImport, String journal) {
		
		super(sosi, base, fichierImport, journal);
	}


	public void importer() throws Exception {
	
	
		Ecriture currentEcr = null;
		int currentLine = 0;
		int ttc;
		FileReader fr = new FileReader(fichier);

		BufferedReader br = new BufferedReader(fr);
		if (br.ready()) {
			String line = br.readLine();
			currentLine++;

			while (br.ready()) {

				line = br.readLine();
				cc.incLine();
				currentLine++;
				line+=";;";
				String [] elem = splitmanuel(line, 11);
				if (elem.length==11) {
					String nom=remplace(elem[0]);
					String num_client=remplace(elem[1]);
					String num_vente=remplace(elem[2]);
					String num_tva=remplace(elem[3]);
					String designation=remplace(elem[4]);
					String num_fact=remplace(elem[5]);
					String date_fact=remplace(elem[6]);
					String date_echeance=remplace(elem[7]);
					String montant_ht=nombre(remplace(elem[8]));
					String montant_tva=nombre(remplace(elem[9]));
					String montant_ttc=nombre(remplace(elem[10]));

					if (num_fact.length()>20) {elog.addError("Le numro de la facture est incorrect ligne : "+currentLine);}
					if (date_fact.length()!=10 && date_fact.length()!=8) {elog.addError("La date de facturation est incorrecte ligne : "+currentLine);}
					if (date_echeance.length()!=10 && date_echeance.length()!=8 && date_echeance.length()!=0) {elog.addError("La date d'chance est incorrecte ligne : "+currentLine);}
					
					cc.checkEmpty(num_client,"Le numro de client est vide");
					cc.checkEmpty(num_tva,"Le numro de TVA est vide");
					cc.checkEmpty(num_fact,"Le numro de facture est vide");
					cc.checkEmpty(date_fact,"La date de facturation est vide");
					
					cc.checkNumeroCompte(num_client,"C");
					cc.checkNumeroCompte(num_tva,"G");

					Compte compte = new Compte();
					compte.setIntitule("VENTES");
					compte.setTypeCompte("G");

					if (num_vente.length()!=0) {
						compte.setNumeroCompte(num_vente);						
						cc.checkNumeroCompte(num_vente,"G");
						comptes.put(num_vente.toLowerCase(), compte);
					}
					else {					
						//compte de vente par dfaut
						num_vente=getDefautCompteVente();
						if (!num_vente.equals("")) {
							compte.setNumeroCompte(num_vente);						
							cc.checkNumeroCompte(num_vente,"G");
							comptes.put(num_vente.toLowerCase(), compte);
						}
					}
				
					compte.setNumeroCompte(num_tva);
					compte.setIntitule("TVA");					
					comptes.put(num_tva.toLowerCase(), compte);
					
					compte.setNumeroCompte(num_client);					
					compte.setIntitule(nom);
					compte.setTypeCompte("C");					
					comptes.put(num_client.toLowerCase(), compte);
					
					DateTime dt;
					if (date_fact.length()==8) {
						dt = new DateTime(DateTime.parseDate(date_fact,"dd/MM/yy"));	
					}
					else {
						dt = new DateTime(DateTime.parseDate(date_fact,"dd/MM/yyyy"));						
					}
					long dateOp = dt.getDateInMillis();
					dt.setDay(1);
					
					long dateEcriture = dt.getDateInMillis();
						
					cc.checkCodeJournal(journal);
					cc.checkPeriode(dateEcriture);
					cc.checkDate(dateOp);

					long dateEcheance =0;
					if (date_echeance.length()==8) {
						dateEcheance = DateTime.parseDate(date_echeance,"dd/MM/yy");
					}
					else if (date_echeance.length()==10) {
						dateEcheance = DateTime.parseDate(date_echeance,"dd/MM/yyyy");
					}

					currentEcr = new Ecriture();
					currentEcr.setCodeJournal(journal);
					currentEcr.setDateEcriture(dateEcriture);
					
					int montant_vente=0;
					int montant_taxe=0;
					
					try {
						if (!montant_ht.equals("")) {
							double htdb = (new Double(montant_ht)).doubleValue();
							montant_vente=(new Double(htdb*100)).intValue();
							if (!montant_tva.equals("")) {
								double tvadb = (new Double(montant_tva)).doubleValue();
								montant_taxe = (new Double(tvadb*100)).intValue();
							}
						}
						else if (!montant_tva.equals("")) {
							double tvadb = (new Double(montant_tva)).doubleValue();
							montant_taxe= (new Double(tvadb*100)).intValue();
							if (!montant_ttc.equals("")) {
								double ttcdb = (new Double(montant_ttc)).doubleValue();
								ttc=(new Double(ttcdb*100)).intValue();
								montant_vente=ttc-montant_taxe;
							}
						}
						else if (!montant_ttc.equals("")) {
						
							double ttcdb = (new Double(montant_ttc)).doubleValue();
							ttc=(new Double(ttcdb*100)).intValue();
							montant_vente=ttc;
						}
					}
					catch (NumberFormatException e) {
						elog.addError("Les montants sont incorrects ligne : "+currentLine);
					}
					if (montant_vente>0) {
				
						ecritures.addEcriture(currentEcr);

						cc.checkLibelleOp(designation);
						
						Operation op = new Operation();
						op.setDateOp(dateOp);
						op.setLibelle(designation);
						op.setNumeroCompte(num_vente);
						op.setMontantD(0);
						op.setMontantC(montant_vente);
						op.setNumPiece(num_fact);
						op.setDateEcheance(dateEcheance);

						currentEcr.addOperation(op);
						
						if (montant_taxe>0) {
							op = new Operation();
							op.setDateOp(dateOp);
							op.setLibelle(designation);
							op.setNumeroCompte(num_tva);
							op.setMontantD(0);
							op.setMontantC(montant_taxe);
							op.setNumPiece(num_fact);
							op.setDateEcheance(dateEcheance);

							currentEcr.addOperation(op);
						}
						
						op = new Operation();
						op.setDateOp(dateOp);
						op.setLibelle(designation);
						op.setNumeroCompte(num_client);
						op.setMontantD(montant_vente+montant_taxe);
						op.setMontantC(0);
						op.setNumPiece(num_fact);
						op.setDateEcheance(dateEcheance);

						currentEcr.addOperation(op);																																													
					}

				}
				else {
					elog.addError("Le nombre de colonnes est incorrect ligne : "+currentLine);
				}
			}
		}
		else {
			elog.addError("Fichier vide");
		}

		br.close();
	}
	
	
	
	private String getDefautCompteVente() throws Exception {
			
		PreparedStatement psCpte = con.prepareStatement("select Numero_Compte_Vente from "+ baseDossier +".PARAM_DOSSIER");
		ResultSet rset = psCpte.executeQuery();
		if (rset.next()) {		
			return rset.getString("Numero_Compte_Vente");
		}
		return "";
	}
	

} // fin ImportCsv



