/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Cre le tableau en Ooo
 */

package org.opensi.compta.actions.tableauDeBord;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.openoffice.CreateurOpenOffice;
import org.opensi.util.openoffice.OooCellule;
import org.opensi.util.openoffice.OooLigne;
import org.opensi.util.openoffice.OooStyleCellule;
import org.opensi.util.openoffice.OooStyleLigne;


public class tabDeBordVersOoo extends Action {

	CreateurOpenOffice picasso;
	OooStyleCellule titreStyle, petitePolice, chiffreTitreStyle, rienStyle, caseStyle;
	OooStyleLigne ligneStyle;
	String chemin, nomFichier;
	Connection con;
	
	int nbMois=12;
	String base;
	int moisDebut, anneeDebut;
	String date_cloture;

	long [] tab_CA,tab_AD,tab_CP,tab_CE,tab_IT,tab_AM,tab_CF;
	
	long total_CA, total_AD, total_CP, total_CE, total_IT, total_AM, total_CF;
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
		chemin = s.getAppConfiguration().get("opensi.absdir") ;
		con = s.getConnection(null);
		nomFichier=r.getParameter("fichierSxc");
		String nbMois_s=r.getParameter("nbMois");
		base=r.getParameter("baseBD");
		String moisDebut_s=r.getParameter("moisDebut");
		String anneeDebut_s=r.getParameter("anneeDebut");
		date_cloture=r.getParameter("clos");		
		
		nbMois=Integer.parseInt(nbMois_s);
		moisDebut=Integer.parseInt(moisDebut_s);
		anneeDebut=Integer.parseInt(anneeDebut_s);
		
		BDversTableaux();
		calculeSommes();
		
		initOoo();
		creerEntetes();
		rempliLignesOoo();
		
		picasso.changerLargeurColonne(0,6.0f);
		File truc=picasso.genererDocument(nomFichier);
		truc.deleteOnExit();		
		
		return true;
	}
	
	
	
	public void BDversTableaux() throws SQLException {
		
		tab_CA=new long[nbMois];
		tab_AD=new long[nbMois];
		tab_CP=new long[nbMois];
		tab_CE=new long[nbMois];
		tab_IT=new long[nbMois];
		tab_AM=new long[nbMois];
		tab_CF=new long[nbMois];
		
		
		String requete="";
		int vraiAn;
		
		for(int i=1; i<=nbMois;i++)
		{
			vraiAn=anneeDebut+((i-1)/12);
			requete="select Libelle, Montant from "+base+".SAUVE_TB where Mois="+i+" and Annee="+vraiAn;
			
			
				Statement stt1 = con.createStatement();
				ResultSet resultatReq=stt1.executeQuery(requete);
			
			while (resultatReq.next()) {
				String lib=resultatReq.getString("Libelle");
				
				if (lib.equals("CA"))
				{
					tab_CA[i-1]=resultatReq.getLong("Montant");
				}
				else if (lib.equals("AD"))
				{
					tab_AD[i-1]=resultatReq.getLong("Montant");
				}
				else if (lib.equals("CP"))
				{
					tab_CP[i-1]=resultatReq.getLong("Montant");
				}
				else if (lib.equals("CE"))
				{
					tab_CE[i-1]=resultatReq.getLong("Montant");
				}
				else if (lib.equals("IT"))
				{
					tab_IT[i-1]=resultatReq.getLong("Montant");
				}
				else if (lib.equals("AM"))
				{
					tab_AM[i-1]=resultatReq.getLong("Montant");
				}
				else if (lib.equals("CF"))
				{
					tab_CF[i-1]=resultatReq.getLong("Montant");
				}
			
			}			
		}	
	}
	
	
	
	public void calculeSommes()	{
	
	 	total_CA = 0;
	 	total_AD = 0;
	 	total_CP = 0;
	 	total_CE = 0;
	 	total_IT = 0;
	 	total_AM = 0;
	 	total_CF = 0;
		
		for (int y=1; y<=nbMois; y++) {
			total_CA+=tab_CA[y-1];
		 	total_AD+=tab_AD[y-1];
		 	total_CP+=tab_CP[y-1];
		 	total_CE+=tab_CE[y-1];
		 	total_IT+=tab_IT[y-1];
		 	total_AM+=tab_AM[y-1];
		 	total_CF+=tab_CF[y-1];
		}		
	}
	
	
	
	public void rempliLignesOoo() {
	
		OooCellule cel;
		OooCellule celVide=new OooCellule("",rienStyle);
		OooLigne ligne;
		long cumul;

		// CA production
			cel=new OooCellule("CA production", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(total_CA, caseStyle);
			ligne.ajouterCellule(cel);
			
			cumul=0;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(tab_CA[n-1], caseStyle);
				ligne.ajouterCellule(cel);
				cumul+=tab_CA[n-1];
				cel=new OooCellule(cumul, caseStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			picasso.ajouterLigne(ligne);
			
			
			// AD
			cel=new OooCellule("Achats directs et sous traitances", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(total_AD, caseStyle);
			ligne.ajouterCellule(cel);
			
			cumul=0;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(tab_AD[n-1], caseStyle);
				ligne.ajouterCellule(cel);
				cumul+=tab_AD[n-1];
				cel=new OooCellule(cumul, caseStyle);
				ligne.ajouterCellule(cel);
			}
	
			picasso.ajouterLigne(ligne);
			
			
			// Marge brute
			cel=new OooCellule("Marge brute", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule((total_CA-total_AD), chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			cumul=0;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule((tab_CA[n-1]-tab_AD[n-1]), chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cumul+=tab_CA[n-1]-tab_AD[n-1];
				cel=new OooCellule(cumul, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
			}
	
			picasso.ajouterLigne(ligne);
			
			// charges de personnel
			cel=new OooCellule("Charges de personnel", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(total_CP, caseStyle);
			ligne.ajouterCellule(cel);
			
			cumul=0;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(tab_CP[n-1], caseStyle);
				ligne.ajouterCellule(cel);
				cumul+=tab_CP[n-1];
				cel=new OooCellule(cumul, caseStyle);
				ligne.ajouterCellule(cel);
			}
	
			picasso.ajouterLigne(ligne);
			
			// charges externes
			cel=new OooCellule("Charges externes", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(total_CE, caseStyle);
			ligne.ajouterCellule(cel);
			
			cumul=0;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(tab_CE[n-1], caseStyle);
				ligne.ajouterCellule(cel);
				cumul+=tab_CE[n-1];
				cel=new OooCellule(cumul, caseStyle);
				ligne.ajouterCellule(cel);
			}
	
			picasso.ajouterLigne(ligne);
			
			// impots
			cel=new OooCellule("Autres impots et taxes", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(total_IT, caseStyle);
			ligne.ajouterCellule(cel);
			
			cumul=0;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(tab_IT[n-1], caseStyle);
				ligne.ajouterCellule(cel);
				cumul+=tab_IT[n-1];
				cel=new OooCellule(cumul, caseStyle);
				ligne.ajouterCellule(cel);
			}
	
			picasso.ajouterLigne(ligne);
			
			// amort
			cel=new OooCellule("Amortissements", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(total_AM, caseStyle);
			ligne.ajouterCellule(cel);
			
			cumul=0;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(tab_AM[n-1], caseStyle);
				ligne.ajouterCellule(cel);
				cumul+=tab_AM[n-1];
				cel=new OooCellule(cumul, caseStyle);
				ligne.ajouterCellule(cel);
			}
	
			picasso.ajouterLigne(ligne);
			
			// charges financires
			cel=new OooCellule("Charges financires", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(total_CF, caseStyle);
			ligne.ajouterCellule(cel);
			
			cumul=0;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(tab_CF[n-1], caseStyle);
				ligne.ajouterCellule(cel);
				cumul+=tab_CF[n-1];
				cel=new OooCellule(cumul, caseStyle);
				ligne.ajouterCellule(cel);
			}
	
			picasso.ajouterLigne(ligne);
			
			// Rsultat patatra !
			cel=new OooCellule("Resultat courant", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			long result=(total_CA+total_AD)-(total_CP+total_CE+total_IT+total_AM+total_CF);
			cel=new OooCellule(result, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			cumul=0;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				result=(tab_CA[n-1]+tab_AD[n-1])-(tab_CP[n-1]+tab_CE[n-1]+tab_IT[n-1]+tab_AM[n-1]+tab_CF[n-1]);
				cel=new OooCellule(result, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cumul+=result;
				cel=new OooCellule(cumul, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
			}
	
			picasso.ajouterLigne(ligne);			
	}
	
	
	
	
	
	
	/**
	* Initialise le crateur et cre les styles
	**/
	public void initOoo()
	{
		picasso=new CreateurOpenOffice(chemin+"/openoffice");
		
		titreStyle=picasso.creerNewStyleCellule();
		titreStyle.setCouleurFond("#FCD9AF");
		titreStyle.setAlignement(OooStyleCellule.H_CENTRE,OooStyleCellule.V_MILIEU);
		titreStyle.setBordure(true);
		
		petitePolice=picasso.creerNewStyleCellule();
		petitePolice.setTaillePolice(10);
		
		chiffreTitreStyle=picasso.creerNewStyleCellule();
		chiffreTitreStyle.setCouleurFond("#FCD9AF");
		chiffreTitreStyle.setBordure(true);
		chiffreTitreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		caseStyle=picasso.creerNewStyleCellule();
		caseStyle.setBordure(true);
		caseStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		rienStyle=picasso.getStyleCelluleParDefaut();
		ligneStyle=picasso.getStyleLigneParDefaut();
	}
	
	/**
	* Entte des tableaux
	**/
	
	public void creerEntetes() {

		OooCellule celVide=new OooCellule("",rienStyle);
		OooCellule celMois=new OooCellule("Janvier", titreStyle);
		celMois.setFusion(1,2);
		OooLigne ligne=new OooLigne(ligneStyle);
		
		
		// *** PREMIERE LIGNE ***
		
		//tab de gauche
		for (int o=0; o<2; o++)
			{
				ligne.ajouterCellule(celVide);
			}
		
		//les mois
		for (int k=1; k<=nbMois; k++)
		{
			ligne.ajouterCellule(celVide);
			
			int vraiMois=k+moisDebut-1;	
			int vraiAn=anneeDebut+((k-1)/12);
			String mois=leMois(vraiMois);
			
			celMois=new OooCellule(mois+" "+vraiAn, titreStyle);
			celMois.setFusion(1,2);
			ligne.ajouterCellule(celMois);
		}
		
		picasso.ajouterLigne(ligne);
		
		
		// *** DEUXIEME LIGNE ***
		
		//tab de gauche
		OooCellule exoClosCel=new OooCellule("Exercice clos le "+date_cloture, titreStyle);
		exoClosCel.setFusion(1,2);
		ligne=new OooLigne(ligneStyle);
		ligne.ajouterCellule(exoClosCel);
		
		//les mois
		for (int k=1; k<=nbMois; k++)
		{
			ligne.ajouterCellule(celVide);
			ligne.ajouterCellule(new OooCellule("Ralis",titreStyle));
			ligne.ajouterCellule(new OooCellule("Cumul",titreStyle ));
		}
		
		picasso.ajouterLigne(ligne);		
	}
	
	
	
	
	
	public String leMois(int lemois)
	{
		String resultat="";
		
		switch (lemois)
		{
			case 1: resultat="Janvier";break;
			case 2: resultat="Fvrier";break;
			case 3: resultat="Mars";break;
			case 4: resultat="Avril";break;
			case 5: resultat="Mai";break;
			case 6: resultat="Juin";break;
			case 7: resultat="Juillet";break;
			case 8: resultat="Aout";break;
			case 9: resultat="Septembre";break;
			case 10: resultat="Octobre";break;
			case 11: resultat="Novembre";break;
			case 12: resultat="Dcembre";break;
			default: resultat="";
		
		}
		
		return resultat;
	}
	

	
} // tabDeBordVersOoo
