/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un avoir
 */

package org.opensi.compta.actions.etats;


import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.pdf.GlobalDocument;


public class GenPlanComptable extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
	  Session session=s;
	  String fichier ="";	
	  String choix ="";	
	  String rep ="";
	  String repTemp="";
	  String absdir = s.getAppConfiguration().get("opensi.absdir");
	  GlobalDocument gd =null;
	   	Integer sortie=new Integer (r.getParameter("sortie"));
	   	Integer plan=new Integer(r.getParameter("plan"));
	   
	   	choix=r.getParameter("choix");
			
	   	if (sortie==1){
	   		
	   		fichier = r.getParameter("Fichier");
	   		
	   		String buffer = absdir +"/iobuffer/";
	   		if (plan==1){
	   			//plan comptable gnral
//	   		Classe des donnes  mettre dans le document
	   			DataPlanComptableGeneral lignesdata =new DataPlanComptableGeneral(session);					
	   			new CsvPlanComptableGeneral(buffer, fichier, lignesdata);
		   	}
	   		if (plan==2){
//		   		Classe des donnes  mettre dans le document
		   		DataPlanComptableDossier lignesdata =new DataPlanComptableDossier(session, choix);		
		   		new CsvPlanComptableDossier(buffer, fichier, lignesdata);
	   		}
			
	   	}
	   	else if (sortie==2) {
	   		//	   	gnration d'un pdf - dfinition du repertoire et du format de sortie (A4)		   	
	   		rep = absdir +"/pdf/";	
	   		repTemp = rep;	
	   		fichier = r.getParameter("Fichier");
//		   	gnration d'un pdf - dfinition du repertoire et du format de sortie (A4)		
	   		gd = new GlobalDocument(rep, fichier);	
	   		
	   		if (plan==1){
	   			//plan comptable gnral
//	   		Classe des donnes  mettre dans le document
	   			DataPlanComptableGeneral lignesdata =new DataPlanComptableGeneral(session);	
				//				classe de construction du document pdf (com.lowagie)
	   			PdfPlanComptableGeneral PlanComptable = new PdfPlanComptableGeneral(lignesdata, repTemp);					
	   			gd.addInternal(PlanComptable);
		   	}
		   	else if (plan==2){
		   		//	plan comptable dossier
	   			//	   		Classe des donnes  mettre dans le document
		   		DataPlanComptableDossier lignesdata =new DataPlanComptableDossier(session, choix);		
				//				classe de construction du document pdf (com.lowagie)
		   		PdfPlanComptableDossier PlanComptable = new PdfPlanComptableDossier(lignesdata, repTemp);	
		   		//		   	gnration du document
		   		gd.addInternal(PlanComptable);
		   	}
	   			
			//fermeture du document
			gd.close(GlobalDocument.ON_EXIT);
			gd.close();
	   	}
	   	
	   	
	   	
		return true;
		
	} // fin service


} // fin GenAvoir
