/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition du centralisateur.
 */

package org.opensi.compta.actions.etats;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfCentralisateur extends Action {


	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse;
	private String compAdresse;
	private String codePostal;
	private String ville;

	private String titre;
	private String debutExercice;
	private String finExercice;


		public MyPageEvent(String dossierId, String ordre, String debutExercice, String finExercice) throws SQLException {

			this.dossierId = dossierId;

			this.titre = ordre.equals("J")?"Journaux":"Mois";

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery("select * from "+ baseDossier +".SOCIETE");

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finExercice = formatDate.format(new Date(Long.parseLong(finExercice)));
			this.debutExercice = formatDate.format(new Date(Long.parseLong(debutExercice)));

		}

    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				// Entete Gnrale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.compAdresse, fontGen));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.codePostal + " " + this.ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Centralisateur par "+ titre, new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);


				cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExercice + " au " + this.finExercice, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale


				// Titres de colonnes

				PdfPTable titresColonnes = new PdfPTable(5);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(15);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(5);
				titresColonnes.addCell(cellTitre);
				cellTitre.setColspan(1);

				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("JOURNAL", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("PERIODE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("ECRITURES", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("DEBIT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("CREDIT", fontLine));
				titresColonnes.addCell(cellTitre);

				document.add(titresColonnes);

				// fin Titres de colonnes

			}
			catch(DocumentException de) { de.printStackTrace(); }

		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 9, Font.NORMAL);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");

private int widths[] = {13,18,19,25,25}; // largeurs des colonnes du listing


private Connection con;
private String baseDossier;

  public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);


		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("-");
		numFormat.setNegativePrefix("");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);


		String dossierId = s.getCookie().get("Dossier_Id");
		String base = s.getCookie().get("BaseExo");
		String debutExercice = r.getParameter("Debut_Exercice");
		String finExercice = r.getParameter("Fin_Exercice");
		String dateDebut = r.getParameter("Date_Debut");
		String dateFin = r.getParameter("Date_Fin");
		String journal = r.getParameter("Code_Journal");
		String ordre = r.getParameter("Ordre");
		
		baseDossier = s.getCookie().get("BaseDossier");


		double credit;
		double debit;
		double creditTotal = 0;
		double debitTotal = 0;
		double creditGeneral = 0;
		double debitGeneral = 0;

		String journalCourant = "";
		String journalOld = "";
		long periodeCourant = 0;
		long periodeOld = 0;

		Calendar calendar = Calendar.getInstance();
		calendar.clear();

		long debutPeriode;
		long finPeriode;
		long nbec;
		long nbecTotal = 0;
		long nbecGeneral = 0;

		int fyy;
		int fmm;
		int dyy;
		int dmm;

		SimpleDateFormat dfPeriode = new SimpleDateFormat("MM.yy");


		if (dateFin.length() == 0 && dateDebut.length() == 0) {
			debutPeriode = Long.parseLong(debutExercice);
			finPeriode = Long.parseLong(finExercice) + 216000000;  // on ajoute un jour
		}
		else {
			dyy = 2000 + Integer.parseInt(dateDebut.substring(2,4));
			dmm = Integer.parseInt(dateDebut.substring(0,2))-1;

			if(dateFin.length() == 0) {
				calendar.set(dyy,dmm,1,0,0,0);
				debutPeriode = calendar.getTimeInMillis();
				calendar.set(dyy,dmm+1,1,0,0,0);
				finPeriode = calendar.getTimeInMillis();
			}
			else {
				fyy = 2000 + Integer.parseInt(dateFin.substring(2,4));
				fmm = Integer.parseInt(dateFin.substring(0,2));
				calendar.set(dyy,dmm,1,0,0,0);
				debutPeriode = calendar.getTimeInMillis();
				calendar.set(fyy,fmm,1,0,0,0);
				finPeriode = calendar.getTimeInMillis();
			}
		}


		Document document = new Document(PageSize.A4, 25, 25, 25, 25);

		String chemin = s.getAppConfiguration().get("opensi.absdir") +"/pdf/";
		String fichierPdf = r.getParameter("FichierPDF");

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

		MyPageEvent event = new MyPageEvent(dossierId, ordre, debutExercice, finExercice);

		writer.setPageEvent(event);

		document.open();


		String reqLesJournaux = "select Code_Journal, Date_Ecriture, sum(Montant_D) as Debit, sum(Montant_C) as Credit, count(Op_Id) as NbEc from "+ base +".ECRITURE e," + base + ".OPERATION o "
			+ "where e.Ecriture_Id=o.Ecriture_Id and Date_Ecriture<" + finPeriode + " and Date_Ecriture>=" + debutPeriode;


		if (!journal.equalsIgnoreCase("tous")) {
			reqLesJournaux += " and Code_Journal='"+ journal +"'";
		}

		if (ordre.equals("J")) {
			reqLesJournaux += " group by Code_Journal, Date_Ecriture";
		}
		else {
			reqLesJournaux += " group by Date_Ecriture, Code_Journal";
		}


		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery(reqLesJournaux);

		PdfPTable listing = new PdfPTable(5);
		listing.setWidthPercentage(100);
		listing.setWidths(widths);

		while (rset.next()) {

			journalCourant = rset.getString("Code_Journal");
			periodeCourant = rset.getLong("Date_Ecriture");

			if (ordre.equals("J")) {

				if (!journalOld.equals("") && !journalCourant.equals(journalOld)) {
					putTotal(listing, journalOld, nbecTotal, debitTotal, creditTotal);
					creditTotal = 0;
					debitTotal = 0;
					nbecTotal = 0;
				}

				journalOld = journalCourant;

			}
			else {

				if (periodeOld != 0 && periodeCourant != periodeOld) {
					putTotal(listing, dfPeriode.format(new Date(periodeOld)), nbecTotal, debitTotal, creditTotal);
					creditTotal = 0;
					debitTotal = 0;
					nbecTotal = 0;
				}

				periodeOld = periodeCourant;

			}

			credit = rset.getDouble("Credit");
			debit = rset.getDouble("Debit");
			nbec = rset.getLong("NbEc");

			putLigneCentralisateur(listing, journalCourant, periodeCourant, nbec, debit, credit);

			creditTotal += credit;
			debitTotal += debit;
			creditGeneral += credit;
			debitGeneral += debit;
			nbecTotal += nbec;
			nbecGeneral += nbec;

		}
		rset.close();

		stt.close();


		if (ordre.equals("J")) {
			putTotal(listing, journalOld, nbecTotal, debitTotal, creditTotal);
		}
		else {
			putTotal(listing, dfPeriode.format(new Date(periodeOld)), nbecTotal, debitTotal, creditTotal);
		}

		putTotalGeneral(listing, nbecGeneral, debitGeneral, creditGeneral);

		document.add(listing);

		document.close();

		s.closeConnection(con, null);


		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}


		return true;


	} // fin service



	/** Ajoute une ligne d'operation au listing */

	private void putLigneCentralisateur(PdfPTable listing, String codeJournal, long periode, long ecritures, double debit, double credit) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(codeJournal, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(periode)), fontLine));
		listing.addCell(cellListing);

		cellListing.setPaddingRight(5);
		cellListing.setBorder(PdfPCell.RIGHT);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(""+ecritures, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(debit==0?"":numFormat.format(debit), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(credit==0?"":numFormat.format(credit), fontLine));
		listing.addCell(cellListing);

	}


	/** Ajoute une ligne de total pour un journal au listing */

	private void putTotalGeneral(PdfPTable listing, long ecritures, double debit, double credit) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(Color.LIGHT_GRAY);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setColspan(2);
		cellListing.setPaddingRight(5);

		cellListing.setPhrase(new Phrase("Total G\u00E9n\u00E9ral", fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(1);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(""+ecritures, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		listing.addCell(cellListing);

	}

	/** Ajoute une ligne de total pour un journal au listing */

	private void putTotal(PdfPTable listing, String titre, long ecritures, double debit, double credit) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setColspan(2);
		cellListing.setPaddingRight(5);

		cellListing.setPhrase(new Phrase("Total "+titre, fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(1);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(""+ecritures, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		listing.addCell(cellListing);

	}


} // fin GenPdfCentralisateur
