/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.compta.actions.etats;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.DateTime;

import com.lowagie.text.*;
import com.lowagie.text.pdf.*;


public class GenPdfBilan extends Action {


	class MyPageEvent implements PdfPageEvent {


	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse;
	private String compAdresse;
	private String codePostal;
	private String ville;
	private String monnaie;

	private String debutExercice;
	private String finExercice;
	private String finPeriodeStr;
	private String finExerciceN1Str;
	private boolean dateHeure;
	private boolean numDossier;
	private boolean projet;


		public MyPageEvent(String dossierId, String debutExercice, String finExercice, String dateHeure, String numDossier, String projet) throws SQLException {

			this.dossierId = dossierId;
			this.dateHeure = dateHeure.equalsIgnoreCase("y");
			this.numDossier = numDossier.equalsIgnoreCase("n");
			this.projet = projet.equalsIgnoreCase("y");

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ baseDossier +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery(reqLeDossier);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finPeriodeStr = formatDate.format(new Date(finPeriode));
			this.debutExercice = formatDate.format(new Date(Long.parseLong(debutExercice)));
			this.finExercice = formatDate.format(new Date(Long.parseLong(finExercice)));
			this.finExerciceN1Str = formatDate.format(new Date(finExerciceN1));

		}

    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				if (projet) {
					try {
						PdfContentByte dcu = writer.getDirectContentUnder();
						Image fond = Image.getInstance(cheminImages +"projet.jpg");
						fond.scaleAbsolute(324, 468);
						fond.setAbsolutePosition(135,100);
						dcu.addImage(fond);
					}
					catch(java.net.MalformedURLException mfue) { System.err.println(mfue.getMessage()); }
					catch(IOException ioe) { System.err.println(ioe.getMessage()); }
				}

				// Entete Gnrale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase(numDossier?"Dossier : "+this.dossierId:"", fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase(dateHeure?"Date : "+this.dateCourante:"", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExercice + " au " + this.finExercice, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.compAdresse, fontGen));
				cellEntete.setColspan(1);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.codePostal + " " + this.ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(detailBIL?"D\u00E9tail du Bilan "+titre:"Bilan "+titre, new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(9);
				entete.addCell(cellEntete);


				cellEntete.setPhrase(new Phrase("Au " + this.finPeriodeStr, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(8);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale


				// Titres de colonnes

				PdfPTable titreEntier = new PdfPTable(2);
				titreEntier.setWidthPercentage(100);
				titreEntier.setWidths(widthsSection);
				PdfPCell cellEntier = new PdfPCell(titreEntier.getDefaultCell());

				if (!detailBIL) {
					cellEntier.setFixedHeight(8);
					cellEntier.setBorder(PdfPCell.NO_BORDER);
					cellEntier.setPhrase(new Phrase(""));
					cellEntier.setColspan(nbColListing);
					titreEntier.addCell(cellEntier);

					cellEntier.setColspan(1);
					cellEntier.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
					cellEntier.setBackgroundColor(Color.LIGHT_GRAY);
					cellEntier.setPhrase(new Phrase(""));
					cellEntier.setPadding(0);
					titreEntier.addCell(cellEntier);
				}

				PdfPTable titresColonnes = new PdfPTable(nbColListing);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widthsListing);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				if (detailBIL) {
					cellTitre.setFixedHeight(10);
					cellTitre.setBorder(PdfPCell.NO_BORDER);
					cellTitre.setPhrase(new Phrase(""));
					cellTitre.setColspan(nbColListing);
					titresColonnes.addCell(cellTitre);
				}

				cellTitre.setColspan(1);
				cellTitre.setMinimumHeight(16);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM - (detailBIL?0:PdfPCell.LEFT));
				cellTitre.setPhrase(new Phrase(""));
				titresColonnes.addCell(cellTitre);

				if (!detailBIL && titre.equalsIgnoreCase("Actif")) {
					cellTitre.setColspan(3);
					cellTitre.setBorder(PdfPCell.BOX);
					Phrase exon = new Phrase("Exercice N  "+ this.finPeriodeStr, fontLine);
					exon.add(new Chunk("\n("+ dureeN +" mois)", fontMini));

					cellTitre.setPhrase(exon);
				}
				else {
					cellTitre.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
					Phrase exon = new Phrase("Exercice N", fontLine);
					exon.add(new Chunk("\n("+ dureeN +" mois)", fontMini));

					cellTitre.setPhrase(exon);
				}

				titresColonnes.addCell(cellTitre);
				cellTitre.setColspan(1);

				if (compareN1) {
					if (!detailBIL && titre.equalsIgnoreCase("Actif")) {
						Phrase exon1 = new Phrase("Exercice N-1", fontLine);
						exon1.add(new Chunk("\n("+ dureeN1 +" mois)", fontMini));
						exon1.add(new Chunk("\n"+ this.finExerciceN1Str, fontLine));

						cellTitre.setPhrase(exon1);
					}
					else {
						Phrase exon1 = new Phrase("Exercice N-1", fontLine);
						exon1.add(new Chunk("\n("+ dureeN1 +" mois)", fontMini));

						cellTitre.setPhrase(exon1);
					}
					titresColonnes.addCell(cellTitre);

					cellTitre.setColspan(2);
					cellTitre.setBorder(PdfPCell.BOX);
					Phrase enn1 = new Phrase("Ecart N / N-1", fontLine);

					if (proratisation) {
						enn1.add(new Chunk("\n(proratis\u00E9)", fontMini));
					}

					cellTitre.setPhrase(enn1);
					titresColonnes.addCell(cellTitre);
				}

				cellTitre.setColspan(1);
				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.TOP - (detailBIL?0:PdfPCell.LEFT));

				cellTitre.setPhrase(new Phrase("", fontLine));
				titresColonnes.addCell(cellTitre);

				if (!detailBIL && titre.equalsIgnoreCase("Actif")) {
					cellTitre.setBorder(PdfPCell.BOX - PdfPCell.TOP);
					cellTitre.setPhrase(new Phrase("Brut", fontLine));
					titresColonnes.addCell(cellTitre);
					cellTitre.setPhrase(new Phrase("Amortissements et Provisions", new Font(Font.HELVETICA , 7, Font.NORMAL)));
					titresColonnes.addCell(cellTitre);
					cellTitre.setPhrase(new Phrase("Net", fontLine));
					titresColonnes.addCell(cellTitre);
				}
				else {
					cellTitre.setBorder(PdfPCell.BOX - PdfPCell.TOP);
					cellTitre.setPhrase(new Phrase(this.finPeriodeStr, fontLine));
					titresColonnes.addCell(cellTitre);
				}

				if (compareN1) {
					if (!detailBIL && titre.equalsIgnoreCase("Actif")) {
						cellTitre.setPhrase(new Phrase("Net", fontLine));
					}
					else {
						cellTitre.setPhrase(new Phrase(this.finExerciceN1Str, fontLine));
					}
					titresColonnes.addCell(cellTitre);

					cellTitre.setBorder(PdfPCell.BOX);
					cellTitre.setPhrase(new Phrase(this.monnaie.toUpperCase() + "S", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setPhrase(new Phrase("%", fontLine));
					titresColonnes.addCell(cellTitre);
				}

				if (!detailBIL) {
					cellEntier = new PdfPCell(titresColonnes);
					cellEntier.setBorder(PdfPCell.BOX - PdfPCell.LEFT);

					titreEntier.addCell(cellEntier);
					document.add(titreEntier);
				}
				else {
					document.add(titresColonnes);
				}

				// fin Titres de colonnes

			}
			catch(DocumentException de) { de.printStackTrace(); }

		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 9, Font.NORMAL);		// font pour lignes de listing
private static final Font fontMini = new Font(Font.HELVETICA , 7, Font.NORMAL);		// font pour prcisions
private DecimalFormat numFormat = new DecimalFormat("0");
private DecimalFormat numFormat2 = new DecimalFormat("0.00");

private int widthsSection[] = {8,92};
private int widthsListing[];

private String titre;
private String base;
private String baseDossier;
private String baseN1;
private boolean detailBIL;
private boolean compareN1;
private boolean proratisation;
private long debutPeriode;
private long finPeriode;
private long finExerciceN1;
private int nbColListing;
private int dureeN1 = 0;
private int dureeN = 0;

private Connection con;
private String cheminImages;

private PdfWriter pdfWriter;

  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);


		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);

		numFormat2.setDecimalFormatSymbols(dfs);
		numFormat2.setGroupingUsed(true);
		numFormat2.setGroupingSize(3);

		String dossierId = s.getCookie().get("Dossier_Id");
		String base = s.getCookie().get("BaseExo");
		this.baseDossier = s.getCookie().get("BaseDossier");

		String debutExercice = r.getParameter("Debut_Exercice");
		String finExercice = r.getParameter("Fin_Exercice");
		String dateFin = r.getParameter("Date_Fin");
		String type = r.getParameter("Type");
		String numDossier = r.getParameter("Num_Dossier");
		String dateHeure = r.getParameter("Date_Heure");
		String comparatif = r.getParameter("Comparatif");
		String proratiser = r.getParameter("Proratisation");
		String projet = r.getParameter("Projet");
		String detail = r.getParameter("Detail");
	  int numExerciceN1 = Integer.parseInt(r.getParameter("Num_Exercice"))-1;


		int widthsListing2[] = {60,40};          			// largeurs colonnes sans comparatif N-1 pour bilan passif et bilan actif dtaill
		int widthsListing4[] = {58,14,14,14}; 				// largeurs de colonnes sans comparatif N-1 pour bilan actif
		int widthsListing5[] = {57,12,12,11,8};    		// largeurs colonnes avec comparatif N-1 pour bilan passif et bilan actif dtaill
		int widthsListing7[] = {33,12,12,12,12,11,8}; // largeurs de colonnes avec comparatif N-1 pour bilan actif non dtaill


		if (type.equalsIgnoreCase("D")) {
			this.finPeriode = DateTime.parseDate(dateFin, "dd/MM/yy");
		}
		else {
			this.finPeriode = Long.parseLong(finExercice);
		}

		this.debutPeriode = Long.parseLong(debutExercice);
		this.base = base;
		this.detailBIL = detail.equalsIgnoreCase("y");
		this.compareN1 = comparatif.equalsIgnoreCase("n");
		this.proratisation = proratiser.equalsIgnoreCase("y");


		// base si comparatif et exercice n-1 existe

		String reqExoN1 = "select Nom_Base, Duree_Exercice, Fin_Exercice from "+ baseDossier +".EXERCICE where Num_Exercice="+ numExerciceN1;

		Statement stt = con.createStatement();
		ResultSet rsetN1 = stt.executeQuery(reqExoN1);

		if (rsetN1.next()) {
			baseN1 = rsetN1.getString("Nom_Base");
			dureeN1 = rsetN1.getInt("Duree_Exercice");
			finExerciceN1 = rsetN1.getLong("Fin_Exercice");
			Arrondi rd = new Arrondi(0);
			dureeN = (int)rd.round((((double)finPeriode-debutPeriode)/86400000)/30);
		}
		else {
			this.compareN1 = false; // on force a faux si pas d'exo precedent
		}

		rsetN1.close();
		stt.close();


		Document document = new Document(PageSize.A4, 25, 25, 25, 25);

		String chemin = s.getAppConfiguration().get("opensi.absdir") +"/pdf/";

		this.cheminImages = s.getAppConfiguration().get("opensi.absdir") +"/images/";

		String fichierPdf = r.getParameter("FichierPDF");

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

		pdfWriter = writer;

		MyPageEvent event = new MyPageEvent(dossierId, debutExercice, finExercice, dateHeure, numDossier, projet);

		writer.setPageEvent(event);


		if (compareN1) {
			this.nbColListing = 5;
			this.widthsListing = widthsListing5;
		}
		else {
			this.nbColListing = 2;
			this.widthsListing = widthsListing2;
		}

		this.titre = "Passif";

		document.open();


		/* BILAN PASSIF */

		document.add(putSectionPassif());

		this.titre = "Actif";

		if (compareN1) {
			if (detailBIL) {
				this.nbColListing = 5;
				this.widthsListing = widthsListing5;
			}
			else {
				this.nbColListing = 7;
				this.widthsListing = widthsListing7;
			}
		}
		else {
			if (detailBIL) {
				this.nbColListing = 2;
				this.widthsListing = widthsListing2;
			}
			else {
				this.nbColListing = 4;
				this.widthsListing = widthsListing4;
			}
		}

		document.newPage();


		/* BILAN ACTIF */

		document.add(putSectionActif());

		document.close();

		s.closeConnection(con, null);


		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}


		return true;


	} // fin service


	private double getSumCompte(int sum, String like) throws SQLException, Exception {

		double val = 0;
		double debit;
		double credit;
		String request;


		Statement stt = con.createStatement();

		request = "select sum(Montant_D) as debit, sum(Montant_C) as credit from "+ baseDossier +".COMPTE c,"+ base +".OPERATION o where o.Date_Op>="+ debutPeriode +" and o.Date_Op<="+ finPeriode +" and c.Numero_Compte=o.Numero_Compte and c.Numero_Compte like '"+ like +"' group by c.Numero_Compte";

		ResultSet rset = stt.executeQuery(request);

		while(rset.next()) {

			credit = rset.getDouble("credit");
			debit = rset.getDouble("debit");

			if (sum==0)
				val += this.titre.equalsIgnoreCase("Passif")?credit-debit:debit-credit;
			else if (sum==-1)
				val += debit>credit?debit-credit:0;
			else if (sum==1)
				val += credit>debit?credit-debit:0;

		}
		rset.close();

		// traitement des comptes auxiliaires/clients/fournisseurs

		request = "select sum(Montant_D) as debit, sum(Montant_C) as credit from "+ base +".OPERATION o,"+ baseDossier +".COMPTE c where c.Type_Compte<>'G' and c.Collectif like '"+ like +"' and o.Numero_Compte=c.Numero_Compte and ((Date_Op<="+ finPeriode +" and Date_Op>="+ debutPeriode +") or Date_Op<"+ debutPeriode +") group by c.Numero_Compte";

		rset = stt.executeQuery(request);

		while(rset.next()) {

			credit = rset.getDouble("credit");
			debit = rset.getDouble("debit");

			if (sum==0)
				val += this.titre.equalsIgnoreCase("Passif")?credit-debit:debit-credit;
			else if (sum==-1)
				val += debit>credit?debit-credit:0;
			else if (sum==1)
				val += credit>debit?credit-debit:0;

		}
		rset.close();

		stt.close();

		return val;
	}
	

	private void putDetailSection(PdfPTable listing, int sum, String like) throws SQLException, Exception {

		double credit;
		double debit;
		double val = 0;
		double valN1 = 0;
		String libelle;
		String numero;
		ResultSet rsetLib;
		ResultSet rsetN1;
		ResultSet rsetN;


		Statement stt = con.createStatement();
		PreparedStatement ps = con.prepareStatement("select sum(Montant_D) as debit, sum(Montant_C) as credit from "+ baseDossier +".COMPTE c,"+ base +".OPERATION o where o.Date_Op>="+ debutPeriode +" and o.Date_Op<="+ finPeriode +" and c.Numero_Compte=o.Numero_Compte and c.Numero_Compte=?");
		PreparedStatement ps1 = con.prepareStatement("select Total_Debit, Total_Credit from "+ baseN1 +".SOLDE_COMPTE where Numero_Compte=?");

		// Cas gnral

		String request = "select Intitule, Numero_Compte from "+ baseDossier +".COMPTE c where Type_Compte='G' and Centralisateur=0 and Numero_Compte like '"+ like +"'";

		ResultSet rset = stt.executeQuery(request);

		while (rset.next()) {
			libelle = rset.getString("Intitule");
			numero = rset.getString("Numero_Compte");

			ps.clearParameters();
			ps.setString(1, numero);

			rsetN = ps.executeQuery();

			if (rsetN.next()) {

				credit = rsetN.getDouble("credit");
				debit = rsetN.getDouble("debit");

				if (sum==0)
					val = this.titre.equalsIgnoreCase("Passif")?credit-debit:debit-credit;
				else if (sum==-1)
					val = debit>credit?debit-credit:0;
				else if (sum==1)
					val = credit>debit?credit-debit:0;

			}
			rsetN.close();

			if (compareN1) {

				ps1.clearParameters();
				ps1.setString(1, numero);
				rsetN1 = ps1.executeQuery();

				if (rsetN1.next()) {

					credit = rsetN1.getDouble("Total_Credit");
					debit = rsetN1.getDouble("Total_Debit");

					if (sum==0)
						valN1 = this.titre.equalsIgnoreCase("Passif")?credit-debit:debit-credit;
					else if (sum==-1)
						valN1 = debit>credit?debit-credit:0;
					else if (sum==1)
						valN1 = credit>debit?credit-debit:0;

				}
				rsetN1.close();
			}

			val = (val>=0.01 || val<=-0.01)?val:0;
			valN1 = (valN1>=0.01 || valN1<=-0.01)?valN1:0;

			if (val!=0 || valN1!=0) {
				putLigneDetail(listing, numero, libelle, val, valN1);
			}
		}
		rset.close();


		ps.close();
		ps1.close();

		
		ps = con.prepareStatement("select sum(Montant_D) as debit, sum(Montant_C) as credit from "+ baseDossier +".COMPTE c,"+ base +".OPERATION o where c.Collectif=? and ((o.Date_Op>="+ debutPeriode +" and o.Date_Op<="+ finPeriode +") or Date_Op<"+ debutPeriode +") and c.Numero_Compte=o.Numero_Compte group by c.Numero_Compte");
		ps1 = con.prepareStatement("select s.Total_Debit, s.Total_Credit from "+ baseN1 +".SOLDE_COMPTE s join "+ baseDossier +".COMPTE c on c.Numero_Compte=s.Numero_Compte where c.Collectif=?");
		
		request = "select Intitule, Numero_Compte from "+ baseDossier +".COMPTE c where Type_Compte='G' and Centralisateur=1 and Numero_Compte like '"+ like +"'";

		rset = stt.executeQuery(request);

		while (rset.next()) {
			libelle = rset.getString("Intitule");
			numero = rset.getString("Numero_Compte");

			ps.clearParameters();
			ps.setString(1, numero);

			rsetN = ps.executeQuery();
			
			val = 0;

			while (rsetN.next()) {

				credit = rsetN.getDouble("credit");
				debit = rsetN.getDouble("debit");

				if (sum==0)
					val += this.titre.equalsIgnoreCase("Passif")?credit-debit:debit-credit;
				else if (sum==-1)
					val += debit>credit?debit-credit:0;
				else if (sum==1)
					val += credit>debit?credit-debit:0;

			}
			rsetN.close();

			if (compareN1) {

				ps1.clearParameters();
				ps1.setString(1, numero);
				rsetN1 = ps1.executeQuery();

				valN1 = 0;

				while (rsetN1.next()) {

					credit = rsetN1.getDouble("Total_Credit");
					debit = rsetN1.getDouble("Total_Debit");

					if (sum==0)
						valN1 += this.titre.equalsIgnoreCase("Passif")?credit-debit:debit-credit;
					else if (sum==-1)
						valN1 += debit>credit?debit-credit:0;
					else if (sum==1)
						valN1 += credit>debit?credit-debit:0;

				}
				rsetN1.close();
			}

			val = (val>=0.01 || val<=-0.01)?val:0;
			valN1 = (valN1>=0.01 || valN1<=-0.01)?valN1:0;

			if (val!=0 || valN1!=0) {
				putLigneDetail(listing, numero, libelle, val, valN1);
			}
		}
		rset.close();


		ps.close();
		ps1.close();

		stt.close();
	}
	

	private void putLigneDetail(PdfPTable listing, String numero, String libelle, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPaddingLeft(25);
		cellListing.setPhrase(new Phrase(numero +" "+ libelle, fontLine));
		listing.addCell(cellListing);

		cellListing.setPaddingLeft(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}

	private PdfPTable putSectionPassif() throws DocumentException, SQLException, Exception {

		double valN;
		double valN1 = 0;
		double totalN = 0;
		double totalN1 = 0;

		double globalN = 0;
		double globalN1 = 0;

		int s = 0;
		int d = -1;
		int c = 1;

		PdfPTable section = new PdfPTable(2);
		section.setWidthPercentage(100);
		section.setWidths(widthsSection);


		PdfContentByte pcb = pdfWriter.getDirectContent();

		BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA_BOLD, BaseFont.CP1252, BaseFont.NOT_EMBEDDED);

		PdfTemplate template = pcb.createTemplate(130,45);

		template.beginText();
    template.setFontAndSize(bf, 12);
    template.setTextMatrix(0, 20);
		template.showText("CAPITAUX PROPRES");
    template.endText();

		//cellSection.setCellEvent(new MyCellEvent());

		Image image = Image.getInstance(template);
		image.setRotationDegrees(90);

		PdfPCell cellSection = new PdfPCell(image, false);


		cellSection.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellSection.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		PdfPTable listing = new PdfPTable(this.nbColListing);
		listing.setWidthPercentage(100);
		listing.setWidths(widthsListing);

		//cellSection.setPhrase(new Phrase("CAPITAUX PROPRES", new Font(Font.HELVETICA, 10, Font.BOLD)));

		valN  = getSumCompte(s, "100%")
					+ getSumCompte(s, "101%")
					+ getSumCompte(s, "102%")
					+ getSumCompte(s, "103%")
					+ getSumCompte(s, "108%")
					+ getSumCompte(c, "109%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "100%")
						+ getSumCompteN1(s, "101%")
						+ getSumCompteN1(s, "102%")
						+ getSumCompteN1(s, "103%")
						+ getSumCompteN1(s, "108%")
						+ getSumCompteN1(c, "109%");

			totalN1 += valN1;
		}

		double dontVerse = getSumCompte(s, "1014%") + getSumCompte(s, "1013%") + getSumCompte(s, "1018%");

		putLigneBilanPassif(listing, "Capital (Dont vers\u00E9: "+ numFormat.format(dontVerse) +" )", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"100%");
			putDetailSection(listing, s,"101%");
			putDetailSection(listing, s,"102%");
			putDetailSection(listing, s,"103%");
			putDetailSection(listing, s,"108%");
			putDetailSection(listing, c,"109%");
			putEspacement(listing, 5);
		}

		valN  = getSumCompte(s, "104%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "104%");
			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Primes d'\u00E9mission, de fusion, d'apport", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"104%");
			putEspacement(listing, 5);
		}

		valN  = getSumCompte(s, "105%")
					+ getSumCompte(s, "107%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "105%")
						+ getSumCompteN1(s, "107%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Ecart de r\u00E9\u00E9valuation", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"105%");
			putDetailSection(listing, s,"107%");
			putEspacement(listing, 5);
		}

		valN  = getSumCompte(s, "1061%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "1061%");
			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "R\u00E9serve l\u00E9gale", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"1061%");
			putEspacement(listing, 5);
		}

		valN  = getSumCompte(s, "1063%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "1063%");
			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "R\u00E9serves statutaires ou contractuelles", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"1063%");
			putEspacement(listing, 5);
		}

		valN  = getSumCompte(s, "1062%")
				  + getSumCompte(s, "1064%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "1062%")
				  	+ getSumCompteN1(s, "1064%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "R\u00E9serves r\u00E9glement\u00E9es", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"1062%");
			putDetailSection(listing, s,"1064%");
			putEspacement(listing, 5);
		}

		valN  = getSumCompte(s, "106%")
					- getSumCompte(s, "1061%")
					- getSumCompte(s, "1062%")
					- getSumCompte(s, "1063%")
					- getSumCompte(s, "1064%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "106%")
						- getSumCompteN1(s, "1061%")
						- getSumCompteN1(s, "1062%")
						- getSumCompteN1(s, "1063%")
						- getSumCompteN1(s, "1064%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Autres r\u00E9serves", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"106%' and c.Numero_Compte not like '1061%' and c.Numero_Compte not like '1062%' and c.Numero_Compte not like '1063%' and c.Numero_Compte not like	'1064%");
			putEspacement(listing, 5);
		}

		valN  = getSumCompte(s, "11%")
				  + getSumCompte(s, "12%")
					+ getSumCompte(s, "19%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "11%")
				  	+ getSumCompteN1(s, "12%")
						+ getSumCompteN1(s, "19%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Report \u00E0 nouveau", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"11%");
			putDetailSection(listing, s,"12%");
			putDetailSection(listing, s,"19%");
			putEspacement(listing, 5);
		}

		valN  = getSumCompte(s, "1%")
					+ getSumCompte(s, "2%")
					+ getSumCompte(s, "3%")
					+ getSumCompte(s, "4%")
					+ getSumCompte(s, "5%");

		totalN -= valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "1%")
						+ getSumCompteN1(s, "2%")
						+ getSumCompteN1(s, "3%")
						+ getSumCompteN1(s, "4%")
						+ getSumCompteN1(s, "5%");

			totalN1 -= valN1;
		}

		putLigneBilanPassif(listing, "RESULTAT DE L'EXERCICE (b\u00E9n\u00E9fice ou perte)", -valN, -valN1);

		valN = getSumCompte(s, "13%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "13%");
			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Subventions d'investissement", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"13%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(s, "14%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "14%");
			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Provisions r\u00E9glement\u00E9es", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"14%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 10);
		putLigneTotal(listing ,"TOTAL I", totalN, totalN1);
		//putEspacement(listing, 5);

		globalN += totalN;
		totalN = 0;

		if (compareN1) {
			globalN1 += totalN1;
			totalN1 = 0;
		}

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));

			listing = new PdfPTable(this.nbColListing);
			listing.setWidthPercentage(95);
			listing.setWidths(widthsListing);

			template = pcb.createTemplate(90,25);

			template.beginText();
    	template.setFontAndSize(bf, 10);
    	template.setTextMatrix(0, 20);
    	template.showTextAligned(PdfContentByte.ALIGN_LEFT,"  AUTRES FONDS",0,15,0);
			template.showTextAligned(PdfContentByte.ALIGN_LEFT,"       PROPRES",0,0,0);
    	template.endText();

			image = Image.getInstance(template);
			image.setRotationDegrees(90);

			cellSection = new PdfPCell(image, false);

			cellSection.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cellSection.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

			//cellSection.setPhrase(new Phrase("AUTRES FONDS PROPRES", new Font(Font.HELVETICA, 10, Font.BOLD)));
		}

		valN = getSumCompte(s, "1671%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "1671%");
			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Produit des \u00E9missions de titres participatifs", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"1671%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(s, "1672%")
				 + getSumCompte(s, "1674%")
				 + getSumCompte(s, "1676%")
				 + getSumCompte(s, "229%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "1672%")
				  	+ getSumCompteN1(s, "1674%")
				  	+ getSumCompteN1(s, "1676%")
						+ getSumCompteN1(s, "229%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Avances conditionn\u00E9es", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"1672%");
			putDetailSection(listing, s,"1674%");
			putDetailSection(listing, s,"1676%");
			putDetailSection(listing, s,"229%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 10);

		if (!detailBIL) {
			putEspacement(listing, 32);
		}

		putLigneTotal(listing ,"TOTAL II", totalN, totalN1);
		//putEspacement(listing, 5);

		globalN += totalN;
		totalN = 0;

		if (compareN1) {
			globalN1 += totalN1;
			totalN1 = 0;
		}

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));

			listing = new PdfPTable(this.nbColListing);
			listing.setWidthPercentage(80);
			listing.setWidths(widthsListing);

			template = pcb.createTemplate(84,35);

			template.beginText();
    	template.setFontAndSize(bf, 10);
    	template.setTextMatrix(0, 20);
    	template.showTextAligned(PdfContentByte.ALIGN_LEFT,"    PROVISIONS",0,28,0);
			template.showTextAligned(PdfContentByte.ALIGN_LEFT," POUR RISQUES",0,14,0);
			template.showTextAligned(PdfContentByte.ALIGN_LEFT,"   ET CHARGES",0,0,0);
    	template.endText();

			image = Image.getInstance(template);
			image.setRotationDegrees(90);

			cellSection = new PdfPCell(image, false);

			cellSection.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cellSection.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

			//cellSection.setPhrase(new Phrase("PROVISIONS POUR RISQUES ET CHARGES", new Font(Font.HELVETICA, 10, Font.BOLD)));
		}

		valN = getSumCompte(s, "151%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "151%");
			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Provisions pour risques", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"151%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(s, "15%")
				 - getSumCompte(s, "151%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "15%")
				  	- getSumCompteN1(s, "151%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Provisions pour charges", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"15%' and c.Numero_Compte not like '151%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 10);

		if (!detailBIL) {
			putEspacement(listing, 28);
		}

		putLigneTotal(listing ,"TOTAL III", totalN, totalN1);
		//putEspacement(listing, 5);

		globalN += totalN;
		totalN = 0;

		if (compareN1) {
			globalN1 += totalN1;
			totalN1 = 0;
		}

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));

			listing = new PdfPTable(this.nbColListing);
			listing.setWidthPercentage(100);
			listing.setWidths(widthsListing);

			template = pcb.createTemplate(50,45);

			template.beginText();
    	template.setFontAndSize(bf, 12);
    	template.setTextMatrix(0, 20);
			template.showText("DETTES");
    	template.endText();

			image = Image.getInstance(template);
			image.setRotationDegrees(90);

			cellSection = new PdfPCell(image, false);

			cellSection.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cellSection.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

			//cellSection.setPhrase(new Phrase("DETTES", new Font(Font.HELVETICA, 10, Font.BOLD)));
		}

		valN = getSumCompte(s, "161%")
				 + getSumCompte(s, "16881%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "161%")
				  	+ getSumCompteN1(s, "16881%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Emprunts obligataires convertibles", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"161%");
			putDetailSection(listing, s,"16881%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(s, "163%")
				 + getSumCompte(s, "16883%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "163%")
				  	+ getSumCompteN1(s, "16883%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Autres emprunts obligataires", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"163%");
			putDetailSection(listing, s,"16883%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(s, "164%")
				 + getSumCompte(s, "16884%")
				 + getSumCompte(c, "51%")
				 + getSumCompte(c, "52%")
				 + getSumCompte(c, "54%")
				 + getSumCompte(c, "55%")
				 + getSumCompte(c, "56%")
				 + getSumCompte(c, "57%")
				 + getSumCompte(c, "58%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "164%")
				  	+ getSumCompteN1(s, "16884%")
				  	+ getSumCompteN1(c, "51%")
				  	+ getSumCompteN1(c, "52%")
				  	+ getSumCompteN1(c, "54%")
				  	+ getSumCompteN1(c, "55%")
				  	+ getSumCompteN1(c, "56%")
				  	+ getSumCompteN1(c, "57%")
				  	+ getSumCompteN1(c, "58%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Emprunts et dettes aupr\u00E8s des \u00E9tablissements de cr\u00E9dit", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"164%");
			putDetailSection(listing, s,"16884%");
			putDetailSection(listing, c,"51%");
			putDetailSection(listing, c,"52%");
			putDetailSection(listing, c,"54%");
			putDetailSection(listing, c,"55%");
			putDetailSection(listing, c,"56%");
			putDetailSection(listing, c,"57%");
			putDetailSection(listing, c,"58%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(s, "16%")
				 + getSumCompte(s, "17%")
				 + getSumCompte(s, "18%")
				 + getSumCompte(c, "426%")
				 + getSumCompte(c, "45%")
				 - getSumCompte(c, "457%")
				 - getSumCompte(s, "161%")
				 - getSumCompte(s, "163%")
				 - getSumCompte(s, "164%")
				 - getSumCompte(s, "1671%")
				 - getSumCompte(s, "1672%")
				 - getSumCompte(s, "1674%")
				 - getSumCompte(s, "1676%")
				 - getSumCompte(s, "16881%")
				 - getSumCompte(s, "16883%")
				 - getSumCompte(s, "16884%")
				 - getSumCompte(s, "169%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "16%")
				  	+ getSumCompteN1(s, "17%")
				  	+ getSumCompteN1(s, "18%")
				  	+ getSumCompteN1(c, "426%")
				  	+ getSumCompteN1(c, "45%")
				  	- getSumCompteN1(c, "457%")
				  	- getSumCompteN1(s, "161%")
				  	- getSumCompteN1(s, "163%")
				  	- getSumCompteN1(s, "164%")
				  	- getSumCompteN1(s, "1671%")
				  	- getSumCompteN1(s, "1672%")
				  	- getSumCompteN1(s, "1674%")
				  	- getSumCompteN1(s, "1676%")
				  	- getSumCompteN1(s, "16881%")
				  	- getSumCompteN1(s, "16883%")
				  	- getSumCompteN1(s, "16884%")
				  	- getSumCompteN1(s, "169%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Emprunts et dettes financi\u00E8res divers", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"16%' and c.Numero_Compte not like '161%' and c.Numero_Compte not like '163%' and c.Numero_Compte not like '164%' and c.Numero_Compte not like '1671%' and c.Numero_Compte not like '1672%' and c.Numero_Compte not like '1674%' and c.Numero_Compte not like '1676%' and c.Numero_Compte not like '16881%' and c.Numero_Compte not like '16883%' and c.Numero_Compte not like '16884%' and c.Numero_Compte not like '169%");
			putDetailSection(listing, s,"17%");
			putDetailSection(listing, s,"18%");
			putDetailSection(listing, c,"426%");
			putDetailSection(listing, c,"45%' and c.Numero_Compte not like '457%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(c, "4191%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(c, "4191%");
			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Avances et acomptes reus sur commandes en cours", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, c,"4191%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(c, "40%")
				 + getSumCompte(d, "40199999%")
				 - getSumCompte(c, "404%")
				 - getSumCompte(c, "405%")
				 - getSumCompte(c, "4084%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(c, "40%")
				  	+ getSumCompteN1(d, "40199999%")
				  	- getSumCompteN1(c, "404%")
				  	- getSumCompteN1(c, "405%")
				  	- getSumCompteN1(c, "4084%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Dettes fournisseurs et comptes rattach\u00E9s", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, c,"40%' and c.Numero_Compte not like '40199999%' and c.Numero_Compte not like '404%' and c.Numero_Compte not like '405%' and c.Numero_Compte not like '4084%");
			putDetailSection(listing, d,"40199999%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(c, "42%")
				 + getSumCompte(c, "43%")
				 + getSumCompte(c, "44%")
				 + getSumCompte(c, "457%")
				 - getSumCompte(c, "426%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(c, "42%")
				  	+ getSumCompteN1(c, "43%")
				  	+ getSumCompteN1(c, "44%")
				  	+ getSumCompteN1(c, "457%")
				  	- getSumCompteN1(c, "426%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Dettes fiscales et sociales", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, c,"42%' and c.Numero_Compte not like '426%");
			putDetailSection(listing, c,"43%");
			putDetailSection(listing, c,"44%");
			putDetailSection(listing, c,"457%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(s, "269%")
				 + getSumCompte(s, "279%")
				 + getSumCompte(c, "404%")
				 + getSumCompte(c, "405%")
				 + getSumCompte(c, "4084%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "269%")
				  	+ getSumCompteN1(s, "279%")
				  	+ getSumCompteN1(c, "404%")
				  	+ getSumCompteN1(c, "405%")
				  	+ getSumCompteN1(c, "4084%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Dettes sur immobilisations et comptes rattach\u00E9s", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"269%");
			putDetailSection(listing, s,"279%");
			putDetailSection(listing, c,"404%");
			putDetailSection(listing, c,"405%");
			putDetailSection(listing, c,"4084%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(c, "41%")
				 + getSumCompte(c, "452%")
				 + getSumCompte(c, "453%")
				 + getSumCompte(c, "454%")
				 + getSumCompte(c, "46%")
				 + getSumCompte(c, "47%")
				 + getSumCompte(c, "50%")
				 - getSumCompte(c, "41199999%")
				 - getSumCompte(c, "4191%")
				 - getSumCompte(c, "476%")
				 - getSumCompte(c, "477%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(c, "41%")
						+ getSumCompteN1(c, "452%")
						+ getSumCompteN1(c, "453%")
						+ getSumCompteN1(c, "454%")
				  	+ getSumCompteN1(c, "46%")
				  	+ getSumCompteN1(c, "47%")
				  	+ getSumCompteN1(c, "50%")
				  	- getSumCompteN1(c, "41199999%")
				  	- getSumCompteN1(c, "4191%")
				  	- getSumCompteN1(c, "476%")
				  	- getSumCompteN1(c, "477%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Autres dettes", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, c,"41%' and c.Numero_Compte not like'41199999%' and c.Numero_Compte not like'4191%");
			putDetailSection(listing, c,"452%");
			putDetailSection(listing, c,"453%");
			putDetailSection(listing, c,"454%");
			putDetailSection(listing, c,"46%");
			putDetailSection(listing, c,"47%' and c.Numero_Compte not like'476%' and c.Numero_Compte not like'477%");
			putDetailSection(listing, c,"50%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte(c, "480%")
				 + getSumCompte(c, "482%")
				 + getSumCompte(c, "483%")
				 + getSumCompte(c, "484%")
				 + getSumCompte(c, "485%")
				 + getSumCompte(c, "487%")
				 + getSumCompte(c, "488%")
				 + getSumCompte(c, "489%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(c, "480%")
				  	+ getSumCompteN1(c, "482%")
				  	+ getSumCompteN1(c, "483%")
				  	+ getSumCompteN1(c, "484%")
				  	+ getSumCompteN1(c, "485%")
				  	+ getSumCompteN1(c, "487%")
				  	+ getSumCompteN1(c, "488%")
				  	+ getSumCompteN1(c, "489%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Produits constat\u00E9s d'avance", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, c,"480%");
			putDetailSection(listing, c,"482%");
			putDetailSection(listing, c,"483%");
			putDetailSection(listing, c,"484%");
			putDetailSection(listing, c,"485%");
			putDetailSection(listing, c,"487%");
			putDetailSection(listing, c,"488%");
			putDetailSection(listing, c,"489%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 10);
		putLigneTotal(listing ,"TOTAL IV", totalN, totalN1);
		//putEspacement(listing, 5);

		globalN += totalN;
		totalN = 0;

		if (compareN1) {
			globalN1 += totalN1;
			totalN1 = 0;
		}

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));

			listing = new PdfPTable(this.nbColListing);
			listing.setWidthPercentage(100);
			listing.setWidths(widthsListing);

			template = pcb.createTemplate(100,25);

			template.beginText();
    	template.setFontAndSize(bf, 10);
    	template.setTextMatrix(0, 0);
    	template.showTextAligned(PdfContentByte.ALIGN_LEFT,"      COMPTES DE",0,15,0);
			template.showTextAligned(PdfContentByte.ALIGN_LEFT,"  REGULARISATION",0,0,0);
    	template.endText();

			image = Image.getInstance(template);
			image.setRotationDegrees(90);

			cellSection = new PdfPCell(image, false);

			cellSection.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cellSection.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

			//cellSection.setPhrase(new Phrase("COMPTES DE REGULARISATION", new Font(Font.HELVETICA, 10, Font.BOLD)));
		}

		valN = getSumCompte(c, "476%")
				 + getSumCompte(c, "477%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1(c, "476%")
				  	+ getSumCompteN1(c, "477%");

			totalN1 += valN1;
		}

		putLigneBilanPassif(listing, "Ecarts de conversion passif (V)", valN, valN1);

		if (detailBIL) {
			putDetailSection(listing, c,"476%");
			putDetailSection(listing, c,"477%");
			putEspacement(listing, 5);
		}

		//putEspacement(listing, 10);
		//putLigneTotal(listing ,"TOTAL V", totalN, totalN1);
		//putEspacement(listing, 5);

		globalN += totalN;

		if (compareN1) {
			globalN1 += totalN1;
		}

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));

			listing = new PdfPTable(this.nbColListing);
			listing.setWidthPercentage(100);
			listing.setWidths(widthsListing);

			cellSection.setImage(null);
			cellSection.setPhrase(new Phrase("", new Font(Font.HELVETICA, 10, Font.BOLD)));
		}

		//putEspacement(listing, 10);
		putLigneTotal(listing ,"TOTAL GENERAL (I+II+III+IV+V)", globalN, globalN1);
		//putEspacement(listing, 5);

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));
			return section;
		}
		return listing;

	}


	private void putLigneBilanPassif(PdfPTable listing, String intitule, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);

		if (detailBIL) {
			intitule = intitule.toUpperCase();
		}

		cellListing.setPhrase(new Phrase(intitule, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);

		if (detailBIL) {
			cellListing.setBackgroundColor(new Color(210,210,210));
		}

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}


	private PdfPTable putSectionActif() throws DocumentException, SQLException, Exception {

		double valAP;
		double valBrut;
		double valN1 = 0;
		double totalBrut = 0;
		double totalAP = 0;
		double totalN1 = 0;

		double globalBrut = 0;
		double globalAP = 0;
		double globalN1 = 0;

		int s = 0;
		int d = -1;
		int c = 1;

		PdfPTable section = new PdfPTable(2);
		section.setWidthPercentage(100);
		section.setWidths(widthsSection);

		PdfContentByte pcb = pdfWriter.getDirectContent();

		BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA_BOLD, BaseFont.CP1252, BaseFont.NOT_EMBEDDED);

		PdfTemplate template = pcb.createTemplate(125,45);

		template.beginText();
    template.setFontAndSize(bf, 12);
    template.setTextMatrix(0, 20);
		template.showText("ACTIF IMMOBILISE");
    template.endText();

		Image image = Image.getInstance(template);
		image.setRotationDegrees(90);

		PdfPCell cellSection = new PdfPCell(image, false);

	//	PdfPCell cellSection = new PdfPCell(section.getDefaultCell());

		cellSection.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellSection.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		PdfPTable listing = new PdfPTable(this.nbColListing);
		listing.setWidthPercentage(100);
		listing.setWidths(widthsListing);

		//cellSection.setPhrase(new Phrase("ACTIF IMMOBILISE", new Font(Font.HELVETICA, 10, Font.BOLD)));

		valBrut = getSumCompte(d, "109%");

		valAP = 0;

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(d, "109%");
			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Capital souscrit non appel\u00E9", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, d,"109%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "201%");

		valAP = getSumCompte(s, "2801%")
					+ getSumCompte(s, "2901%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "201%")
						+ getSumCompteN1(s, "2801%")
						+ getSumCompteN1(s, "2901%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Frais d'\u00E9tablissement", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"201%");
			putDetailSection(listing, s,"2801%");
			putDetailSection(listing, s,"2901%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "203%");

		valAP = getSumCompte(s, "2803%")
					+ getSumCompte(s, "2903%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "203%")
						+ getSumCompteN1(s, "2803%")
						+ getSumCompteN1(s, "2903%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Frais de recherche et d\u00E9veloppement", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"203%");
			putDetailSection(listing, s,"2803%");
			putDetailSection(listing, s,"2903%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "205%");

		valAP = getSumCompte(s, "2805%")
					+ getSumCompte(s, "2905%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "205%")
						+ getSumCompteN1(s, "2805%")
						+ getSumCompteN1(s, "2905%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Concessions, brevets et droits similaires", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"205%");
			putDetailSection(listing, s,"2805%");
			putDetailSection(listing, s,"2905%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "206%")
						+ getSumCompte(s, "207%");

		valAP = getSumCompte(s, "2806%")
					+ getSumCompte(s, "2906%")
					+ getSumCompte(s, "2807%")
					+ getSumCompte(s, "2907%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "206%")
						+ getSumCompteN1(s, "207%")
						+ getSumCompteN1(s, "2806%")
						+ getSumCompteN1(s, "2906%")
						+ getSumCompteN1(s, "2807%")
						+ getSumCompteN1(s, "2907%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Fonds commercial", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"206%");
			putDetailSection(listing, s,"207%");
			putDetailSection(listing, s,"2806%");
			putDetailSection(listing, s,"2807%");
			putDetailSection(listing, s,"2906%");
			putDetailSection(listing, s,"2907%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "20%")
						- getSumCompte(s, "201%")
						- getSumCompte(s, "203%")
						- getSumCompte(s, "205%")
						- getSumCompte(s, "206%")
						- getSumCompte(s, "207%")
						+ getSumCompte(s, "232%");

		valAP = getSumCompte(s, "280%")
					+ getSumCompte(s, "290%")
					- getSumCompte(s, "2801%")
					- getSumCompte(s, "2803%")
					- getSumCompte(s, "2805%")
					- getSumCompte(s, "2806%")
					- getSumCompte(s, "2807%")
					+ getSumCompte(s, "2832%")
					- getSumCompte(s, "2901%")
					- getSumCompte(s, "2903%")
					- getSumCompte(s, "2905%")
					- getSumCompte(s, "2906%")
					- getSumCompte(s, "2907%")
					+ getSumCompte(s, "2932%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "20%")
						- getSumCompteN1(s, "201%")
						- getSumCompteN1(s, "203%")
						- getSumCompteN1(s, "205%")
						- getSumCompteN1(s, "206%")
						- getSumCompteN1(s, "207%")
						+ getSumCompteN1(s, "232%")
						+ getSumCompteN1(s, "280%")
						+ getSumCompteN1(s, "290%")
						- getSumCompteN1(s, "2801%")
						- getSumCompteN1(s, "2803%")
						- getSumCompteN1(s, "2805%")
						- getSumCompteN1(s, "2806%")
						- getSumCompteN1(s, "2807%")
						+ getSumCompteN1(s, "2832%")
						- getSumCompteN1(s, "2901%")
						- getSumCompteN1(s, "2903%")
						- getSumCompteN1(s, "2905%")
						- getSumCompteN1(s, "2906%")
						- getSumCompteN1(s, "2907%")
						+ getSumCompteN1(s, "2932%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Autres immobilisations incorporelles", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"20%' and c.Numero_Compte not like '201%' and c.Numero_Compte not like '203%' and c.Numero_Compte not like '205%' and c.Numero_Compte not like '206%' and c.Numero_Compte not like '207%");
			putDetailSection(listing, s,"232%");
			putDetailSection(listing, s,"280%' and c.Numero_Compte not like '2801%' and c.Numero_Compte not like '2803%' and c.Numero_Compte not like '2805%' and c.Numero_Compte not like '2806%' and c.Numero_Compte not like '2807%");
			putDetailSection(listing, s,"2832%");
			putDetailSection(listing, s,"290%' and c.Numero_Compte not like '2901%' and c.Numero_Compte not like '2903%' and c.Numero_Compte not like '2905%' and c.Numero_Compte not like '2906%' and c.Numero_Compte not like '2907%");
			putDetailSection(listing, s,"2932%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "237%");

		valAP = getSumCompte(s, "2837%")
					+ getSumCompte(s, "2937%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "237%")
						+ getSumCompteN1(s, "2837%")
						+ getSumCompteN1(s, "2937%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Avances et acomptes sur immobilisations incorporelles", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"237%");
			putDetailSection(listing, s,"2837%");
			putDetailSection(listing, s,"2937%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "211%")
						+ getSumCompte(s, "212%");

		valAP = getSumCompte(s, "2811%")
					+ getSumCompte(s, "2812%")
					+ getSumCompte(s, "2911%")
					+ getSumCompte(s, "2912%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "211%")
						+ getSumCompteN1(s, "212%")
						+ getSumCompteN1(s, "2811%")
						+ getSumCompteN1(s, "2812%")
						+ getSumCompteN1(s, "2911%")
						+ getSumCompteN1(s, "2912%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Terrains", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"211%");
			putDetailSection(listing, s,"212%");
			putDetailSection(listing, s,"2811%");
			putDetailSection(listing, s,"2812%");
			putDetailSection(listing, s,"2911%");
			putDetailSection(listing, s,"2912%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "213%")
						+ getSumCompte(s, "214%");

		valAP = getSumCompte(s, "2813%")
					+ getSumCompte(s, "2814%")
					+ getSumCompte(s, "2913%")
					+ getSumCompte(s, "2914%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "213%")
						+ getSumCompteN1(s, "214%")
						+ getSumCompteN1(s, "2813%")
						+ getSumCompteN1(s, "2814%")
						+ getSumCompteN1(s, "2913%")
						+ getSumCompteN1(s, "2914%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Constructions", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"213%");
			putDetailSection(listing, s,"214%");
			putDetailSection(listing, s,"2813%");
			putDetailSection(listing, s,"2814%");
			putDetailSection(listing, s,"2913%");
			putDetailSection(listing, s,"2914%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "215%");

		valAP = getSumCompte(s, "2815%")
					+ getSumCompte(s, "2915%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "215%")
						+ getSumCompteN1(s, "2815%")
						+ getSumCompteN1(s, "2915%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Installations techniques mat\u00E9riel et outillage industriels", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"215%");
			putDetailSection(listing, s,"2815%");
			putDetailSection(listing, s,"2915%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "21%")
						- getSumCompte(s, "211%")
						- getSumCompte(s, "212%")
						- getSumCompte(s, "213%")
						- getSumCompte(s, "214%")
						- getSumCompte(s, "215%")
						- getSumCompte(s, "229%")
						+ getSumCompte(s, "22%")
						+ getSumCompte(s, "24%")
						+ getSumCompte(s, "25%");

		valAP = getSumCompte(s, "281%")
					+ getSumCompte(s, "291%")
					+ getSumCompte(s, "282%")
					+ getSumCompte(s, "284%")
					+ getSumCompte(s, "285%")
					+ getSumCompte(s, "292%")
					+ getSumCompte(s, "294%")
					+ getSumCompte(s, "295%")
					- getSumCompte(s, "2811%")
					- getSumCompte(s, "2812%")
					- getSumCompte(s, "2813%")
					- getSumCompte(s, "2814%")
					- getSumCompte(s, "2815%")
					- getSumCompte(s, "2911%")
					- getSumCompte(s, "2912%")
					- getSumCompte(s, "2913%")
					- getSumCompte(s, "2914%")
					- getSumCompte(s, "2915%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "21%")
						- getSumCompteN1(s, "211%")
						- getSumCompteN1(s, "212%")
						- getSumCompteN1(s, "213%")
						- getSumCompteN1(s, "214%")
						- getSumCompteN1(s, "215%")
						- getSumCompteN1(s, "229%")
						+ getSumCompteN1(s, "22%")
						+ getSumCompteN1(s, "24%")
						+ getSumCompteN1(s, "25%")
						+ getSumCompteN1(s, "281%")
						+ getSumCompteN1(s, "291%")
						+ getSumCompteN1(s, "282%")
						+ getSumCompteN1(s, "284%")
						+ getSumCompteN1(s, "285%")
						+ getSumCompteN1(s, "292%")
						+ getSumCompteN1(s, "294%")
						+ getSumCompteN1(s, "295%")
						- getSumCompteN1(s, "2811%")
						- getSumCompteN1(s, "2812%")
						- getSumCompteN1(s, "2813%")
						- getSumCompteN1(s, "2814%")
						- getSumCompteN1(s, "2815%")
						- getSumCompteN1(s, "2911%")
						- getSumCompteN1(s, "2912%")
						- getSumCompteN1(s, "2913%")
						- getSumCompteN1(s, "2914%")
						- getSumCompteN1(s, "2915%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Autres immobilisations corporelles", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"21%' and c.Numero_Compte not like '211%' and c.Numero_Compte not like '212%' and c.Numero_Compte not like '213%' and c.Numero_Compte not like '214%' and c.Numero_Compte not like '215%");
			putDetailSection(listing, s,"22%' and c.Numero_Compte not like '229%");
			putDetailSection(listing, s,"24%");
			putDetailSection(listing, s,"25%");
			putDetailSection(listing, s,"281%' and c.Numero_Compte not like '2811%' and c.Numero_Compte not like '2812%' and c.Numero_Compte not like '2813%' and c.Numero_Compte not like '2814%' and c.Numero_Compte not like '2815%");
			putDetailSection(listing, s,"282%");
			putDetailSection(listing, s,"284%");
			putDetailSection(listing, s,"285%");
			putDetailSection(listing, s,"291%' and c.Numero_Compte not like '2911%' and c.Numero_Compte not like '2912%' and c.Numero_Compte not like '2913%' and c.Numero_Compte not like '2914%' and c.Numero_Compte not like '2915%");
			putDetailSection(listing, s,"292%");
			putDetailSection(listing, s,"294%");
			putDetailSection(listing, s,"295%");

			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "23%")
						- getSumCompte(s, "232%")
						- getSumCompte(s, "237%")
						- getSumCompte(s, "238%");

		valAP = getSumCompte(s, "283%")
					+ getSumCompte(s, "293%")
					- getSumCompte(s, "2832%")
					- getSumCompte(s, "2837%")
					- getSumCompte(s, "2838%")
					- getSumCompte(s, "2932%")
					- getSumCompte(s, "2937%")
					- getSumCompte(s, "2938%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "23%")
						- getSumCompteN1(s, "232%")
						- getSumCompteN1(s, "237%")
						- getSumCompteN1(s, "238%")
						+ getSumCompteN1(s, "283%")
						+ getSumCompteN1(s, "293%")
						- getSumCompteN1(s, "2832%")
						- getSumCompteN1(s, "2837%")
						- getSumCompteN1(s, "2838%")
						- getSumCompteN1(s, "2932%")
						- getSumCompteN1(s, "2937%")
						- getSumCompteN1(s, "2938%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Immobilisations en cours", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"23%' and c.Numero_Compte not like '232%' and c.Numero_Compte not like '237%' and c.Numero_Compte not like '238%");
			putDetailSection(listing, s,"283%' and c.Numero_Compte not like '2832%' and c.Numero_Compte not like '2837%' and c.Numero_Compte not like '2838%");
			putDetailSection(listing, s,"293%' and c.Numero_Compte not like '2932%' and c.Numero_Compte not like '2937%' and c.Numero_Compte not like '2938%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "238%");

		valAP = getSumCompte(s, "2838%")
					+ getSumCompte(s, "2938%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "238%")
						+ getSumCompteN1(s, "2838%")
						+ getSumCompteN1(s, "2938%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Avances et acomptes", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"238%");
			putDetailSection(listing, s,"2838%");
			putDetailSection(listing, s,"2938%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "263%");

		valAP = getSumCompte(s, "2963%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "263%")
						+ getSumCompteN1(s, "2963%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Participations \u00E9valu\u00E9es selon la m\u00E9thode de mise en \u00E9quivalence", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"263%");
			putDetailSection(listing, s,"2963%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "26%")
						- getSumCompte(s, "263%")
						- getSumCompte(s, "267%")
						- getSumCompte(s, "268%")
						- getSumCompte(s, "269%");

		valAP = getSumCompte(s, "296%")
					- getSumCompte(s, "2963%")
					- getSumCompte(s, "2967%")
					- getSumCompte(s, "2968%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "26%")
						- getSumCompteN1(s, "263%")
						- getSumCompteN1(s, "267%")
						- getSumCompteN1(s, "268%")
						- getSumCompteN1(s, "269%")
						+ getSumCompteN1(s, "296%")
						- getSumCompteN1(s, "2963%")
						- getSumCompteN1(s, "2967%")
						- getSumCompteN1(s, "2968%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Autres participations", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"26%' and c.Numero_Compte not like '263%' and c.Numero_Compte not like '267%' and c.Numero_Compte not like '268%' and c.Numero_Compte not like '268%");
			putDetailSection(listing, s,"296%' and c.Numero_Compte not like '2963%' and c.Numero_Compte not like '2967%' and c.Numero_Compte not like '2968%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "267%")
						+ getSumCompte(s, "268%");

		valAP = getSumCompte(s, "2967%")
					+ getSumCompte(s, "2968%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "267%")
						+ getSumCompteN1(s, "268%")
						+ getSumCompteN1(s, "2967%")
						+ getSumCompteN1(s, "2968%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Cr\u00E9ances rattach\u00E9es \u00E0 des participations", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"267%");
			putDetailSection(listing, s,"268%");
			putDetailSection(listing, s,"2967%");
			putDetailSection(listing, s,"2968%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "271%")
						+ getSumCompte(s, "272%")
						+ getSumCompte(s, "273%")
						+ getSumCompte(s, "27682%");

		valAP = getSumCompte(s, "2971%")
					+ getSumCompte(s, "2972%")
					+ getSumCompte(s, "2973%")
					+ getSumCompte(s, "297682%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "271%")
						+ getSumCompteN1(s, "272%")
						+ getSumCompteN1(s, "273%")
						+ getSumCompteN1(s, "27682%")
						+ getSumCompteN1(s, "2971%")
						+ getSumCompteN1(s, "2972%")
						+ getSumCompteN1(s, "2973%")
						+ getSumCompteN1(s, "297682%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Autres titres immobilis\u00E9s", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"271%");
			putDetailSection(listing, s,"272%");
			putDetailSection(listing, s,"273%");
			putDetailSection(listing, s,"27682%");
			putDetailSection(listing, s,"2971%");
			putDetailSection(listing, s,"2972%");
			putDetailSection(listing, s,"2973%");
			putDetailSection(listing, s,"297682%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "274%")
						+ getSumCompte(s, "27684%");

		valAP = getSumCompte(s, "2974%")
					+ getSumCompte(s, "297684%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "274%")
						+ getSumCompteN1(s, "27684%")
						+ getSumCompteN1(s, "2974%")
						+ getSumCompteN1(s, "297684%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Pr\u00EAts", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"274%");
			putDetailSection(listing, s,"27684%");
			putDetailSection(listing, s,"2974%");
			putDetailSection(listing, s,"297684%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "27%")
						- getSumCompte(s, "271%")
						- getSumCompte(s, "272%")
						- getSumCompte(s, "273%")
						- getSumCompte(s, "274%")
						- getSumCompte(s, "27682%")
						- getSumCompte(s, "27684%")
						- getSumCompte(s, "279%");

		valAP = getSumCompte(s, "297%")
					- getSumCompte(s, "2971%")
					- getSumCompte(s, "2972%")
					- getSumCompte(s, "2973%")
					- getSumCompte(s, "2974%")
					- getSumCompte(s, "297682%")
					- getSumCompte(s, "297684%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "27%")
						- getSumCompteN1(s, "271%")
						- getSumCompteN1(s, "272%")
						- getSumCompteN1(s, "273%")
						- getSumCompteN1(s, "274%")
						- getSumCompteN1(s, "27682%")
						- getSumCompteN1(s, "27684%")
						- getSumCompteN1(s, "279%")
						+ getSumCompteN1(s, "297%")
						- getSumCompteN1(s, "2971%")
						- getSumCompteN1(s, "2972%")
						- getSumCompteN1(s, "2973%")
						- getSumCompteN1(s, "2974%")
						- getSumCompteN1(s, "297682%")
						- getSumCompteN1(s, "297684%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Autres immobilisations financi\u00E8res", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"27%' and c.Numero_Compte not like '271%' and c.Numero_Compte not like '272%' and c.Numero_Compte not like '273%' and c.Numero_Compte not like '274%' and c.Numero_Compte not like '27682%' and c.Numero_Compte not like '27684%' and c.Numero_Compte not like '279%");
			putDetailSection(listing, s,"297%' and c.Numero_Compte not like '2971%' and c.Numero_Compte not like '2972%' and c.Numero_Compte not like '2973%' and c.Numero_Compte not like '2974%' and c.Numero_Compte not	like '297682%' and c.Numero_Compte not like '297684%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 10);
		putLigneTotal(listing ,"TOTAL I", totalBrut, totalAP, totalN1);
		//putEspacement(listing, 5);

		globalBrut += totalBrut;
		globalAP += totalAP;

		if (compareN1) {
			globalN1 += totalN1;
		}

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));

			listing = new PdfPTable(this.nbColListing);
			listing.setWidthPercentage(100);
			listing.setWidths(widthsListing);

			template = pcb.createTemplate(110,45);

			template.beginText();
    	template.setFontAndSize(bf, 12);
    	template.setTextMatrix(0, 20);
    	template.showText("ACTIF CIRCULANT");
    	template.endText();

			image = Image.getInstance(template);
			image.setRotationDegrees(90);

			cellSection = new PdfPCell(image, false);

			cellSection.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cellSection.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

			//cellSection.setPhrase(new Phrase("ACTIF CIRCULANT", new Font(Font.HELVETICA, 10, Font.BOLD)));
		}

		valBrut = getSumCompte(s, "3%")
						- getSumCompte(s, "33%")
						- getSumCompte(s, "34%")
						- getSumCompte(s, "35%")
						- getSumCompte(s, "37%")
						- getSumCompte(s, "39%");

		valAP = getSumCompte(s, "39%")
					- getSumCompte(s, "393%")
					- getSumCompte(s, "394%")
					- getSumCompte(s, "395%")
					- getSumCompte(s, "397%");

		totalBrut = valBrut;
		totalAP = valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "3%")
						- getSumCompteN1(s, "33%")
						- getSumCompteN1(s, "34%")
						- getSumCompteN1(s, "35%")
						- getSumCompteN1(s, "37%")
						- getSumCompteN1(s, "393%")
						- getSumCompteN1(s, "394%")
						-	getSumCompteN1(s, "395%")
						- getSumCompteN1(s, "397%");

			totalN1 = valN1;
		}

		putLigneBilanActif(listing, "Mati\u00E8res premi\u00E8res, approvisionnements", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"3%' and c.Numero_Compte not like '33%' and c.Numero_Compte not like '34%' and c.Numero_Compte not like '35%' and c.Numero_Compte not like '37%' and c.Numero_Compte not like '39%");
			putDetailSection(listing, s,"39%' and c.Numero_Compte not like '393%' and c.Numero_Compte not like '394%' and c.Numero_Compte not like '395%' and c.Numero_Compte not like '397%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "33%");

		valAP = getSumCompte(s, "393%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "33%")
						+ getSumCompteN1(s, "393%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "En cours de production de biens", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"33%");
			putDetailSection(listing, s,"393%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "34%");

		valAP = getSumCompte(s, "394%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "34%")
						+ getSumCompteN1(s, "394%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "En cours de production de services", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"34%");
			putDetailSection(listing, s,"394%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "35%");

		valAP = getSumCompte(s, "395%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "35%")
						+ getSumCompteN1(s, "395%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Produits interm\u00E9diaires et finis", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"35%");
			putDetailSection(listing, s,"395%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "37%");

		valAP = getSumCompte(s, "397%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "37%")
						+ getSumCompteN1(s, "397%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Marchandises", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"37%");
			putDetailSection(listing, s,"397%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(d, "4091%");

		valAP = 0;

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(d, "4091%");
			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Avances et acomptes vers\u00E9s sur commandes", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, d,"4091%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(d, "41%")
						+ getSumCompte(c, "41199999%");

		valAP = getSumCompte(s, "49%")
					- getSumCompte(s, "495%")
					- getSumCompte(s, "496%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(d, "41%")
						+ getSumCompteN1(c, "41199999%")
						+ getSumCompteN1(s, "49%")
						- getSumCompteN1(s, "495%")
						- getSumCompteN1(s, "496%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Clients et comptes rattach\u00E9s", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, d,"41%' and c.Numero_Compte not like '41199999%");
			putDetailSection(listing, c,"41199999%");
			putDetailSection(listing, s,"49%' and c.Numero_Compte not like '495%' and c.Numero_Compte not like '496%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(d, "40%")
						- getSumCompte(d, "40199999%")
						- getSumCompte(d, "4091%")
						- getSumCompte(d, "4562%")
						- getSumCompte(d, "476%")
						- getSumCompte(d, "477%")
						+ getSumCompte(d, "42%")
						+ getSumCompte(d, "43%")
						+ getSumCompte(d, "44%")
						+ getSumCompte(d, "45%")
						+ getSumCompte(d, "46%")
						+ getSumCompte(d, "47%")
						+ getSumCompte(d, "18%");

		valAP = getSumCompte(s, "495%")
					+ getSumCompte(s, "496%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(d, "40%")
						- getSumCompteN1(d, "40199999%")
						- getSumCompteN1(d, "4091%")
						- getSumCompteN1(d, "4562%")
						- getSumCompteN1(d, "476%")
						- getSumCompteN1(d, "477%")
						+ getSumCompteN1(d, "42%")
						+ getSumCompteN1(d, "43%")
						+ getSumCompteN1(d, "44%")
						+ getSumCompteN1(d, "45%")
						+ getSumCompteN1(d, "46%")
						+ getSumCompteN1(d, "47%")
						+ getSumCompteN1(s, "495%")
					  + getSumCompteN1(s, "496%")
						+ getSumCompteN1(d, "18%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Autres cr\u00E9ances", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, d,"18%");
			putDetailSection(listing, d,"40%' and c.Numero_Compte not like '40199999%' and c.Numero_Compte not like '4091%");
			putDetailSection(listing, d,"42%");
			putDetailSection(listing, d,"43%");
			putDetailSection(listing, d,"44%");
			putDetailSection(listing, d,"45%' and c.Numero_Compte not like '4562%");
			putDetailSection(listing, d,"46%");
			putDetailSection(listing, d,"47%' and c.Numero_Compte not like '476%' and c.Numero_Compte not like '477%");
			putDetailSection(listing, s,"495%");
			putDetailSection(listing, s,"496%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(d, "4562%");

		valAP = 0;

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(d, "4562%");
			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Capital souscrit et appel\u00E9, non vers\u00E9", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, d,"4562%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(d, "50%");

		valAP = getSumCompte(s, "590%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(d, "50%")
						+ getSumCompteN1(s, "590%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Valeurs mobili\u00E8res de placement", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, d,"50%");
			putDetailSection(listing, s,"590%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(d, "51%")
						+ getSumCompte(d, "52%")
						+ getSumCompte(s, "53%")
						+ getSumCompte(d, "54%")
						+ getSumCompte(d, "55%")
						+ getSumCompte(d, "56%")
						+ getSumCompte(d, "57%")
						+ getSumCompte(d, "58%");

		valAP = getSumCompte(s, "59%")
					- getSumCompte(s, "590%");

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(d, "51%")
						+ getSumCompteN1(d, "52%")
						+ getSumCompteN1(s, "53%")
						+ getSumCompteN1(d, "54%")
						+ getSumCompteN1(d, "55%")
						+ getSumCompteN1(d, "56%")
						+ getSumCompteN1(d, "57%")
						+ getSumCompteN1(d, "58%")
						+ getSumCompteN1(s, "59%")
					  - getSumCompteN1(s, "590%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Disponibilit\u00E9s", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, d,"51%");
			putDetailSection(listing, d,"52%");
			putDetailSection(listing, s,"53%");
			putDetailSection(listing, d,"54%");
			putDetailSection(listing, d,"55%");
			putDetailSection(listing, d,"56%");
			putDetailSection(listing, d,"57%");
			putDetailSection(listing, d,"58%");
			putDetailSection(listing, s,"59%' and c.Numero_Compte not like '590%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "486%");

		valAP = 0;

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "486%");
			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Charges constat\u00E9es d'avance", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"486%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 10);
		putLigneTotal(listing ,"TOTAL II", totalBrut, totalAP, totalN1);
		//putEspacement(listing, 5);

		globalBrut += totalBrut;
		globalAP += totalAP;

		if (compareN1) {
			globalN1 += totalN1;
		}

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));

			listing = new PdfPTable(this.nbColListing);
			listing.setWidthPercentage(100);
			listing.setWidths(widthsListing);

			template = pcb.createTemplate(85,25);

			template.beginText();
    	template.setFontAndSize(bf, 9);
    	template.setTextMatrix(0, 0);
    	template.showTextAligned(PdfContentByte.ALIGN_LEFT,"     COMPTES DE",0,15,0);
			template.showTextAligned(PdfContentByte.ALIGN_LEFT," REGULARISATION",0,0,0);
    	template.endText();

			image = Image.getInstance(template);
			image.setRotationDegrees(90);

			cellSection = new PdfPCell(image, false);

			cellSection.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cellSection.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

			//cellSection.setPhrase(new Phrase("COMPTES DE REGULARISATION", new Font(Font.HELVETICA, 10, Font.BOLD)));
		}

		valBrut = getSumCompte(d, "480%")
						+ getSumCompte(s, "481%")
						+ getSumCompte(d, "482%")
						+ getSumCompte(d, "483%")
						+ getSumCompte(d, "484%")
						+ getSumCompte(d, "485%")
						+ getSumCompte(d, "488%")
						+ getSumCompte(d, "489%");

		valAP = 0;

		totalBrut = valBrut;
		totalAP = valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(d, "480%")
						+ getSumCompteN1(s, "481%")
						+ getSumCompteN1(d, "482%")
						+ getSumCompteN1(d, "483%")
						+ getSumCompteN1(d, "484%")
						+ getSumCompteN1(d, "485%")
						+ getSumCompteN1(d, "488%")
						+ getSumCompteN1(d, "489%");

			totalN1 = valN1;
		}

		putLigneBilanActif(listing, "Charges \u00E0 r\u00E9partir sur plusieurs exercices (III)", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, d,"480%");
			putDetailSection(listing, s,"481%");
			putDetailSection(listing, d,"482%");
			putDetailSection(listing, d,"483%");
			putDetailSection(listing, d,"484%");
			putDetailSection(listing, d,"485%");
			putDetailSection(listing, d,"488%");
			putDetailSection(listing, d,"489%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(s, "169%");

		valAP = 0;

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(s, "169%");
			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Primes de remboursement des obligations (IV)", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, s,"169%");
			putEspacement(listing, 5);
		}

		valBrut = getSumCompte(d, "476%")
						+ getSumCompte(d, "477%");

		valAP = 0;

		totalBrut += valBrut;
		totalAP += valAP;

		if (compareN1) {
			valN1 = getSumCompteN1(d, "476%")
						+ getSumCompteN1(d, "477%");

			totalN1 += valN1;
		}

		putLigneBilanActif(listing, "Ecart de conversion Actif (V)", valBrut, valAP, valN1);

		if (detailBIL) {
			putDetailSection(listing, d,"476%");
			putDetailSection(listing, d,"477%");
			putEspacement(listing, 5);
		}

		//putEspacement(listing, 10);
		//putLigneTotal(listing ,"TOTAL III", totalBrut, totalAP, totalN1);
		//putEspacement(listing, 5);

		globalBrut += totalBrut;
		globalAP += totalAP;

		if (compareN1) {
			globalN1 += totalN1;
		}

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));

			listing = new PdfPTable(this.nbColListing);
			listing.setWidthPercentage(100);
			listing.setWidths(widthsListing);

			cellSection.setImage(null);
			cellSection.setPhrase(new Phrase("", new Font(Font.HELVETICA, 10, Font.BOLD)));
		}

		//putEspacement(listing, 10);
		putLigneTotal(listing ,"TOTAL GENERAL (I+II+III+IV+V)", globalBrut, globalAP, globalN1);
		//putEspacement(listing, 5);

		if (!detailBIL) {
			section.addCell(cellSection);
			section.addCell(new PdfPCell(listing));
			return section;
		}
		return listing;

	}


	private void putLigneBilanActif(PdfPTable listing, String intitule, double soldeBrut, double soldeAP, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);

		if (detailBIL) {
			intitule = intitule.toUpperCase();
		}

		cellListing.setPhrase(new Phrase(intitule, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);

		if (!detailBIL) {
			cellListing.setPhrase(new Phrase(soldeBrut==0?"":numFormat.format(soldeBrut), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(soldeAP==0?"":numFormat.format(-soldeAP), fontLine));
			listing.addCell(cellListing);
		}
		else {
			cellListing.setBackgroundColor(new Color(210,210,210));
		}

		double soldeN = soldeBrut + soldeAP;

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}


	private void putLigneTotal(PdfPTable listing, String intitule, double soldeBrut, double soldeAP, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		if (detailBIL) {
			cellListing.setBackgroundColor(Color.LIGHT_GRAY);
			cellListing.setBorder(PdfPCell.BOX);
		}
		else {
			cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		}

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);

		cellListing.setPhrase(new Phrase(intitule, new Font(Font.HELVETICA, 10, Font.BOLD)));
		listing.addCell(cellListing);

		cellListing.setBackgroundColor(Color.LIGHT_GRAY);

		if (!detailBIL) {
			cellListing.setPhrase(new Phrase(soldeBrut==0?"":numFormat.format(soldeBrut), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(soldeAP==0?"":numFormat.format(-soldeAP), fontLine));
			listing.addCell(cellListing);
		}

		double soldeN = soldeBrut + soldeAP;

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}

	private void putLigneTotal(PdfPTable listing, String intitule, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		if (detailBIL) {
			cellListing.setBackgroundColor(Color.LIGHT_GRAY);
			cellListing.setBorder(PdfPCell.BOX);
		}
		else {
			cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		}

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);

		cellListing.setPhrase(new Phrase(intitule, new Font(Font.HELVETICA, 10, Font.BOLD)));
		listing.addCell(cellListing);

		cellListing.setBackgroundColor(Color.LIGHT_GRAY);

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}


	private void putEspacement(PdfPTable listing, int space) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(space);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("", fontLine));

		listing.addCell(cellListing);
		listing.addCell(cellListing);

		if (!detailBIL && titre.equalsIgnoreCase("Actif")) {
			listing.addCell(cellListing);
			listing.addCell(cellListing);
		}

		if (compareN1) {
			listing.addCell(cellListing);
			listing.addCell(cellListing);
			listing.addCell(cellListing);
		}

	}

	/** Solde, Credit ou Debit des comptes commencant par "like" de l'exercice N-1 */

	private double getSumCompteN1(int sum, String like) throws SQLException, Exception {

		double val = 0;
		double debit;
		double credit;

		String request = "select sum(Total_Debit) as debit, sum(Total_Credit) as credit"
										+" from "+ baseN1 +".SOLDE_COMPTE s join "+ baseDossier +".COMPTE c on c.Numero_Compte=s.Numero_Compte"
										+" where c.Centralisateur=0 and (c.Numero_Compte like '"+ like +"' or c.Collectif like '"+ like +"') group by c.Numero_Compte";

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery(request);

		while(rset.next()) {

			credit = rset.getDouble("credit");
			debit = rset.getDouble("debit");

			if (sum==0)
				val += this.titre.equalsIgnoreCase("Passif")?credit-debit:debit-credit;
			else if (sum==-1)
				val += debit>credit?debit-credit:0;
			else if (sum==1)
				val += credit>debit?credit-debit:0;

		}
		rset.close();

		stt.close();

		return val;

	}

} // fin GenPdfBilan
