/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un avoir standard
 */

package org.opensi.compta.actions.etats;


import java.sql.*;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;


public class DataPlanComptableDossier {


	protected ArrayList<LignePlanDossier> lignes = new ArrayList<LignePlanDossier>(10);
	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse;	
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	
	protected int numClasse;
	protected String libClasse;
	protected int Niveau;
	protected int code;


	
	public DataPlanComptableDossier(Session s, String choix) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			
			
			// Paramtres dossier
      			
			ResultSet rset = stt.executeQuery("select * from "+ base +".SOCIETE");
						
			if (rset.next()) {				
				this.raisonSociale = rset.getString("Denomination");
				this.adresse = rset.getString("Adresse_1");				
				this.codePostal = rset.getString("Code_Postal");
				this.ville = rset.getString("Ville");
				this.tel = rset.getString("Telephone");
				this.fax = rset.getString("Fax");
				this.email = rset.getString("Email");			
			}		
	
			// selection des lignes du plan comptable gnral

			rset = stt.executeQuery("select * from "+base+".COMPTE where Type_Compte='"+ choix +"'");
			
			while(rset.next()) {	
				LignePlanDossier lp=new LignePlanDossier();				
				lp.numCompte = rset.getString("Numero_Compte");
				lp.intitule = rset.getString("Intitule");				
				lp.type = rset.getString("Type_Compte");
				lp.contrepartie =rset.getString("Contrepartie");
				lignes.add(lp);
			}
			
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	

	

	
	
} 
