/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.bo;


import java.sql.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.HashMap;

import org.opensi.dbm.exercice.DBM_Ecriture;
import org.opensi.dbm.exercice.DBM_Operation;
import org.opensi.dbm.exercice.DBM_SoldeCompte;

import org.opensi.data.exercice.Operation;
import org.opensi.data.exercice.Ecriture;

import org.opensi.bo.BO_Comptes;

import org.opensi.util.tools.Arrondi;


public class BO_Ecritures {

	private Connection con;
	private String baseDossier;
	private String baseExo;


	public BO_Ecritures(Connection con, String baseDossier, String baseExo) {
		this.con = con;
		this.baseDossier = baseDossier;
		this.baseExo = baseExo;
	}


	public boolean isEcritureSupprimable(int ecritureId) {
		// exercice ouvert, priode ouverte, ecriture non lettre, non pointe, non bloque (journal), non cloture

		// une criture n'est supprimable que si elle ne contient pas d'opration pointe (d'un rappro clotur...)
			// pkoi ne pas autoriser la cloture rappro que sur critures valides ? --> car un rappro peut se faire au jour le jour,  voir....
			// voir aussi les tats de l'criture (cloture / valide..... etc...)

		return true;
	}


	public boolean isOperationSupprimable(int opId) {
		// exercice ouvert, priode ouverte, ecriture non lettre, non pointe, non bloque (journal), non cloture
		// A FAIRE suppression des oprations de l'criture --> attention aux oprations non contraintes (rappro bancaire)
		return true;
	}


	public boolean deleteEcriture(int ecritureId) throws SQLException {

		if (isEcritureSupprimable(ecritureId)) {

			PreparedStatement psEcr = con.prepareStatement("select Code_Journal, Date_Ecriture from "+ baseExo +".ECRITURE where Ecriture_Id=?");
			psEcr.setInt(1, ecritureId);
			ResultSet rsE = psEcr.executeQuery();
			if (rsE.next()) {

				ArrayList<String> listeCpte = new ArrayList<String>(3);

				PreparedStatement psCptes = con.prepareStatement("select distinct Numero_Compte from "+ baseExo +".OPERATION where Ecriture_Id=?");

				psCptes.setInt(1, ecritureId);
				ResultSet rsO = psCptes.executeQuery();

				while (rsO.next()) {
					listeCpte.add(rsO.getString("Numero_Compte"));
				}
				rsO.close();

				DBM_Operation dbmOperation = new DBM_Operation(con, baseExo);
				dbmOperation.deleteOpsEcriture(ecritureId);

				DBM_Ecriture dbmEcriture = new DBM_Ecriture(con, baseExo);
				dbmEcriture.delete(ecritureId);

				BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);

				for (int i=0; i<listeCpte.size(); i++) {
					boComptes.updateSoldesCompte(listeCpte.get(i));
				}

				majAvancement(rsE.getString("Code_Journal"), rsE.getLong("Date_Ecriture"));
			}
			rsE.close();

			return true;
		}
		else {
			return false;
		}
	}


	public void saveEcriture(Ecriture ecriture) throws SQLException {

		if (ecriture.isValid()) {

			if (ecriture.getNumero()==0) {
				PreparedStatement psNumEcr = con.prepareStatement("select coalesce(max(Numero),0)+1 from "+ baseExo +".ECRITURE where Code_Journal=? and Date_Ecriture=?");

				psNumEcr.setString(1, ecriture.getCodeJournal());
				psNumEcr.setLong(2, ecriture.getDateEcriture());
				ResultSet rsNE = psNumEcr.executeQuery();
				rsNE.next();
				ecriture.setNumero(rsNE.getInt(1));
				rsNE.close();
				
				psNumEcr.close();
			}

			DBM_Ecriture dbmEcriture = new DBM_Ecriture(con, baseExo);

			if (ecriture.getEcritureId()==0) {
				dbmEcriture.insert(ecriture);
			}
			else {
				dbmEcriture.update(ecriture);
			}

			saveOperations(ecriture);

			majAvancement(ecriture.getCodeJournal(), ecriture.getDateEcriture());
		}
		else {
			System.out.println("Ecriture non valide");
			ecriture.printEcriture();
		}
	}


	private void saveOperations(Ecriture ecriture) throws SQLException {

		PreparedStatement psNumCpte = con.prepareStatement("select Numero_Compte from "+ baseExo +".OPERATION where Op_Id=?");

		HashMap<Integer, Operation> operations = ecriture.getOperations();
		Iterator i = operations.keySet().iterator();

		BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);

		DBM_Operation dbmOperation = new DBM_Operation(con, baseExo);

		String listeOp = "";

		while (i.hasNext()) {
			Operation op = operations.get(i.next());
			op.setEcritureId(ecriture.getEcritureId());

			if (op.getOpId()==0) {

				dbmOperation.insert(op);
			}
			else {

				String oldNumeroCompte = "";

				psNumCpte.setInt(1, op.getOpId());
				ResultSet rsO = psNumCpte.executeQuery();
      	if (rsO.next()) {
        	oldNumeroCompte = rsO.getString("Numero_Compte");
      	}

				dbmOperation.update(op);

      	if (!oldNumeroCompte.equals(op.getNumeroCompte())) {
      		boComptes.updateSoldesCompte(oldNumeroCompte);
				}
      }

			boComptes.updateSoldesCompte(op.getNumeroCompte());
			
			listeOp += op.getOpId() +",";
		}
		
		psNumCpte.close();

		// suppression des oprations qui ne font plus partie de l'criture		
		
		listeOp = org.opensi.util.sql.SqlUtils.normalizeCSList(listeOp);
		
		if (!listeOp.isEmpty()) {
			PreparedStatement psOp = con.prepareStatement("select Op_Id, Numero_Compte from "+ baseExo +".OPERATION where Ecriture_Id=? and Op_Id not in ("+ listeOp +")");
			psOp.setInt(1, ecriture.getEcritureId());

			ResultSet rsO = psOp.executeQuery();

			while (rsO.next()) {

				dbmOperation.delete(rsO.getInt("Op_Id"));
				boComptes.updateSoldesCompte(rsO.getString("Numero_Compte"));
			}
			psOp.close();
		}
	}


	private void majAvancement(String codeJournal, long periode) throws SQLException {

		PreparedStatement psNbOp = con.prepareStatement("select count(o.Op_Id) from "+ baseExo +".ECRITURE e join "+ baseExo +".OPERATION o on e.Ecriture_Id=o.Ecriture_Id where e.Code_Journal=? and e.Date_Ecriture=?");

		psNbOp.setString(1, codeJournal);
		psNbOp.setLong(2, periode);
		ResultSet rsNO = psNbOp.executeQuery();
		rsNO.next();
		int nbOp = rsNO.getInt(1);
		rsNO.close();
		
		psNbOp.close();

		PreparedStatement psUpNbOp = con.prepareStatement("insert into "+ baseExo +".NB_OP_JOURNAUX (Code_Journal, Periode, Nb_Op) values (?,?,?) on duplicate key update Nb_Op=values(Nb_Op)");

		psUpNbOp.setString(1, codeJournal);
		psUpNbOp.setLong(2, periode);
		psUpNbOp.setInt(3, nbOp);
		psUpNbOp.executeUpdate();
		psUpNbOp.close();
	}


	public boolean opBelongToAN(String listeOp) throws SQLException {

		PreparedStatement psOBAN = con.prepareStatement("select j.Type_Journal from "+ baseExo +".OPERATION o join "+ baseExo +".ECRITURE e on e.Ecriture_Id=o.Ecriture_Id join "+ baseDossier +".JOURNAL j on j.Code_Journal=e.Code_Journal where o.Op_Id in ("+ listeOp +") and j.Type_Journal='AN'");

		ResultSet rset = psOBAN.executeQuery();
		Boolean belong = rset.next();
		rset.close();
		psOBAN.close();

		return belong;
	}


	public boolean opCompteBelongToAN(String numeroCompte) throws SQLException {

		PreparedStatement psCBAN = con.prepareStatement("select j.Type_Journal from "+ baseExo +".OPERATION o join "+ baseExo +".ECRITURE e on e.Ecriture_Id=o.Ecriture_Id join "+ baseDossier +".JOURNAL j on j.Code_Journal=e.Code_Journal where o.Numero_Compte=? and j.Type_Journal='AN'");
		psCBAN.setString(1, numeroCompte);

		ResultSet rset = psCBAN.executeQuery();
		Boolean belong = rset.next();
		rset.close();
		psCBAN.close();

		return belong;
	}


	public String getLettresNonEqui(String listeOp) throws SQLException {

		String listeLettresNonEqui = "";

		PreparedStatement psEqui = con.prepareStatement("select sum(Montant_C-Montant_D) as Equilibre, Lettre from "+ baseExo +".OPERATION where Op_Id in ("+ listeOp +") and Lettre<>'' group by Lettre having Equilibre<>0");
		ResultSet rset = psEqui.executeQuery();
		while (rset.next()) {
			listeLettresNonEqui += rset.getString("Lettre");
		}

		rset.close();
		psEqui.close();

		return listeLettresNonEqui.isEmpty()?null:listeLettresNonEqui;
	}


	public boolean checkOpNonLettrees(String listeOp) throws SQLException {

		PreparedStatement psONL = con.prepareStatement("select Op_Id from "+ baseExo +".OPERATION where Lettre<>'' and Op_Id in ("+ listeOp +")");
		ResultSet rset = psONL.executeQuery();
		boolean check = !rset.next();
		psONL.close();
		return check;
	}


	public boolean checkEcrNonLettrees(String listeEcr) throws SQLException {

		PreparedStatement psONL = con.prepareStatement("select e.Ecriture_Id from "+ baseExo +".ECRITURE e join "+ baseExo +".OPERATION o on e.Ecriture_Id=o.Ecriture_Id where o.Lettre<>'' and e.Ecriture_Id in ("+ listeEcr +")");
		ResultSet rset = psONL.executeQuery();
		boolean check = !rset.next();
		psONL.close();
		return check;
	}


	public int getNbEcrInRB(String listeEcr) throws SQLException {

		PreparedStatement psNb = con.prepareStatement("select count(distinct o.Ecriture_Id) from "+ baseExo +".OPERATION o join "+ baseDossier +".LIGNE_RAPPROCHEMENT r on r.Op_Id=o.Op_Id and r.Nom_Base=? where o.Ecriture_Id in ("+ listeEcr +")");
		psNb.setString(1, baseExo);
		ResultSet rset = psNb.executeQuery();
		rset.next();
		int nb = rset.getInt(1);
		psNb.close();

		return nb;
	}


	public boolean checkEquiLettrage(String listeOp) throws SQLException {

		PreparedStatement psCEL = con.prepareStatement("select sum(Montant_D)-sum(Montant_C) from "+ baseExo +".OPERATION where Op_Id in ("+ listeOp +")");
		ResultSet rset = psCEL.executeQuery();
		rset.next();
		Arrondi rd = new Arrondi(2);
		boolean check = rd.round(rset.getDouble(1))==0;
		psCEL.close();
		return check;
	}


	public int changeCompteOp(String compteSrc, String compteDest, String listeOp) throws SQLException {

		DBM_Operation dbmOperation = new DBM_Operation(con, baseExo);
		int nbTrans = dbmOperation.changeCompteOp(compteSrc, compteDest, listeOp);

		BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);
		boComptes.updateSoldesCompte(compteSrc);
		boComptes.updateSoldesCompte(compteDest);

		// relettrage si les oprations taient lettres
		PreparedStatement psALettrer = con.prepareStatement("select Lettre, group_concat(Op_Id) as Liste from "+ baseExo +".OPERATION where Lettre<>'' and Op_Id in ("+ listeOp +") group by Lettre");

		ResultSet rset = psALettrer.executeQuery();

		while (rset.next()) {
			lettrer(compteDest, rset.getString("Liste"));
		}

		psALettrer.close();

		return nbTrans;
	}


	public String lettrer(String numeroCompte, String listeOp) throws SQLException {

		DBM_SoldeCompte dbmSC = new DBM_SoldeCompte(con, baseExo);

		String derniereLettre = dbmSC.getLettre(numeroCompte);

		String lettre = getLettreSuivante(derniereLettre);

		dbmSC.setLettre(numeroCompte, lettre);

		DBM_Operation dbmOperation = new DBM_Operation(con, baseExo);
		dbmOperation.lettrer(listeOp, lettre);

		return lettre;
	}


	public String getLettreSuivante(String lettre) {

		if (lettre.isEmpty()) {
			return "AAA";
		}
		else {
			String cfin = lettre.substring(lettre.length()-1);
			String debut = lettre.substring(0,lettre.length()-1);

			if (cfin.equalsIgnoreCase("Z")) {
				cfin = "A";
				if (!debut.isEmpty()) {
					debut = getLettreSuivante(debut);
				}
			}
			else {
				char c = cfin.charAt(0);
				cfin = String.valueOf(++c);
			}

			return debut + cfin;
		}
	}


} // fin BO_Ecritures
