/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.management.jmx.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationType;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;

public class RelationTypeSupport
implements RelationType {
    private String myTypeName = null;
    private HashMap myRoleName2InfoMap = new HashMap();
    private boolean myIsInRelServFlg = false;
    private static String localClassName = "RelationTypeSupport";

    protected RelationTypeSupport(String string) {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("Protected constructor: entering", string);
        }
        this.myTypeName = new String(string);
        if (this.isTraceOn()) {
            this.trace("Protected constructor: exiting", null);
        }
    }

    public RelationTypeSupport(String string, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (string == null || roleInfoArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", string);
        }
        this.initMembers(string, roleInfoArray);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    protected void addRoleInfo(RoleInfo roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfo == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isDebugOn()) {
            this.debug("addRoleInfo: entering", roleInfo.toString());
        }
        if (this.myIsInRelServFlg) {
            String string = "Relation type cannot be updated as it is declared in the Relation Service.";
            throw new RuntimeException(string);
        }
        String string = roleInfo.getName();
        if (this.myRoleName2InfoMap.containsKey(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "Two role infos provided for role ";
            stringBuffer.append(string2);
            stringBuffer.append(string);
            throw new InvalidRelationTypeException(stringBuffer.toString());
        }
        this.myRoleName2InfoMap.put(new String(string), new RoleInfo(roleInfo));
        if (this.isDebugOn()) {
            this.debug("addRoleInfo: exiting", null);
        }
    }

    static void checkRoleInfos(RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfoArray == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (roleInfoArray.length == 0) {
            String string = "No role info provided.";
            throw new InvalidRelationTypeException(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < roleInfoArray.length) {
            String string;
            RoleInfo roleInfo = roleInfoArray[n];
            if (roleInfo == null) {
                string = "Null role info provided.";
                throw new InvalidRelationTypeException(string);
            }
            string = roleInfo.getName();
            if (arrayList.contains(string)) {
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = "Two role infos provided for role ";
                stringBuffer.append(string2);
                stringBuffer.append(string);
                throw new InvalidRelationTypeException(stringBuffer.toString());
            }
            arrayList.add(string);
            ++n;
        }
    }

    private void debug(String string, String string2) {
        Trace.send((int)2, (int)64, (String)localClassName, (String)string, (String)string2);
        Trace.send((int)2, (int)64, (String)"", (String)"", (String)"\n");
    }

    public String getRelationTypeName() {
        return this.myTypeName;
    }

    public RoleInfo getRoleInfo(String string) throws IllegalArgumentException, RoleInfoNotFoundException {
        RoleInfo roleInfo;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRoleInfo: entering", string);
        }
        if ((roleInfo = (RoleInfo)this.myRoleName2InfoMap.get(string)) == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "No role info for role ";
            stringBuffer.append(string3);
            stringBuffer.append(string);
            throw new RoleInfoNotFoundException(stringBuffer.toString());
        }
        if (this.isTraceOn()) {
            this.trace("getRoleInfo: exiting", null);
        }
        return roleInfo;
    }

    public List getRoleInfos() {
        return new ArrayList(this.myRoleName2InfoMap.values());
    }

    private void initMembers(String string, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (string == null || roleInfoArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            this.debug("initMembers: entering", string);
        }
        this.myTypeName = new String(string);
        RelationTypeSupport.checkRoleInfos(roleInfoArray);
        int n = 0;
        while (n < roleInfoArray.length) {
            RoleInfo roleInfo = roleInfoArray[n];
            this.myRoleName2InfoMap.put(new String(roleInfo.getName()), new RoleInfo(roleInfo));
            ++n;
        }
        if (this.isDebugOn()) {
            this.debug("initMembers: exiting", null);
        }
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)64);
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)64);
    }

    void setRelationServiceFlag(boolean bl) {
        this.myIsInRelServFlg = bl;
    }

    private void trace(String string, String string2) {
        Trace.send((int)1, (int)64, (String)localClassName, (String)string, (String)string2);
        Trace.send((int)1, (int)64, (String)"", (String)"", (String)"\n");
    }
}

