/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.management.jmx.Trace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.DefaultLoaderRepository;
import javax.management.loading.MLetContent;
import javax.management.loading.MLetMBean;
import javax.management.loading.MLetObjectInputStream;
import javax.management.loading.MLetParser;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration {
    private MBeanServer server = null;
    private Vector mletList = new Vector();
    private String libraryDirectory = System.getProperty("user.dir");
    private ObjectName mletObjectName = null;
    private URL[] myUrls = null;
    private static Hashtable systemParam = new Hashtable(7);
    private static final byte TE_NULL = 112;
    private static final byte TE_OBJECT = 113;
    private String dbgTag = "MLet";
    private boolean dlr = false;
    private Hashtable primitiveClasses = new Hashtable(8);

    static {
        systemParam.put("archive", "archive");
        systemParam.put("code", "code");
        systemParam.put("codebase", "codebase");
        systemParam.put("name", "name");
        systemParam.put("object", "object");
        systemParam.put("persistent", "persistent");
        systemParam.put("version", "version");
    }

    public MLet() {
        super(new URL[0]);
        this.primitiveClasses.put(Boolean.TYPE.toString(), this.getClass("java.lang.Boolean"));
        this.primitiveClasses.put(Character.TYPE.toString(), this.getClass("java.lang.Character"));
        this.primitiveClasses.put(Byte.TYPE.toString(), this.getClass("java.lang.Byte"));
        this.primitiveClasses.put(Short.TYPE.toString(), this.getClass("java.lang.Short"));
        this.primitiveClasses.put(Integer.TYPE.toString(), this.getClass("java.lang.Integer"));
        this.primitiveClasses.put(Long.TYPE.toString(), this.getClass("java.lang.Long"));
        this.primitiveClasses.put(Float.TYPE.toString(), this.getClass("java.lang.Float"));
        this.primitiveClasses.put(Double.TYPE.toString(), this.getClass("java.lang.Double"));
        this.libraryDirectory = System.getProperty("jmx.mlet.library.dir");
        if (this.libraryDirectory == null) {
            this.libraryDirectory = System.getProperty("user.dir");
        }
    }

    public MLet(URL[] uRLArray) {
        super(uRLArray);
        this.primitiveClasses.put(Boolean.TYPE.toString(), this.getClass("java.lang.Boolean"));
        this.primitiveClasses.put(Character.TYPE.toString(), this.getClass("java.lang.Character"));
        this.primitiveClasses.put(Byte.TYPE.toString(), this.getClass("java.lang.Byte"));
        this.primitiveClasses.put(Short.TYPE.toString(), this.getClass("java.lang.Short"));
        this.primitiveClasses.put(Integer.TYPE.toString(), this.getClass("java.lang.Integer"));
        this.primitiveClasses.put(Long.TYPE.toString(), this.getClass("java.lang.Long"));
        this.primitiveClasses.put(Float.TYPE.toString(), this.getClass("java.lang.Float"));
        this.primitiveClasses.put(Double.TYPE.toString(), this.getClass("java.lang.Double"));
        this.libraryDirectory = System.getProperty("jmx.mlet.library.dir");
        if (this.libraryDirectory == null) {
            this.libraryDirectory = System.getProperty("user.dir");
        }
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
        this.primitiveClasses.put(Boolean.TYPE.toString(), this.getClass("java.lang.Boolean"));
        this.primitiveClasses.put(Character.TYPE.toString(), this.getClass("java.lang.Character"));
        this.primitiveClasses.put(Byte.TYPE.toString(), this.getClass("java.lang.Byte"));
        this.primitiveClasses.put(Short.TYPE.toString(), this.getClass("java.lang.Short"));
        this.primitiveClasses.put(Integer.TYPE.toString(), this.getClass("java.lang.Integer"));
        this.primitiveClasses.put(Long.TYPE.toString(), this.getClass("java.lang.Long"));
        this.primitiveClasses.put(Float.TYPE.toString(), this.getClass("java.lang.Float"));
        this.primitiveClasses.put(Double.TYPE.toString(), this.getClass("java.lang.Double"));
        this.libraryDirectory = System.getProperty("jmx.mlet.library.dir");
        if (this.libraryDirectory == null) {
            this.libraryDirectory = System.getProperty("user.dir");
        }
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(uRLArray, classLoader, uRLStreamHandlerFactory);
        this.primitiveClasses.put(Boolean.TYPE.toString(), this.getClass("java.lang.Boolean"));
        this.primitiveClasses.put(Character.TYPE.toString(), this.getClass("java.lang.Character"));
        this.primitiveClasses.put(Byte.TYPE.toString(), this.getClass("java.lang.Byte"));
        this.primitiveClasses.put(Short.TYPE.toString(), this.getClass("java.lang.Short"));
        this.primitiveClasses.put(Integer.TYPE.toString(), this.getClass("java.lang.Integer"));
        this.primitiveClasses.put(Long.TYPE.toString(), this.getClass("java.lang.Long"));
        this.primitiveClasses.put(Float.TYPE.toString(), this.getClass("java.lang.Float"));
        this.primitiveClasses.put(Double.TYPE.toString(), this.getClass("java.lang.Double"));
        this.libraryDirectory = System.getProperty("jmx.mlet.library.dir");
        if (this.libraryDirectory == null) {
            this.libraryDirectory = System.getProperty("user.dir");
        }
    }

    public void addURL(String string) throws ServiceNotFoundException {
        try {
            URL uRL = new URL(string);
            if (!Arrays.asList(this.getURLs()).contains(uRL)) {
                super.addURL(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new ServiceNotFoundException("The specified URL is malformed");
        }
    }

    public void addURL(URL uRL) {
        if (!Arrays.asList(this.getURLs()).contains(uRL)) {
            super.addURL(uRL);
        }
    }

    private synchronized URL check(String string, URL uRL, String string2, MLetContent mLetContent) {
        return uRL;
    }

    private Object constructParameter(String string, String string2) {
        block11: {
            Class clazz = (Class)this.primitiveClasses.get(string2);
            if (clazz != null) {
                Class[] classArray = new Class[1];
                try {
                    classArray[0] = Class.forName("java.lang.String");
                    Constructor constructor = clazz.getConstructor(classArray);
                    Object[] objectArray = new Object[]{string};
                    return constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block11;
                    this.debug(this.dbgTag, "constructParameter", "Unexpected Exception" + exception.getClass().getName() + " occured");
                }
            }
        }
        if (string2.compareTo("java.lang.Boolean") == 0) {
            return new Boolean(string);
        }
        if (string2.compareTo("java.lang.Byte") == 0) {
            return new Byte(string);
        }
        if (string2.compareTo("java.lang.Short") == 0) {
            return new Short(string);
        }
        if (string2.compareTo("java.lang.Long") == 0) {
            return new Long(string);
        }
        if (string2.compareTo("java.lang.Integer") == 0) {
            return new Integer(string);
        }
        if (string2.compareTo("java.lang.Float") == 0) {
            return new Float(string);
        }
        if (string2.compareTo("java.lang.Double") == 0) {
            return new Double(string);
        }
        if (string2.compareTo("java.lang.String") == 0) {
            return string;
        }
        return string;
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)2, (String)string, (String)string2, (String)string3);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class clazz = null;
        if (this.isTraceOn()) {
            this.trace("findClass", string);
        }
        try {
            clazz = super.findClass(string);
            if (this.isTraceOn()) {
                this.trace("findClass", "Class " + string + " loaded through mlet classloader");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (!this.dlr && clazz == null) {
            try {
                clazz = DefaultLoaderRepository.loadClassWithout(this, string);
                if (this.isTraceOn()) {
                    this.trace("findClass", "Class " + string + " loaded through the default classloader repository");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    protected String findLibrary(String string) {
        String string2;
        String string3 = "findLibrary";
        String string4 = System.mapLibraryName(string);
        if (this.isTraceOn()) {
            this.trace(string3, "Search " + string + " in all JAR files.");
        }
        if (this.isTraceOn()) {
            this.trace(string3, "loadLibraryAsResource(" + string4 + ")");
        }
        if ((string2 = this.loadLibraryAsResource(string4)) != null) {
            if (this.isTraceOn()) {
                this.trace(string3, String.valueOf(string4) + " loaded " + "absolute path = " + string2);
            }
            return string2;
        }
        string4 = String.valueOf(this.removeSpace(System.getProperty("os.name"))) + File.separator + this.removeSpace(System.getProperty("os.arch")) + File.separator + this.removeSpace(System.getProperty("os.version")) + File.separator + "lib" + File.separator + string4;
        if (this.isTraceOn()) {
            this.trace(string3, "loadLibraryAsResource(" + string4 + ")");
        }
        if ((string2 = this.loadLibraryAsResource(string4)) != null) {
            if (this.isTraceOn()) {
                this.trace(string3, String.valueOf(string4) + " loaded " + "absolute path = " + string2);
            }
            return string2;
        }
        if (this.isTraceOn()) {
            this.trace(string3, String.valueOf(string) + " not found in any JAR file.");
            this.trace(string3, "Search " + string + " along the path specified as the java.library.path property.");
        }
        return null;
    }

    private Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.isDebugOn()) {
                this.debug(this.dbgTag, "getClass", "Unexpected ClassNotFoundException occured");
            }
            return null;
        }
    }

    public String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    public Set getMBeansFromURL(String string) throws ServiceNotFoundException {
        String string2 = "getMBeansFromURL";
        if (string == null) {
            if (this.isTraceOn()) {
                this.trace(string2, "URL is null");
            }
            throw new ServiceNotFoundException("The specified URL is null");
        }
        string = string.replace(File.separatorChar, '/');
        if (this.isTraceOn()) {
            this.trace(string2, "<URL = " + string + ">");
        }
        MLetParser mLetParser = new MLetParser();
        this.mletList = mLetParser.parseURL(string);
        if (this.mletList == null) {
            if (this.isTraceOn()) {
                this.trace(string2, "Problems while parsing URL " + string);
            }
            throw new ServiceNotFoundException("Problems while parsing URL " + string);
        }
        if (this.mletList.size() == 0) {
            if (this.isTraceOn()) {
                this.trace(string2, "File " + string + " not found or MLET tag not defined in file");
            }
            throw new ServiceNotFoundException("File " + string + " not found or MLET tag not defined in file");
        }
        HashSet<Serializable> hashSet = new HashSet<Serializable>();
        Enumeration enumeration = this.mletList.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            MLetContent mLetContent = (MLetContent)enumeration.nextElement();
            String string3 = mLetContent.getCode();
            if (string3 != null && string3.endsWith(".class")) {
                string3 = string3.substring(0, string3.length() - 6);
            }
            String string4 = mLetContent.getName();
            URL uRL = mLetContent.getCodeBase();
            String string5 = mLetContent.getVersion();
            String string6 = mLetContent.getSerializedObject();
            String string7 = mLetContent.getJarFiles();
            URL uRL2 = mLetContent.getDocumentBase();
            Hashtable hashtable = mLetContent.getAttributes();
            if (this.isTraceOn()) {
                this.trace(string2, "MLET TAG     = " + hashtable.toString());
                this.trace(string2, "CODEBASE     = " + uRL);
                this.trace(string2, "ARCHIVE      = " + string7);
                this.trace(string2, "CODE         = " + string3);
                this.trace(string2, "OBJECT       = " + string6);
                this.trace(string2, "NAME         = " + string4);
                this.trace(string2, "VERSION      = " + string5);
                this.trace(string2, "DOCUMENT URL = " + uRL2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string7, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (this.isTraceOn()) {
                    this.trace(string2, "Load archive for codebase <" + uRL + ">, file <" + (String)object + ">");
                }
                try {
                    uRL = this.check(string5, uRL, (String)object, mLetContent);
                }
                catch (Exception exception) {
                    if (this.isDebugOn()) {
                        this.debug(string2, "Versioning Error: Versioning won't be performed");
                    }
                    uRL = mLetContent.getCodeBase();
                }
                try {
                    if (Arrays.asList(this.getURLs()).contains(new URL(String.valueOf(uRL.toString()) + (String)object))) continue;
                    this.addURL(String.valueOf(String.valueOf(uRL)) + (String)object);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            object = null;
            ObjectInstance objectInstance = null;
            if (string3 != null && string6 != null) {
                if (this.isTraceOn()) {
                    this.trace(string2, "CODE and OBJECT parameters cannot be specified at the same time in tag MLET.");
                }
                hashSet.add(new Error("CODE and OBJECT parameters cannot be specified at the same time in tag MLET"));
                continue;
            }
            if (string3 == null && string6 == null) {
                if (this.isTraceOn()) {
                    this.trace(string2, "Either CODE or OBJECT parameter must be specified in tag MLET.");
                }
                hashSet.add(new Error("Either CODE or OBJECT parameter must be specified in tag MLET"));
                continue;
            }
            try {
                if (string3 != null) {
                    Hashtable hashtable2 = new Hashtable();
                    Vector vector = new Vector();
                    Vector vector2 = new Vector();
                    Enumeration enumeration2 = hashtable.keys();
                    while (enumeration2.hasMoreElements()) {
                        String string8 = (String)enumeration2.nextElement();
                        if (string8.equals("types")) {
                            vector = (Vector)mLetContent.getParameter(string8);
                        }
                        if (!string8.equals("values")) continue;
                        vector2 = (Vector)mLetContent.getParameter(string8);
                    }
                    int n = 0;
                    while (n < vector.size()) {
                        vector2.setElementAt(this.constructParameter((String)vector2.elementAt(n), (String)vector.elementAt(n)), n);
                        ++n;
                    }
                    if (vector.isEmpty()) {
                        objectInstance = string4 == null ? this.server.createMBean(string3, null, this.mletObjectName) : this.server.createMBean(string3, new ObjectName(string4), this.mletObjectName);
                    } else {
                        Object[] objectArray = vector2.toArray();
                        String[] stringArray = new String[vector.size()];
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            stringArray[n2] = (String)vector.elementAt(n2);
                            ++n2;
                        }
                        if (this.isDebugOn()) {
                            int n3 = 0;
                            while (n3 < stringArray.length) {
                                this.debug(string2, "Signature     = " + stringArray[n3]);
                                this.debug(string2, "Params     = " + objectArray[n3].toString());
                                ++n3;
                            }
                        }
                        objectInstance = string4 == null ? this.server.createMBean(string3, null, this.mletObjectName, objectArray, stringArray) : this.server.createMBean(string3, new ObjectName(string4), this.mletObjectName, objectArray, stringArray);
                    }
                } else {
                    object = this.loadSerializedObject(uRL, string6);
                    if (string4 == null) {
                        this.server.registerMBean(object, null);
                    } else {
                        this.server.registerMBean(object, new ObjectName(string4));
                    }
                    objectInstance = new ObjectInstance(string4, object.getClass().getName());
                }
            }
            catch (ReflectionException reflectionException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "ReflectionException: " + reflectionException.getMessage());
                }
                hashSet.add(reflectionException);
                continue;
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "InstanceAlreadyExistsException: " + instanceAlreadyExistsException.getMessage());
                }
                hashSet.add(instanceAlreadyExistsException);
                continue;
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "MBeanRegistrationException: " + mBeanRegistrationException.getMessage());
                }
                hashSet.add(mBeanRegistrationException);
                continue;
            }
            catch (MBeanException mBeanException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "MBeanException: " + mBeanException.getMessage());
                }
                hashSet.add(mBeanException);
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "NotCompliantMBeanException: " + notCompliantMBeanException.getMessage());
                }
                hashSet.add(notCompliantMBeanException);
                continue;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "InstanceNotFoundException: " + instanceNotFoundException.getMessage());
                }
                hashSet.add(instanceNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "IOException: " + iOException.getMessage());
                }
                hashSet.add(iOException);
                continue;
            }
            catch (SecurityException securityException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "SecurityException: " + securityException.getMessage());
                }
                hashSet.add(securityException);
                continue;
            }
            catch (Exception exception) {
                if (this.isTraceOn()) {
                    this.trace(string2, "Exception: " + exception.getClass().getName() + exception.getMessage());
                }
                hashSet.add(exception);
                continue;
            }
            catch (Error error) {
                if (this.isTraceOn()) {
                    this.trace(string2, "Error: " + error.getMessage());
                }
                hashSet.add(error);
                continue;
            }
            hashSet.add(objectInstance);
        }
        return hashSet;
    }

    public Set getMBeansFromURL(URL uRL) throws ServiceNotFoundException {
        if (uRL == null) {
            throw new ServiceNotFoundException("The specified URL is null");
        }
        return this.getMBeansFromURL(uRL.toString());
    }

    public URL[] getURLs() {
        return super.getURLs();
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)2);
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)2);
    }

    Class loadClassCalledFromDLR(String string) throws ClassNotFoundException {
        this.dlr = true;
        return this.loadClass(string);
    }

    private synchronized String loadLibraryAsResource(String string) {
        try {
            InputStream inputStream;
            File file = new File(this.libraryDirectory, string);
            if (file.exists()) {
                file.delete();
            }
            if ((inputStream = ((ClassLoader)this).getResourceAsStream(string.replace(File.separatorChar, '/'))) != null) {
                int n;
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                inputStream.close();
                fileOutputStream.close();
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private Object loadSerializedObject(URL uRL, String string) throws IOException, ClassNotFoundException {
        InputStream inputStream;
        if (string != null) {
            string = string.replace(File.separatorChar, '/');
        }
        if (this.isTraceOn()) {
            this.trace("loadSerializedObject", String.valueOf(uRL.toString()) + string);
        }
        if ((inputStream = ((ClassLoader)this).getResourceAsStream(string)) != null) {
            try {
                MLetObjectInputStream mLetObjectInputStream = new MLetObjectInputStream(inputStream, this);
                Object object = mLetObjectInputStream.readObject();
                mLetObjectInputStream.close();
                return object;
            }
            catch (IOException iOException) {
                if (this.isDebugOn()) {
                    this.debug("loadSerializedObject", "Exception while deserializing " + string + ", " + iOException.getMessage());
                }
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.isDebugOn()) {
                    this.debug("loadSerializedObject", "Exception while deserializing " + string + ", " + classNotFoundException.getMessage());
                }
                throw classNotFoundException;
            }
        }
        if (this.isDebugOn()) {
            this.debug("loadSerializedObject", "Error: File " + string + " containing serialized object not found");
        }
        throw new Error("File " + string + " containing serialized object not found");
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        this.mletObjectName = objectName;
        if (objectName == null) {
            return new ObjectName(String.valueOf(mBeanServer.getDefaultDomain()) + ":" + "type=MLet");
        }
        return objectName;
    }

    private Object readContents(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by == 113) {
            return objectInput.readObject();
        }
        if (by == 112) {
            return null;
        }
        throw new IOException("Input stream corrupted.");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        URL[] uRLArray = (URL[])this.readContents(objectInput);
        if (uRLArray != null) {
            int n = 0;
            while (n < uRLArray.length) {
                this.addURL(uRLArray[n]);
                ++n;
            }
        }
        this.mletObjectName = (ObjectName)this.readContents(objectInput);
        this.server = (MBeanServer)this.readContents(objectInput);
        this.libraryDirectory = (String)this.readContents(objectInput);
    }

    private String removeSpace(String string) {
        int n = (string = string.trim()).indexOf(32);
        if (n == -1) {
            return string;
        }
        String string2 = new String();
        int n2 = 0;
        while (n != -1) {
            n = (string = string.substring(n2)).indexOf(32);
            string2 = n != -1 ? String.valueOf(string2) + string.substring(0, n) : String.valueOf(string2) + string.substring(0);
            n2 = n + 1;
        }
        return string2;
    }

    public void setLibraryDirectory(String string) {
        this.libraryDirectory = string;
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)2, (String)string, (String)string2, (String)string3);
    }

    private void writeContents(ObjectOutput objectOutput, Object object) throws IOException {
        if (object == null) {
            objectOutput.writeByte(112);
        } else {
            objectOutput.writeByte(113);
            objectOutput.writeObject(object);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeContents(objectOutput, super.getURLs());
        this.writeContents(objectOutput, this.mletObjectName);
        this.writeContents(objectOutput, this.server);
        this.writeContents(objectOutput, this.libraryDirectory);
    }
}

