/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.enhydra.instantdb.db.BlobColumn;
import org.enhydra.instantdb.db.ByteColumn;
import org.enhydra.instantdb.db.Char1Column;
import org.enhydra.instantdb.db.Char1String;
import org.enhydra.instantdb.db.Column;
import org.enhydra.instantdb.db.CurrencyColumn;
import org.enhydra.instantdb.db.Database;
import org.enhydra.instantdb.db.DateColumn;
import org.enhydra.instantdb.db.DoubleColumn;
import org.enhydra.instantdb.db.FloatColumn;
import org.enhydra.instantdb.db.IntegerColumn;
import org.enhydra.instantdb.db.LongColumn;
import org.enhydra.instantdb.db.Search;
import org.enhydra.instantdb.db.SqlFunction;
import org.enhydra.instantdb.db.StringColumn;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.matchedTokens;

class expression
implements Cloneable {
    Database dbase;
    Column col;
    String pseudoTblName;
    Object value;
    String name;
    expression subExpr1;
    expression subExpr2;
    int operation;
    int exprType;
    int exprClass;
    int exprSubtype;
    expression otherExpr;
    int colLen;
    int tblIndex;
    int funcClass;
    Object funcValue;
    int funcCount;
    Vector valueList;
    char currencyChar;
    int currencyDecimals;
    String dateFormat;
    boolean strictLiterals;
    boolean exprContainsFunc;
    boolean isGroupBy;
    boolean isNull;
    SqlFunction sqlFunction;
    expression[] funcExprs;
    int[] parameterTypes;
    int oldExprClass;
    expression oldSubExpr1;
    Object oldValue;
    static Integer int0 = new Integer(0);
    static Integer int1 = new Integer(1);
    static final String[] ops = new String[]{"null", "+", "-", "*", "/"};
    static final String[] funcs = new String[]{"null", "COUNT", "MAX", "MIN", "SUM", "AVG"};
    static final String[] rowFuncs = new String[]{"null", "TO_DATE", "UPPER", "LOWER", "TO_NUMBER"};
    static final int NUMERIC = 0;
    static final int STRING = 1;
    static final int OP_PLUS = 1;
    static final int OP_MINUS = 2;
    static final int OP_MUL = 3;
    static final int OP_DIV = 4;
    static final int X_COL = 1;
    static final int X_CONST = 2;
    static final int X_EXPR = 3;
    static final int X_SUBEXPR = 4;
    static final int X_FUNC = 5;
    static final int X_ROWFUNC = 6;
    static final int X_INTERNAL = 7;
    static final int I_CARDINALITY = 1;
    static final int I_ROW_COUNT = 2;
    static final int I_DEL_ROW_COUNT = 3;
    static final int I_LAST_VALUE = 4;
    static final int F_COUNT = 1;
    static final int F_MAX = 2;
    static final int F_MIN = 3;
    static final int F_SUM = 4;
    static final int F_AVG = 5;
    static final int F_TO_DATE = 1;
    static final int F_UPPER = 2;
    static final int F_LOWER = 3;
    static final int F_TO_NUMBER = 4;

    expression(Column column, int n) {
        this.col = column;
        this.dbase = column.dbase;
        this.tblIndex = n;
        this.pseudoTblName = column.getName();
        this.value = this.col.getName();
        if (!this.col.numeric()) {
            this.exprType = 1;
            this.colLen = this.col.getLength();
        } else {
            LongColumn longColumn;
            this.exprSubtype = this.col.type;
            if (this.exprSubtype == 6) {
                longColumn = (CurrencyColumn)this.col;
                this.currencyChar = longColumn.unitChar;
                this.currencyDecimals = longColumn.decimalPosn;
            }
            if (this.exprSubtype == 5) {
                longColumn = (DateColumn)this.col;
                this.dateFormat = ((DateColumn)longColumn).formatStr;
            }
            if (this.exprSubtype == 9) {
                this.exprSubtype = 2;
            }
        }
        this.exprClass = 1;
    }

    expression(Database database, Object object) throws SQLException {
        this.dbase = database;
        this.value = object;
        this.exprClass = 2;
        if (object instanceof String || object instanceof Char1String) {
            this.exprType = 3;
        } else if (object instanceof Integer) {
            this.exprSubtype = 2;
        } else if (object instanceof Long) {
            this.exprSubtype = 4;
        } else if (object instanceof Float) {
            this.exprSubtype = 7;
        } else if (object instanceof Double) {
            this.exprSubtype = 8;
        } else if (object instanceof byte[]) {
            this.exprSubtype = 10;
        } else {
            throw new SQLException("Unknown type for constant value: " + object);
        }
    }

    expression(matchedTokens matchedTokens2, Vector vector, Vector vector2) throws SQLException {
        this.strictLiterals = matchedTokens2.dbase.strictLiterals;
        this.constructExpr(matchedTokens2, vector, vector2);
    }

    expression(matchedTokens matchedTokens2, Vector vector, Vector vector2, expression expression2) throws SQLException {
        this.otherExpr = expression2;
        this.strictLiterals = matchedTokens2.dbase.strictLiterals;
        this.constructExpr(matchedTokens2, vector, vector2);
    }

    expression(matchedTokens matchedTokens2, Vector vector, Vector vector2, boolean bl) throws SQLException {
        this.strictLiterals = matchedTokens2.dbase.strictLiterals;
        this.isGroupBy = bl;
        this.constructExpr(matchedTokens2, vector, vector2);
    }

    void addToResultsSet(Table table) throws SQLException {
        Column column;
        String string = this.toString();
        Database database = table.dbase;
        String string2 = database.getStringProperty("resultsSetCache", "CACHE_ROWS");
        int n = database.translateCacheCondition(string2);
        int n2 = Integer.parseInt(database.getStringProperty("resultsSetCacheAmount", "100"));
        Column column2 = null;
        if (this.exprType == 1) {
            if (this.exprClass == 1) {
                if (this.col instanceof BlobColumn) {
                    column = (BlobColumn)this.col;
                    column2 = new BlobColumn(table, string, ((BlobColumn)column).binType);
                }
                if (this.col instanceof Char1Column) {
                    column2 = new Char1Column(table, string, this.colLen - 4);
                }
            }
            if (column2 == null) {
                column2 = new StringColumn(table, string, (this.colLen - 4) / 2);
            }
        } else {
            switch (this.exprSubtype) {
                case 1: {
                    column2 = new ByteColumn(table, string);
                    break;
                }
                case 2: {
                    column2 = new IntegerColumn(table, string);
                    break;
                }
                case 7: {
                    column2 = new FloatColumn(table, string);
                    break;
                }
                case 5: {
                    column2 = new DateColumn(table, string, this.dateFormat);
                    break;
                }
                case 6: {
                    column2 = new CurrencyColumn(table, string, this.currencyChar, this.currencyDecimals);
                    break;
                }
                case 8: {
                    column2 = new DoubleColumn(table, string);
                    break;
                }
                case 4: {
                    column2 = new LongColumn(table, string);
                    break;
                }
                case 10: {
                    column2 = new BlobColumn(table, string, BlobColumn.BINARY_BLOB);
                    break;
                }
                default: {
                    throw new SQLException("Internal error: can't create column of type: " + this.exprSubtype);
                }
            }
        }
        column2.setCacheCondition(n, n2);
        column2.setBooleanProperty(6, true);
        column = this.getColumn();
        if (column != null) {
            column2.setUnderlyingTable(column.getTable());
        }
    }

    boolean checkCurrency(String string) {
        Object object;
        Column column;
        if (this.otherExpr != null && (column = this.otherExpr.col) != null && column.type == 6 && (object = column.toObject(string)) != null) {
            this.exprSubtype = 4;
            this.value = object;
            this.exprClass = 2;
            this.exprType = 0;
            return true;
        }
        return false;
    }

    public Object clone() {
        expression expression2 = null;
        try {
            expression2 = (expression)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Error cloning expression");
        }
        return expression2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void constructExpr(matchedTokens matchedTokens2, Vector vector, Vector vector2) throws SQLException {
        this.dbase = matchedTokens2.dbase;
        String string = null;
        matchedTokens2.setSearchDepth(2);
        Object object = matchedTokens2.get("expr_item2");
        if (object != null) {
            matchedTokens2.setSearchDepth(2);
            this.operation = Search.pickString(ops, matchedTokens2);
            Object object2 = matchedTokens2.mark("expr_item");
            this.subExpr1 = new expression(matchedTokens2, vector, vector2, this.isGroupBy);
            matchedTokens2.mark(object2);
            matchedTokens2.mark("expr_item2");
            matchedTokens2.mark("expr_item");
            this.subExpr2 = new expression(matchedTokens2, vector, vector2, this.isGroupBy);
            if (this.subExpr1.exprType != this.subExpr2.exprType) {
                throw new SQLException("Expressions different types: " + this);
            }
            this.exprType = this.subExpr1.exprType;
            expression expression2 = this.subExpr1;
            if (this.subExpr2.exprSubtype > this.subExpr1.exprSubtype) {
                expression2 = this.subExpr2;
            }
            this.exprSubtype = expression2.exprSubtype;
            this.currencyChar = expression2.currencyChar;
            this.currencyDecimals = expression2.currencyDecimals;
            this.dateFormat = expression2.dateFormat;
            if (this.exprType == 1 && this.operation != 1) {
                throw new SQLException("Operation: " + ops[this.operation] + ", undefined for strings, col: " + this.toString());
            }
            this.exprClass = 3;
            if (this.operation == 4 && this.exprSubtype != 7) {
                this.exprSubtype = 8;
            }
            if (this.subExpr1.exprClass == 2 && this.subExpr2.exprClass == 2) {
                this.value = this.evaluate(null);
                this.exprClass = 2;
                this.subExpr2 = null;
                this.subExpr1 = null;
                return;
            }
            this.value = String.valueOf(this.subExpr1.toString()) + ops[this.operation] + this.subExpr2.toString();
            return;
        }
        matchedTokens2.mark("expr_item");
        matchedTokens2.setSearchDepth(2);
        if (matchedTokens2.mark("function") != null) {
            matchedTokens2.setSearchDepth(3);
            this.exprClass = 5;
            this.funcClass = Search.pickString(funcs, matchedTokens2);
            if (this.funcClass == 4) {
                this.funcValue = int0;
            }
            String string2 = "";
            if (matchedTokens2.containsKey("DISTINCT")) {
                this.valueList = new Vector(100, 100);
                string2 = "DISTINCT ";
            }
            matchedTokens2.setSearchDepth(1);
            matchedTokens2.mark("expr_item");
            this.subExpr1 = new expression(matchedTokens2, vector, vector2, this.isGroupBy);
            this.exprType = this.subExpr1.exprType;
            this.exprSubtype = this.subExpr1.exprSubtype;
            this.currencyChar = this.subExpr1.currencyChar;
            this.currencyDecimals = this.subExpr1.currencyDecimals;
            this.dateFormat = this.subExpr1.dateFormat;
            if (this.funcClass == 1) {
                this.exprType = 0;
                this.exprSubtype = 2;
            }
            if (this.exprType == 1) {
                if (this.funcClass == 4 || this.funcClass == 5) {
                    throw new SQLException("Function: " + funcs[this.funcClass] + ", undefined for strings");
                }
                this.colLen = 256;
                if (this.subExpr1.col != null) {
                    this.colLen = this.subExpr1.col.getLength();
                }
            }
            this.value = String.valueOf(funcs[this.funcClass]) + "(" + string2 + this.subExpr1.toString() + ")";
            return;
        }
        if (matchedTokens2.mark("rowfunc") != null) {
            int n;
            Vector vector3;
            this.exprClass = 6;
            this.name = (String)matchedTokens2.get("funcname");
            String string3 = "org.enhydra.instantdb.db." + this.name.toLowerCase();
            try {
                vector3 = null;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    vector3 = (Vector)Class.forName(string3).newInstance();
                }
                this.sqlFunction = (SqlFunction)((Object)vector3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SQLException("Error loading class: " + string3 + ", " + exception.getMessage());
            }
            vector3 = (Vector)matchedTokens2.get("parameter");
            int n2 = 0;
            if (vector3 != null) {
                n2 = vector3.size();
            }
            this.funcExprs = new expression[n2];
            this.parameterTypes = new int[n2];
            this.name = String.valueOf(this.name) + "(";
            int n3 = 0;
            while (n3 < n2) {
                matchedTokens2.mark(vector3.elementAt(n3));
                matchedTokens2.mark("expr");
                expression expression3 = new expression(matchedTokens2, vector, vector2);
                if (n3 > 0) {
                    this.name = String.valueOf(this.name) + ",";
                }
                this.name = String.valueOf(this.name) + expression3;
                n = expression3.exprSubtype;
                if (expression3.exprType == 1) {
                    if (expression3.exprSubtype != 10) {
                        n = 3;
                    } else if (expression3.getBlobType() == BlobColumn.STRING_BLOB) {
                        n = 3;
                    }
                }
                if (n == 5) {
                    this.sqlFunction.setSpecialValue(100, new Integer(this.dbase.milleniumBoundary));
                }
                this.funcExprs[n3] = expression3;
                this.parameterTypes[n3] = n;
                ++n3;
            }
            this.name = String.valueOf(this.name) + ")";
            int n4 = this.sqlFunction.checkParameters(this.parameterTypes);
            if (n4 == 3 || n4 == 10) {
                this.exprType = 1;
                this.colLen = 64;
                n = 0;
                while (n < n2) {
                    if (this.funcExprs[n].exprType == 1 && this.funcExprs[n].colLen > this.colLen) {
                        this.colLen = this.funcExprs[n].colLen;
                    }
                    ++n;
                }
                return;
            } else {
                this.exprType = 0;
                this.exprSubtype = n4;
                if (n4 != 5) return;
                this.sqlFunction.setSpecialValue(100, new Integer(this.dbase.milleniumBoundary));
                Object object3 = this.sqlFunction.getSpecialValue(100);
                if (object3 == null) return;
                try {
                    int n5 = (Integer)object3;
                    this.dateFormat = (String)this.funcExprs[n5].value;
                    return;
                }
                catch (Exception exception) {
                    throw new SQLException("Invalid return from " + string3 + ".getSpecialValue");
                }
            }
        }
        if (matchedTokens2.mark("internal_parameter") != null) {
            Object object4 = matchedTokens2.mark("expr2");
            this.subExpr1 = new expression(matchedTokens2, vector, vector2);
            matchedTokens2.mark(object4);
            object4 = matchedTokens2.mark("expr3");
            this.subExpr2 = new expression(matchedTokens2, vector, vector2);
            matchedTokens2.mark(object4);
            this.exprClass = 7;
            this.exprType = 0;
            this.exprSubtype = 2;
            String string4 = (String)matchedTokens2.get("param");
            this.name = String.valueOf(this.subExpr1.toString()) + "." + this.subExpr2.toString() + "." + string4;
            if (string4.equalsIgnoreCase("cardinality")) {
                this.operation = 1;
                return;
            } else if (string4.equalsIgnoreCase("row_count")) {
                this.operation = 2;
                return;
            } else if (string4.equalsIgnoreCase("del_row_count")) {
                this.operation = 3;
                return;
            } else {
                if (!string4.equalsIgnoreCase("last_value")) throw new SQLException("Unknown internal operation: " + string4);
                this.operation = 4;
            }
            return;
        } else if (matchedTokens2.mark("text_item") != null) {
            this.exprClass = 2;
            this.exprType = 1;
            this.name = (String)matchedTokens2.get("str_lit");
            this.value = this.name;
            return;
        } else {
            if (matchedTokens2.mark("col_ref") != null) {
                Object object5 = matchedTokens2.get("colName", false);
                if (!(object5 instanceof String)) {
                    this.exprClass = 2;
                    if (object5 instanceof Date) {
                        Date date = (Date)object5;
                        this.value = new Long(date.getTime());
                        this.exprType = 0;
                        this.exprSubtype = 5;
                        return;
                    }
                    if (object5 instanceof StringBuffer) {
                        if (this.otherExpr != null && this.otherExpr.exprType == 0) {
                            this.strictLiterals = false;
                        }
                        this.interpretString(object5.toString());
                        return;
                    }
                    this.value = object5;
                    if (this.value instanceof Number) {
                        if (this.value instanceof Integer) {
                            this.exprSubtype = 2;
                        } else if (this.value instanceof Float) {
                            this.exprSubtype = 7;
                        } else if (this.value instanceof Long) {
                            this.exprSubtype = 4;
                        } else if (this.value instanceof Double) {
                            this.exprSubtype = 8;
                        }
                    }
                    if (this.otherExpr == null) return;
                    this.exprType = this.otherExpr.exprType;
                    this.exprSubtype = this.otherExpr.exprSubtype;
                    return;
                }
                String string5 = (String)object5;
                String string6 = (String)matchedTokens2.get("tableName");
                boolean bl = this.interpretColumn(vector, vector2, string6, string5);
                if (!bl) {
                    bl = this.interpretColumn(vector, vector2, null, String.valueOf(string6) + "." + string5);
                }
                if (bl) return;
                if (string6 != null) {
                    this.interpretString(String.valueOf(string6) + "." + string5);
                    return;
                } else {
                    this.interpretString(string5);
                }
                return;
            }
            if (matchedTokens2.mark("expr") != null) {
                this.exprClass = 4;
                this.subExpr1 = new expression(matchedTokens2, vector, vector2, this.isGroupBy);
                this.exprType = this.subExpr1.exprType;
                this.exprSubtype = this.subExpr1.exprSubtype;
                this.currencyChar = this.subExpr1.currencyChar;
                this.currencyDecimals = this.subExpr1.currencyDecimals;
                this.dateFormat = this.subExpr1.dateFormat;
                this.value = this.subExpr1.toString();
                if (this.subExpr1.exprClass != 2) return;
                this.value = this.evaluate(null);
                this.exprClass = 2;
                this.subExpr1 = null;
                return;
            }
            if (matchedTokens2.mark("COUNT") != null) {
                this.exprClass = 5;
                this.exprSubtype = 2;
                this.funcClass = 1;
                this.value = "COUNT(*)";
                return;
            } else {
                string = (String)matchedTokens2.get("int_lit");
                if (string != null) {
                    this.strictLiterals = false;
                    this.toNumericValue(string);
                    return;
                }
                string = (String)matchedTokens2.get("str_lit");
                if (string == null) throw new SQLException("Internal error: could not parse expression" + matchedTokens2);
                if (!this.strictLiterals) {
                    String string7 = string;
                    String string8 = (String)matchedTokens2.get("str_lit2");
                    if (string8 == null) {
                        int n = string.indexOf(46);
                        if (n != -1) {
                            string8 = string.substring(n + 1);
                            string7 = string.substring(0, n);
                        } else {
                            string7 = null;
                            string8 = string;
                        }
                    }
                    if (this.interpretColumn(vector, vector2, string7, string8)) {
                        return;
                    }
                }
                this.interpretString(string);
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    Object evaluate(int[] var1_1) throws SQLException {
        this.isNull = false;
        this.exprContainsFunc = false;
        var2_2 = null;
        var3_3 = null;
        if (this.subExpr1 != null) {
            var2_2 = this.subExpr1.evaluate(var1_1);
            if (this.subExpr1.exprContainsFunc) {
                this.exprContainsFunc = true;
            }
        }
        if (this.subExpr2 != null) {
            var3_3 = this.subExpr2.evaluate(var1_1);
            if (this.subExpr2.exprContainsFunc) {
                this.exprContainsFunc = true;
            }
        }
        if (this.exprContainsFunc) {
            return null;
        }
        if (var1_1 == null && this.exprClass == 5) {
            this.oldExprClass = 5;
            this.oldSubExpr1 = this.subExpr1;
            this.oldValue = this.value;
            if (this.funcClass == 5) {
                switch (this.exprSubtype) {
                    case 4: 
                    case 5: 
                    case 6: {
                        var4_4 = ((Number)this.funcValue).longValue();
                        var4_4 = (long)((double)var4_4 / (double)this.funcCount);
                        this.funcValue = new Long(var4_4);
                        break;
                    }
                    case 7: {
                        var6_7 = ((Number)this.funcValue).floatValue();
                        this.funcValue = new Float(var6_7 / (float)this.funcCount);
                        break;
                    }
                    case 8: {
                        var7_10 = ((Number)this.funcValue).doubleValue();
                        this.funcValue = new Double(var7_10 / (double)this.funcCount);
                        break;
                    }
                    default: {
                        var9_16 = ((Number)this.funcValue).intValue();
                        this.funcValue = new Integer(var9_16 / this.funcCount);
                    }
                }
            }
            var4_5 = "NULL";
            var4_5 = this.getNullObj();
            this.exprClass = 2;
            this.subExpr1 = null;
            if (this.funcClass == 1) {
                this.funcValue = new Integer(this.funcCount);
            }
            this.value = this.funcValue;
            if (this.value == null) {
                this.value = var4_5;
            }
            this.exprContainsFunc = true;
            return null;
        }
        switch (this.exprClass) {
            case 6: {
                var4_6 = this.funcExprs.length;
                var5_22 = new Object[var4_6];
                var6_8 = 0;
                while (var6_8 < var4_6) {
                    var7_11 = this.funcExprs[var6_8].evaluate(var1_1);
                    if (var7_11 instanceof byte[]) {
                        var8_23 = (byte[])var7_11;
                        if (var8_23[0] == BlobColumn.STRING_BLOB) {
                            var7_11 = BlobColumn.objToString(var8_23);
                        } else {
                            var9_17 = new byte[var8_23.length - 1];
                            System.arraycopy(var8_23, 1, var9_17, 0, var9_17.length);
                            var7_11 = var9_17;
                        }
                    }
                    var5_22[var6_8] = var7_11;
                    if (this.funcExprs[var6_8].exprContainsFunc) {
                        this.exprContainsFunc = true;
                    }
                    if (var7_11 == null) {
                        return null;
                    }
                    ++var6_8;
                }
                if (this.exprContainsFunc) {
                    return null;
                }
                var2_2 = this.sqlFunction.evaluate(var5_22);
                return var2_2;
            }
            case 1: {
                if (var1_1 == null) {
                    return null;
                }
                var6_9 = var1_1[this.tblIndex];
                var2_2 = var6_9 == -1 ? this.col.nullObj : this.col.getByRow(var6_9);
                if (this.col.isNull(var2_2)) {
                    this.isNull = true;
                }
                return var2_2;
            }
            case 2: {
                return this.value;
            }
            case 4: {
                this.isNull = this.subExpr1.isNull;
                return var2_2;
            }
            case 5: {
                this.exprContainsFunc = true;
                if (var2_2 == null) {
                    ++this.funcCount;
                    return null;
                }
                if (this.subExpr1.isNull) {
                    return null;
                }
                if (this.valueList != null) {
                    var7_12 = var2_2.toString();
                    var8_24 = 0;
                    while (var8_24 < this.valueList.size()) {
                        var9_18 = (String)this.valueList.elementAt(var8_24);
                        if (var7_12.equalsIgnoreCase(var9_18)) {
                            return null;
                        }
                        ++var8_24;
                    }
                    this.valueList.addElement(var7_12);
                }
                ++this.funcCount;
                if (this.funcClass == 1) {
                    return null;
                }
                if (this.funcValue == null) {
                    this.funcValue = var2_2;
                    return null;
                }
                if (this.exprType == 1) {
                    var7_12 = (String)var2_2;
                    if (var7_12 == StringColumn.NULL) {
                        return null;
                    }
                    var8_25 = (String)this.funcValue;
                    if (this.funcClass == 2) {
                        if (var7_12.compareTo(var8_25) > 0) {
                            this.funcValue = var2_2;
                        }
                    } else if (var7_12.compareTo(var8_25) < 0) {
                        this.funcValue = var2_2;
                    }
                    return null;
                }
                switch (this.exprSubtype) {
                    case 4: 
                    case 5: 
                    case 6: {
                        var7_13 = ((Number)var2_2).longValue();
                        var9_19 = ((Number)this.funcValue).longValue();
                        switch (this.funcClass) {
                            case 2: {
                                if (var7_13 > var9_19) {
                                    this.funcValue = var2_2;
                                }
                                ** GOTO lbl193
                            }
                            case 3: {
                                if (var7_13 < var9_19) {
                                    this.funcValue = var2_2;
                                }
                                ** GOTO lbl193
                            }
                            case 4: 
                            case 5: {
                                this.funcValue = new Long(var9_19 += var7_13);
                                ** GOTO lbl193
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    case 7: {
                        var11_27 = ((Number)var2_2).floatValue();
                        var12_31 = ((Number)this.funcValue).floatValue();
                        switch (this.funcClass) {
                            case 2: {
                                if (var11_27 > var12_31) {
                                    this.funcValue = var2_2;
                                }
                                ** GOTO lbl193
                            }
                            case 3: {
                                if (var11_27 < var12_31) {
                                    this.funcValue = var2_2;
                                }
                                ** GOTO lbl193
                            }
                            case 4: 
                            case 5: {
                                this.funcValue = new Float(var12_31 += var11_27);
                                ** GOTO lbl193
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    case 8: {
                        var13_33 = ((Number)var2_2).doubleValue();
                        var15_35 = ((Number)this.funcValue).doubleValue();
                        switch (this.funcClass) {
                            case 2: {
                                if (var13_33 > var15_35) {
                                    this.funcValue = var2_2;
                                    ** break;
                                }
                                ** GOTO lbl193
                            }
                            case 3: {
                                if (var13_33 < var15_35) {
                                    this.funcValue = var2_2;
                                    ** break;
                                }
                                ** GOTO lbl193
                            }
                            case 4: 
                            case 5: {
                                this.funcValue = new Double(var15_35 += var13_33);
                                ** break;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    default: {
                        var17_37 = ((Number)var2_2).intValue();
                        var18_39 = ((Number)this.funcValue).intValue();
                        switch (this.funcClass) {
                            case 2: {
                                if (var17_37 > var18_39) {
                                    this.funcValue = var2_2;
                                    ** break;
                                }
                                ** GOTO lbl193
                            }
                            case 3: {
                                if (var17_37 < var18_39) {
                                    this.funcValue = var2_2;
                                    ** break;
                                }
                                ** GOTO lbl193
                            }
                            case 4: 
                            case 5: {
                                this.funcValue = new Integer(var18_39 += var17_37);
                                ** break;
                            }
                        }
                    }
                }
lbl193:
                // 17 sources

                return null;
            }
            case 3: {
                if (var2_2 == null || var3_3 == null) {
                    return null;
                }
                if (this.subExpr1.isNull || this.subExpr2.isNull) {
                    this.isNull = true;
                    return expression.int0;
                }
                if (this.exprType == 1) {
                    return String.valueOf((String)var2_2) + (String)var3_3;
                }
                switch (this.exprSubtype) {
                    case 4: 
                    case 5: 
                    case 6: {
                        var7_14 = ((Number)var2_2).longValue();
                        var9_20 = ((Number)var3_3).longValue();
                        switch (this.operation) {
                            case 1: {
                                this.value = new Long(var7_14 + var9_20);
                                ** GOTO lbl273
                            }
                            case 2: {
                                this.value = new Long(var7_14 - var9_20);
                                ** GOTO lbl273
                            }
                            case 3: {
                                this.value = new Long(var7_14 * var9_20);
                                ** GOTO lbl273
                            }
                            case 4: {
                                this.value = new Long(var7_14 / var9_20);
                                ** GOTO lbl273
                            }
                            default: {
                                if (this.subExpr1.exprClass != 2) ** GOTO lbl278
                            }
                        }
                    }
                    case 7: {
                        var11_28 = ((Number)var2_2).floatValue();
                        var12_32 = ((Number)var3_3).floatValue();
                        switch (this.operation) {
                            case 1: {
                                this.value = new Float(var11_28 + var12_32);
                                ** GOTO lbl273
                            }
                            case 2: {
                                this.value = new Float(var11_28 - var12_32);
                                ** GOTO lbl273
                            }
                            case 3: {
                                this.value = new Float(var11_28 * var12_32);
                                ** GOTO lbl273
                            }
                            case 4: {
                                this.value = new Float(var11_28 / var12_32);
                                ** GOTO lbl273
                            }
                            default: {
                                if (this.subExpr1.exprClass != 2) ** GOTO lbl278
                            }
                        }
                    }
                    case 8: {
                        var13_34 = ((Number)var2_2).doubleValue();
                        var15_36 = ((Number)var3_3).doubleValue();
                        switch (this.operation) {
                            case 1: {
                                this.value = new Double(var13_34 + var15_36);
                                ** break;
                            }
                            case 2: {
                                this.value = new Double(var13_34 - var15_36);
                                ** break;
                            }
                            case 3: {
                                this.value = new Double(var13_34 * var15_36);
                                ** break;
                            }
                            case 4: {
                                this.value = new Double(var13_34 / var15_36);
                                ** break;
                            }
                            default: {
                                if (this.subExpr1.exprClass != 2) ** GOTO lbl278
                            }
                        }
                    }
                    default: {
                        var17_38 = ((Number)var2_2).intValue();
                        var18_40 = ((Number)var3_3).intValue();
                        switch (this.operation) {
                            case 1: {
                                this.value = new Integer(var17_38 + var18_40);
                                ** break;
                            }
                            case 2: {
                                this.value = new Integer(var17_38 - var18_40);
                                ** break;
                            }
                            case 3: {
                                this.value = new Integer(var17_38 * var18_40);
                                ** break;
                            }
                            case 4: {
                                this.value = new Integer(var17_38 / var18_40);
                                ** break;
                            }
                        }
                    }
                }
lbl273:
                // 17 sources

                if (this.subExpr1.exprClass != 2) ** GOTO lbl278
                if (this.subExpr2.exprClass == 2) {
                    this.exprClass = 2;
                    this.subExpr2 = null;
                    this.subExpr1 = null;
                }
lbl278:
                // 7 sources

                return this.value;
            }
            case 7: {
                var7_15 = 0;
                if (var2_2 == null || var3_3 == null) {
                    return null;
                }
                var8_26 = var2_2.toString();
                var9_21 = var3_3.toString();
                var10_41 = this.dbase.getTable(var8_26);
                if (var10_41 != null) {
                    this.col = var10_41.getColByName(var9_21);
                }
                if (this.col == null) {
                    return null;
                }
                switch (this.operation) {
                    case 1: {
                        var7_15 = this.col.cardinality - 1;
                        break;
                    }
                    case 2: {
                        var7_15 = this.col.cTable.rowCount;
                        break;
                    }
                    case 4: {
                        var11_29 = this.col.lastValueInserted;
                        return var11_29;
                    }
                    case 3: {
                        var7_15 = this.col.cTable.deletedRowCount;
                    }
                }
                var11_30 = new Integer(var7_15);
                return var11_30;
            }
        }
        return null;
    }

    int getBlobType() {
        int n = -1;
        if (this.col != null && this.col instanceof BlobColumn) {
            BlobColumn blobColumn = (BlobColumn)this.col;
            n = blobColumn.binType;
        }
        if (n == -1 && this.subExpr1 != null) {
            n = this.subExpr1.getBlobType();
        }
        if (n == -1 && this.subExpr2 != null) {
            n = this.subExpr2.getBlobType();
        }
        return n;
    }

    Column getColumn() throws SQLException {
        Column column = null;
        Column column2 = null;
        if (this.col != null) {
            return this.col;
        }
        if (this.subExpr1 != null) {
            column = this.subExpr1.getColumn();
        }
        if (this.subExpr2 != null) {
            column2 = this.subExpr2.getColumn();
        }
        if (column2 == null) {
            return column;
        }
        if (column == null) {
            return column2;
        }
        return column;
    }

    int getMinTableIndex() {
        int n;
        int n2 = Integer.MAX_VALUE;
        if (this.col != null) {
            n2 = this.tblIndex;
        }
        if (this.subExpr1 != null && (n = this.subExpr1.getMinTableIndex()) < n2) {
            n2 = n;
        }
        if (this.subExpr2 != null && (n = this.subExpr2.getMinTableIndex()) < n2) {
            n2 = n;
        }
        return n2;
    }

    Object getNullObj() {
        if (this.col != null) {
            return this.col.getNull();
        }
        if (this.subExpr1 != null) {
            return this.subExpr1.getNullObj();
        }
        if (this.subExpr2 != null) {
            return this.subExpr1.getNullObj();
        }
        return null;
    }

    String getTableName() throws SQLException {
        String string = null;
        String string2 = null;
        if (this.pseudoTblName != null) {
            return this.pseudoTblName;
        }
        if (this.subExpr1 != null) {
            string = this.subExpr1.getTableName();
        }
        if (this.subExpr2 != null) {
            string2 = this.subExpr2.getTableName();
        }
        if (string2 == null) {
            return string;
        }
        if (string == null) {
            return string2;
        }
        if (string.equalsIgnoreCase(string2)) {
            return string;
        }
        throw new SQLException("Expression uses 2 tables: " + string + " and " + string2);
    }

    boolean interpretColumn(Vector vector, Vector vector2, String string, String string2) throws SQLException {
        Object object;
        this.exprClass = 1;
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            Column column;
            object = (Table)vector.elementAt(n);
            String string3 = ((Table)object).getTableName();
            String string4 = (String)vector2.elementAt(n);
            if (this.isGroupBy && string != null) {
                string2 = String.valueOf(string) + '.' + string2;
                string = null;
            }
            if ((column = ((Table)object).getColByName(string2, true)) != null && (string == null || string.equalsIgnoreCase(string4) && (string.equalsIgnoreCase(string3) || string.equalsIgnoreCase(string4)))) {
                if (bl && column != this.col) {
                    throw new SQLException("Column name is ambiguous: " + string2);
                }
                this.pseudoTblName = string4;
                this.col = column;
                bl = true;
                this.tblIndex = n;
            }
            ++n;
        }
        if (!bl) {
            return false;
        }
        this.value = this.col.getName();
        if (string != null) {
            this.value = String.valueOf(string) + "." + this.value;
        }
        if (this.col instanceof StringColumn || this.col instanceof BlobColumn) {
            this.exprType = 1;
            this.exprSubtype = this.col.type;
            this.colLen = this.col.getLength();
        } else {
            this.exprSubtype = this.col.type;
            if (this.exprSubtype == 6) {
                object = (CurrencyColumn)this.col;
                this.currencyChar = ((CurrencyColumn)object).unitChar;
                this.currencyDecimals = ((CurrencyColumn)object).decimalPosn;
            }
            if (this.exprSubtype == 5) {
                object = (DateColumn)this.col;
                this.dateFormat = ((DateColumn)object).formatStr;
            }
            if (this.exprSubtype == 9) {
                this.exprSubtype = 2;
            }
        }
        return true;
    }

    void interpretString(String string) {
        this.exprClass = 2;
        this.value = string;
        this.exprType = 1;
        this.colLen = string.length() * 2 + 4;
        if (this.otherExpr != null && this.otherExpr.exprType == 1) {
            return;
        }
        this.stringToNumber(string);
    }

    boolean isConstant() {
        return this.exprClass == 2;
    }

    void reset() {
        if (this.oldExprClass == 5) {
            this.exprClass = 5;
            this.subExpr1 = this.oldSubExpr1;
            this.value = this.oldValue;
            if (this.valueList != null) {
                this.valueList.removeAllElements();
            }
            this.funcCount = 0;
            this.funcValue = null;
            if (this.funcClass == 4) {
                this.funcValue = int0;
            }
        }
        if (this.subExpr1 != null) {
            this.subExpr1.reset();
        }
        if (this.subExpr2 != null) {
            this.subExpr2.reset();
        }
    }

    void reset(expression expression2) {
        this.col = expression2.col;
        this.value = expression2.value;
        this.subExpr1 = expression2.subExpr1;
        this.subExpr2 = expression2.subExpr2;
        this.exprClass = expression2.exprClass;
        this.funcValue = expression2.funcValue;
        this.funcCount = expression2.funcCount;
        this.valueList = expression2.valueList;
        this.exprContainsFunc = expression2.exprContainsFunc;
    }

    void setName(String string) {
        this.name = string;
    }

    boolean stringToNumber(String string) {
        Object object;
        String string2 = null;
        if (this.checkCurrency(string)) {
            return true;
        }
        if (this.otherExpr != null && (object = this.otherExpr.col) != null) {
            if (((Column)object).type == 5) {
                DateColumn dateColumn = (DateColumn)object;
                string2 = dateColumn.preferredParseFormat;
            } else if (((Column)object).type == 1) {
                ByteColumn byteColumn = (ByteColumn)object;
                this.value = byteColumn.toObject(string);
                this.exprType = 0;
                this.exprClass = 2;
                return true;
            }
        }
        if ((object = DateColumn.toDate(string2, string, this.dbase.milleniumBoundary, this.dbase.nowMeansTime)) != null) {
            this.exprSubtype = 5;
            this.value = object;
            this.exprType = 0;
            return true;
        }
        if (this.strictLiterals) {
            return false;
        }
        boolean bl = this.toNumericValue(string);
        return bl;
    }

    boolean toNumericValue(String string) {
        if (this.checkCurrency(string)) {
            return true;
        }
        boolean bl = true;
        try {
            if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                Double d = new Double(string);
                boolean bl2 = false;
                if (this.otherExpr != null && this.otherExpr.exprSubtype == 8) {
                    bl2 = true;
                }
                if (Math.abs(d) < 3.4028234663852886E38 && !bl2) {
                    this.value = new Float(d.floatValue());
                    this.exprSubtype = 7;
                } else {
                    this.value = d;
                    this.exprSubtype = 8;
                }
            } else {
                Long l = new Long(string);
                if (Math.abs(l) < Integer.MAX_VALUE) {
                    this.value = new Integer(l.intValue());
                    this.exprSubtype = 2;
                } else {
                    this.value = l;
                    this.exprSubtype = 4;
                }
            }
            this.exprType = 0;
            this.exprClass = 2;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }
}

