/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.experlog.openeas.api.DataObject;

public class ESDbMapper
implements DataObject {
    Hashtable tab_ = null;

    public ESDbMapper(String fname) throws IOException {
        if (fname == null) {
            return;
        }
        Properties props = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(fname));
            props = new Properties();
            props.load(in);
            in.close();
        }
        catch (IOException ioe) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ee) {
                    System.err.println("ESDbMapper Exception " + ee);
                }
            }
            throw ioe;
        }
        this.tab_ = new Hashtable(props.size());
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement().toString();
            this.tab_.put(key.toUpperCase(), props.get(key));
        }
    }

    public String getTable(String table) {
        try {
            return this.get(table);
        }
        catch (SQLException e) {
            return table;
        }
    }

    public String getField(String table, String field) {
        try {
            return this.get(table + "." + field);
        }
        catch (SQLException e) {
            return field;
        }
    }

    public String get(String name) throws SQLException {
        if (this.tab_ == null) {
            return this.getName(name);
        }
        String newname = (String)this.tab_.get(name.toUpperCase());
        if (newname == null) {
            return this.getName(name);
        }
        return newname;
    }

    private String getName(String name) {
        int pos = name.indexOf(46);
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    protected void finalize() {
        if (this.tab_ != null) {
            this.tab_.clear();
        }
        this.tab_ = null;
    }
}

